package provide proxy 0.1

namespace eval proxy {

proc HttpProxy {Server Port} {
	upvar #0 icq::data data
	if {$data(-proxy_user)!="" && $data(-proxy_password)!=""} {
			uplevel #0 "package require base64"
	}
	icq::log 1 "Connecting to proxy $data(-proxy_server):$data(-proxy_port)"
	if {[catch {set data(socket) [socket -async $data(-proxy_server) $data(-proxy_port)]}]} {
		icq::CallHandlers 0:11 "Can't connect to proxy"
		return
	}
	fconfigure $data(socket) -translation crlf -buffering line -blocking no
	fileevent $data(socket) writable "proxy::HttpProxyWrite $Server $Port"
}

proc HttpProxyWrite {Server Port} {
	upvar #0 icq::data data
	puts $data(socket) "CONNECT $Server:$Port HTTP/1.0"
	if {$data(-proxy_user)!="" && $data(-proxy_password)!=""} {
		set auth [::base64::encode $data(-proxy_user):$data(-proxy_password)]
		puts $data(socket) "Proxy-Authorization: Basic $auth\n"
	}
	puts $data(socket) ""
	icq::log 3 "Proxy request sent"
	fileevent $data(socket) writable {}
	fileevent $data(socket) readable "proxy::HttpProxyRead"
}

proc HttpProxyRead {} {
	upvar #0 icq::data data
	set count [gets $data(socket) http_resp]
	if {$count==-1} {
		if {$http_resp!={}} return 
		fileevent $data(socket) readable {}
	}
	if {$count==0} {
		if {[regexp {^HTTP\/1\.[01] ([0-9]+)} $data(Body) s http_status]} {
			if {$http_status==200} {
				set data(proxy_status) "connected"
				fconfigure $data(socket) -blocking no -translation binary
				fileevent $data(socket) readable "icq::ReadData"
				icq::log 3 "Connected to proxy"
			} else {
				icq::CloseConnection
				fileevent $data(socket) readable {}
				icq::CallHandlers Error 0:10 "Proxy returned code $http_status"
			}
		}
	} else { append data(Body) $http_resp "\n"; return }
}
}
