//
//  Folder.cpp -- Folder class functions
//  -- created  4/13/00   updated 4/19/00
////////////////////////////////////////////

#include <iostream.h>
#include <string>
#include <list>
#include "Folder.h"
#include "Server.h"
#include "SelectFolder.h"
#include "imap.h"
#include "errors.h"

void Folder::set_Folder_Name( const string &name )
{
    folder_name = name;
}

void Folder::set_Sequence_Start( int new_start )
{
    sequence_start = new_start;
}

void Folder::set_Sequence_Stop( int new_stop )
{
    sequence_stop = new_stop;
}

void Folder::set_Server_Ptr( Server * s_ptr )
{
    server_ptr = s_ptr;
}

void Folder::set_Full_Folder_Name( const string &name )
{
    full_folder_name = name;
}


string Folder::get_Folder_Name()
{
    return( folder_name );
}

int Folder::get_Num_Messages()
{
    return( message_list.size() );
}

int Folder::get_Sequence_Start()
{
    return( sequence_start );
}

int Folder::get_Sequence_Stop()
{
    return( sequence_stop );
}

Server * Folder::get_Server_Ptr()
{
    return server_ptr;
}

Message * Folder::get_Message( int n )
{
    list<Message>::iterator it;
    int count = 1;
    
    it = message_list.begin();

    while( it != message_list.end() && count < n )
    {
        count++;
        it++;
    }
    if( count <= get_Num_Messages() )
        return( &( *it ) );

    else
        return( NULL );
}

string Folder::get_Full_Folder_Name()
{
    return( full_folder_name );
}


void Folder::add_Message( Message M )
{
    message_list.push_back( M );
    if( message_list.size() == 1 )
        sequence_start = M.get_Sequence_Number();
    sequence_stop = M.get_Sequence_Number();
}

void Folder::delete_Message( int ID )
{
    list<Message>::iterator it;
    it = message_list.begin();
    while( it != message_list.end() && (*it).get_Message_ID() != ID )
    {
        it++;
    }
    if( (*it).get_Message_ID() == ID )
        message_list.erase( it );
}

int Folder::get_Message_Headers( )
{
    return( GetMessageHeaders( get_Server_Ptr()->get_Connection(), *this ) );
}

int Folder::expunge_Deleted_Mail( )
{
    list<int> deleted_list;

    int ret_val= IMAPExpunge( get_Server_Ptr()->get_Connection(), deleted_list );
    

    for (list<int>::iterator it = deleted_list.begin();
	 it != deleted_list.end();
	 it++) {
      list<Message>::iterator mit;
      mit = message_list.begin();
      while( mit != message_list.end() && (*mit).get_Message_ID() != (*it) )
      {
	mit++;
      }

      mit=message_list.erase(mit );
      int counter=0;
      for (int x = 1; x<get_Sequence_Stop(); x++) {
	Message *M= get_Message(x);
	if (M!=NULL) {
	  counter++;
	  M->set_Message_ID(counter);
	} 
      }
      set_Sequence_Stop( counter );
      

    }
    
    
    
    return ret_val;


}
    
    

void Folder::clear( )
{
    message_list.clear();
}


//  Debugging purposes only
void Folder::display()
{
    list<Message>::iterator it;
    
    cout << endl << "   +" << folder_name << endl
        << "     " << message_list.size() << " messages" << endl
        << "     from " << sequence_start << " to " << sequence_stop << endl << "     |" << endl
        << "     Message Info" << endl;

    it = message_list.begin();
    while( it != message_list.end() )
    {
        (*it).display();
        it++;
    }
    
    
}
