dnl Check if the compiler can handle unsigned long constants, ie 2ul.
AC_DEFUN(AMANDA_C_UNSIGNED_LONG_CONSTANTS,
    [
	AC_CACHE_CHECK(
	    [for working unsigned long constants],
	    amanda_cv_c_unsigned_long_constants,
	    [
		AC_TRY_COMPILE(
		    [
		    ],
		    [
			long l = 1ul;
		    ],
		    amanda_cv_c_unsigned_long_constants=yes,
		    amanda_cv_c_unsigned_long_constants=no
		)
	    ]
	)
	if test "$amanda_cv_c_unsigned_long_constants" = yes; then
	    AC_DEFINE(HAVE_UNSIGNED_LONG_CONSTANTS,1,[Define if the compiler support unsigned long constants. ])
	fi
    ]
)

dnl Check for the argument type for shmat() and shmdt()
AC_DEFUN(AMANDA_FUNC_SHM_ARG_TYPE,
    [
	AC_CACHE_CHECK(
	    [for shmdt() argument type],
	    amanda_cv_shmdt_arg_type,
	    [
		if test "$ac_cv_func_shmget" = yes; then
		    cat <<EOF >conftest.$ac_ext
#include "confdefs.h"
#ifdef HAVE_SYS_TYPES_H
# include <sys/types.h>
#endif
#ifdef HAVE_SYS_IPC_H
# include <sys/ipc.h>
#endif
#ifdef HAVE_SYS_SHM_H
# include <sys/shm.h>
#endif

#ifdef __cplusplus
extern "C" void *shmat(int, void *, int);
#else
void *shmat();
#endif

int main()
{
    int i;
    return 0;
}
EOF
		    ${CC-cc} -c $CFLAGS $CPPFLAGS conftest.$ac_ext >/dev/null 2>/dev/null
		    if test $? = 0; then
			amanda_cv_shmdt_arg_type=void
		    else
			amanda_cv_shmdt_arg_type=char
		    fi
		    rm -f conftest*
		else
		    amanda_cv_shmdt_arg_type=nothing
		fi
	    ]
	)
	AC_DEFINE_UNQUOTED(SHM_ARG_TYPE,$amanda_cv_shmdt_arg_type,[Define to type of shmget() function argument. ])
    ]
)

dnl Figure out the select() argument type.
AC_DEFUN(AMANDA_FUNC_SELECT_ARG_TYPE,
    [
	AC_CACHE_CHECK(
	    [for select() argument type],
	    amanda_cv_select_arg_type,
	    [
		rm -f conftest.c
		cat <<EOF >conftest.$ac_ext
#include "confdefs.h"
#ifdef HAVE_SYS_TIME_H
# include <sys/time.h>
#endif
#ifdef HAVE_SYS_TYPES_H
# include <sys/types.h>
#endif
#ifdef HAVE_SYS_SELECT_H
#  include <sys/select.h>
#endif
#ifdef HAVE_SYS_SOCKET_H
#  include <sys/socket.h>
#endif
#ifdef HAVE_UNISTD_H
# include <unistd.h>
#endif

int main()
{
#ifdef FD_SET_POINTER
	(void)select(0, (fd_set *) 0, (fd_set *) 0, (fd_set *) 0, 0);
#else
	(void)select(0, (int *) 0, (int *) 0, (int *) 0, 0);
#endif
	return 0;
}
EOF

		dnl Figure out the select argument type by first trying to
		dnl compile with the fd_set argument.  If the compile fails,
		dnl then we know to use the int.  If it suceeds, then try to
		dnl use the int.  If the int fails, then use fd_set.  If
		dnl both suceeed, then do a line count on the number of
		dnl lines that the compiler spit out, assuming that the
		dnl compile outputing more lines had more errors.
		amanda_cv_select_arg_type=no
		select_compile="${CC-cc} -c $CFLAGS $CPPFLAGS"
		$select_compile -DFD_SET_POINTER conftest.$ac_ext 1>conftest.fd_set 2>&1
		if test $? -ne 0; then
		    amanda_cv_select_arg_type=int
		fi
		if test "$amanda_cv_select_arg_type" = no; then
		    $select_compile conftest.$ac_ext 1>conftest.int 2>&1
		    if test $? -ne 0; then
			amanda_cv_select_arg_type=fd_set
		    fi
		fi
		if test "$amanda_cv_select_arg_type" = no; then
		    wc_fdset=`wc -l <conftest.fd_set`
		    wc_int=`wc -l <conftest.int`
		    if test "$wc_fdset" -le "$wc_int"; then
			amanda_cv_select_arg_type=fd_set
		    else
			amanda_cv_select_arg_type=int
		    fi
		fi
		rm -f conftest*
	    ]
	)
	AC_DEFINE_UNQUOTED(SELECT_ARG_TYPE,$amanda_cv_select_arg_type,[Define to type of select arguments. ])
    ]
)

dnl Check if setsockopt can use the SO_SNDTIMEO option.
dnl This defines HAVE_SO_SNDTIMEO if setsockopt works
dnl with SO_SNDTIMEO.
AC_DEFUN(AMANDA_FUNC_SETSOCKOPT_SO_SNDTIMEO,
    [
	AC_CACHE_CHECK(
	    [for setsockopt SO_SNDTIMEO option],
	    amanda_cv_setsockopt_SO_SNDTIMEO,
	    [
		AC_TRY_RUN(
		    [
#include <sys/types.h>
#include <sys/socket.h>
#ifdef TIME_WITH_SYS_TIME
#  include <sys/time.h>
#  include <time.h>
#else
#  ifdef HAVE_SYS_TIME_H
#    include <sys/time.h>
#  else
#    include <time.h>
#  endif
#endif

main() {
#ifdef SO_SNDTIMEO
    int sock = socket(AF_INET, SOCK_STREAM, 0);
    struct timeval timeout;
    timeout.tv_sec = 1;
    timeout.tv_usec = 0;
    return (setsockopt(sock, SOL_SOCKET, SO_SNDTIMEO,
             (void *)&timeout, sizeof(timeout)));
#else
    return -1;
#endif
}
		    ],
		    amanda_cv_setsockopt_SO_SNDTIMEO=yes,
		    amanda_cv_setsockopt_SO_SNDTIMEO=no,
		    amanda_cv_setsockopt_SO_SNDTIMEO=no
		)
	    ]
	)
	if test "$amanda_cv_setsockopt_SO_SNDTIMEO" = yes; then
	    AC_DEFINE(HAVE_SO_SNDTIMEO,1,[Define if SO_SNDTIMEO is available. ])
	fi
    ]
)

dnl Find out how {awk,gawk,nawk,mawk} likes to assign variables, if it
dnl can do so at all.
AC_DEFUN(AMANDA_PROG_AWK_VAR,
    [
	AC_REQUIRE([AC_PROG_AWK])
	AC_CACHE_CHECK(
	    [for $AWK command line variable assignment],
	    amanda_cv_awk_var_assignment,
	    [
		echo 'BEGIN{print i; exit}' > conftest.awk
		result=`$AWK -f conftest.awk i=xx | wc -c`
		if test "$result" -le 1; then
		    result=`$AWK -f conftest.awk -v i=xx | wc -c`
		    if test "$result" -le 1; then
			amanda_cv_awk_var_assignment=no
		    else
			amanda_cv_awk_var_assignment="yes with -v"
		    fi
		else
		    amanda_cv_awk_var_assignment="yes"
		fi
		rm -fr conftest.awk
	    ]
	)
	AWK_VAR_ASSIGNMENT_OPT=
	case "$amanda_cv_awk_var_assignment" in
	    no)
		HAVE_AWK_WITH_VAR=no
		;;
	    yes)
		HAVE_AWK_WITH_VAR=yes
		;;
	    "yes with -v")
		HAVE_AWK_WITH_VAR=yes
		AWK_VAR_ASSIGNMENT_OPT=-v
		;;
	esac
	AC_SUBST(AWK_VAR_ASSIGNMENT_OPT)
    ]
)	

dnl Check for the one or two argument version of gettimeofday.
AC_DEFUN(AMANDA_FUNC_GETTIMEOFDAY_ARGS,
    [
	AC_REQUIRE([AC_HEADER_TIME])
	AC_CACHE_CHECK(
	    [for gettimeofday number of arguments],
	    amanda_cv_gettimeofday_args,
	    [
		AC_TRY_COMPILE(
		    [
#ifdef TIME_WITH_SYS_TIME
#  include <sys/time.h>
#  include <time.h>
#else
#  ifdef HAVE_SYS_TIME_H
#    include <sys/time.h>
#  else
#    include <time.h>
#  endif
#endif
		    ],
		    [
			struct timeval val;
			struct timezone zone;
			gettimeofday(&val, &zone);
		    ],
		    amanda_cv_gettimeofday_args=2,
		    amanda_cv_gettimeofday_args=1
		)
	    ]
	)
	if test "$amanda_cv_gettimeofday_args" = 2; then
	    AC_DEFINE(HAVE_TWO_ARG_GETTIMEOFDAY,1,[Define if gettimeofday takes two arguments. ])
	fi
    ]
)



dnl Check if the compiler understands volatile.
AC_DEFUN(AMANDA_C_VOLATILE,
    [
	AC_CACHE_CHECK(
	    [for working volatile],
	    amanda_cv_c_volatile,
	    [
		AC_TRY_COMPILE(,
		    [
			volatile int aaa = 0;
		    ],
		    amanda_cv_c_volatile=yes,
		    amanda_cv_c_volatile=no
		)
	    ]
	)
	if test $amanda_cv_c_volatile = no; then
	    AC_DEFINE(volatile, [],[Define to empty if the compiler does not support volatile. ])
	fi
    ]
)


dnl Check for if pid_t is a long, int, or short.
AC_DEFUN(AMANDA_TYPE_PID_T,
    [
	AC_REQUIRE([AC_TYPE_PID_T])
	AC_CACHE_CHECK([for pid_t type], amanda_cv_pid_type,
	    [
		amanda_cv_pid_type=unknown
		if test "$ac_cv_type_pid_t" = no; then
		    amanda_cv_pid_type=int
		fi
		for TEST_amanda_cv_pid_type in long short int; do
		    if test $amanda_cv_pid_type = unknown; then
			AC_EGREP_CPP(typedef.*${TEST_amanda_cv_pid_type}.*pid_t,
			    [
#include <sys/types.h>
#if STDC_HEADERS
#include <stdlib.h>
#include <stddef.h>
#endif
			    ],
			amanda_cv_pid_type=$TEST_amanda_cv_pid_type)
		    fi
		    if test $amanda_cv_pid_type = unknown; then
			AC_EGREP_CPP(ZZZZ.*${TEST_amanda_cv_pid_type},
			    [
#include <sys/types.h>
#if STDC_HEADERS
#include <stdlib.h>
#include <stddef.h>
#endif
				ZZZZ pid_t
			],
			amanda_cv_pid_type=$TEST_amanda_cv_pid_type)
		    fi
		done
		if test $amanda_cv_pid_type = unknown; then
		    amanda_cv_pid_type=int
		fi
	    ]
	)
	case $amanda_cv_pid_type in
	    int)	AC_DEFINE_UNQUOTED(PRINTF_PID_T,"%d",[Define to printf formatting string to print a PID. ]) ;;
	    long)	AC_DEFINE_UNQUOTED(PRINTF_PID_T,"%ld") ;;
	    short)	AC_DEFINE_UNQUOTED(PRINTF_PID_T,"%d") ;;
	esac
    ]
)

dnl
dnl
dnl ICE_CHECK_DECL (FUNCTION, HEADER-FILE...)
dnl If FUNCTION is available, define `HAVE_FUNCTION'.  If it is declared
dnl in one of the headers named in the whitespace-separated list 
dnl HEADER_FILE, define `HAVE_FUNCTION_DECL` (in all capitals).
dnl
AC_DEFUN(ICE_CHECK_DECL,
[
ice_have_$1=no
AC_CHECK_FUNCS($1, ice_have_$1=yes)
if test "${ice_have_$1}" = yes; then
AC_MSG_CHECKING(for $1 declaration in $2)
AC_CACHE_VAL(ice_cv_have_$1_decl,
[
ice_cv_have_$1_decl=no
changequote(,)dnl
ice_re_params='[a-zA-Z_][a-zA-Z0-9_]*'
ice_re_word='(^|[^a-zA-Z0-9_])'
changequote([,])dnl
for header in $2; do
# Check for ordinary declaration
AC_EGREP_HEADER([${ice_re_word}$1[ 	]*\(], $header, 
	ice_cv_have_$1_decl=yes)
if test "$ice_cv_have_$1_decl" = yes; then
	break
fi
# Check for "fixed" declaration like "getpid _PARAMS((int))"
AC_EGREP_HEADER([${ice_re_word}$1[ 	]*$ice_re_params\(\(], $header, 
	ice_cv_have_$1_decl=yes)
if test "$ice_cv_have_$1_decl" = yes; then
	break
fi
done
])
AC_MSG_RESULT($ice_cv_have_$1_decl)
if test "$ice_cv_have_$1_decl" = yes; then
AC_DEFINE_UNQUOTED([HAVE_]translit($1,[a-z],[A-Z])[_DECL],1,[Define if $1 is declared. ])
fi
fi
])dnl
dnl Test for the presence of <sys/wait.h>, 'union wait', arg-type of 'wait()'.
dnl by T.E.Dickey" , Jim Spath <jspath@mail.bcpl.lib.md.us>
dnl
dnl     FIXME: These tests should have been in autoconf 1.11!
dnl
dnl     Note that we cannot simply grep for 'union wait' in the wait.h file,
dnl     because some Posix systems turn this on only when a BSD variable is
dnl     defined. Since I'm trying to do without special defines, I'll live
dnl     with the default behavior of the include-file.
dnl
dnl     I do _2_ compile checks, because we may have union-wait, but the
dnl     prototype for 'wait()' may want an int.
dnl
dnl     Don't use HAVE_UNION_WAIT, because the autoconf documentation implies
dnl     that if we've got union-wait, we'll automatically use it.
dnl
dnl Garrett Wollman adds:
dnl	The tests described above don't quite do the right thing,
dnl	since some systems have hacks which allow `union wait' to
dnl	still work even though `int' is preferred (and generates
dnl	fewer warnings).  Since all of these systems use prototypes,
dnl	we can use the prototype of wait(2) to disambiguate them.
dnl
dnl Alexandre Oliva adds:
dnl     A single compile check is enough.  If we don't have union wait,
dnl     it's obvious that the test will fail, and that we must use int.
dnl     If we do, the prototype (on STDC systems) and WIFEXITED will tell
dnl     whether we're supposed to be using union wait instead of int.
dnl
AC_DEFUN([CF_WAIT],
[
AC_REQUIRE([AC_TYPE_PID_T])
AC_HAVE_HEADERS(sys/wait.h wait.h)
AC_CACHE_CHECK([whether wait uses union wait], [cf_cv_arg_union_wait],
        [AC_TRY_COMPILE([
#include <sys/types.h>

#if HAVE_SYS_WAIT_H
# include <sys/wait.h>
#else
# if HAVE_WAIT_H
#  include <wait.h>
# endif
#endif

#ifdef __STDC__
pid_t wait(union wait *);
#endif
], [
  union wait x; int i;
  wait(&x); i = WIFEXITED(x)
], [cf_cv_arg_union_wait=yes], [cf_cv_arg_union_wait=no])])
if test $cf_cv_arg_union_wait = yes; then
	AC_DEFINE(WAIT_USES_UNION,1,[Defined if wait() puts the status in a union wait instead of int. ])
fi
])dnl
## libtool.m4 - Configure libtool for the target system. -*-Shell-script-*-
## Copyright (C) 1996-1999 Free Software Foundation, Inc.
## Originally by Gordon Matzigkeit <gord@gnu.ai.mit.edu>, 1996
##
## This program is free software; you can redistribute it and/or modify
## it under the terms of the GNU General Public License as published by
## the Free Software Foundation; either version 2 of the License, or
## (at your option) any later version.
##
## This program is distributed in the hope that it will be useful, but
## WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
## General Public License for more details.
##
## You should have received a copy of the GNU General Public License
## along with this program; if not, write to the Free Software
## Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
##
## As a special exception to the GNU General Public License, if you
## distribute this file as part of a program that contains a
## configuration script generated by Autoconf, you may include it under
## the same distribution terms that you use for the rest of that program.

# serial 40 AC_PROG_LIBTOOL
AC_DEFUN(AC_PROG_LIBTOOL,
[AC_REQUIRE([AC_LIBTOOL_SETUP])dnl

# Save cache, so that ltconfig can load it
AC_CACHE_SAVE

# Actually configure libtool.  ac_aux_dir is where install-sh is found.
CC="$CC" CFLAGS="$CFLAGS" CPPFLAGS="$CPPFLAGS" \
LD="$LD" LDFLAGS="$LDFLAGS" LIBS="$LIBS" \
LN_S="$LN_S" NM="$NM" RANLIB="$RANLIB" \
DLLTOOL="$DLLTOOL" AS="$AS" OBJDUMP="$OBJDUMP" \
${CONFIG_SHELL-/bin/sh} $ac_aux_dir/ltconfig --no-reexec \
$libtool_flags --no-verify $ac_aux_dir/ltmain.sh $host \
|| AC_MSG_ERROR([libtool configure failed])

# Reload cache, that may have been modified by ltconfig
AC_CACHE_LOAD

# This can be used to rebuild libtool when needed
LIBTOOL_DEPS="$ac_aux_dir/ltconfig $ac_aux_dir/ltmain.sh"

# Always use our own libtool.
LIBTOOL='$(SHELL) $(top_builddir)/libtool'
AC_SUBST(LIBTOOL)dnl

# Redirect the config.log output again, so that the ltconfig log is not
# clobbered by the next message.
exec 5>>./config.log
])

AC_DEFUN(AC_LIBTOOL_SETUP,
[AC_PREREQ(2.13)dnl
AC_REQUIRE([AC_ENABLE_SHARED])dnl
AC_REQUIRE([AC_ENABLE_STATIC])dnl
AC_REQUIRE([AC_ENABLE_FAST_INSTALL])dnl
AC_REQUIRE([AC_CANONICAL_HOST])dnl
AC_REQUIRE([AC_CANONICAL_BUILD])dnl
AC_REQUIRE([AC_PROG_RANLIB])dnl
AC_REQUIRE([AC_PROG_CC])dnl
AC_REQUIRE([AC_PROG_LD])dnl
AC_REQUIRE([AC_PROG_NM])dnl
AC_REQUIRE([AC_PROG_LN_S])dnl
dnl

# Check for any special flags to pass to ltconfig.
libtool_flags="--cache-file=$cache_file"
test "$enable_shared" = no && libtool_flags="$libtool_flags --disable-shared"
test "$enable_static" = no && libtool_flags="$libtool_flags --disable-static"
test "$enable_fast_install" = no && libtool_flags="$libtool_flags --disable-fast-install"
test "$ac_cv_prog_gcc" = yes && libtool_flags="$libtool_flags --with-gcc"
test "$ac_cv_prog_gnu_ld" = yes && libtool_flags="$libtool_flags --with-gnu-ld"
ifdef([AC_PROVIDE_AC_LIBTOOL_DLOPEN],
[libtool_flags="$libtool_flags --enable-dlopen"])
ifdef([AC_PROVIDE_AC_LIBTOOL_WIN32_DLL],
[libtool_flags="$libtool_flags --enable-win32-dll"])
AC_ARG_ENABLE(libtool-lock,
  [  --disable-libtool-lock  avoid locking (might break parallel builds)])
test "x$enable_libtool_lock" = xno && libtool_flags="$libtool_flags --disable-lock"
test x"$silent" = xyes && libtool_flags="$libtool_flags --silent"

# Some flags need to be propagated to the compiler or linker for good
# libtool support.
case "$host" in
*-*-irix6*)
  # Find out which ABI we are using.
  echo '[#]line __oline__ "configure"' > conftest.$ac_ext
  if AC_TRY_EVAL(ac_compile); then
    case "`/usr/bin/file conftest.o`" in
    *32-bit*)
      LD="${LD-ld} -32"
      ;;
    *N32*)
      LD="${LD-ld} -n32"
      ;;
    *64-bit*)
      LD="${LD-ld} -64"
      ;;
    esac
  fi
  rm -rf conftest*
  ;;

*-*-sco3.2v5*)
  # On SCO OpenServer 5, we need -belf to get full-featured binaries.
  SAVE_CFLAGS="$CFLAGS"
  CFLAGS="$CFLAGS -belf"
  AC_CACHE_CHECK([whether the C compiler needs -belf], lt_cv_cc_needs_belf,
    [AC_TRY_LINK([],[],[lt_cv_cc_needs_belf=yes],[lt_cv_cc_needs_belf=no])])
  if test x"$lt_cv_cc_needs_belf" != x"yes"; then
    # this is probably gcc 2.8.0, egcs 1.0 or newer; no need for -belf
    CFLAGS="$SAVE_CFLAGS"
  fi
  ;;

ifdef([AC_PROVIDE_AC_LIBTOOL_WIN32_DLL],
[*-*-cygwin* | *-*-mingw*)
  AC_CHECK_TOOL(DLLTOOL, dlltool, false)
  AC_CHECK_TOOL(AS, as, false)
  AC_CHECK_TOOL(OBJDUMP, objdump, false)
  ;;
])
esac
])

# AC_LIBTOOL_DLOPEN - enable checks for dlopen support
AC_DEFUN(AC_LIBTOOL_DLOPEN, [AC_BEFORE([$0],[AC_LIBTOOL_SETUP])])

# AC_LIBTOOL_WIN32_DLL - declare package support for building win32 dll's
AC_DEFUN(AC_LIBTOOL_WIN32_DLL, [AC_BEFORE([$0], [AC_LIBTOOL_SETUP])])

# AC_ENABLE_SHARED - implement the --enable-shared flag
# Usage: AC_ENABLE_SHARED[(DEFAULT)]
#   Where DEFAULT is either `yes' or `no'.  If omitted, it defaults to
#   `yes'.
AC_DEFUN(AC_ENABLE_SHARED, [dnl
define([AC_ENABLE_SHARED_DEFAULT], ifelse($1, no, no, yes))dnl
AC_ARG_ENABLE(shared,
changequote(<<, >>)dnl
<<  --enable-shared[=PKGS]  build shared libraries [default=>>AC_ENABLE_SHARED_DEFAULT],
changequote([, ])dnl
[p=${PACKAGE-default}
case "$enableval" in
yes) enable_shared=yes ;;
no) enable_shared=no ;;
*)
  enable_shared=no
  # Look at the argument we got.  We use all the common list separators.
  IFS="${IFS= 	}"; ac_save_ifs="$IFS"; IFS="${IFS}:,"
  for pkg in $enableval; do
    if test "X$pkg" = "X$p"; then
      enable_shared=yes
    fi
  done
  IFS="$ac_save_ifs"
  ;;
esac],
enable_shared=AC_ENABLE_SHARED_DEFAULT)dnl
])

# AC_DISABLE_SHARED - set the default shared flag to --disable-shared
AC_DEFUN(AC_DISABLE_SHARED, [AC_BEFORE([$0],[AC_LIBTOOL_SETUP])dnl
AC_ENABLE_SHARED(no)])

# AC_ENABLE_STATIC - implement the --enable-static flag
# Usage: AC_ENABLE_STATIC[(DEFAULT)]
#   Where DEFAULT is either `yes' or `no'.  If omitted, it defaults to
#   `yes'.
AC_DEFUN(AC_ENABLE_STATIC, [dnl
define([AC_ENABLE_STATIC_DEFAULT], ifelse($1, no, no, yes))dnl
AC_ARG_ENABLE(static,
changequote(<<, >>)dnl
<<  --enable-static[=PKGS]  build static libraries [default=>>AC_ENABLE_STATIC_DEFAULT],
changequote([, ])dnl
[p=${PACKAGE-default}
case "$enableval" in
yes) enable_static=yes ;;
no) enable_static=no ;;
*)
  enable_static=no
  # Look at the argument we got.  We use all the common list separators.
  IFS="${IFS= 	}"; ac_save_ifs="$IFS"; IFS="${IFS}:,"
  for pkg in $enableval; do
    if test "X$pkg" = "X$p"; then
      enable_static=yes
    fi
  done
  IFS="$ac_save_ifs"
  ;;
esac],
enable_static=AC_ENABLE_STATIC_DEFAULT)dnl
])

# AC_DISABLE_STATIC - set the default static flag to --disable-static
AC_DEFUN(AC_DISABLE_STATIC, [AC_BEFORE([$0],[AC_LIBTOOL_SETUP])dnl
AC_ENABLE_STATIC(no)])


# AC_ENABLE_FAST_INSTALL - implement the --enable-fast-install flag
# Usage: AC_ENABLE_FAST_INSTALL[(DEFAULT)]
#   Where DEFAULT is either `yes' or `no'.  If omitted, it defaults to
#   `yes'.
AC_DEFUN(AC_ENABLE_FAST_INSTALL, [dnl
define([AC_ENABLE_FAST_INSTALL_DEFAULT], ifelse($1, no, no, yes))dnl
AC_ARG_ENABLE(fast-install,
changequote(<<, >>)dnl
<<  --enable-fast-install[=PKGS]  optimize for fast installation [default=>>AC_ENABLE_FAST_INSTALL_DEFAULT],
changequote([, ])dnl
[p=${PACKAGE-default}
case "$enableval" in
yes) enable_fast_install=yes ;;
no) enable_fast_install=no ;;
*)
  enable_fast_install=no
  # Look at the argument we got.  We use all the common list separators.
  IFS="${IFS= 	}"; ac_save_ifs="$IFS"; IFS="${IFS}:,"
  for pkg in $enableval; do
    if test "X$pkg" = "X$p"; then
      enable_fast_install=yes
    fi
  done
  IFS="$ac_save_ifs"
  ;;
esac],
enable_fast_install=AC_ENABLE_FAST_INSTALL_DEFAULT)dnl
])

# AC_ENABLE_FAST_INSTALL - set the default to --disable-fast-install
AC_DEFUN(AC_DISABLE_FAST_INSTALL, [AC_BEFORE([$0],[AC_LIBTOOL_SETUP])dnl
AC_ENABLE_FAST_INSTALL(no)])

# AC_PROG_LD - find the path to the GNU or non-GNU linker
AC_DEFUN(AC_PROG_LD,
[AC_ARG_WITH(gnu-ld,
[  --with-gnu-ld           assume the C compiler uses GNU ld [default=no]],
test "$withval" = no || with_gnu_ld=yes, with_gnu_ld=no)
AC_REQUIRE([AC_PROG_CC])dnl
AC_REQUIRE([AC_CANONICAL_HOST])dnl
AC_REQUIRE([AC_CANONICAL_BUILD])dnl
ac_prog=ld
if test "$ac_cv_prog_gcc" = yes; then
  # Check if gcc -print-prog-name=ld gives a path.
  AC_MSG_CHECKING([for ld used by GCC])
  ac_prog=`($CC -print-prog-name=ld) 2>&5`
  case "$ac_prog" in
    # Accept absolute paths.
changequote(,)dnl
    [\\/]* | [A-Za-z]:[\\/]*)
      re_direlt='/[^/][^/]*/\.\./'
changequote([,])dnl
      # Canonicalize the path of ld
      ac_prog=`echo $ac_prog| sed 's%\\\\%/%g'`
      while echo $ac_prog | grep "$re_direlt" > /dev/null 2>&1; do
	ac_prog=`echo $ac_prog| sed "s%$re_direlt%/%"`
      done
      test -z "$LD" && LD="$ac_prog"
      ;;
  "")
    # If it fails, then pretend we aren't using GCC.
    ac_prog=ld
    ;;
  *)
    # If it is relative, then search for the first ld in PATH.
    with_gnu_ld=unknown
    ;;
  esac
elif test "$with_gnu_ld" = yes; then
  AC_MSG_CHECKING([for GNU ld])
else
  AC_MSG_CHECKING([for non-GNU ld])
fi
AC_CACHE_VAL(ac_cv_path_LD,
[if test -z "$LD"; then
  IFS="${IFS= 	}"; ac_save_ifs="$IFS"; IFS="${IFS}${PATH_SEPARATOR-:}"
  for ac_dir in $PATH; do
    test -z "$ac_dir" && ac_dir=.
    if test -f "$ac_dir/$ac_prog" || test -f "$ac_dir/$ac_prog$ac_exeext"; then
      ac_cv_path_LD="$ac_dir/$ac_prog"
      # Check to see if the program is GNU ld.  I'd rather use --version,
      # but apparently some GNU ld's only accept -v.
      # Break only if it was the GNU/non-GNU ld that we prefer.
      if "$ac_cv_path_LD" -v 2>&1 < /dev/null | egrep '(GNU|with BFD)' > /dev/null; then
	test "$with_gnu_ld" != no && break
      else
	test "$with_gnu_ld" != yes && break
      fi
    fi
  done
  IFS="$ac_save_ifs"
else
  ac_cv_path_LD="$LD" # Let the user override the test with a path.
fi])
LD="$ac_cv_path_LD"
if test -n "$LD"; then
  AC_MSG_RESULT($LD)
else
  AC_MSG_RESULT(no)
fi
test -z "$LD" && AC_MSG_ERROR([no acceptable ld found in \$PATH])
AC_SUBST(LD)
AC_PROG_LD_GNU
])

AC_DEFUN(AC_PROG_LD_GNU,
[AC_CACHE_CHECK([if the linker ($LD) is GNU ld], ac_cv_prog_gnu_ld,
[# I'd rather use --version here, but apparently some GNU ld's only accept -v.
if $LD -v 2>&1 </dev/null | egrep '(GNU|with BFD)' 1>&5; then
  ac_cv_prog_gnu_ld=yes
else
  ac_cv_prog_gnu_ld=no
fi])
])

# AC_PROG_NM - find the path to a BSD-compatible name lister
AC_DEFUN(AC_PROG_NM,
[AC_MSG_CHECKING([for BSD-compatible nm])
AC_CACHE_VAL(ac_cv_path_NM,
[if test -n "$NM"; then
  # Let the user override the test.
  ac_cv_path_NM="$NM"
else
  IFS="${IFS= 	}"; ac_save_ifs="$IFS"; IFS="${IFS}${PATH_SEPARATOR-:}"
  for ac_dir in $PATH /usr/ccs/bin /usr/ucb /bin; do
    test -z "$ac_dir" && ac_dir=.
    if test -f $ac_dir/nm || test -f $ac_dir/nm$ac_exeext ; then
      # Check to see if the nm accepts a BSD-compat flag.
      # Adding the `sed 1q' prevents false positives on HP-UX, which says:
      #   nm: unknown option "B" ignored
      if ($ac_dir/nm -B /dev/null 2>&1 | sed '1q'; exit 0) | egrep /dev/null >/dev/null; then
	ac_cv_path_NM="$ac_dir/nm -B"
	break
      elif ($ac_dir/nm -p /dev/null 2>&1 | sed '1q'; exit 0) | egrep /dev/null >/dev/null; then
	ac_cv_path_NM="$ac_dir/nm -p"
	break
      else
	ac_cv_path_NM=${ac_cv_path_NM="$ac_dir/nm"} # keep the first match, but
	continue # so that we can try to find one that supports BSD flags
      fi
    fi
  done
  IFS="$ac_save_ifs"
  test -z "$ac_cv_path_NM" && ac_cv_path_NM=nm
fi])
NM="$ac_cv_path_NM"
AC_MSG_RESULT([$NM])
AC_SUBST(NM)
])

# AC_CHECK_LIBM - check for math library
AC_DEFUN(AC_CHECK_LIBM,
[AC_REQUIRE([AC_CANONICAL_HOST])dnl
LIBM=
case "$host" in
*-*-beos* | *-*-cygwin*)
  # These system don't have libm
  ;;
*-ncr-sysv4.3*)
  AC_CHECK_LIB(mw, _mwvalidcheckl, LIBM="-lmw")
  AC_CHECK_LIB(m, main, LIBM="$LIBM -lm")
  ;;
*)
  AC_CHECK_LIB(m, main, LIBM="-lm")
  ;;
esac
])

# AC_LIBLTDL_CONVENIENCE[(dir)] - sets LIBLTDL to the link flags for
# the libltdl convenience library, adds --enable-ltdl-convenience to
# the configure arguments.  Note that LIBLTDL is not AC_SUBSTed, nor
# is AC_CONFIG_SUBDIRS called.  If DIR is not provided, it is assumed
# to be `${top_builddir}/libltdl'.  Make sure you start DIR with
# '${top_builddir}/' (note the single quotes!) if your package is not
# flat, and, if you're not using automake, define top_builddir as
# appropriate in the Makefiles.
AC_DEFUN(AC_LIBLTDL_CONVENIENCE, [AC_BEFORE([$0],[AC_LIBTOOL_SETUP])dnl
  case "$enable_ltdl_convenience" in
  no) AC_MSG_ERROR([this package needs a convenience libltdl]) ;;
  "") enable_ltdl_convenience=yes
      ac_configure_args="$ac_configure_args --enable-ltdl-convenience" ;;
  esac
  LIBLTDL=ifelse($#,1,$1,['${top_builddir}/libltdl'])/libltdlc.la
  INCLTDL=ifelse($#,1,-I$1,['-I${top_builddir}/libltdl'])
])

# AC_LIBLTDL_INSTALLABLE[(dir)] - sets LIBLTDL to the link flags for
# the libltdl installable library, and adds --enable-ltdl-install to
# the configure arguments.  Note that LIBLTDL is not AC_SUBSTed, nor
# is AC_CONFIG_SUBDIRS called.  If DIR is not provided, it is assumed
# to be `${top_builddir}/libltdl'.  Make sure you start DIR with
# '${top_builddir}/' (note the single quotes!) if your package is not
# flat, and, if you're not using automake, define top_builddir as
# appropriate in the Makefiles.
# In the future, this macro may have to be called after AC_PROG_LIBTOOL.
AC_DEFUN(AC_LIBLTDL_INSTALLABLE, [AC_BEFORE([$0],[AC_LIBTOOL_SETUP])dnl
  AC_CHECK_LIB(ltdl, main,
  [test x"$enable_ltdl_install" != xyes && enable_ltdl_install=no],
  [if test x"$enable_ltdl_install" = xno; then
     AC_MSG_WARN([libltdl not installed, but installation disabled])
   else
     enable_ltdl_install=yes
   fi
  ])
  if test x"$enable_ltdl_install" = x"yes"; then
    ac_configure_args="$ac_configure_args --enable-ltdl-install"
    LIBLTDL=ifelse($#,1,$1,['${top_builddir}/libltdl'])/libltdl.la
    INCLTDL=ifelse($#,1,-I$1,['-I${top_builddir}/libltdl'])
  else
    ac_configure_args="$ac_configure_args --enable-ltdl-install=no"
    LIBLTDL="-lltdl"
    INCLTDL=
  fi
])

dnl old names
AC_DEFUN(AM_PROG_LIBTOOL, [indir([AC_PROG_LIBTOOL])])dnl
AC_DEFUN(AM_ENABLE_SHARED, [indir([AC_ENABLE_SHARED], $@)])dnl
AC_DEFUN(AM_ENABLE_STATIC, [indir([AC_ENABLE_STATIC], $@)])dnl
AC_DEFUN(AM_DISABLE_SHARED, [indir([AC_DISABLE_SHARED], $@)])dnl
AC_DEFUN(AM_DISABLE_STATIC, [indir([AC_DISABLE_STATIC], $@)])dnl
AC_DEFUN(AM_PROG_LD, [indir([AC_PROG_LD])])dnl
AC_DEFUN(AM_PROG_NM, [indir([AC_PROG_NM])])dnl

dnl This is just to silence aclocal about the macro not being used
ifelse([AC_DISABLE_FAST_INSTALL])dnl
