/* $Id: wmtitle.c,v 1.31 2000/10/31 03:45:12 komatsu Exp $ */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif /* HAVE_CONFIG_H */

#include <glib.h>
#include <gtk/gtk.h>
#include <stdio.h>  /* sprintf */
#include <stdlib.h> /* malloc  */
#include <string.h> /* strncpy */
#include "wmmain.h"
#include "wmclient.h"
#include "wmtitle.h"
#include "wmdrag.h"
#include "wmbutton.h"
#include "wmaction.h"
#include "wmmisc.h"
#include "wmmenuitem.h"
#include "gtkfsize.h"

#define BUFREST(size) (BUFLEN - count)
#define MAXLEN(size)  (size > BUFLEN ? BUFLEN : size)

static void wm_title_change_signal (GtkWidget *widget, gpointer data);

struct _WmTitleInfo {
    GtkWidget *widget;
    gchar     *format;
};

typedef struct _WmTitleInfo WmTitleInfo;

gchar *wm_title_parse(GtkWidget *widget)
{
    return wm_title_parse_with_format(widget, WM_CLIENT_TITLE_FORMAT(widget));
}

gchar *wm_title_parse_with_format(GtkWidget *widget, gchar *format)
{
    gint length;
    gint count = 0;
    gchar buffer[BUFLEN +1]; 
    gchar outbuf[BUFLEN +1];
    gchar *output;

    if(!IS_WM_CLIENT(widget)) {
	return g_strdup("WM WINDOW"); 
	/* ;Ϥꡣ
	   Gtk+ ǡWM_HINTS? ǤΤǤɤߤ */
    }
    while(*format && BUFREST(count) > 0) {
	if(*format == '$') {
	    format++;
	    switch(*format++) {
	    case '$':
	    case 0:
		buffer[0] = '$';
		buffer[1] = 0;
		break;
	    case 't':
		strncpy(buffer, WM_CLIENT_TITLE(widget), 
			MAXLEN(strlen(WM_CLIENT_TITLE(widget)) +1));
		break;
	    case 'n':
		strncpy(buffer, WM_CLIENT_NAME(widget), 
			MAXLEN(strlen(WM_CLIENT_NAME(widget)) +1));
		break;
	    case 'c':
		strncpy(buffer, WM_CLIENT_CLASS_HINT(widget), 
			MAXLEN(strlen(WM_CLIENT_CLASS_HINT(widget)) +1));
		break;
	    case 'i':  /* ̾ */
		strncpy(buffer, WM_CLIENT_ICON(widget), 
			MAXLEN(strlen(WM_CLIENT_ICON(widget)) +1));
		break;
	    case 'x':  /* ȥΰѹ */
		sprintf(buffer, "%d", WM_CLIENT_X(widget));
		break;
	    case 'y':
		sprintf(buffer, "%d", WM_CLIENT_Y(widget));
		break;
	    case 'w':
		sprintf(buffer, "%d", 
			((WM_CLIENT_WIDTH(widget) - WM_CLIENT_W_BASE(widget))
			 / WM_CLIENT_W_INC(widget)));
		break;
	    case 'h':
		sprintf(buffer, "%d", 
			((WM_CLIENT_HEIGHT(widget) - WM_CLIENT_H_BASE(widget))
			 / WM_CLIENT_H_INC(widget)));
		break;
	    }
	    length = strlen(buffer);
	    strncpy(outbuf + count, buffer, BUFREST(count));
	    count += length;
	} else {
	    outbuf[count++] = *format++;
	}
    }
    outbuf[count] = 0;
    output = g_strdup(outbuf);
    return output;
}

static void wm_title_change_signal(GtkWidget *widget, gpointer data)
{
    gchar *title;
    if(((WmTitleInfo *)data)->format) {
	title = 
	    wm_title_parse_with_format(widget, ((WmTitleInfo *)data)->format);
    } else {
	title = wm_title_parse(widget);
    }
    gtk_label_set(GTK_LABEL(((WmTitleInfo *)data)->widget), title);
    g_free(title);
}

void wm_title_move(GtkWidget *widget, gint x, gint y, gpointer data)
{
    gtk_widget_set_uposition(GTK_WIDGET(data),
			     x + WM_CLIENT_WIDTH(widget)/2 - 20, 
			     y + WM_CLIENT_HEIGHT(widget)/2);
}

void wm_title_resize(GtkWidget *widget, 
		     gint width, gint height, gint gravity, gpointer data)
{
    gtk_widget_set_uposition(GTK_WIDGET(data),
			     WM_CLIENT_X(widget) + width/2 - 20, 
			     WM_CLIENT_Y(widget) + height/2);
}

void wm_title_press1(GtkWidget *widget, GdkEventButton *event, gpointer data)
{
    GtkWidget *label, *window;

    label = wm_title_label_new(GTK_WIDGET(data), "$x, $y");
    window = gtk_window_new(GTK_WINDOW_POPUP);
    gtk_container_border_width(GTK_CONTAINER(window), 3);
    gtk_container_add(GTK_CONTAINER(window), label);

    wm_signal_connect_safety(GTK_OBJECT(widget), "release1",
			     GTK_SIGNAL_FUNC(wm_action_destroy),
			     (gpointer)window);
    wm_signal_connect_safety(GTK_OBJECT(data), "move",
			     GTK_SIGNAL_FUNC(wm_title_move),
			     (gpointer)window);
    gtk_widget_set_uposition(window,
			     WM_CLIENT_X(data) + WM_CLIENT_WIDTH(data)/2 - 20, 
			     WM_CLIENT_Y(data) + WM_CLIENT_HEIGHT(data)/2);
    gtk_widget_show(label);
    gtk_widget_show(window);
}

void wm_title_press2(GtkWidget *widget, GdkEventButton *event, gpointer data)
{
    gtk_widget_activate(gtk_widget_get_toplevel(widget));
}

void wm_title_press3(GtkWidget *widget, GdkEventButton *event, gpointer data)
{
    GtkWidget *label, *window;

    label = wm_title_label_new(GTK_WIDGET(data), "$w x $h");
    window = gtk_window_new(GTK_WINDOW_POPUP);
    gtk_container_border_width(GTK_CONTAINER(window), 3);
    gtk_container_add(GTK_CONTAINER(window), label);

    wm_signal_connect_safety(GTK_OBJECT(widget), "release3",
			     GTK_SIGNAL_FUNC(wm_action_destroy),
			     (gpointer)window);
    wm_signal_connect_safety(GTK_OBJECT(data), "resize",
			     GTK_SIGNAL_FUNC(wm_title_resize),
			     (gpointer)window);
    gtk_widget_set_uposition(window,
			     WM_CLIENT_X(data) + WM_CLIENT_WIDTH(data)/2 - 20, 
			     WM_CLIENT_Y(data) + WM_CLIENT_HEIGHT(data)/2);
    gtk_widget_show(label);
    gtk_widget_show(window);
}

void wm_title_drag3(GtkWidget *widget, GdkEventMotion *event, gpointer data)
{
    gint dx, dy;
    wm_drag_get_increase((int)(event->x_root), (int)(event->y_root), &dx, &dy);
    wm_client_resize_with_gravity(data,
				  WM_CLIENT_W_PREV(data) + dx,
				  WM_CLIENT_H_PREV(data) - dy,
				  SouthWestGravity);
}


GtkWidget *wm_title_label_new(GtkWidget *client, gchar *format)
{
    GtkWidget *title;
    WmWidgetStruct *titleinfo;

    if(IS_WM_CLIENT(client)) {
	if(format) {
	    title = gtk_label_new(wm_title_parse_with_format(client, format));
	} else {
	    title = gtk_label_new(wm_title_parse(client));
	}
	titleinfo = g_malloc(sizeof(WmTitleInfo));
	titleinfo->widget = title;
	titleinfo->data   = format;
	wm_signal_connect_safety_with_struct(GTK_OBJECT(client),
					     "title_change",
					     wm_title_change_signal, 
					     (gpointer)titleinfo);
    } else {
	title = gtk_label_new("WM WINDOW");
    }
    return title;
}

GtkWidget *wm_title_label_new_default(GtkWidget *client)
{
    GtkWidget *title;

    title = wm_title_label_new(client, NULL);
    return title;
}


GtkWidget *wm_title_button_new(GtkWidget *client)
{
    GtkWidget *title;
    GtkWidget *button;
    GtkWidget *fsize;

    title = wm_title_label_new_default(client);
    gtk_label_set_justify(GTK_LABEL(title), GTK_JUSTIFY_LEFT);
    gtk_widget_show(title);

    fsize = gtk_fsize_new();
    gtk_container_add(GTK_CONTAINER(fsize), title);
    gtk_widget_show(fsize);

    button = wm_button_new_default(client);

    gtk_signal_connect(GTK_OBJECT(button), "press1", 
		       GTK_SIGNAL_FUNC(wm_action_raise), client);
    gtk_signal_connect(GTK_OBJECT(button), "press1", 
		       GTK_SIGNAL_FUNC(wm_title_press1), client);
    gtk_signal_connect(GTK_OBJECT(button), "double1", 
		       GTK_SIGNAL_FUNC(wm_action_lower), client);
    gtk_signal_connect(GTK_OBJECT(button), "press2", 
		       GTK_SIGNAL_FUNC(wm_title_press2), client);
    gtk_signal_connect(GTK_OBJECT(button), "drag1", 
		       GTK_SIGNAL_FUNC(wm_action_move), client);
/*     gtk_signal_connect(GTK_OBJECT(button), "press2",  */
/* 		       GTK_SIGNAL_FUNC(wm_action_raise_group), client); */
/*     gtk_signal_connect(GTK_OBJECT(button), "double2",  */
/* 		       GTK_SIGNAL_FUNC(wm_action_lower_group), client); */
    gtk_signal_connect(GTK_OBJECT(button), "drag2", 
		       GTK_SIGNAL_FUNC(wm_action_move_group),  client);
    gtk_signal_connect(GTK_OBJECT(button), "press3", 
		       GTK_SIGNAL_FUNC(wm_title_press3), client);
    gtk_signal_connect(GTK_OBJECT(button), "drag3", 
		       GTK_SIGNAL_FUNC(wm_title_drag3), client);

    gtk_container_add(GTK_CONTAINER(button), fsize);

    return button;
}

GtkWidget *wm_title_button_new_default(GtkWidget *client)
{
    GtkWidget *title;

    title = wm_title_button_new(client);

    return title;
}

GtkWidget *wm_title_menu_item_new(GtkWidget *client)
{
    GtkWidget *item;
    GtkWidget *alabel;
    WmWidgetStruct *titleinfo;

/*     item   = gtk_menu_item_new(); */
    item   = wm_menu_item_new();
    if(IS_WM_CLIENT(client)) {
	alabel = gtk_accel_label_new(wm_title_parse(client));
	titleinfo = g_malloc(sizeof(WmTitleInfo));
	titleinfo->widget = alabel;
	titleinfo->data   = WM_CLIENT_TITLE_FORMAT(client);
	wm_signal_connect_safety_with_struct(GTK_OBJECT(client),
					     "title_change",
					     wm_title_change_signal, 
					     (gpointer)titleinfo);
    } else {
	alabel = gtk_accel_label_new("WM CLIENT");
    }
    gtk_misc_set_alignment(GTK_MISC(alabel), 0.0, 0.5);
    gtk_container_add(GTK_CONTAINER(item), alabel);
    gtk_accel_label_set_accel_widget(GTK_ACCEL_LABEL(alabel), item);
    gtk_widget_show(alabel);

    return item;
}
