/* $Id: gtkfsize.c,v 1.4 2000/03/26 08:15:59 komatsu Exp $ */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif /* HAVE_CONFIG_H */

#include "gtkfsize.h"

static void gtk_fsize_class_init    (GtkFsizeClass  *klass);
static void gtk_fsize_init          (GtkFsize       *fsize);
static void gtk_fsize_size_request  (GtkWidget      *widget,
				     GtkRequisition *requisition);
static void gtk_fsize_size_allocate (GtkWidget      *widget,
				     GtkAllocation  *allocation);

GtkType gtk_fsize_get_type(void)
{
    static GtkType fsize_type = 0;

    if (!fsize_type) {
	static const GtkTypeInfo fsize_info = {
	    "GtkFsize",
	    sizeof (GtkFsize),
	    sizeof (GtkFsizeClass),
	    (GtkClassInitFunc) gtk_fsize_class_init,
	    (GtkObjectInitFunc) gtk_fsize_init,
	    /* reserved_1 */ NULL,
	    /* reserved_2 */ NULL,
	    (GtkClassInitFunc) NULL,
	};

	fsize_type = gtk_type_unique(GTK_TYPE_BIN, &fsize_info);
    }

    return fsize_type;
}

static void gtk_fsize_class_init(GtkFsizeClass *class)
{
    GtkObjectClass *object_class;
    GtkWidgetClass *widget_class;

    object_class = (GtkObjectClass*) class;
    widget_class = (GtkWidgetClass*) class;

    widget_class->size_request  = gtk_fsize_size_request;
    widget_class->size_allocate = gtk_fsize_size_allocate;
}

static void gtk_fsize_init(GtkFsize *fsize)
{
    GTK_WIDGET_SET_FLAGS(fsize, GTK_NO_WINDOW);
}

GtkWidget *gtk_fsize_new(void)
{
    GtkFsize *fsize;

    fsize = gtk_type_new(gtk_fsize_get_type());

    return GTK_WIDGET(fsize);
}

static void gtk_fsize_size_request(GtkWidget *widget,
				   GtkRequisition *requisition)
{
    GtkFsize *fsize;
    GtkBin *bin;

    g_return_if_fail(widget != NULL);
    g_return_if_fail(GTK_IS_FSIZE(widget));
    g_return_if_fail(requisition != NULL);

    fsize = GTK_FSIZE(widget);
    bin = GTK_BIN(widget);

    requisition->width  = 1;
    requisition->height = 1;

    if (bin->child && GTK_WIDGET_VISIBLE(bin->child)) {
	GtkRequisition child_requisition;
      
	gtk_widget_size_request(bin->child, &child_requisition);

#if 0
	requisition->width  += child_requisition.width;
	requisition->height += child_requisition.height;
#endif 
    }
}

static void gtk_fsize_size_allocate(GtkWidget *widget,
				    GtkAllocation *allocation)
{
    GtkFsize *fsize;
    GtkBin *bin;
    GtkAllocation child_allocation;
    GtkRequisition child_requisition;
    gint width, height;
    gint x, y;

    g_return_if_fail(widget != NULL);
    g_return_if_fail(GTK_IS_FSIZE(widget));
    g_return_if_fail(allocation != NULL);

    widget->allocation = *allocation;
    fsize = GTK_FSIZE(widget);
    bin = GTK_BIN(widget);

    if (bin->child && GTK_WIDGET_VISIBLE(bin->child)) {
	gtk_widget_get_child_requisition(bin->child, &child_requisition);

	x = GTK_CONTAINER(fsize)->border_width;
	y = GTK_CONTAINER(fsize)->border_width;
	width = MAX(allocation->width - 2 * x, 0);
	height = MAX(allocation->height - 2 * y, 0);

	child_allocation.x      = allocation->x + x;
	child_allocation.y      = allocation->y + y;
	child_allocation.width  = width;
	child_allocation.height = height;

	gtk_widget_size_allocate(bin->child, &child_allocation);
    }
}
