/* $Id: wmroot.c,v 1.41 2000/07/26 14:47:40 komatsu Exp $ */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif /* HAVE_CONFIG_H */
 
#include "wmmain.h"
#include "wmroot.h"
#include "wmclient.h"
#include "wmwindow.h"
#include "wmmisc.h"
#include "wmmenu.h"
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif /* HAVE_UNISTD_H */
#include <gtk/gtk.h>

static void wm_root_class_init(WmRootClass *class);
static void wm_root_init(WmRoot *wm_root);
static void wm_root_destroy(GtkObject *object);
static void wm_root_realize(GtkWidget *widget);
static void wm_root_size_request(GtkWidget *widget,
				 GtkRequisition *requisition);
static void wm_root_size_allocate(GtkWidget *wiget, GtkAllocation *allocation);
static gint wm_root_expose_event(GtkWidget *wiget, GdkEventExpose *event);
static gint wm_root_delete_event(GtkWidget *wiget, GdkEventAny *event);
static gint wm_root_button_press_event(GtkWidget *wiget, 
				       GdkEventButton *event);
static gint wm_root_button_release_event(GtkWidget *wiget, 
					 GdkEventButton *event);
static gint wm_root_destroy_event(GtkWidget *wiget, GdkEventAny *event);
static gint wm_root_unmap_event(GtkWidget *wiget, GdkEventAny *event);
static gint wm_root_property_notify_event(GtkWidget *wiget, 
					  GdkEventProperty *event);
static GdkFilterReturn wm_root_anyevent_filter(GdkXEvent *xev, GdkEvent *event,
					       gpointer cb_data);
static GdkFilterReturn wm_root_cmevent_filter(GdkXEvent *xev, GdkEvent *event,
					      gpointer cb_data);

static GtkWidgetClass *parent_class = NULL;

GtkType wm_root_get_type(void)
{
    static GtkType wm_root_type = 0;

    if(!wm_root_type) {
	static const GtkTypeInfo wm_root_info =
	{
	    "WmRoot",
	    sizeof(WmRoot),
	    sizeof(WmRootClass),
	    (GtkClassInitFunc) wm_root_class_init,
	    (GtkObjectInitFunc) wm_root_init,
	    /* reserved_1 */ NULL,
	    /* reserved_2 */ NULL,
	    (GtkClassInitFunc) NULL,
	};
	wm_root_type = gtk_type_unique(GTK_TYPE_WIDGET, &wm_root_info);
    }
    return wm_root_type;
}

enum {
    WM_ROOT_CREATE_CLIENT_SIGNAL,
    WM_ROOT_DELETE_CLIENT_SIGNAL,
    LAST_SIGNAL
};

static gint wm_root_signals[LAST_SIGNAL] = { 0 };

static void wm_root_class_init(WmRootClass *class)
{
    GtkObjectClass *object_class;
    GtkWidgetClass *widget_class;

    object_class = (GtkObjectClass*) class;
    widget_class = (GtkWidgetClass*) class;

    parent_class = gtk_type_class(gtk_widget_get_type());
    
    object_class->destroy = wm_root_destroy;

    widget_class->realize               = wm_root_realize;
    widget_class->expose_event          = wm_root_expose_event;
    widget_class->delete_event          = wm_root_delete_event;
    widget_class->destroy_event         = wm_root_destroy_event;
    widget_class->unmap_event           = wm_root_unmap_event;
    widget_class->button_press_event    = wm_root_button_press_event;
    widget_class->button_release_event  = wm_root_button_release_event;
    widget_class->property_notify_event = wm_root_property_notify_event;
    widget_class->size_request          = wm_root_size_request;
    widget_class->size_allocate         = wm_root_size_allocate;

    wm_root_signals[WM_ROOT_CREATE_CLIENT_SIGNAL] = 
	gtk_signal_new("create_client", GTK_RUN_FIRST, object_class->type, 
		       GTK_SIGNAL_OFFSET(WmRootClass, create_client),
		       gtk_marshal_NONE__POINTER, 
		       GTK_TYPE_NONE, 1,
		       GTK_TYPE_POINTER);

    wm_root_signals[WM_ROOT_DELETE_CLIENT_SIGNAL] = 
	gtk_signal_new("delete_client", GTK_RUN_FIRST, object_class->type, 
		       GTK_SIGNAL_OFFSET(WmRootClass, delete_client),
		       gtk_marshal_NONE__POINTER, 
		       GTK_TYPE_NONE, 1,
		       GTK_TYPE_POINTER);

    gtk_object_class_add_signals(object_class, wm_root_signals, LAST_SIGNAL);
    class->create_client = NULL;
    class->delete_client = NULL;
}

static void wm_root_init(WmRoot *wm_root)
{
}

GtkWidget* wm_root_new()
{
    WmRoot *wm_root;

    wm_message("WmRoot: new\n");
    wm_root = gtk_type_new(wm_root_get_type());
    wm_root->width  = gdk_root_parent.width;
    wm_root->height = gdk_root_parent.height;

    wm_root_realize((GtkWidget *)wm_root);
    return GTK_WIDGET(wm_root);
}

static void wm_root_destroy(GtkObject *object)
{
    g_return_if_fail(object != NULL);
    g_return_if_fail(IS_WM_ROOT (object));

    wm_message("WmRoot: destroy\n");

    if(GTK_OBJECT_CLASS(parent_class)->destroy) {
	(* GTK_OBJECT_CLASS (parent_class)->destroy) (object);
    }
}

static void wm_root_realize(GtkWidget *widget)
{
    WmRoot *wm_root;

    g_return_if_fail(widget != NULL);
    g_return_if_fail(IS_WM_ROOT(widget));

    GTK_WIDGET_SET_FLAGS(widget, GTK_REALIZED);
    wm_root = WM_ROOT(widget);

    widget->window = GDK_ROOT_PARENT();

#if 1
    gdk_window_ref(GDK_ROOT_PARENT());
    gdk_xid_table_insert(&GDK_ROOT_WINDOW(), GDK_ROOT_PARENT());
    ((GdkWindowPrivate *)GDK_ROOT_PARENT())->destroyed = FALSE;
#endif

    gdk_window_set_user_data(GDK_ROOT_PARENT(), widget); 

    /* gdk Ǥ, SubstructureRedirectMask ʤ. */
    XSelectInput(GDK_DISPLAY(), GDK_ROOT_WINDOW(), 
		 SubstructureRedirectMask | SubstructureNotifyMask |
		 ColormapChangeMask | ButtonPressMask | ButtonReleaseMask | 
		 PropertyChangeMask);

    /* Iconify Ѥ ClientMessage ٥Ȥ */
   gdk_add_client_message_filter(wm_atom_wm_change_state,
				 wm_root_cmevent_filter, NULL);
   gdk_window_add_filter(GDK_ROOT_PARENT(), wm_root_anyevent_filter, NULL);
}

/* Iconify Ѥ ClientMessage ٥Ȥե륿ؿ */
static GdkFilterReturn wm_root_cmevent_filter(GdkXEvent *xev, GdkEvent *event,
					      gpointer cb_data)
{
    GdkFilterReturn     return_value;
    XClientMessageEvent *xevent;
    GtkWidget           *client;

    return_value = GDK_FILTER_CONTINUE;
    xevent = (XClientMessageEvent *)xev;

    wm_message("WmRoot: wm_root_cmevent_filter\n");

    if(xevent->format == 32 && xevent->data.l[0] == IconicState &&
       (client = (GtkWidget *)wm_client_list_find(xevent->window)) != NULL) {
	wm_message("WmRoot: iconify\n");
	wm_client_iconify(WM_CLIENT(client));
	return_value = GDK_FILTER_REMOVE;
    }
    return return_value;
}

/* ConfigureRequest, MapRequest ե륿ؿ */
static GdkFilterReturn wm_root_anyevent_filter(GdkXEvent *xev, GdkEvent *event,
					       gpointer cb_data)
{
    GdkFilterReturn return_value = GDK_FILTER_CONTINUE;
    XEvent         *xevent = (XEvent *)xev;
    GtkWidget      *client;

    switch(xevent->xany.type) {
    case ClientMessage:
	wm_message("WmRoot: Event - ClientMessage\n");
	break;
    case CirculateRequest:
	wm_message("WmRoot: Event - CirculateRequest\n");
	break;

    case ConfigureRequest:
	client = wm_client_list_find(xevent->xconfigurerequest.window);
	wm_message("WmRoot[%x]: Event - ConfigureRequest (%d,%d) %dx%d %d\n",
		   xevent->xconfigurerequest.window,
		   xevent->xconfigurerequest.value_mask & CWX ?
		   xevent->xconfigurerequest.x : -1,
		   xevent->xconfigurerequest.value_mask & CWY ?
		   xevent->xconfigurerequest.y : -1,
		   xevent->xconfigurerequest.value_mask & CWWidth ?
		   xevent->xconfigurerequest.width : -1,
		   xevent->xconfigurerequest.value_mask & CWHeight ?
		   xevent->xconfigurerequest.height : -1,
		   xevent->xconfigurerequest.value_mask);
	if(client) {
	    /* Widget ˤʤäƤ뤱 BaseWindow ǥȥåפʤȤ
	     * 㤨 Withdrawn . (ʳˤ⤢Τ?)
	     */
	    if(xevent->xconfigurerequest.value_mask & CWX) {
		WM_CLIENT_X(client) = xevent->xconfigurerequest.x;
	    }
	    if(xevent->xconfigurerequest.value_mask & CWY) {
		WM_CLIENT_Y(client) = xevent->xconfigurerequest.y;
	    }
	    if(xevent->xconfigurerequest.value_mask & (CWX | CWY)) {
		XMoveWindow(GDK_DISPLAY(), 
			    WM_XWINDOW(gtk_widget_get_toplevel(client)),
			    WM_CLIENT_X(client), WM_CLIENT_Y(client));
	    }
	    if(xevent->xconfigurerequest.value_mask & CWWidth) {
		WM_CLIENT_WIDTH(client)  = xevent->xconfigurerequest.width;
	    }
	    if(xevent->xconfigurerequest.value_mask & CWHeight) {
		WM_CLIENT_HEIGHT(client) = xevent->xconfigurerequest.height;
	    }
	    if(xevent->xconfigurerequest.value_mask & (CWWidth | CWHeight)) {
		gtk_widget_set_usize(client,
				     WM_CLIENT_WIDTH(client),
				     WM_CLIENT_HEIGHT(client));
	    }
	} else {
	    XWindowChanges wc;
	    wc.x = xevent->xconfigurerequest.x;
	    wc.y = xevent->xconfigurerequest.y;
	    wc.width  = xevent->xconfigurerequest.width;
	    wc.height = xevent->xconfigurerequest.height;
	    wc.border_width = 0;
/* 	    wc.sibling = None; */
	    wc.sibling = xevent->xconfigurerequest.above;
	    wc.stack_mode = Above;
/* 	    wc.sibling = wc.stack_mode = TopIf; */
	    xevent->xconfigurerequest.value_mask &= ~CWSibling;
	    xevent->xconfigurerequest.value_mask &= ~CWStackMode;
	    xevent->xconfigurerequest.value_mask |= CWBorderWidth;
	    XConfigureWindow(GDK_DISPLAY(), xevent->xconfigurerequest.window,
			     xevent->xconfigurerequest.value_mask, &wc);
	} 
	return_value = GDK_FILTER_REMOVE;
	break;

    case MapRequest:
	wm_message("WmRoot: Event - MapRequest\n");
	client = wm_client_list_find(xevent->xmaprequest.window);
	if(!client) {
	    client = wm_client_new(xevent->xmaprequest.window);
	    wm_window_border_add(client);
	} 
	gtk_widget_set_uposition(gtk_widget_get_toplevel(client),
				 WM_CLIENT_X(client), WM_CLIENT_Y(client));
	gtk_widget_show(gtk_widget_get_toplevel(client));
	wm_client_set_WMState(client, NormalState);
	WM_CLIENT_STATE(client) = NormalState;
	return_value = GDK_FILTER_REMOVE;
	break;

    case ResizeRequest:
	wm_message("WmRoot: Event - ResizeRequest\n");
	break;
    case DestroyNotify:
	wm_message("WmRoot: Event - DestroyNotify %x\n", 
		   xevent->xdestroywindow.window);
	if(0) { /* Τʥ椫. */
	    WmGroup *leader;
	    
	    leader = wm_group_find_leader(xevent->xdestroywindow.window);
	    if(leader) {
		wm_group_destroy(leader);
		all_groups = g_list_remove(all_groups, leader);
	    }
	}
	break;
    }
    return return_value;
}

    
/* ̵̣ */
static void wm_root_size_request(GtkWidget *widget, GtkRequisition*requisition)
{
    Window xroot;
    gint x, y;
    guint width, height, border, depth;

    wm_message("WmRoot: size_request\n");

    XGetGeometry(GDK_DISPLAY(), GDK_ROOT_WINDOW(), &xroot,
		 &x, &y, &width, &height, &border, &depth);
    requisition->width  = width;
    requisition->height = height;
}

/* ̵̣ */
static void wm_root_size_allocate(GtkWidget *widget, GtkAllocation *allocation)
{
    WmRoot *wm_root;

    g_return_if_fail(widget != NULL);
    g_return_if_fail(IS_WM_ROOT(widget));
    g_return_if_fail(allocation != NULL);

    wm_message("WmRoot: size_allocate\n");

    widget->allocation = *allocation;
    if(GTK_WIDGET_REALIZED(widget)) {
	wm_root = WM_ROOT(widget);
	gdk_window_move_resize(widget->window, 
			       allocation->x, allocation->y,
			       allocation->width, allocation->height);
    }
}

static gint wm_root_button_press_event(GtkWidget *widget, 
				       GdkEventButton *event)
{
    wm_message("WmRoot: button_press_event Button %d\n", event->button);

    switch(event->button) {
    case Button1:
	gtk_menu_popup(GTK_MENU(launcher),
		       NULL, NULL, NULL, NULL, event->button, event->time);
	break;
    case Button2:
	wm_menu_popup_temporarily(GTK_MENU(wm_group_menu_groups2()),
				  NULL, NULL, NULL, NULL,
				  event->button, event->time);
	break;
    case Button3:
	wm_menu_popup_temporarily(GTK_MENU(wm_menu_jobs()),
				  NULL, NULL, NULL, NULL,
				  event->button, event->time);
	break;
    }
    wm_message("WmRoot: ENDof button_press_event Button %d\n", event->button);
    return TRUE;
}

static gint wm_root_button_release_event(GtkWidget *widget,
					 GdkEventButton *event)
{
    wm_message("WmRoot: button_release_event Button %d\n", event->button);
    return FALSE;
}

static gint wm_root_expose_event(GtkWidget *widget, GdkEventExpose *event)
{
    wm_message("WmRoot: expose_event\n");
    return FALSE;
}

static gint wm_root_delete_event(GtkWidget *widget, GdkEventAny *event)
{
    wm_message("WmRoot: delete event\n");

    return FALSE;
} 

static gint wm_root_unmap_event(GtkWidget *widget, GdkEventAny *event)
{
    return FALSE;
} 

static gint wm_root_destroy_event(GtkWidget *widget, GdkEventAny *event)
{
    wm_message("WmRoot: destroy event WIN[%d]\n",
	       ((GdkWindowPrivate *)event->window)->xwindow);

    /* ǽŪˤϥʥȯƤˤơƥɥȽǤ롣 */
    /* gtk_widget_destroy(gtk_widget_get_toplevel(widget)); */

    /* TRUE ֤ event 館Ƥɬפ. */
    return TRUE;
}

static gint wm_root_property_notify_event(GtkWidget *wiget, 
					  GdkEventProperty *event)
{
    wm_message("WmRoot: Property Notify Event\n");
    return FALSE;
}

