/*
    Copyright (C) 2006-2009 Fons Adriaensen <fons@kokkinizita.net>
    
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#ifndef __TYPEWIN_H
#define	__TYPEWIN_H


#include <clxclient.h>
#include "radbut.h"


class Typewin : public X_window, public X_callback
{
public:

  enum { XSIZE = 530, YSIZE = 155 };

  Typewin (X_rootwin *parent, X_callback *callb, X_resman *xres, int xp, int yp);
  ~Typewin (void);
  Typewin (const Typewin&);
  Typewin& operator=(const Typewin&);

  int coeff (void) const { return _rcoeff.stat (); }
  int h_ord (void) const { return _rh_ord.stat () + 1; }
  int v_ord (void) const { return _rv_ord.stat (); }
  int nband (void) const { return _rnband.stat () + 1; }
  int nspkr (void) const { return _nspkr; }

private:

  enum { B_CANCEL, B_CREATE };

  void handle_event (XEvent *);
  void handle_callb (int type, X_window *W, XEvent *E);
  void clmesg (XClientMessageEvent *E);
  void checkpar (void);

  Atom            _atom;
  X_callback     *_callb;
  Radbut          _rcoeff; 
  Radbut          _rh_ord; 
  Radbut          _rv_ord; 
  Radbut          _rnband; 
  X_textip       *_tnspkr; 
  X_button       *_bcancel; 
  X_button       *_bcreate; 
  int             _nspkr;

  static const char *_rcoeff_text [3];
  static const char *_rh_ord_text [3];
  static const char *_rv_ord_text [3];
  static const char *_rbands_text [2];
 
};


#endif
