# E.5 Can ethical consumerism stop the ecological crisis?

No. At best, it can have a limited impact in reducing environmental
degradation and so postpone the ecological crisis. At worse, it could
accelerate that crisis by creating new markets and thus increasing growth.

Before discussing why and just so there is no misunderstanding, we must stress
that anarchists fully recognise that using recycled or renewable raw
materials, reducing consumption and buying "ecologically friendly" products
and technologies **are** very important. As such, we would be the last to
denounce such a thing. But such measures are of very limited use as solutions
to the ecological problems we face. At best they can only delay, not prevent,
capitalism's ultimate destruction of the planet's ecological base.

Green consumerism is often the only thing capitalism has to offer in the face
of mounting ecological destruction. Usually it boils down to nothing more than
slick advertising campaigns by big corporate polluters to hype band-aid
measures such as using a few recycled materials or contributing money to a
wildlife fund, which are showcased as "concern for the environment" while off
camera the pollution and devouring of non-renewable resources goes on. They
also engage in "greenwashing", in which companies lavishly fund PR campaigns
to paint themselves "green" without altering their current polluting
practices!

This means that apparently "green" companies and products actually are not.
Many firms hire expensive Public Relations firms and produce advertisements to
paint a false image of themselves as being ecologically friendly (i.e. perform
"greenwashing"). This indicates a weakness of market economies -- they hinder
(even distort) the flow of information required for consumers to make informed
decisions. The market does not provide enough information for consumers to
determine whether a product **is** actually green or not -- it just gives them
a price supplemented by (often deliberately misleading) advertising designed
to manipulate the consumer and present an appropriate corporate image.
Consumers have to rely on other sources, many of which are minority journals
and organisations and so difficult to find, to provide them with the accurate
information required to countermand the power and persuasion of advertising
and the work of PR experts. This helps explain why, for example, _"large
agribusiness firms are now attempting, like Soviet commissars, to stifle
criticism of their policies"_ by means of _"veggie libel laws."_ These laws,
which in 2001 had been passed in 13 American states (_"backed by
agribusiness"_) _"make it illegal to criticise agricultural commodities in a
manner inconsistent with 'reasonable' scientific evidence. The whole concept
of 'veggie libel' laws is probably unconstitutional; nevertheless, these laws
remain on the books."_ [Eric Schlosser, **Fast Food Nation**, p. 266]

We should not discount the impact of PR experts in shaping the way people see
the world or decide to consume. A lot of resources are poured into corporate
Public Relations in order to present a green image. _"In the perverse world of
corporate public relations,"_ note critics John Stauber and Sheldon Rampton,
_"propagandising and lobbying **against** environmental protection is called
'environmental' or 'green' PR. 'Greenwashing' is a more accurate pejorative
now commonly used to describe the ways that polluters employ deceptive PR to
falsely paint themselves an environmentally responsible public image . . .
Today a virulent, pro-industry, **anti**-environmentalism is on the rise . . .
PR experts . . . are waging and winning a war against environmentalists on
behalf of corporate clients in the chemical, energy, food, automobile,
forestry and mining industries."_ A significant amount of cash is spent (an
estimated $1 billion a year by the mid-1990s) _"on the services of anti-
environmental PR professionals and on 'greenwashing' their corporate image."_
[**Toxic Sludge is Good for You!**, p. 125] See the chapter called _"Silencing
Spring"_ in Stauber's and Rampton's book **Toxic Sludge is Good for You!** for
a good summary of this use of PR firms.

Even apparently ecologically friendly firms like "The Body Shop" can present a
false image of what they do. For example, journalist Jon Entine investigated
that company in 1994 and discovered that only a minuscule fraction of its
ingredients came from **Trade Not Aid** (a program claimed to aid developing
countries). Entine also discovered that the company also used many outdated,
off-the-shelf product formulas filled with non-renewable petrochemicals as
well as animal tested ingredients. When Entine contacted the company he
received libel threats and it hired a PR company to combat his story. [Stauber
and Rampton, **Op. Cit.**, pp. 74-5] This highlights the dangers of looking to
consumerism to solve ecological problems. As Entine argued:

> _ "The Body Shop is a corporation with the privileges and power in society
as all others. Like other corporations it makes products that are
unsustainable, encourages consumerism, uses non-renewable materials, hires
giant PR and law firms, and exaggerates its environment policies. If we are to
become a sustainable society, it is crucial that we have institutions . . .
that are truly sustainable. The Body Shop has deceived the public by trying to
make us think that they are a lot further down the road to sustainability than
they really are. We should . . . no longer . . . lionise the Body Shop and
others who claim to be something they are not."_ [quoted by Stauber and
Rampton, **Op. Cit.**, p. 76]

Even ignoring the distorting influence of advertising and corporate-paid PR,
the fundamental issue remains of whether consumerism can actually
fundamentally influence how business works. One environmental journalist puts
the arguments well in his excellent book on "Fast Food" (from the
industrialisation of farming, to the monopolisation of food processing, to the
standardisation of food consumption it). As he puts corporations will _"sell
free-range, organic, grass-fed hamburgers if you demand it. They will sell
whatever sells at a profit."_ [Eric Schlosser, **Op. Cit.**, p. 269] He
complements this position by suggesting various regulations and some role for
trade unions.

Which, of course, is true. It is equally true that we are not forced to buy
any specific product, which is why companies spend so much in convincing us to
buy their products. Yet even ignoring the influence of advertising, it is
unlikely that using the market will make capitalism nicer. Sadly, the market
rewards the anti-social activities that Schlosser and other environmentalists
chronicle. As he himself notes, the _"low price of a fast food hamburger does
not reflect its real cost . . . The profits of the fast food chains have been
made possible by the losses imposed on the rest of society."_ [**Op. Cit.**,
p. 261] This means that the idea that by using the market we can "reform"
capitalism is flawed simply because even "good" companies have to make a
profit and so will be tempted to cut costs, inflict them on third parties
(such as workers, consumers and the planet). The most obvious form of such
externalities is pollution. Such anti-social and anti-ecological behaviour
makes perfect business sense as prices fall when costs are passed on to others
in the form of externalities. Thus firms which employ debt-slaves in
sweatshops while polluting the atmosphere in a third-world dictatorship will
have lower costs and so prices than those employing unionised workers under
eco-friendly regulations.

The amazing thing is that being concerned about such issues is considered as a
flaw in economics. In fact, seeking the lowest price and ignoring the social
and ecological impact of a product is _"considered virtuousness"_ by the
market and by economists for, as green economist E. F. Schumacher, pointed out
_"[i]f a buyer refused a good bargain because he suspected that the cheapness
of the goods in question stemmed from exploitation or other despicable
practices (except theft), he would be open to criticism of behaving
'uneconomically' which is viewed as nothing less than a fall from grace.
Economists and others are wont to treat such eccentric behaviour with derision
if not indignation. The religion of economics has its own code of ethics, and
the First Commandment is to behave 'economically.'"_ [**Small is Beautiful**,
p. 30] And, of course, such a consumer would face numerous competitors who
will happily take advantage of such activities.

Then there is the issue of how the market system hides much more information
than it gives (a factor we will return to in [section
I.1.2](secI1.html#seci12)). Under the price system, customers have no way of
knowing the ecological (or social) impact of the products they buy. All they
have is a price and that simply does not indicate how the product was produced
and what costs were internalised in the final price and which were
externalised. Such information, unsurprisingly, is usually supplied
**outside** the market by ecological activists, unions, customer groups and so
on. Then there is the misinformation provided by the companies themselves in
their adverts and PR campaigns. The skilfully created media images of
advertising can easily swamp the efforts of these voluntary groups to inform
the public of the facts of the social and environmental costs of certain
products. Besides, any company has the threat of court action to silence their
critics as the cost in money, resources, energy and time to fight for free
speech in court is an effective means to keep the public ignorant about the
dark side of capitalism.

This works the other way too. Simply put, a company has no idea whether you
not buying a product is based on ethical consumption decisions or whether it
is due to simple dislike of the product. Unless there is an organised consumer
boycott, i.e. a collective campaign, then the company really has no idea that
it is being penalised for its anti-ecological and/or anti-social actions.
Equally, corporations are so interlinked that it can make boycotts
ineffective. For example, unless you happened to read the business section on
the day McDonalds bought a sizeable share in Pret-a-Manger you would have no
idea that going there instead of McDonalds would be swelling the formers
profits.

Ultimately, the price mechanism does not provide enough information for the
customer to make an informed decision about the impact of their purchase and,
by reducing prices, actively rewards the behaviour Schlosser condemns. After
all, what is now "organic" production was just the normal means of doing it.
The pressures of the market, the price mechanism so often suggested as a tool
for change, ensured the industrialisation of farming which so many now rightly
condemn. By reducing costs, market demand increased for the cheaper products
and these drove the other, more ecologically and socially sound, practices out
of business.

Which feeds into the issue of effective demand and income limitations. The
most obvious problem is that the market is **not** a consumer democracy as
some people have more votes than others (in fact, the world's richest people
have more "votes" than the poorest billions, combined!). Those with the most
"votes" (i.e. money) will hardly be interested in changing the economic system
which placed them in that position. Similarly, those with the least "votes"
will be more willing to buy ecologically destructive products simply to make
ends meet rather than any real desire to do so. In addition, one individual's
decision **not** to buy something will easily be swamped by others seeking the
best deal, i.e. the lowest prices, due to economic necessity or ignorance.
Money (quantity) counts in the market, not values (quality).

Then there is the matter of sourcing of secondary products. After all, most
products we consume are made up of a multitude of other goods and it is
difficult, if not impossible, to know where these component parts come from.
Thus we have no real way of knowing whether your latest computer has parts
produced in sweatshops in third-world countries nor would a decision not to
buy it be communicated that far back down the market chain (in fact, the
company would not even know that you were even **thinking** about buying a
product unless you used non-market means to inform them and then they may
simply dismiss an individual as a crank).

So the notion that consumerism can be turned to pressurising companies is
deeply flawed. This is **not** to suggest that we become unconcerned about how
we spend our money. Far from it. Buying greener products rather than the
standard one does have an impact. It just means being aware of the limitations
of green consumerism, particularly as a means of changing the world. Rather,
we must look to changing how goods are produced. This applies, of course, to
shareholder democracy as well. Buying shares in a firm rarely results in an
majority at the annual meetings nor, even if it did, does it allow an
effective say in the day-to-day decisions management makes.

Thus green consumerism is hindered by the nature of the market -- how the
market reduces everything to price and so hides the information required to
make truly informed decisions on what to consume. Moreover, it is capable of
being used to further ecological damage by the use of PR to paint a false
picture of the companies and their environmental activities. In this way, the
general public think things are improving while the underlying problems remain
(and, perhaps, get worse). Even assuming companies are honest and do minimise
their environmental damage they cannot face the fundamental cause of the
ecological crisis in the "grow-or-die" principle of capitalism ("green" firms
need to make profits, accumulate capital and grow bigger), nor do they address
the pernicious role of advertising or the lack of public control over
production and investment under capitalism. Hence it is a totally inadequate
solution.

As green Sharon Beder notes, green marketing aims at _"increasing consumption,
not reducing it. Many firms [seek] to capitalise on new markets created by
rising environmental consciousness"_ with such trends prompting _"a surge of
advertisements and labels claiming environmental benefits. Green imagery was
used to sell products, and caring for the environment became a marketing
strategy"_ and was a _"way of redirecting a willingness to spend less into a
willingness to buy green products."_ This means that firms can _"expand their
market share to include consumers that want green products. Since
manufacturers still make environmentally damaging products and retailers still
sell non-green products on shelves next to green ones, it is evident that
green marketing is merely a way of expanding sales. If they were genuinely
concerned to protect the environment they would replace the unsound products
with sound ones, not just augment their existing lines."_ Moreover, green
marketing _"does not necessarily mean green products, but false and misleading
claims can be hard for consumers to detect"_ while the _"most cynical
marketers simply use environmental imagery to conjure up the impression that a
product is good for the environment without making any real claims at all."_
Ultimately, green consumerism _"reduces people to consumers. Their power to
influence society is reduced to their purchasing power."_ It _"does not deal
with issues such as economic growth on a finite planet, the power of
transnational corporations, and the way power is structured in our society."_
[**Global Spin**, pp. 176-80]

Andrew Watson sums up green consumerism very eloquently as follows:

> _ "green consumerism, which is largely a cynical attempt to maintain profit
margins, does not challenge capital's eco-cidal accumulation, but actually
facilitates it by opening a new market. All products, no matter how 'green',
cause some pollution, use some resources and energy, and cause some ecological
disturbance. This would not matter in a society in which production was
rationally planned, but in an exponentially expanding economy, production,
however 'green', would eventually destroy the Earth's environment. Ozone-
friendly aerosols, for example, still use other harmful chemicals; create
pollution in their manufacture, use and disposal; and use large amounts of
resources and energy. Of course, up to now, the green pretensions of most
companies have been exposed largely as presenting an acceptably green image,
with little or no substance. The market is presented as the saviour of the
environment. Environmental concern is commodified and transformed into
ideological support for capitalism. Instead of raising awareness of the causes
of the ecological crisis, green consumerism mystifies them. The solution is
presented as an individual act rather than as the collective action of
individuals struggling for social change. The corporations laugh all the way
to the bank."_ [**From Green to Red**, pp. 9-10]

"Ethical" consumerism, like "ethical" investment, is still based on profit
making, the extraction of surplus value from others. This is hardly "ethical,"
as it cannot challenge the inequality in exchange and power that lies at the
heart of capitalism nor the authoritarian social relationships it creates.
Therefore it cannot really undermine the ecologically destructive nature of
capitalism.

In addition, since capitalism is a world system, companies can produce and
sell their non-green and dangerous goods elsewhere. Many of the products and
practices banned or boycotted in developed countries are sold and used in
developing ones. For example, Agent Orange (used as to defoliate forests
during the Vietnam War by the US) is used as an herbicide in the Third World,
as is DDT. Agent Orange contains one of the most toxic compounds known to
humanity and was responsible for thousands of deformed children in Vietnam.
Ciba-Geigy continued to sell Enterovioform (a drug which caused blindness and
paralysis in at least 10,000 Japanese users of it) in those countries that
permitted it to do so. Many companies have moved to developing countries to
escape the stricter pollution and labour laws in the developed countries.

Neither does green consumerism question why it should be the ruling elites
within capitalism that decide what to produce and how to produce it. Since
these elites are driven by profit considerations, if it is profitable to
pollute, pollution will occur. Moreover, green consumerism does not challenge
the (essential) capitalist principle of consumption for the sake of
consumption, nor can it come to terms with the fact that "demand" is created,
to a large degree, by "suppliers," specifically by advertising agencies that
use a host of techniques to manipulate public tastes, as well as using their
financial clout to ensure that "negative" (i.e. truthful) stories about
companies' environmental records do not surface in the mainstream media.

Because ethical consumerism is based **wholly** on market solutions to the
ecological crisis, it is incapable even of recognising a key **root** cause of
that crisis, namely the atomising nature of capitalism and the social
relationships it creates. Atomised individuals ("soloists") cannot change the
world, and "voting" on the market hardly reduces their atomisation. As Murray
Bookchin argues, _"[t]ragically, these millions [of "soloists"] have
surrendered their social power, indeed, their very personalities, to
politicians and bureaucrats who live in a nexus of obedience and command in
which they are normally expected to play subordinate roles. **Yet this is
precisely the immediate cause of the ecological crisis of our time** \-- a
cause that has its historic roots in the market society that engulfs us."_
[**Toward an Ecological Society**, p. 81] This means that fighting ecological
destruction today must be a **social** movement rather than one of individual
consumption decisions or personalistic transformation. These can go on without
questioning the ecocidal drive of capitalism which _"will insidiously simplify
the biosphere (making due allowances for 'wilderness' reserves and theme
parks), steadily reduce the organic to the inorganic and the complex to the
simple, and convert soil into sand -- all at the expense of the biosphere's
integrity and viability. The state will still be an ever-present means for
keeping oppressed people at bay and will 'manage' whatever crises emerge as
best it can. Ultimately, society will tend to become more and more
authoritarian, public life will atrophy."_ [Bookchin, _"The Future of the
Ecology Movement,"_ pp. 1-20, **Which Way for the Ecology Movement?**, p. 14]

All this is not to suggest that individual decisions on what to consume are
irrelevant, far from it. Nor are consumer boycotts a waste of time. If
organised into mass movements and linked to workplace struggle they can be
very effective. It is simply to point out that individual actions, important
as they are, are no solution to **social** problems. Thus Bookchin:

> _ "The fact is that we are confronted by a thoroughly irrational social
system, not simply by predatory individuals who can be won over to ecological
ideas by moral arguments, psychotherapy, or even the challenges of a troubled
public to their products and behaviour . . . One can only commend the
individuals who by virtue of their consumption habits, recycling activities.
and appeals for a new sensibility undertake public activities to stop
ecological degradation. Each surely does his or her part. But it will require
a much greater effort -- and organised, clearly conscious, and forward-looking
political **movement** \-- to meet the basic challenges posed by our
aggressively **anti**-ecological society.  
>  _

>

> _"Yes, we as individuals should change our lifestyles as much as possible,
but it is the utmost short-sightedness to believe that that is all or even
primarily what we have to do. We need to restructure the entire society, even
as we engage in lifestyle changes and single-issue struggles against
pollution, nuclear power plants, the excessive use of fossil fuels, the
destruction of soil, and so forth. We must have a coherent analysis of the
deep-seated hierarchical relationships and systems of domination, as well as
class relationships and economic exploitation, that degrade people as well as
the environment."_ [_"The Ecological Crisis, Socialism, and the need to remake
society,"_ pp. 1-10, **Society and Nature**, vol. 2, no. 3, p. 4]

Using the capitalist market to combat the effects produced by that same market
is no alternative. Until capitalism and the state are dismantled, solutions
like ethical consumerism will be about as effective as fighting a forest fire
with a water pistol. Such solutions are doomed to failure because they promote
individual responses to social problems, problems that by their very nature
require collective action, and deal only with the symptoms, rather than
focusing on the cause of the problem in the first place. Real change comes
from collective struggle, not individual decisions within the market place
which cannot combat the cancerous growth principle of the capitalist economy.
As such, ethical consumerism does not break from the logic of capitalism and
so is doomed to failure.

[‹ E.4 Can laissez-faire capitalism protect the environment?](/afaq/secE4.html
"Go to previous page" ) [up](/afaq/secEcon.html "Go to parent page" ) [E.6
What is the population myth? ›](/afaq/secE6.html "Go to next page" )

