
/*
This Java source file was generated by test-to-java.xsl
and is a derived work from the source document.
The source document contained the following notice:


Copyright (c) 2001-2003 World Wide Web Consortium,
(Massachusetts Institute of Technology, Institut National de
Recherche en Informatique et en Automatique, Keio University). All
Rights Reserved. This program is distributed under the W3C's Software
Intellectual Property License. This program is distributed in the
hope that it will be useful, but WITHOUT ANY WARRANTY; without even
the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.
See W3C License http://www.w3.org/Consortium/Legal/ for more details.

*/

package org.w3c.domts.level1.core;

import org.w3c.dom.*;


import org.w3c.domts.DOMTestCase;
import org.w3c.domts.DOMTestDocumentBuilderFactory;



/**
 *     If the "newChild" is already in the tree, it is first
 *     removed before the new one is appended.
 *     
 *     Retrieve the "em" second employee and   
 *     append the first child to the end of the list.   After
 *     the "appendChild(newChild)" method is invoked the first 
 *     child should be the one that was second and the last
 *     child should be the one that was first.
* @author Curt Arnold
* @see <a href="http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-184E7107">http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-184E7107</a>
* @see <a href="http://www.w3.org/Bugs/Public/show_bug.cgi?id=246">http://www.w3.org/Bugs/Public/show_bug.cgi?id=246</a>
*/
public final class hc_nodeappendchildchildexists extends DOMTestCase {

   /**
    * Constructor.
    * @param factory document factory, may not be null
    * @throws org.w3c.domts.DOMTestIncompatibleException Thrown if test is not compatible with parser configuration
    */
   public hc_nodeappendchildchildexists(final DOMTestDocumentBuilderFactory factory)  throws org.w3c.domts.DOMTestIncompatibleException {
      super(factory);

    //
    //   check if loaded documents are supported for content type
    //
    String contentType = getContentType();
    preload(contentType, "hc_staff", true);
    }

   /**
    * Runs the test case.
    * @throws Throwable Any uncaught exception causes test to fail
    */
   public void runTest() throws Throwable {
      Document doc;
      NodeList elementList;
      NodeList childList;
      Node childNode;
      Node newChild;
      Node memberNode;
      String memberName;
      java.util.List refreshedActual = new java.util.ArrayList();
      
      java.util.List actual = new java.util.ArrayList();
      
      int nodeType;
      java.util.List expected = new java.util.ArrayList();
      expected.add("strong");
      expected.add("code");
      expected.add("sup");
      expected.add("var");
      expected.add("acronym");
      expected.add("em");
      
      Node appendedChild;
      doc = (Document) load("hc_staff", true);
      elementList = doc.getElementsByTagName("p");
      childNode = elementList.item(1);
      childList = ((Element) /*Node */childNode).getElementsByTagName("*");
      newChild = childList.item(0);
      appendedChild = childNode.appendChild(newChild);
      for (int indexN10085 = 0; indexN10085 < childList.getLength(); indexN10085++) {
          memberNode = (Node) childList.item(indexN10085);
    memberName = memberNode.getNodeName();
      actual.add(memberName);
        }
      assertEqualsAutoCase("element", "liveByTagName", expected, actual);
        childList = childNode.getChildNodes();
      for (int indexN1009C = 0; indexN1009C < childList.getLength(); indexN1009C++) {
          memberNode = (Node) childList.item(indexN1009C);
    nodeType = (int) memberNode.getNodeType();
      
      if (equals(1, nodeType)) {
          memberName = memberNode.getNodeName();
      refreshedActual.add(memberName);
      }
      }
      assertEqualsAutoCase("element", "refreshedChildNodes", expected, refreshedActual);
        }
   /**
    *  Gets URI that identifies the test.
    *  @return uri identifier of test
    */
   public String getTargetURI() {
      return "http://www.w3.org/2001/DOM-Test-Suite/level1/core/hc_nodeappendchildchildexists";
   }
   /**
    * Runs this test from the command line.
    * @param args command line arguments
    */
   public static void main(final String[] args) {
        DOMTestCase.doMain(hc_nodeappendchildchildexists.class, args);
   }
}

