/*
 * defaults.c
 * Copyright (C) 2000  Kh. Naba Kumar Singh
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/* This variable is used in project dbase */
/* To bring in the default project */

char * default_project = 
{
	"project.name=Dummy\n"
	"project.version=0.1\n"
	"project.source.target=dummy\n"
	"project.menu.group=Applications\n"
	"project.menu.entry=Dummy\n"
	"project.menu.need.terminal=1\n"
	"module.include.name=include\n"
	"module.source.name=src\n"
	"module.source.type=executable\n"
	"module.source.files=\n"
	"module.help.name=help\n"
	"module.help.type=Gnome help system\n"
	"module.help.files=\n"
	"module.data.name=data\n"
	"module.data.type=\n"
	"module.data.files=\n"
	"module.pixmap.name=pixmaps\n"
	"module.pixmap.type=Gnome pixmaps\n"
	"module.pixmap.files=\n"
	"module.doc.name=doc\n"
	"module.doc.type=\n"
	"module.doc.files=\n"
	"module.po.files=\n"
	"module.macro.files=\n"
	"compiler.options.include.paths=\n"
	"compiler.options.library.paths=\n"
	"compiler.options.libraries=\n"
	"compiler.options.defines=\n"
	"compiler.options.warning.buttons=0 0 1 1 1 1 1 1 1 1 1 0 1 1 0 1 \n"
	"compiler.options.optimize.buttons=0 1 0 0 \n"
	"compiler.options.other.buttons=1 0 \n"
	"compiler.options.other.c.options=\n"
	"compiler.options.other.l.options=\n"
};


/* These are the build in default settings */
/* Almost everything here can be found in the */
/* internal configuration file: internal.properties. */
/* These have been provided, in case the file */
/* could not be found at startup. Anjuta will fall to this build in settings */
/* This will bring the minimal functionality to Anjuta without crashing it. */

/* Sorry for such a long variable ;)*/

char* default_settings=
{
"autoformat.custom.style= -i8 -sc -bli0 -bl0 -cbi0 -ss\n"
"autoformat.style=Style of Kangleipak\n"
"editor.tag.pos=top\n"
"command.print=lpr\n"
"maximum.recent.projects=6\n"
"maximum.recent.files=10\n"
"maximum.combo.history=8\n"
"dialog.on.build.complete=0\n"
"beep.on.build.complete=1\n"
"build.option.keep.going=1\n"
"build.option.debug=0\n"
"build.option.silent=0\n"
"build.option.warn.undef=0\n"
"build.option.jobs=0\n"
"disable.syntax.hilighting=0\n"
"save.automatic=1\n"
"autosave.timer=10\n"
"save.session.timer=10\n"
"strip.trailing.spaces=1\n"
"fold.on.open=0\n"
"autoformat.disable=0\n"
"editor.tag.hide=0\n"
"truncat.messages=0\n"
"truncat.mesg.first=50\n"
"truncat.mesg.last=50\n"
"automatic.tags.update=1\n"
"tabsize=8\n"
"indent.size=8\n"
"use.tabs=1\n"
"indent.automatic=1\n"
"indent.opening=0\n"
"indent.closing=0\n"
"caret.period=350\n"
"caret.fore=#000000\n"
"caret.width=1\n"
"calltip.back=#FFF0F\n"
"edge.column=100\n"
"edge.mode=0\n"
"edge.colour=#C0DCC0\n"
"selection.fore=#FFFFFF\n"
"selection.back=#000000\n"
"margin.linenumber.visible=0\n"
"margin.marker.visible=1\n"
"margin.fold.visible=1\n"
"margin.linenumber.width=40\n"
"margin.marker.width=16\n"
"margin.fold.width=14\n"
"buffered.draw=1\n"
"braces.check=1\n"
"braces.sloppy=1\n"
"default.file.ext=x.c\n"
"vc.home.key=1\n"
"highlight.indentation.guides=1\n"
"strip.trailing.spaces=1\n"
"print.magnification=-4\n"
"print.colour.mode=1\n"
"fold=1\n"
"fold.flags=16\n"
"fold.use.plus=1\n"
"fold.on.open=0\n"
"styling.within.preprocessor=1\n"
"calltip.*.ignorecase=0\n"
"autocomplete.*.ignorecase=0\n"
"autocomplete.choose.single=1\n"
"blank.margin.left=1\n"
"blank.margin.right=1\n"
"horizontal.scrollbar=1\n"
"chars.alpha=abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ\n"
"chars.numeric=0123456789\n"
"chars.accented=\n"
"source.files=*.c;*.cc;*.cpp;*.cs;*.cxx;*.h;*.hh;*.hxx;*.hpp;*.java;*.js;\n"
"file.is.source.$(source.files)=1\n"
"view.eol=0\n"
"view.whitespace=0\n"
"view.indentation.whitespace=1\n"
"view.indentation.guides=0\n"
"statusbar.visible=1\n"
"main.toolbar.visible=1\n"
"extended.toolbar.visible=0\n"
"browser.toolbar.visible=1\n"
"debug.toolbar.visible=0\n"
"format.toolbar.visible=1\n"
"tags.toolbar.visible=1\n"
"file.patterns.c=*.c;\n"
"file.patterns.cpp=*.cpp;*.cxx;*.cc\n"
"file.patterns.header=*.h;*.hh;*.hpp;*.hxx\n"
"file.patterns.java=*.java\n"
"file.patterns.js=*.js\n"
"file.patterns.web=*.html;*.htm;*.asp;*.shtml\n"
"file.patterns.php=*.php3;*.phtml;*.inc;*.php\n"
"file.patterns.html=*.html;*.htm;*.asp;*.shtml;*.php3;*.phtml;*.inc;*.php\n"
"file.patterns.xml=*.xml;*.xsl;*.xul;*.sgml;*.omf\n"
"file.patterns.props=*.properties;*.ini;*.inf;*.reg\n"
"file.patterns.project=*.prj\n"
"file.patterns.icon=*.xpm;*.png\n"
"file.patterns.image=*.jpg;*.gif;*.tif;*.bmp,\n"
"file.patterns.braces=$(file.patterns.cpp);$(file.patterns.idl);*.java;$(file.patterns.cs)\n"
"lexer.$(file.patterns.c)=cpp\n"
"lexer.$(file.patterns.cpp)=cpp\n"
"lexer.$(file.patterns.header)=cpp\n"
"lexer.$(file.patterns.java)=cpp\n"
"lexer.$(file.patterns.js)=cpp\n"
"lexer.$(file.patterns.props)=props\n"
"lexer.$(file.patterns.project)=props\n"
"filetype.$(file.patterns.c)=c\n"
"filetype.$(file.patterns.cpp)=cpp\n"
"filetype.$(file.patterns.header)=header\n"
"filetype.$(file.patterns.java)=java\n"
"filetype.$(file.patterns.js)=js\n"
"filetype.$(file.patterns.props)=props\n"
"filetype.$(file.patterns.project)=project\n"
"filetype.$(file.patterns.icon)=icon\n"
"filetype.$(file.patterns.image)=image\n"
"file.has.folds.$(file.patterns.cpp)=1\n"
"file.has.tags.$(file.patterns.cpp)=1\n"
"file.can.autoformat.$(file.patterns.cpp)=1\n"
"file.has.folds.$(file.patterns.c)=1\n"
"file.has.tags.$(file.patterns.c)=1\n"
"file.can.autoformat.$(file.patterns.c)=1\n"
"file.has.folds.$(file.patterns.header)=1\n"
"file.has.tags.$(file.patterns.header)=1\n"
"file.can.autoformat.$(file.patterns.header)=1\n"
"file.has.folds.$(file.patterns.java)=1\n"
"file.has.folds.$(file.patterns.js)=1\n"
"keywordclass.c=asm auto bool break case char const const_cast continue \\\n"
"do double dynamic_cast else enum explicit export extern float for \\\n"
"goto if inline int long \\\n"
"register reinterpret_cast return short signed sizeof static static_cast struct switch \\\n"
"default template typedef typeid typename union unsigned using \\\n"
"void volatile wchar_t while\n"
"keywords.$(file.patterns.c)=$(keywordclass.c)\n"
"keywordclass.cpp=\\\n"
"catch class delete false friend mutable namespace new \\\n"
"operator private protected public this throw true virtual\n"
"keywords.$(file.patterns.cpp)=$(keywordclass.cpp) $(keywordclass.c)\n"
"keywords.$(file.patterns.header)=$(keywordclass.cpp) $(keywordclass.c)\n"
"word.chars.cxx=$(chars.alpha)$(chars.numeric)_#\n"
"word.characters.$(file.patterns.cpp)=$(word.chars.cxx)\n"
"word.characters.$(file.patterns.c)=$(word.chars.cxx)\n"
"word.characters.$(file.patterns.header)=$(word.chars.cxx)\n"
"statement.indent.$(file.patterns.cpp)=5 case catch class default do else for if \\\n"
"private protected public struct try union while\n"
"statement.indent.$(file.patterns.header)=5 case catch class default do else for if \\\n"
"private protected public struct try union while\n"
"statement.indent.$(file.patterns.c)=5 case do else for if struct union while\n"
"statement.end.$(file.patterns.cpp)=10 ;\n"
"statement.end.$(file.patterns.c)=10 ;\n"
"statement.end.$(file.patterns.header)=10 ;\n"
"statement.lookback.$(file.patterns.cpp)=20\n"
"statement.lookback.$(file.patterns.c)=20\n"
"statement.lookback.$(file.patterns.header)=20\n"
"block.start.$(file.patterns.cpp)=10 {\n"
"block.end.$(file.patterns.cpp)=10 }\n"
"block.start.$(file.patterns.c)=10 {\n"
"block.end.$(file.patterns.c)=10 }\n"
"block.start.$(file.patterns.header)=10 {\n"
"block.end.$(file.patterns.header)=10 }\n"
"styling.within.preprocessor=1\n"
"keywordclass.java=abstract boolean break byte case catch char class const \\n"
"continue default do double else extends final finally float for future \\n"
"generic goto if implements import inner instanceof int interface long \\n"
"native new null operator outer package private protected public rest \\n"
"return short static super switch synchronized this throw throws \\n"
"transient try var void volatile while\n"
"keywords.*.java=$(keywordclass.java)\n"
"keywordclass.javascript=abstract boolean break byte case catch char class \\\n"
"const continue debugger default delete do double else enum export extends \\\n"
"final finally float for function goto if implements import in instanceof \\\n"
"int interface long native new package private protected public \\\n"
"return short static super switch synchronized this throw throws \\\n"
"transient try typeof var void volatile while with\\n"
"keywords.*.js=$(keywordclass.javascript)\n"
"file.interpreted.$(file.patterns.java)=1\n"
"file.interpreted.$(file.patterns.js)=1\n"
"style.cpp.0=$(style.default.whitespace)\n"
"style.cpp.1=$(style.default.comment)\n"
"style.cpp.2=$(style.default.comment)\n"
"style.cpp.3=$(style.default.comment)\n"
"style.cpp.4=$(style.default.number)\n"
"style.cpp.5=$(style.default.keyword)\n"
"style.cpp.6=$(style.default.doublequote)\n"
"style.cpp.7=$(style.default.singlequote)\n"
"style.cpp.8=fore:#804080\n"
"style.cpp.9=$(style.default.preprocessor)\n"
"style.cpp.10=$(style.default.operator)\n"
"style.cpp.11=$(style.default.identifier)\n"
"style.cpp.12=$(style.default.unclosedstring)\n"
"style.cpp.13=fore:#007F00,back:#E0FFE0,eolfilled\n"
"braces.cpp.style=10\n"
"make=make\n"
"command.build.module=$(make) $(anjuta.make.options)\n"
"command.build.project=$(make) $(anjuta.make.options)\n"
"command.build.tarball=$(make) $(anjuta.make.options) dist\n"
"command.build.install=$(make) $(anjuta.make.options) install\n"
"command.build.clean=$(make) $(anjuta.make.options) clean\n"
"command.build.clean.all=$(make) $(anjuta.make.options) distclean\n"
"command.execute.project=./$(project.source.target) $(anjuta.program.arguments)\n"
"command.terminal=gnome-terminal --command=\"$(anjuta.current.command)\"\n"
"anjuta.compiler.flags=-O -g\n"
"anjuta.linker.flags=\n"
"command.view.file.$(file.patterns.icon)=gnome-iconedit $(current.file.name.ext)\n"
"command.view.file.$(file.patterns.image)=gimp $(current.file.name.ext)\n"
"command.view.file.$(file.patterns.html)=gnome-help-browser file:$(current.full.filename.ext)\n"
"command.open.file.$(file.patterns.icon)=gnome-iconedit $(current.file.name.ext)\n"
"command.open.file.$(file.patterns.image)=gimp $(current.file.name.ext)\n"
"command.open.file.$(file.patterns.html)=\n"
"command.compile.file.$(file.patterns.c)=gcc $(anjuta.compiler.flags) -c $(current.file.name.ext) -o $(current.file.name).o\n"
"command.make.file.$(file.patterns.c)=$(make) $(current.file.name).o\n"
"command.build.file.$(file.patterns.c)=gcc $(anjuta.compiler.flags) $(anjuta.linker.flags) $(current.file.name.ext) -o $(current.file.name)\n"
"command.execute.file.$(file.patterns.c)=$(current.full.filename) $(anjuta.program.arguments)\n"
"command.compile.file.$(file.patterns.cpp)=g++ $(anjuta.compiler.flags) -c $(current.file.name.ext) -o $(current.file.name).o\n"
"command.make.file.$(file.patterns.cpp)=$(make) $(current.file.name).o\n"
"command.build.file.$(file.patterns.cpp)=g++ $(anjuta.compiler.flags) $(anjuta.linker.flags) $(current.file.name.ext) -o $(current.file.name)\n"
"command.execute.file.$(file.patterns.cpp)=$(current.full.filename) $(anjuta.program.arguments)\n"
"command.compile.file.$(file.patterns.java)=javac --verbose $(current.file.name.ext)\n"
"command.make.file.$(file.patterns.java)=$(make) $(current.file.name).class\n"
"command.build.file.$(file.patterns.java)=javac --verbose *.java\n"
"command.execute.file.$(file.patterns.java)=java $(current.full.filename)\n"
"font.base=font:new century schoolbook\n"
"font.monospace=font:courier,size:12\n"
"font.big=$(font.base),size:16\n"
"font.medium=$(font.base),size:12\n"
"font.small=$(font.base),size:10\n"
"font.comment=$(font.monospace)\n"
"style.default.whitespace=fore:#808080\n"
"style.default.comment=fore:#FF0000,$(font.comment)\n"
"style.default.number=fore:#007F00,$(font.monospace)\n"
"style.default.keyword=fore:#00007F,bold\n"
"style.default.doublequote=fore:#E8C100,$(font.monospace)\n"
"style.default.singlequote=fore:#E8C100,$(font.monospace)\n"
"style.default.preprocessor=fore:#7F7F00\n"
"style.default.operator=\n"
"style.default.unclosedstring=fore:#000000,back:#E0C0E0,$(font.monospace),eolfilled\n"
"style.default.identifier=fore:#000022\n"
"style.default.definition=fore:#0000FF,bold\n"
"style.default.function=fore:#007F7F,bold\n"
"style.*.32=$(font.medium)\n"
"style.*.33=back:#D0D0D0\n"
"style.*.34=$(font.big),fore:#0000FF,bold\n"
"style.*.35=$(font.big),fore:#FF0000,bold\n"
"style.*.36=\n"
"style.*.37=fore:#C0C0C0,back:#FFFFFF\n"
};
