// ========================================================================
// copyright (C) 1999-2003 by Tobias Erbsland <te@profzone.ch>
// ------------------------------------------------------------------------
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2 of the License, or (at your
// option) any later version.
// ========================================================================

#include "ltanalyse.h"

ltAnalyse::ltAnalyse() :
		strPrefix( "lt" ),
		strName( "To Local Traffic" ),
		strVersion( "V0.1" ),
		strAuthor( "Tobias Erbsland <te@profzone.ch>" ),
		strHelp( "Create statistics about all traffic from in- and outside to all local accounts." )
{
	addParam( "limit", "Limit Output to n Lines.", "Integer from 1 to x.", G_STRING, "25" );
	addParam( "no-delivery", "Statistic with not delivered mail",
	          "If set, not delivered mails are included.", G_FLAG, "0" );
	addParam( "only-no-delivery", "Statistic ONLY with not delivered mail",
	          "If set, ONLY not delivered mails are included.", G_FLAG, "0" );
}

void ltAnalyse::run( std::map< std::string, unity_t > * unity_map )
{
	bool not_del = false;
	bool del = true;

	std::map< std::string, long > intern_traffic_c;

	std::map< std::string, unity_t >::iterator i;
	std::list< std::string >::iterator m;
	std::map< std::string, long >::iterator j;

	if ( getFlagParam( "no-delivery" ) ) not_del = true; // Auch falsche;
	if ( getFlagParam( "only-no-delivery" ) )  // Hat auch vorrang.
	{
		not_del = true;
		del = false;
	};

	for ( i = unity_map->begin(); i != unity_map->end(); i++ )
	{
		// Nichtzugestellte oder zugestellte Mails aus statistik entfernen.
		if ( !not_del && ( i->second.to_intern.size() + i->second.to_extern.size() == 0 ) ) continue;
		if ( !del && ( i->second.to_intern.size() + i->second.to_extern.size() != 0 ) ) continue;

		// Belastung fuer User rechnen, duch addieres der mailgroesse zu den
		// empfaengerkonten.
		for ( m = i->second.to_intern.begin(); m != i->second.to_intern.end(); m++ )
		{
			intern_traffic_c[ *m ] += i->second.size;
			mailc_toi_c[ *m ] ++; // Zaehlen.
			// Calculate only traffic from external users.
			if ( i->second.from.find( "@" ) != std::string::npos )
			{
				ext_to_intern_traffic_c[ *m ] += i->second.size;
				mailc_toi_frome_c[ *m ] ++;
			}
		}
	}
	// Temp map umrechnen.
	for ( j = intern_traffic_c.begin(); j != intern_traffic_c.end(); j++ )
		intern_traffic.insert( std::make_pair( j->second, j->first ) );
}

void ltAnalyse::print( void )
{
	if ( !report ) return ; // be sure :-)

	int limit = getIntParam( "limit" );

	std::multimap< long, std::string >::reverse_iterator k;

	report->startNewReport( "Local Traffic - received bytes per local account", Report::TABLE );
	report->addCol( 4, Report::COUNTER, Report::RIGHT, "nr", Report::NONE );
	// -1 = soviel platz verwenden, wie noch vorhanden.
	report->addCol( 10, Report::INTEGER, Report::RIGHT, "from local", Report::NONE, Report::SUM );
	report->addCol( 7, Report::INTEGER, Report::RIGHT, "count", Report::ROUND, Report::SUM );
	report->addCol( 10, Report::INTEGER, Report::RIGHT, "from outs.", Report::NONE, Report::SUM );

	report->addCol( 7, Report::INTEGER, Report::RIGHT, "count", Report::ROUND, Report::SUM );
	report->addCol( -1, Report::STRING, Report::LEFT, "to local-account", Report::NONE );
	report->addCol( 10, Report::INTEGER, Report::RIGHT, "total", Report::NONE, Report::SUM );
	report->addCol( 8, Report::PERCENT, Report::RIGHT, "% outs.", Report::RECT );
	report->printHeader();

	for ( k = intern_traffic.rbegin(); k != intern_traffic.rend(); k++ )
	{
		report->printField( k->first - ext_to_intern_traffic_c[ k->second ] );
		report->printField( mailc_toi_c[ k->second ] );
		report->printField( ext_to_intern_traffic_c[ k->second ] );
		report->printField( mailc_toi_frome_c[ k->second ] );
		report->printField( k->second );
		report->printField( k->first );
		report->printField( ( float ) ext_to_intern_traffic_c[ k->second ] * 100.0 / ( float ) ( k->first ) );

		if ( --limit < 1 ) break;
	}
	report->printFooter();
}

void ltAnalyse::free( void )
{
	intern_traffic.clear();
	ext_to_intern_traffic_c.clear();
	mailc_toi_c.clear();
	mailc_toi_frome_c.clear();
}
