/****************************************************************************
** ui.h extension file, included from the uic-generated form implementation.
**
** If you wish to add, delete or rename functions or slots use
** Qt Designer which will update this file, preserving your code. Create an
** init() function in place of a constructor, and a destroy() function in
** place of a destructor.
*****************************************************************************/


void RecipeDisplay::recipeIdChanged( int _id, int newId,
                                     const QString &,
                                     const QString &newRecipe )
{
  if ( id == _id )
    setRecipe( newId, newRecipe );
}


void RecipeDisplay::setRecipeToHTML( CompilerPtr _recipeToHTML )
{
  recipeToHTML = _recipeToHTML;
}

void RecipeDisplay::setRecipe( int _id, const QString &newRecipe )
{
  try {
    assert( recipeToHTML );
    
    id = _id;
    setCaption( QString( i18n( "Recipe %1" ).arg( id ) ) );
    textBrowser->setText( recipeToHTML->translate( newRecipe ).c_str() );

  } catch ( Error &e ) {
    
#ifndef NDEBUG
    std::cerr << e.what() << std::endl;
#endif
    KMessageBox::error( this, e.what() );
    textBrowser->setText( i18n( "Error" ) );

  };
}

void RecipeDisplay::recipeIdDeleted( int _id )
{
  if ( id == _id )
    close();
}
