/* Copyright (C) 2002, 2003, 2004, 2005 Jan Wedekind.
   This file is part of the recipe database application AnyMeal.

   AnyMeal is free software; you can redistribute it and/or modify it under
   the terms of the GNU GENERAL PUBLIC LICENSE as published by the Free
   Software Foundation; either version 2 of the License, or (at your option)
   any later version.

   AnyMeal is distributed in the hope that it will be useful, but WITHOUT ANY
   WARRANTY; without even the implied warranty of MERCHANTIBILITY or FITNESS
   FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
   details.

   You should have received a copy of the GNU General Public License along
   with AnyMeal; if not, contact one of the authors of this software. */
#ifndef __XMLNODE_TCC
#define __XMLNODE_TCC

#include <xalanc/DOMSupport/DOMServices.hpp>
#include "strX.hpp"

template< class T >
XMLReference< T >::XMLReference( T *_node, XMLDocument *_document ):
  node( _node ), document( _document )
{}

template< class T >
XMLReference< T >::XMLReference( const XMLReference< T > &r ):
  Object( r ), node( r.node ), document( r.document )
{}

template< class T >
XMLReference< T > &XMLReference< T >::operator=( const XMLReference< T > &r )
{
  node = r.node;
  document = r.document;
  return *this;
}

template< class T >
std::string XMLReference< T >::getNodeText(void)
  throw (Error,XMLException)
{
  ERRORMACRO( document != NULL, Error, ,
              "Can not select nodes from empty XML document." );

  XalanDOMString text;
  DOMServices::getNodeData( *node, text );

  CharVectorType result;

  ERRORMACRO( TranscodeToLocalCodePage( text, result, true ), Error, ,
              "Xalan-C failed to transcode some text. Check the content of "
              "the environment variable `LANG'." );
           
  return c_str( result );
}

// Instantiation.
template<>
XMLNodeReferenceList XMLReference< XalanElement >::selectNodes
  ( const std::string &xPath ) throw (Error,XMLException);

#endif
