<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                version="1.0">

  <xsl:output method="text" encoding="UTF-8"/>

  <xsl:param name="mfile">mealmastermap.xml</xsl:param>

  <xsl:template match="/insert|/sqlout">
    <xsl:apply-templates select="*"/>
  </xsl:template>

  <xsl:template match="recipe">

    <!-- Header -->
    <xsl:call-template name="header">
      <xsl:with-param name="title">Meal-Master recipe exported by AnyMeal</xsl:with-param>
    </xsl:call-template>

    <!-- Title -->
    <xsl:text>     Title: </xsl:text><xsl:value-of select="title"/>
    <xsl:text>&#xA;</xsl:text>

    <!-- List of categories. -->
    <xsl:text>Categories: </xsl:text>
    <xsl:for-each select="categories/category">
      <xsl:value-of select="."/>
      <xsl:if test="not(position()=last())">
        <xsl:text>, </xsl:text>
      </xsl:if>
    </xsl:for-each>
    <xsl:text>&#xA;</xsl:text>

    <!-- Servings. -->
    <xsl:text>  Servings: </xsl:text>
    <xsl:value-of select="servings/amount"/><xsl:text> </xsl:text>
    <xsl:value-of select="servings/unit"/>
    <xsl:text>&#xA;</xsl:text>

    <xsl:text>&#xA;</xsl:text>

    <!-- Ingredients. -->
    <xsl:for-each select="ingredients/section">
      <xsl:if test="title">
        <xsl:call-template name="header">
          <xsl:with-param name="title" select="title"/>
        </xsl:call-template>
      </xsl:if>
      <xsl:for-each select="ingredient">
        <!-- Make right-aligned amount entry. -->
        <xsl:choose>
          <xsl:when test="amount">
            <xsl:choose>
              <xsl:when test="amount/float">
                <xsl:variable name="amount"
                  select="substring(format-number(amount,'######0.#####'),1,7)"/>
                <xsl:call-template name="indent">
                  <xsl:with-param name="amount" select="7 - string-length($amount)"/>
                </xsl:call-template>
                <xsl:value-of select="$amount"/>
              </xsl:when>
              <xsl:otherwise>
                <xsl:variable name="amount">
                  <xsl:choose>
                    <xsl:when test="amount/fraction/nominator >= amount/fraction/denominator">
                      <xsl:value-of select="floor(amount/fraction/nominator div amount/fraction/denominator)"/>
                      <xsl:if test="amount/fraction/nominator mod amount/fraction/denominator > 0">
                        <xsl:text> </xsl:text>
                        <xsl:value-of select="amount/fraction/nominator mod amount/fraction/denominator"/>
                        <xsl:text>/</xsl:text>
                        <xsl:value-of select="amount/fraction/denominator"/>
                      </xsl:if>
                    </xsl:when>
                    <xsl:otherwise>
                      <xsl:value-of select="amount/fraction/nominator"/>
                      <xsl:text>/</xsl:text>
                      <xsl:value-of select="amount/fraction/denominator"/>
                    </xsl:otherwise>
                  </xsl:choose>
                </xsl:variable>
                <!-- Protect against overlong fractions. -->
                <xsl:choose>
                  <xsl:when test="string-length($amount) &lt;= 7">
                    <xsl:call-template name="indent">
                      <xsl:with-param name="amount" select="7 - string-length($amount)"/>
                    </xsl:call-template>
                    <xsl:value-of select="$amount"/>
                  </xsl:when>
                  <xsl:otherwise>
                    <xsl:variable name="amountDouble">
                      <xsl:choose>
                        <xsl:when test="amount/fraction/denominator">
                          <xsl:value-of select="amount/fraction/nominator div amount/fraction/denominator"/>
                        </xsl:when>
                        <xsl:otherwise>
                          <xsl:value-of select="amount/fraction/nominator"/>
                        </xsl:otherwise>
                      </xsl:choose>
                    </xsl:variable>
                    <xsl:variable name="amountText"
                      select="substring(format-number($amountDouble,'######0.#####'),1,7)"/>
                    <xsl:call-template name="indent">
                      <xsl:with-param name="amount" select="7 - string-length($amountText)"/>
                    </xsl:call-template>
                    <xsl:value-of select="$amountText"/>
                  </xsl:otherwise>
                </xsl:choose>
              </xsl:otherwise>
            </xsl:choose>
          </xsl:when>
          <xsl:otherwise>
            <xsl:call-template name="indent">
              <xsl:with-param name="amount" select="7"/>
            </xsl:call-template>
          </xsl:otherwise>
        </xsl:choose>
        <!-- <xsl:value-of select="amount"/> -->
        <xsl:text> </xsl:text>
        <!-- Unit must be aligned left. -->
        <xsl:variable name="unit" select="unit"/>
        <xsl:choose>
          <xsl:when test="document($mfile)/mealmastermap/item[@text=$unit]">
            <!-- Look up unit abbreviation -->
            <xsl:variable name="unitabbreviation"
              select="document($mfile)/mealmastermap/item[@text=$unit]"/>
            <xsl:value-of select="$unitabbreviation"/>
            <xsl:call-template name="indent">
              <xsl:with-param name="amount"
                select="3 - string-length($unitabbreviation)"/>
            </xsl:call-template>
            <!-- Print out ingredient name. -->
            <xsl:call-template name="split">
              <xsl:with-param name="text">
                <xsl:value-of select="name"/>
                <xsl:if test="prep">
                  <xsl:text>;</xsl:text>
                  <xsl:value-of select="prep"/>
                </xsl:if>
              </xsl:with-param>
            </xsl:call-template>
          </xsl:when>
          <xsl:otherwise>
            <!-- Print out unit and ingredient name. -->
            <xsl:call-template name="split">
              <xsl:with-param name="text">
                <xsl:text>   </xsl:text>
                <xsl:if test="unit">
                  <xsl:value-of select="unit"/>
                  <xsl:text> </xsl:text>
                </xsl:if>
                <xsl:value-of select="name"/>
                <xsl:if test="prep">
                  <xsl:text>;</xsl:text>
                  <xsl:value-of select="prep"/>
                </xsl:if>
              </xsl:with-param>
            </xsl:call-template>            
          </xsl:otherwise>
        </xsl:choose>
        <xsl:text>&#xA;</xsl:text>
      </xsl:for-each>
    </xsl:for-each>

    <!-- Newline after ingredients (not part of the Mealmaster specification).
         Discussion in de.rec.mampf with Bernhard Mosolf, Ulli Fetzer, Peter
         Hammer, K.-H. Boller and others. -->
    <xsl:text>&#xA;</xsl:text>

    <!-- Instructions. -->
    <xsl:for-each select="instructions/section">
      <xsl:if test="title">
        <xsl:call-template name="header">
          <xsl:with-param name="title" select="title"/>
        </xsl:call-template>
      </xsl:if>
      <xsl:for-each select="par">
        <xsl:text>:</xsl:text>
        <xsl:call-template name="printParagraph">
          <xsl:with-param name="text" select="."/>
        </xsl:call-template>
        <xsl:text>&#xA;&#xA;</xsl:text>
      </xsl:for-each>
    </xsl:for-each>
    
    <xsl:text>MMMMM&#xA;&#xA;</xsl:text>
  </xsl:template>

  <xsl:template name="header">
    <xsl:param name="title"/>
    <xsl:text>MMMMM</xsl:text>
    <xsl:call-template name="repeat">
      <xsl:with-param name="text">-</xsl:with-param>
      <xsl:with-param name="count" select="(70-string-length($title)) div 2"/>
    </xsl:call-template>
    <xsl:value-of select="$title"/>
    <xsl:call-template name="repeat">
      <xsl:with-param name="text">-</xsl:with-param>
      <xsl:with-param name="count" select="(71-string-length($title)) div 2"/>
    </xsl:call-template>
    <xsl:text>&#xA;</xsl:text>
  </xsl:template>

  <xsl:template name="split">
    <!-- Split ingredient-text, if necessary. -->
    <xsl:param name="text"/>
    <xsl:choose>
      <xsl:when test="string-length($text) > 28">
        <xsl:value-of select="substring($text,1,28)"/>
        <xsl:text>&#xA;</xsl:text>
        <xsl:call-template name="indent">
          <xsl:with-param name="amount">11</xsl:with-param>
        </xsl:call-template>
        <xsl:text>-</xsl:text>
        <xsl:call-template name="split">
          <xsl:with-param name="text"
            select="substring($text,29,string-length($text)-28)"/>
        </xsl:call-template>
      </xsl:when>
      <xsl:otherwise>
        <xsl:value-of select="$text"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <xsl:template name="printParagraph">
    <xsl:param name="text"/>
    <!-- Only allow 74 (instead of 75), to allow prepending ':' before invoking
         this template. -->
    <xsl:param name="avail">74</xsl:param>
    <xsl:choose>
      <xsl:when test="contains($text,' ')">
        <xsl:choose>
          <xsl:when test="string-length(substring-before($text,' '))>$avail">
            <xsl:text>&#xA;</xsl:text>
            <xsl:value-of select="substring-before($text,' ')"/>
            <xsl:call-template name="printParagraph">
              <xsl:with-param name="text" select="substring-after($text,' ')"/>
              <xsl:with-param name="avail" select="74 - string-length(substring-before($text,' '))"/>
            </xsl:call-template>
          </xsl:when>
          <xsl:otherwise>
            <xsl:if test="$avail &lt; 74">
              <xsl:text> </xsl:text>
            </xsl:if>
            <xsl:value-of select="substring-before($text,' ')"/>
            <xsl:call-template name="printParagraph">
              <xsl:with-param name="text" select="substring-after($text,' ')"/>
              <xsl:with-param name="avail" select="$avail - 1 - string-length(substring-before($text,' '))"/>
            </xsl:call-template>
          </xsl:otherwise>
        </xsl:choose>  
      </xsl:when>
      <xsl:otherwise>
        <xsl:if test="$avail &lt; 74">
          <xsl:text> </xsl:text>
        </xsl:if>
        <xsl:value-of select="$text"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <xsl:template name="repeat">
    <xsl:param name="text"/>
    <xsl:param name="count"/>
    <xsl:if test="$count>0">
      <xsl:value-of select="$text"/>
      <xsl:call-template name="repeat">
        <xsl:with-param name="text" select="$text"/>
        <xsl:with-param name="count" select="$count - 1"/>
      </xsl:call-template>
    </xsl:if>
  </xsl:template>

  <xsl:template name="indent">
    <!-- Found loop-construct in a posting of Mitch.Amiano (@alcatel.com) -->
    <xsl:param name="amount">0</xsl:param>
    <xsl:if test="number($amount) >= 1">
      <xsl:text> </xsl:text>
      <xsl:call-template name="indent">
        <xsl:with-param name="amount" select="$amount - 1"/>
      </xsl:call-template>
    </xsl:if>
  </xsl:template>

</xsl:stylesheet>
