/* Copyright (C) 2002, 2003, 2004 Jan Wedekind.
   This file is part of the recipe database application AnyMeal.

   AnyMeal is free software; you can redistribute it and/or modify it under
   the terms of the GNU GENERAL PUBLIC LICENSE as published by the Free
   Software Foundation; either version 2 of the License, or (at your option)
   any later version.

   AnyMeal is distributed in the hope that it will be useful, but WITHOUT ANY
   WARRANTY; without even the implied warranty of MERCHANTIBILITY or FITNESS
   FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
   details.

   You should have received a copy of the GNU General Public License along
   with AnyMeal; if not, contact one of the authors of this software. */
#ifndef __ODBCRESULTROW_HPP
#define __ODBCRESULTROW_HPP

#include "include.hpp"
#include <sql.h>
#include "resultRow.hpp"

/** Class for accessing a single row of an SQL-query's result.
    \deprecated{The ODBC classes are not in use at the moment}
    @date Thu Mar 03 2005
    @author Jan Wedekind (wedesoft@users.sourceforge.net) */
class ODBCResultRow: public ResultRow
{
public:
  /** Constructor requiring a statement handle.
      Use \c ODBCStatement::fetchRow instead of this constructor. */
  ODBCResultRow( SQLHSTMT _statement );
  /** Operator for retrieving columns.
      @param i Number of column (starting from <TT>0</TT>).
      @see ODBCStatement::getNumCols */
  virtual std::string operator[]( int i ) throw (Error);
  /** Invalidate the row.
      This method is called by the destructor of \c ODBCStatement to prevent
      the \c ODBCResultRow object from using an invalid SQL-query handle. */
  virtual void invalidate(void) { statement = NULL; }
protected:
  ///
  SQLHSTMT statement;
};

typedef boost::shared_ptr< ODBCResultRow > ODBCResultRowPtr;

#endif
