.TH APCD 8 "APCD 0.6 - 02.01.2000"
.SH NAME
apcd \- daemon for APC SmartUPS support
.SH SYNOPSIS
.B /usr/sbin/apcd 
.br
.B /usr/sbin/apcd
{--version , -v}

.SH DESCRIPTION
.LP
.B apcd
can be used for controlling the APC SmartUPS. After the power failure,
.B apcd
will inform the users about the power failure once per minute. When the
power is restored during user defined timeout,
.B apcd
will inform users about this fact. If power is not restored, the system
shutdown will follow when the timeout expires. The whole shutdown is made
inside the
.B apcd
, so no changes in the inittab are necessary. There is no communication
between
.B apcd
and init(1) process.
.LP
.B apcd
daemon also supports the networking mode. In this mode, one machine is
configured as a master, with UPS attached to the serial port. Other machines
(max. 10) are configured as a slaves. Master has a network connection with
slaves and send them informations about timeouts, power restore etc. The
master machine is also logging the UPS status informations to the text file. 
.LP
The
.B apcd
must be setuid root !!
.LP
If you uses the --version or -v parameter, 
.B apcd
prints the version infromation and exits.
.LP
.SH CONFIGURATION
.LP
Firstly, you will need the cable between APC Smart UPS and PC computer
running Linux. You can use either the special cable which is enclosed with
the PowerChute (TM) software or you can make your own cable connected as
follows:
.LP
	PC (9 pin)	APC (9 pin)
.br
	2 RxD		2
.br
	3 TxD		1
.br
	5 GND		9
.LP 
Further, it is necessary to write configuration info to the file
.B /etc/apcd.conf
.LP
This file is a plain ASCII file and you can use your favorite editor for
configuration. For simple configuration, see enclosed sample file.
.LP 
Configuration commands in 
.B /etc/apcd.conf
are:
.LP
.B	PORT
- for Master machine. Please specify which device is used for UPS
communication. The default is /dev/ups.
.LP
.B	NOTEST
- for Master machine. Skip the beep and the led test when apcd starts.
.LP
.B	TIMEOUT
- for Master machine. This is the timeout between power failure and system
shutdown. The default is 10 minutes for the master and 9 minutes for slaves.
The timeout for slaves is always one minute less than master timeout.
.LP
.B	LOGFILENAME
- for Master machine. The name of the file for logging of UPS statistics.
.LP
.B	SLAVE
- for Master machine. The name of the slave machine attached to the master.
There can be max. 10 slaves attached to one master.
.LP
.B	MASTER
- for Slave machine. The name of the master which is authorised to send
commands to this slave
.LP
.SH DIAGNOSTICS
.LP
Error and information messages are logged to the syslog daemon.
.LP
.SH FILES
.B /etc/apcd.conf
- configuration file
.br
.B /var/adm/upsstat.log
- the UPS status is logged in this file. The file name can be configured in
.B /etc/apcd.conf
.LP
.LP
.B upsstat.log
- FILE FORMAT
.LP
.LP
.B upsstat.log
is a simple ascii file with several floating point numbers on one line. The
format of the line is:
.LP
.B BatteryLoad LineMin LineMax UPSLoad LineFreq LineVoltage OutputVoltage
.B UPSTemp BattVoltage
.LP
.LP 
.SH AUTHOR
.LP
Pavel Korensky <pavelk@dator3.anet.cz>
.LP
Bug fixes by Tibor Koleszar <oldw@debian.org>

