.\" manual page [] for apcupsd
.\" SH section heading
.\" SS subsection heading
.\" LP paragraph
.\" IP indented paragraph
.\" TP hanging label
.TH apcupsd 8 "APC UPS management under Linux -- November 1999"
.SH NAME
apcupsd \- daemon for most APC's UPS for Linux
.SH SYNOPSIS
.B /sbin/apcupsd
.br
.B /etc/apcupsd/apccontrol
.br
.B /etc/apcupsd/apcupsd.conf
.br
.B /sbin/apcaccess
.br
.B /sbin/apcnetd
.br
.SH DESCRIPTION
.LP
This document is considerably out of date. It can be used
for a brief overview of apcupsd, but you should consult the
html manual for current information. Normally this manual
will be loaded on your system in the doc directory, which
varies from system to system. Otherwise, you may find
an online version at: http://www.apcupsd.com

.LP
This daemon can be used for controlling the most APC UPSes.
During a power failure, "apcupsd" will inform the users about the
power failure and that a shutdown may occur.  If power is not
restored, a system shutdown will follow when the battery is
exausted, a timeout (seconds) expires, or runtime expires based
on internal UPS calculations determined by power consumption
rates.  If the power is restored before one of the above shutdown
conditions is met, apcupsd will inform users about this fact.

The shutdown is made by script calls to
"/etc/apcupsd/apccontrol", which is called by "apcupsd".
Consequently, no changes to /etc/inittab are necessary.  There is
no communication between apcupsd and init(1) process.  Apcupsd
modifies the halt script so that at the end of the shutdown
process, apcupsd will be re-executed in order to power off the
UPS. On certain platforms (e.g. FreeBSD) there is no halt script
so apccontrol must be modified to cause apcupsd to power off
the UPS after a delay time.

.LP
The apcupsd daemon now supports two networking modes that function
independently, but if desired they can both run at the same time.

Most users will probably enable the first network mode and
simplest (NIS or Network Information Service), which
permits apcupsd to serve status and event information 
to clients over the network.

The second networking mode is for multiple networked machines that are
powered by the same UPS. In this mode, one machine is configured as a
master with the UPS attached to the serial port.  The other machines
(max.  20) powered by the same UPS are configured as slaves.  The master
has a network connection with the slaves and sends them information
about the UPS status. This mode is significantly more complicated
to setup than the NIS networking mode described above.

For details and configurations on these networking modes please see
the manual.

.LP
RedHat and SuSE versions of Linux have direct install support.  All
other flavors of Linux may need some fussing with to get the install
correct.
.SH OPTIONS
.TP
.B \-c --configure
Attempts to configure the UPS EPROM to the values specified in the
configuration file "/etc/apcupsd/apcupsd.conf".
This option is now deprecated (not supported) and should not
be used. Instead use the apctest program, which has an interactive
EEPROM configuration.
.TP
.B \-d --debug <level>
Turns on debugging output.
.TP
.B \-f --config-file <file>
Specifies the location of the configuration file.  The default
is: /etc/apcupsd/apcupsd.conf
.TP
.B \-k --killpower
Attempt to turn the UPS off. This option is normally only
used by the daemon itself to shut the UPS off after a
system shutdown has completed.
.TP
.B \-V --version
Prints the apcupsd version number and the help.
.TP
.B \-? --help
Prints a brief apcupsd help screen.

.SH CONFIGURATION
It may be necessary to change the configuration information in the file
"/etc/apcupsd/apcupsd.conf" to meet your needs and to correspond to your
configuration.  This file is a plain ASCII file and you can use your
favorite editor to change it. 
.LP 
Configuration commands in 
.B /etc/apcupsd/apcupsd.conf
are:

.LP
.SS GENERAL CONFIGURATION COMMANDS
.LP
.B  UPSCABLE
-- <type of cable you are using>
.br
[ simple | 940-0020B | 940-0023A (broken) ]
.br
[ smart | 940-0024B | 940-0024C ]
.br
[ 940-0095A | 940-0095C ]
.br
[ ether ]
.br 
[ usb ]
.LP
.B  UPSTYPE
-- <Type of APCC UPS you have>
.br
[ dumb | apcsmart | net | usb | snmp | test ] 
.LP
.B  DEVICE
-- <name of serial port>
.br
Please specify which device is used for UPS communication.
The default is /dev/ttyS[0|1|2|3].  If you have a USB UPS,
you should leve the DEVICE directive blank and apcupsd
will figure out where your device is located. If you have
problems, please see the manual as it has more details.
.LP
.B  LOCKFILE
-- <path to lockfile>
.br
By supplying this argument, "apcupsd" tries to create a lockfile
for the serial or USB port in the specified directory.

.LP
.SS CONFIGURATION COMMANDS USED BY THE NETWORK INFORMATION SERVER
.LP
.B NETSTATUS 
[on | off]
.br
This configuration command turns the network information server
on or off. If it is on, apcupsd will spawn a child process that
serves STATUS and EVENTS information over the network. This
information is currently used by the Web based CGI programs.
The default is on. In some cases, for added security, you may
want to invoke a separate information server daemon from the inetd
daemon. In this case, NETSTATUS should be off.

.LP
.B STATUSPORT 
<port>
.br
This configuration command specifies the port to be used by the
apcupsd server. The default is 3550. If you change this port,
you must manually change the #define SERV_TCP_PORT in 
cgi/upsfetch.c and rebuild the CGI programs.

.LP
.B EVENTFILE 
<filename>
.br
If you want the apcupsd network information server to provide
the last 10 events via the network, you must specify a
file where apcupsd will save these events. The default is:
/var/log/apcupsd.events. Currently, apcupsd will save
at most the last 50 events. When more than 50 events are
recorded and a network request for the events arrives,
the network server will truncate the file to
the most recent 10 events. Consequently this file
will not grow indefinitely as long as the events are
checked from time to time.


.LP
.SS CONFIGURATION COMMANDS USED TO CONTROL SYSTEM LOGGING
.LP
.B STATTIME

.LP
.B STATFILE

.LP
.B DATATIME

.LP
.B FACILITY



.LP
.B CONFIGUATION COMMANDS USED DURING POWER FAILURES
.LP
.B  ANNOY
-- <time in seconds>
.br
Please specify the time in seconds between messages requesting
logged in users to get off the system. This timer starts only when
the UPS is running on batteries.  The default is 300 seconds 
(5 minutes).
.LP
.B  ANNOYDELAY
-- <time in seconds>
.br
Please specify delay time in seconds before apcupsd begins requesting
logged in users to get off the system. This timer starts
only after the UPS is running on batteries.
This timer is reset when the power returns. The default
is 60 seconds.  That is the first warning to log off the
system occurs after 60 seconds on batteries.


.LP
.B  NOLOGON
-- <specifies when apcupsd should create the nologon file>
.br
[ disable | timeout | percent | minutes | always ] are valid types.

Based on Ten (10) percent of a setting.  This allows one to define the
point when the /etc/nologin file is added.  This is important for
allowing systems with BIG UPSes to run as normally until the system
administrator determines the need for dumping users.  The feature also
allows the system administrator to hold the "ANNOY" factor until the
/etc/nologin file is added.

.B disable 
prevents apcupsd from creating the nologin file.

.B timeout 
specifies a specific wait time before creating the nologin file.

.B percent 
specifies the percent battery charge remaining before creating
the nologin file. 

.B minutes 
specifies the battery runtime remaining before creating the
nologin file.

.B always 
causes the nologin file to be immediately created on a power
failure.
.LP
.B  BATTERYLEVEL
-- <percent of battery>
.br
If BATTERYLEVEL is specified, during a power failure, apcupsd will
shutdown the system when the remaining battery charge falls below the
specified percentage.  The default is 5.
.LP
.B  MINUTES
-- <battery runtime in minutes>
.br
If MINUTES is specified, during a power failure, apcupsd will
shutdown the system when the remaining remaining runtime on batteries
as internally calculated by the UPS 
falls below the time specified. The default is 3.

.LP
.B  TIMEOUT
-- <time in seconds>
.br
After a power failure, the system will be shutdown after TIMEOUT seconds
have expired.  Normally for SMARTUPSes, this should be zero so that the
shutdown time will be determined by the battery level or remaining runtime 
(see above). This command is useful for dumb UPSes that do not report
battery level or the remaining runtime. It is also useful for
testing apcupsd in that you can force a rapid shutdown by setting
a small value (e.g. 60) and pulling the plug to the UPS. 

The timeout for the master is always 30 seconds longer than slaves.

.B TIMEOUT, BATTERYLEVEL, and MINUTES
can be set together without problems. The daemon will react to the
first case or test that is valid. Normally SmartUPS users will set
.B TIMEOUT
to zero so that the system is shutdown depending on the 
percentage battery charge remaining 
.B (BATTERYLEVEL)
or the remaining battery runtime
.B (MINUTES).


.LP
.SS CONFIGURATION COMMANDS FOR SHARING A UPS
.LP
.B  UPSCLASS
-- <class of operation>
.br
[ standalone | shareslave | sharemaster ] and
.br
[ netslave | netmaster ] are valid types.
.br
[ standalone | netslave | netmaster ] are tested classes.
.br
[ shareslave | sharemaster ] classes are being tested.
.LP
The default is "standalone" and should be used for 
all machines powered by the UPS and having a serial port
connection to the UPS, but where there are no other computers
dependent power from the same UPS.  This is the "normal" case.

Use "netmaster", if and only if you have a serial port connection
to the UPS and there are other machines deriving power from the
same UPS. 

Use "netslave" if and only if you have no serial port connection
to the UPS, but you derive power from it.

Use "shareslave" if and
only if you are using a ShareUPS and connected to a BASIC Port with
Simple Signal. 

Use "sharemaster", if and only if you are using a
ShareUPS and connected to the ADVANCED Port Smart Signal control.

.LP
.B  UPSMODE -- 
[ disable | share | net | sharenet ] are valid types.
.br
.LP
[ disable | net ] are the only known and tested classes.
.br
[ share | sharenet ] classes are being tested.
.LP
BETA [ share ] For two or seven (2/7) additional simple signal
ports on a SmartAccessories(tm) (internal/external box) for SmartUPSes.
.LP
.LP
.B  NETTIME
-- <time in seconds>
.br
The rate in seconds that broadcasts information to Slave machines.
This rate is reset if there is a power state change. This value
is now passed to the slaves to sync. the openning of a socket
by the slave for the master.
.LP
.B  NETPORT
-- <TCP|UDP port number>
.br
This unix service port number must be set in the /etc/services file
as follows:
.br
        tab     tab(spacejunk)  tab     tab
.br
name                    (stuff)/xxp             #
.br
.br
apcupsd         NETPORT/tcp             #
.br
apcupsd         NETPORT/udp             #
.LP
.B  MASTER
-- <name of master> for Slave machine.
.br
The name of the master which is authorized to send commands to this slave.
.LP
.B  SLAVE
-- <name of slave(s)> for Master machine.
.br
The name of the slave machine attached to the master.
There can be max. 20 slaves attached to one master.
.LP
.B  USERMAGIC
-- < user defined password> for the slave machine.
.br
The second level of password security. It must be (17) characters long
without spaces. This is passed to the master machine during
initialization of sockets. This string should be different for
each and every slave on the network. This is not at all secure as
passwords are passed in the clear. Please protect your network by
firewalling or tcpwrappers.

.SH SMARTUPS
If you start getting the follow message:
   
.B Emergency -- Batteries Have Failed!
.br
.B Change Them NOW!

Act upon it quickly. It means what it says.

Also, not all "SmartUPS" models are eqaully smart. A non-NET or old
class of "SmartUPS" has a subset of the full UPSlink(TM) language,
and can not be polled for its control codes.
.LP
.SH SHAREUPS
Special note for ShareUPS users,
.B TIMEOUT, BATTERYLEVEL, and MINUTES
are disabled or set to default values. Currently, there is not a known
way for early signals to be sent to BASIC Ports. MINUTES are set to 0.
.SH FILES
.B /etc/apcupsd/apcupsd.conf
- configuration file.
.br
.B /var/log/apcupsd.status
- STATUS file
.br
.B /var/log/apcupsd.events
- where up to the last 50 events are stored
for the network information server.
.SH EVENTS
apcupsd generates events when certain conditions occur 
such as a power failure, batteries exhausted, power return, 
...

These events are sent to the system log, optionally sent
to the temporary events file (/var/log/apcupsd.events),
and they also generate a call to /etc/apcupsd/apccontrol
which in turn will call any scripts you have placed in the
/etc/apcupsd directory.

.SH DATA format
If the DATATIME configuration command is set nonzero, 
apcupsd will log a data record at the interval defined
on the DATATIME command. This data record is in a format
similar to the PowerChute data file format.

.SH STATUS format
The STATUS output is in ASCII format and generally there
is a single piece of information on each line output.
The format varies based on the type of UPS that you are using.
.LP
.br
DATE     : time and date of last update
.br
CABLE    : cable type used
.br
UPSMODEL : ups type or signal method
.br
UPSMODE  : tells apcupsd what to check
.br
SHARE    : if ShareUPS is used, this determines what
.LP
.B SmartUPS and MatrixUPS Smart Signals
.br
ULINE    : Current (observed) Input Line Voltage
.br
MLINE    : Max (observed) Input Line Voltage
.br
NLINE    : Min (observed) Input Line Voltage
.br
FLINE    : Line Freq (cycles)
.br
VOUTP    : UPS Output Voltage
.br
LOUTP    : Percent Load of UPS Capacity
.br
BOUTP    : Current Charge Voltage of Batteries
.br
BCHAR    : Batteries Current Charge Percent of Capacity
.br
BFAIL    : UNSIGNED INT CODE (ups state)
.br
UTEMP    : Current UPS Temp. in Degrees Cel.
.br
DIPSW    : Current DIP switch settings for UPS.
.LP
.B Newer BackUPS Pro Smart Signals
.br
ULINE    : Current (observed) Input Line Voltage
.br
MLINE    : Max (observed) Input Line Voltage
.br
NLINE    : Min (observed) Input Line Voltage
.br
FLINE    : Line Freq (cycles)
.br
VOUTP    : UPS Output Voltage
.br
LOUTP    : Percent Load of UPS Capacity
.br
BOUTP    : Current Charge Voltage of Batteries
.br
BCHAR    : Batteries Current Charge Percent of Capacity
.br
BFAIL    : UNSIGNED INT CODE (ups state)
.LP
.B BackUPS Pro and SmartUPS v/s Smart Signals
.br
LINEFAIL : OnlineStatus
.br
BATTSTAT : BatteryStatus
.br
MAINS    : LineVoltageState
.br
LASTEVNT : LastEventObserved
.LP
.B BackUPS and NetUPS Simple Signals
.br
LINEFAIL : OnlineStatus
.br
BATTSTAT : BatteryStatus
.LP
.B BackUPS Pro and SmartUPS v/s Smart Signals
.br
OnlineStatus BatteryStatus LineVoltageState
LastEventObserved
.LP
.B BackUPS and NetUPS Simple Signals
.br
OnlineStatus BatteryStatus
.br

.SH SEE ALSO
The html manual installed on your system or
http://www.apcupsd.com

.SH AUTHOR
Andre M. Hedrick
.SS Retired Co-AUTHOR
Christopher J. Reimer
.SS Current maintainers
Kern Sibbald
Adam Kropelin
.SS Contributors
An enormous list of past and former persons who have devoted
their time and energy to this project -- thanks.
