#!/usr/bin/perl
#======================================================================
# Copyright (c) 1998-1999 Daniele Giacomini daniele@pluto.linux.it
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
# General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#======================================================================
# annunci-elimina.pl
#======================================================================

#----------------------------------------------------------------------
# Utilizza il modulo Pg, per l'utilizzo delle librerie LIBPQ di
# PostgreSQL.
#----------------------------------------------------------------------
use Pg;


#======================================================================
# Inizio del programma.
#======================================================================
if ($#ARGV >= 0) {
    $giorni = $ARGV[0];
} else {
    $giorni = 7;
}
$adesso = time();
$data_minima = $adesso - ( $giorni * 24 * 60 * 60 );

#----------------------------------------------------------------------
# Apre la connessione con il server PostgreSQL locale, utilizzando
# il database ``pubblico''.
#----------------------------------------------------------------------
$PGconnessione = Pg::connectdb("dbname = pubblico");

#----------------------------------------------------------------------
# Verifica che la connessione sia avvenuta.
#----------------------------------------------------------------------
if ( $PGconnessione->status == PGRES_CONNECTION_OK ) {
    
    #------------------------------------------------------------------
    # La connessione  avvenuta, e si procede con l'eliminazione
    # degli annunci vecchi.
    #------------------------------------------------------------------

    $PGistruzione = "
	DELETE FROM Annunci WHERE Data < $data_minima ";

    $PGrisultato = $PGconnessione->exec("$PGistruzione");

    #------------------------------------------------------------------
    # Verifica il risultato dell'esecuzione dell'istruzione.
    # Attualmente sembra che il valore dello stato restituito
    # sia invertito.
    #------------------------------------------------------------------
    $PGstatus = $PGconnessione->status;

    if ($PGstatus == PGRES_COMMAND_BAD) {
    
        print "$PGerrore\n";
    }

} else {

    #------------------------------------------------------------------
    # Per qualche motivo la connession con il database non
    # funziona e si avvisa di conseguenza l'utente.
    #--------------------------------------------------------------
    print "Il database ``pubblico''  inaccessibile.\n";
}

#======================================================================
1;
#======================================================================
