(* ================================================================= *)
(* Permuta.pas							     *)
(* ================================================================= *)
program Permutazioni;

const	DIM	= 100;

var	lista	: array[1..DIM] of integer;
	i	: integer;
	z	: integer;

(* ================================================================= *)
(* permuta( <ele-inf>, <ele-sup>, <elementi-totali> )		     *)
(* ----------------------------------------------------------------- *)
function permuta( a : integer; z : integer; elementi : integer ) : integer;

var	scambio	: integer;
	k	: integer;
	i	: integer;

begin

    (* ------------------------------------------------------------- *)
    (* Se il segmento di array contiene almento due elementi,	     *)
    (* si procede.						     *)
    (* ------------------------------------------------------------- *)
    if ( z-a ) >= 1 then
	begin
	    
	    (* ----------------------------------------------------- *)
	    (* Inizia il ciclo di scambi tra l'ultimo elemento e     *)
	    (* uno degli altri contenuti nel segmento di array.	     *)
	    (* ----------------------------------------------------- *)
	    k := z;
	    while k >= a do begin

		(* ------------------------------------------------- *)
		(* Scambia i valori.				     *)
		(* ------------------------------------------------- *)
		scambio := lista[k];
		lista[k] := lista[z];
		lista[z] := scambio;
		
		(* ------------------------------------------------- *)
		(* Esegue una chiamata ricorsiva per permutare un    *)
		(* segmento pi piccolo dell'array.
		(* ------------------------------------------------- *)
		permuta( a, z-1, elementi );
		
		(* ------------------------------------------------- *)
		(* Scambia i valori.				     *)
		(* ------------------------------------------------- *)
		scambio := lista[k];
		lista[k] := lista[z];
		lista[z] := scambio;
		
		k := k-1;
	
	    end;
	end
    else
	begin

	    (* ----------------------------------------------------- *)
	    (* Visualizza la situazione attuale dell'array.	     *)
	    (* ----------------------------------------------------- *)
	    for i := 1 to elementi do begin
		Write( lista[i]:4 );
	    end;
	    Writeln;
		
	end
    ;	

end;

(* ================================================================= *)
(* Inizio del programma.					     *)
(* ----------------------------------------------------------------- *)
begin

    Writeln( 'Inserire la quantita'' di elementi.' );
    Writeln( DIM, ' al massimo.' );
    Readln( z );

    if z > DIM then
	begin
	    z := DIM;
	end
    ;

    Writeln( 'Inserire i valori dell''array' );

    for i := 1 to z do begin
	Write( 'elemento ', i:2, ': ' );
	Readln( lista[i] );
    end;

    permuta( 1, z, z );

end.

(* ================================================================= *)
