(* ================================================================= *)
(* QSort.pas							     *)
(* ================================================================= *)
program QuickSort;

const	DIM	= 100;

var	lista	: array[1..DIM] of integer;
	i	: integer;
	z	: integer;

(* ================================================================= *)
(* part( <ele-inf>, <ele-sup> )					     *)
(* ----------------------------------------------------------------- *)
function part( a : integer; z : integer ) : integer;

var	scambio	: integer;
	i	: integer;
	cf	: integer;
	loop1	: boolean;
	loop2	: boolean;
	loop3	: boolean;

begin

    (* ------------------------------------------------------------- *)
    (* Si assume che a sia inferiore a z.			     *)
    (* ------------------------------------------------------------- *)
    i := a+1;
    cf := z;
    
    (* ------------------------------------------------------------- *)
    (* Inizia il ciclo di scansone dell'array.			     *)
    (* ------------------------------------------------------------- *)
    loop1 := TRUE;
    while loop1 do begin

	loop2 := TRUE;
	while loop2 do begin
	
	    (* ----------------------------------------------------- *)
	    (* Sposta i a destra.				     *)
	    (* ----------------------------------------------------- *)
	    if ( lista[i] > lista[a] ) OR ( i >= cf ) then
		begin
		    loop2 := FALSE;
		end
	    else
		begin
		    i := i+1;
		end
	    ;
	    
	end;
	
	loop3 := TRUE;
	while loop3 do begin
	
	    (* ----------------------------------------------------- *)
	    (* Sposta cf a sinistra.				     *)
	    (* ----------------------------------------------------- *)
	    if lista[cf] <= lista[a] then
		begin
		    loop3 := FALSE;
		end
	    else
		begin
		    cf := cf-1;
		end
	    ;
	    
	end;
	
	if cf <= i then
	    begin
		
		(* ------------------------------------------------- *)
		(*  avvenuto l'incontro tra i e cf.		     *)
		(* ------------------------------------------------- *)
		loop1 := FALSE;
	    end
	else
	    begin
	    
		(* ------------------------------------------------- *)
		(* Vengono scambiati i valori.			     *)
		(* ------------------------------------------------- *)
		scambio := lista[cf];
		lista[cf] := lista[i];
		lista[i] := scambio;

		i := i+1;
		cf := cf-1;
	    end
	;
    end;

    (* ------------------------------------------------------------- *)
    (* A questo punto, lista[a..z]  stata ripartita e cf  la	     *)
    (* collocazione finale.					     *)
    (* ------------------------------------------------------------- *)
    scambio := lista[cf];
    lista[cf] := lista[a];
    lista[a] := scambio;
    
    (* ------------------------------------------------------------- *)
    (* In questo momento, lista[cf]  un elemento (un valore) nella  *)
    (* posizione giusta.					     *)
    (* ------------------------------------------------------------- *)
    part := cf

end;

(* ================================================================= *)
(* quicksort( <ele-inf>, <ele-sup> )				     *)
(* ----------------------------------------------------------------- *)
procedure quicksort( a : integer; z : integer );

var	cf	: integer;

begin

    if z > a then
	begin
	    cf := part( a, z );
	    quicksort( a, cf-1 );
	    quicksort( cf+1, z );
	end
    ;

end;

(* ================================================================= *)
(* Inizio del programma.					     *)
(* ----------------------------------------------------------------- *)
begin

    Writeln( 'Inserire la quantita'' di elementi.' );
    Writeln( DIM, ' al massimo.' );
    Readln( z );

    if z > DIM then
	begin
	    z := DIM;
	end
    ;

    Writeln( 'Inserire i valori dell''array' );

    for i := 1 to z do begin
	Write( 'elemento ', i:2, ': ' );
	Readln( lista[i] );
    end;

    quicksort( 1, z );

    Writeln( 'Array ordinato:' );

    for i := 1 to z do begin
	Write( lista[i] );
    end;

end.

(* ================================================================= *)
