; ======================================================================
; qsort1.scm 
; Quicksort.
; ======================================================================

; ----------------------------------------------------------------------
; Dichiara il vettore a cui faranno riferimento tutte le funzioni.
; Il vettore non viene passato alle funzioni tra gli argomenti, per
; semplificare le funzioni, soprattutto nel caso di part, che
; deve restituire anche un altro valore.
; ----------------------------------------------------------------------
(define DIM 100)
(define vettore (make-vector DIM))

; ======================================================================
; (inverti-elementi <indice-1> <indice-2>)
; ----------------------------------------------------------------------
(define (inverti-elementi a z)
    (define scambio 0)
    (set! scambio (vector-ref vettore a))
    (vector-set! vettore a (vector-ref vettore z))
    (vector-set! vettore z scambio)
)

; ======================================================================
; (part <ele-inf> <ele-sup>)
; ----------------------------------------------------------------------
(define (part a z)
    ; Si assume che a sia inferiore a z.
    (define i (+ a 1))
    (define cf z)
    ; Vengono preparate delle variabili per controllare l'uscita dai cicli.
    (define uscita1 #f)
    (define uscita2 #f)
    (define uscita3 #f)

    ; Inizia il ciclo di scansione dell'array.
    (set! uscita1 #f)
    (do ()
	(uscita1)
	(set! uscita2 #f)
	(do ()
	    (uscita2)

	    ; Sposta i a destra.
	    (if (or
		    (> (vector-ref vettore i) (vector-ref vettore a))
		    (>= i cf)
		)
		; Interrompe il ciclo interno.
		(set! uscita2 #t)
		; Altrimenti incrementa l'indice
		(set! i (+ i 1))
	    )
	)
	(set! uscita3 #f)
	(do ()
	    (uscita3)

	    ; Sposta cf a sinistra.
	    (if (<= (vector-ref vettore cf) (vector-ref vettore a))
		; Interrompe il ciclo interno.
		(set! uscita3 #t)
		; Altrimenti decrementa l'indice
		(set! cf (- cf 1))
	    )
	)

	(if (<= cf i)
	    ;  avvenuto l'incontro tra i e cf.
	    (set! uscita1 #t)
	    ; Altrimenti vengono scambiati i valori.
	    (begin
		(inverti-elementi i cf)
		(set! i (+ i 1))
		(set! cf (- cf 1))
	    )
	)
    )

    ; A questo punto vettore[a..z]  stato ripartito e cf  la
    ; collocazione di vettore[a].
    (inverti-elementi a cf)

    ; A questo punto, vettore[cf]  un elemento (un valore) nella
    ; posizione giusta, e cf  ci che viene restituito.
    cf
)

; ======================================================================
; (ordina <ele-inf> <ele-sup>)
; ----------------------------------------------------------------------
(define (ordina a z)
    ; Viene preparata la variabile cf.
    (define cf 0)

    (if (> z a)
	(begin
	    (set! cf (part a z))
	    (ordina a (- cf 1))
	    (ordina (+ cf 1) z)
	)
    )
)

; ======================================================================
; Inizio del programma.
; ----------------------------------------------------------------------

(define x 0)
(define i 0)
(define z 0)

(display "Inserire la quantit di elementi; ")
(display DIM)
(display " al massimo: ")
(set! z (read))
(newline)

(if (> z DIM)
    (set! z DIM)
)

(display "Inserire i valori del vettore.")
(newline)
(do ( (i 0 (+ i 1)) )
    ( (>= i z) )

    (display "elemento ")
    (display i)
    (display " ")
    (vector-set! vettore i (read))
    (newline)
)

; Il vettore non viene trasferito come argomento della funzione,
; ma risulta accessibile esternamente.
(ordina 0 (- z 1))

(display "Il vettore ordinato  il seguente: ")
(newline)
(do ( (i 0 (+ i 1)) )
    ( (>= i z) )

    (display (vector-ref vettore i))
    (display " ")
)
(newline)

; ======================================================================
