#!/bin/sh

# Si raccoglie la stringa generata da getopt.
STRINGA_ARGOMENTI=`getopt -o ab:c:: -l a-lunga,b-lunga:,c-lunga:: -- "$@"`

# Si trasferisce nei parametri $1, $2,...
eval set -- "$STRINGA_ARGOMENTI"

while true ; do
    case "$1" in
	-a|--a-lunga)
	    echo "Opzione a"
	    shift
	    ;;
	-b|--b-lunga)
	    echo "Opzione b, argomento $2"
	    shift 2
	    ;;
	-c|--c-lunga)
	    case "$2" in
		"") echo "Opzione c, senza argomenti"
		    shift 2
		    ;;
		*)  echo "Opzione c, argomento $2"
		    shift 2
		    ;;
	    esac
	    ;;
	--) shift
	    break
	    ;;
	*)  echo "Errore imprevisto!"
	    exit 1
	    ;;
	esac
done

echo "Argomenti rimanenti:"
for argomento in "$@"
do
    echo "$argomento"
done
