#!/usr/bin/perl
#======================================================================
# Copyright (c) 1998-1999 Daniele Giacomini daniele@pluto.linux.it
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
# General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#======================================================================
# annunci.pl
#======================================================================

#----------------------------------------------------------------------
# Utilizza il modulo Pg, per l'utilizzo delle librerie LIBPQ di
# PostgreSQL.
#----------------------------------------------------------------------
use Pg;

#----------------------------------------------------------------------
# Incorpora la libreria di decodifica dei dati.
#----------------------------------------------------------------------
require ('mini-lib.pl');

#======================================================================
# &Metodo_non_gestibile ()
#----------------------------------------------------------------------
sub Metodo_non_gestibile {
    print "Content-type: text/html\n";
    print "\n";
    print "<HTML>\n";
    print "<HEAD>\n";
    print "<TITLE>Errore</TITLE>\n";
    print "</HEAD>\n";
    print "<BODY>\n";
    print "<H1>Metodo $ENV{REQUEST_METHOD} non gestibile.</H1>\n";
    print "</BODY>\n";
    print "</HTML>\n";
};

#======================================================================
# &Verifica_dati_annuncio ()
#----------------------------------------------------------------------
sub Verifica_dati_annuncio {
    if ( $DATI{rubrica} eq "0" ) {
        return 0;
    };
    if ( $DATI{testo} eq "" ) {
        return 0;
    };
    if ( $DATI{email} eq "" ) {
        return 0;
    };
    if ( $DATI{cognome} eq "" ) {
        return 0;
    };
    if ( $DATI{nome} eq "" ) {
        return 0;
    };
    if ( $DATI{telefono} eq "" ) {
        return 0;
    };
    return 1;
};

#======================================================================
# &Verifica_dati_consultazione ()
#----------------------------------------------------------------------
sub Verifica_dati_consultazione {
    if ( $DATI{rubrica} eq "0" ) {
        return 0;
    };
    if ( $DATI{modello} eq "" ) {
	$DATI{modello} = "%";
    };
    return 1;
};

#======================================================================
# &Dati_insufficienti ()
#----------------------------------------------------------------------
sub Dati_insufficienti {
    print "Content-type: text/html\n";
    print "\n";
    print "<HTML>\n";
    print "<HEAD>\n";
    print "<TITLE>Errore</TITLE>\n";
    print "</HEAD>\n";
    print "<BODY>\n";
    print "<H1>I dati inseriti nel modello sono insufficienti.</H1>\n";
    print "Si prega di controllare e aggiungere i dati mancanti.\n";
    print "</BODY>\n";
    print "</HTML>\n";
};

#======================================================================
# &Modulo_iniziale ()
#----------------------------------------------------------------------
sub Modulo_iniziale {
    print "Content-type: text/html\n";
    print "\n";
    print "<HTML>\n";
    print "<HEAD>\n";
    print "<TITLE>Annunci on-line</TITLE>\n";
    print "</HEAD>\n";
    print "<BODY>\n";
    print "<H1>Annunci on-line</H1>\n";
    print "<P>\n";
    print "Selezionare una delle due voci seguenti:</P>\n";
    print "<P>\n";
    print "<A HREF=\"/cgi-bin/annunci.pl?modulo=preannuncio\">";
    print "inserimento di un nuovo annuncio</A></P>\n";
    print "<P>\n";
    print "<A HREF=\"/cgi-bin/annunci.pl?modulo=prericerca\">";
    print "ricerca tra gli annunci</A></P>\n";
    print "</BODY>\n";
    print "</HTML>\n";
};

#======================================================================
# &Modulo_nuovo_annuncio ()
#----------------------------------------------------------------------
sub Modulo_nuovo_annuncio {
    print "Content-type: text/html\n";
    print "\n";
    print "<HTML>\n";
    print "<HEAD>\n";
    print "<TITLE>Annunci on-line: inserimento</TITLE>\n";
    print "</HEAD>\n";
    print "<BODY>\n";
    print "<H1>Inserimento di un annuncio</H1>\n";
    print "<P>\n";
    print "Si prega di inserire tutti i dati richiesti.</P>\n";
    print "<P>\n";
    print "<FORM ACTION=\"/cgi-bin/annunci.pl\" METHOD=\"POST\">\n";
    print "<INPUT TYPE=hidden NAME=\"modulo\" VALUE=\"annuncio\" >\n";
    print "<P>\n";
    print "Rubrica:&nbsp;<SELECT NAME=\"rubrica\">\n";
    print "	<OPTION VALUE=0 SELECTED>Nessuna\n";
    print "	<OPTION VALUE=1 >Compro\n";
    print "	<OPTION VALUE=2 >Vendo\n";
    print "	<OPTION VALUE=3 >Messaggi\n";
    print "	<OPTION VALUE=4 >Varie\n";
    print "</SELECT></P>\n";
    print "<P>\n";
    print "Testo dell'annuncio:<BR>\n";
    print "	<INPUT NAME=\"testo\" SIZE=80></P>\n";
    print "<P>\n";
    print "e-mail:&nbsp;<INPUT NAME=\"email\" SIZE=40></P>\n";
    print "\n";
    print "<H2>Dati che non vengono pubblicati</H2>\n";
    print "<P>\n";
    print "Cognome:&nbsp;<INPUT NAME=\"cognome\" SIZE=25></P>\n";
    print "<P>\n";
    print "Nome:&nbsp;<INPUT NAME=\"nome\" SIZE=25></P>\n";
    print "<P>\n";
    print "Telefono:&nbsp;<INPUT NAME=\"telefono\" SIZE=25></P>\n";
    print "<P>\n";
    print "<INPUT TYPE=submit VALUE=\"Invia l'inserzione\"></P>\n";
    print "</FORM></P>\n";
    print "</BODY>\n";
    print "</HTML>\n";
};

#======================================================================
# &Modulo_ricerca ()
#----------------------------------------------------------------------
sub Modulo_ricerca {
    print "Content-type: text/html\n";
    print "\n";
    print "<HTML>\n";
    print "<HEAD>\n";
    print "<TITLE>Annunci on-line: ricerca annunci</TITLE>\n";
    print "</HEAD>\n";
    print "<BODY>\n";
    print "<H1>Ricerca tra gli annunci</H1>\n";
    print "<P>\n";
    print "Si deve indicare la rubrica e un modello di ricerca.</P>\n";
    print "<P>\n";
    print "Il modello  sensibile alla differenza tra maiuscole \n";
    print "e minuscole, si pu utilizzare il simbolo `%' per \n";
    print "indicare una stringa di caratteri indefinita.\n</P>";
    print "<P>\n";
    print "<FORM ACTION=\"/cgi-bin/annunci.pl\" METHOD=\"GET\">\n";
    print "<INPUT TYPE=hidden NAME=\"modulo\" VALUE=\"ricerca\" >\n";
    print "<P>\n";
    print "Rubrica:&nbsp;<SELECT NAME=\"rubrica\">\n";
    print "	<OPTION VALUE=0 SELECTED>Nessuna\n";
    print "	<OPTION VALUE=1 >Compro\n";
    print "	<OPTION VALUE=2 >Vendo\n";
    print "	<OPTION VALUE=3 >Messaggi\n";
    print "	<OPTION VALUE=4 >Varie\n";
    print "</SELECT></P>\n";
    print "<P>\n";
    print "Modello di ricerca:&nbsp;";
    print "<INPUT NAME=\"modello\" SIZE=30 VALUE=\"%\"></P>\n";
    print "<P>\n";
    print "<INPUT TYPE=submit VALUE=\"Inizia la ricerca\"></P>\n";
    print "</FORM></P>\n";
    print "</BODY>\n";
    print "</HTML>\n";
};

#======================================================================
# &Ricerca_annunci ()
#----------------------------------------------------------------------
sub Ricerca_annunci {

    local( $PGquery ) = "
	SELECT Annuncio, Email FROM Annunci
		WHERE Rubrica = $DATI{rubrica}
		AND Annuncio LIKE '$DATI{modello}'
		ORDER BY Annuncio
    " ;

    local( @tabella ) = ();
    local( $PGconnessione );
    local( $i );
    local( $j );
        
    #------------------------------------------------------------------
    # Apre la connessione con il server PostgreSQL locale, utilizzando
    # il database ``pubblico''.
    #------------------------------------------------------------------
    $PGconnessione = Pg::connectdb("dbname = pubblico");

    #------------------------------------------------------------------
    # Verifica che la connessione sia avvenuta e quindi esegue
    # l'interrogazione.
    #------------------------------------------------------------------
    if ( $PGconnessione->status == PGRES_CONNECTION_OK ) {
    
	#--------------------------------------------------------------
        # Invia la richiesta utilizzando la funzione Pg::doQuery che
        # fa tutto da sola (non occorre eseguire PQclear).
	#--------------------------------------------------------------
	Pg::doQuery( $PGconnessione, $PGquery, \@tabella );

    } else {

	#--------------------------------------------------------------
	# Per qualche motivo la connessione con il database non
	# funziona e si avvisa di conseguenza l'utente.
	#--------------------------------------------------------------
	&Database_inaccessibile();

    }

    print "Content-type: text/html\n";
    print "\n";
    print "<HTML>\n";
    print "<HEAD>\n";
    print "<TITLE>Annunci on-line: rubrica n. $DATI{rubrica}</TITLE>\n";
    print "</HEAD>\n";
    print "<BODY>\n";
    print "<H1>Consultazione della rubrica n. $DATI{rubrica}</H1>\n";

    for ( $i = 0; $i <= $#tabella; $i++ ) {

	#--------------------------------------------------------------
	# Emette il testo dell'annuncio.
	#--------------------------------------------------------------
	print "<P>\n";
	print "$tabella[$i][0]</P>\n";

	#--------------------------------------------------------------
	# Emette l'indirizzo e-mail dello scrivente.
	#--------------------------------------------------------------
	print "<P>\n";
	print "<A HREF=\"mailto:$tabella[$i][1]\">$tabella[$i][1]</A></P>\n";
	print "<HR>\n";
    }

    print "\n";
    print "</BODY>\n";
    print "</HTML>\n";
};

#======================================================================
# &Database_inaccessibile ()
#----------------------------------------------------------------------
sub Modulo_errato {
    print "Content-type: text/html\n";
    print "\n";
    print "<HTML>\n";
    print "<HEAD>\n";
    print "<TITLE>Errore</TITLE>\n";
    print "</HEAD>\n";
    print "<BODY>\n";
    print "<H1>Problemi di accesso al database.</H1>\n";
    print "Per qualche motivo non  possibile accedere al database ";
    print "degli annunci. Si prega di perdonare l'inconveniente.\n";
    print "</BODY>\n";
    print "</HTML>\n";
};

#======================================================================
# &Istruzione_errata ()
#----------------------------------------------------------------------
sub Istruzione_errata {

    local( $errore ) = @_[0];
    local( $istruzione ) = @_[1];

    print "Content-type: text/html\n";
    print "\n";
    print "<HTML>\n";
    print "<HEAD>\n";
    print "<TITLE>Errore</TITLE>\n";
    print "</HEAD>\n";
    print "<BODY>\n";
    print "<H1>Problemi di accesso al database.</H1>\n";
    print "<P>\n";
    print "Il comando richiesto ha generato l'errore seguente,</P>";
    print "<P>\n";
    print "<CODE>${errore}</CODE></P>";
    print "<P>\n";
    print "a seguito di questa istruzione SQL:</P>";
    print "<P>\n";
    print "<CODE>${istruzione}</CODE></P>";
    print "Si prega di avvisare l'amministratore del servizio.";
    print "</BODY>\n";
    print "</HTML>\n";
};

#======================================================================
# &Annuncio_memorizzato ()
#----------------------------------------------------------------------
sub Annuncio_memorizzato {

    print "Content-type: text/html\n";
    print "\n";
    print "<HTML>\n";
    print "<HEAD>\n";
    print "<TITLE>Annuncio memorizzato</TITLE>\n";
    print "</HEAD>\n";
    print "<BODY>\n";
    print "<H1>Annuncio memorizzato</H1>\n";
    print "L'annuncio  stato memorizzato. Grazie.\n";
    print "</BODY>\n";
    print "</HTML>\n";
};

#======================================================================
# &Memorizza_annuncio ()
#----------------------------------------------------------------------
sub Memorizza_annuncio {

    local( $PGconnessione );
    local( $PGrisultato );
    local( $PGistruzione );
    local( $PGstatus );
    local( $data ) = time();
        
    #------------------------------------------------------------------
    # Apre la connessione con il server PostgreSQL locale, utilizzando
    # il database ``pubblico''.
    #------------------------------------------------------------------
    $PGconnessione = Pg::connectdb("dbname = pubblico");

    #------------------------------------------------------------------
    # Verifica che la connessione sia avvenuta.
    #------------------------------------------------------------------
    if ( $PGconnessione->status == PGRES_CONNECTION_OK ) {
    
	#--------------------------------------------------------------
        # La connessione  avvenuta, e si procede con l'inserimento
	# dell'annuncio.
	#--------------------------------------------------------------

	$PGistruzione = "
		INSERT INTO Annunci ( 
				Data, Cognome, Nome, Telefono, Email,
				Rubrica, Annuncio
			)
			VALUES (
				${data}, '$DATI{cognome}',
				'$DATI{nome}', '$DATI{telefono}',
				'$DATI{email}', $DATI{rubrica},
				'$DATI{testo}'
			) ";

	$PGrisultato = $PGconnessione->exec("$PGistruzione");

	#--------------------------------------------------------------
	# Verifica il risultato dell'esecuzione dell'istruzione.
	# Attualmente sembra che il valore dello stato restituito
	# sia invertito.
	#--------------------------------------------------------------
	#$PGstatus = $PGconnessione->status;
	#
	#if ($PGstatus == PGRES_COMMAND_BAD) {
	#
	#    &Istruzione_errata( $PGconnessione->errorMessage, $PGistruzione );
	#
	#} else {

            &Annuncio_memorizzato();
	#}

    } else {

	#--------------------------------------------------------------
	# Per qualche motivo la connessione con il database non
	# funziona e si avvisa di conseguenza l'utente.
	#--------------------------------------------------------------
	&Database_inaccessibile();
    }
}


#======================================================================
# Inizio del programma.
#======================================================================

local ( %DATI ) = ();

#----------------------------------------------------------------------
# Decodifica i dati in funzione del tipo di metodo della richiesta.
#----------------------------------------------------------------------
if ( $ENV{REQUEST_METHOD} eq 'GET' ) {
    %DATI = &Decodifica_GET;
} elsif ( $ENV{REQUEST_METHOD} eq 'POST' ) {
    %DATI = &Decodifica_POST;
} else {
    &Metodo_non_gestibile;
};

#----------------------------------------------------------------------
# Attraverso il dato memorizzato con il nome ``modulo'' si determina
# l'operazione da compiere.
#----------------------------------------------------------------------
if ( $DATI{modulo} eq 'preannuncio' ) {

    &Modulo_nuovo_annuncio();

} elsif ( $DATI{modulo} eq 'prericerca' ) {

    &Modulo_ricerca();

} elsif ( $DATI{modulo} eq 'annuncio' ) {

    #------------------------------------------------------------------
    # L'utente ha inviato un annuncio.
    #------------------------------------------------------------------
    if ( &Verifica_dati_annuncio ) {
        &Memorizza_annuncio;
    } else {
        &Dati_insufficienti;
    };
} elsif ( $DATI{modulo} eq 'ricerca' ) {

    #------------------------------------------------------------------
    # L'utente ha eseguito una ricerca tra gli annunci.
    #------------------------------------------------------------------
    if ( &Verifica_dati_consultazione ) {
        &Ricerca_annunci;
    } else {
        &Dati_insufficienti;
    };
} else {

    #------------------------------------------------------------------
    # Si comincia dalla presentazione.
    #------------------------------------------------------------------
    &Modulo_iniziale;
};

#======================================================================
1;
#======================================================================
