(* ================================================================= *)
(* BSort.pas							     *)
(* ================================================================= *)
program BubbleSort;

const	DIM	= 100;

var	lista	: array[1..DIM] of integer;
	i	: integer;
	z	: integer;

(* ================================================================= *)
(* bsort( <ele-inf>, <ele-sup> )				     *)
(* ----------------------------------------------------------------- *)
procedure bsort( a : integer; z : integer );

var	scambio	: integer;
	j	: integer;
	k	: integer;

begin

    (* ------------------------------------------------------------- *)
    (* Inizia il ciclo di scansione dell'array.			     *)
    (* ------------------------------------------------------------- *)
    for j := a to ( z-1 ) do begin
    
	(* --------------------------------------------------------- *)
	(* Scansione interna dell'array per collocare nella	     *)
	(* posizione j l'elemento giusto.			     *)
	(* --------------------------------------------------------- *)
	for k := ( j+1 ) to ( z ) do begin
	
	    if lista[k] < lista[j] then
		begin

		    (* --------------------------------------------- *)
		    (* Scambia i valori.			     *)
		    (* --------------------------------------------- *)
		    scambio := lista[k];
		    lista[k] := lista[j];
		    lista[j] := scambio;
		end
	    ;

	end;
    end;

end;

(* ================================================================= *)
(* Inizio del programma.					     *)
(* ----------------------------------------------------------------- *)
begin

    Writeln( 'Inserire la quantita'' di elementi.' );
    Writeln( DIM, ' al massimo.' );
    Readln( z );

    if z > DIM then
	begin
	    z := DIM;
	end
    ;

    Writeln( 'Inserire i valori dell''array' );

    for i := 1 to z do begin
	Write( 'elemento ', i:2, ': ' );
	Readln( lista[i] );
    end;

    bsort( 1, z );

    Writeln( 'Array ordinato:' );

    for i := 1 to z do begin
	Write( lista[i] );
    end;

end.

(* ================================================================= *)
