/*
 * $Id: make.wrapper.c 491 2005-03-20 18:53:21Z acid $
 * gcc.wrapper - Wrapper for gcc used for apt-build
 * (c) 2004 - Julien Danjou <acid@debian.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2, as
 * published by the Free Software Foundation.
 *
 */


#include "apt-build.h"
#include "config.h"

#include <stdlib.h>
#include <unistd.h>

int
make_real(char **argv)
{
  return execv(MAKE_PATH, argv);
}

int
make_apt_build(int argc, char **argv)
{
  return make_real(parse_conf(argc, argv));
}

int
main(int argc, char **argv)
{
  if(getenv(APT_BUILD_STRING_ENV))
	return make_apt_build(argc, argv);

  return make_real(argv);
}
