#!/bin/sh -e

echo Testing build environment...

CXX="$1"
echo '#include <zlib.h>
z_stream t; int main(){ return inflateInit2(&t, 42); }
' > checkenv.cc
if ! "$CXX" -o checkenv.o checkenv.cc -lz ; then
   echo
   echo "ERROR: Unable to use ZLib development components. Install libz-dev."
   exit 1
fi

echo '
#include <bzlib.h>
bz_stream t; int main(){ return BZ2_bzDecompressInit(&t, 1, 0); }
' > checkenv.cc
if ! "$CXX" -o checkenv.o checkenv.cc -lbz2 ; then
   echo
   echo "ERROR: Unable to use libbz2 development components. Install libbz2-dev."
   exit 1
fi

echo '#include <tr1/memory>
int main() { return NULL != std::tr1::shared_ptr<int>(new int(1)); }
' > checkenv.cc
if ! "$CXX" -o checkenv.o checkenv.cc 2>/dev/null ; then
   echo '#include <boost/smart_ptr.hpp>
   int main() { return NULL != boost::shared_ptr<int>(new int(1)); }
   ' > checkenv.cc
   if "$CXX" -o checkenv.o checkenv.cc 2>/dev/null ; then
      echo 'CXXFLAGS += -DUSE_BOOST' >> config.mk
   else
      echo
      echo "ERROR: Unable to use shared pointers from TR1 or Boost."
      exit 1
   fi
fi
