// download_manager.h            -*-c++-*-
//
//  Copyright 2000 Daniel Burrows
//
//  A class that sits there emitting signals about the current download status,
// and can be queried for specific info about that status.

#ifndef DOWNLOAD_MANAGER_H
#define DOWNLOAD_MANAGER_H

#include <apt-pkg/acquire.h>

#include <sigc++/basic_signal.h>

#include "aptitude.h"

class download_manager:public pkgAcquireStatus
{
public:
  // Private variables?  Bah, I'll give you private variables..

  struct timeval &get_time() {return Time;}
  struct timeval &get_start_time() {return StartTime;}
#ifndef HAVE_LIBAPT_PKG3
  unsigned long get_last_bytes() {return LastBytes;}
#else
  double get_last_bytes() {return LastBytes;}
#endif
  double get_currentCPS() {return CurrentCPS;}
#ifndef HAVE_LIBAPT_PKG3
  unsigned long get_current_bytes() {return CurrentBytes;}
  unsigned long get_total_bytes() {return TotalBytes;}
  unsigned long get_fetched_bytes() {return FetchedBytes;}
#else
  double get_current_bytes() {return CurrentBytes;}
  double get_total_bytes() {return TotalBytes;}
  double get_fetched_bytes() {return FetchedBytes;}
#endif
  unsigned long get_elapsed_time() {return ElapsedTime;}
  unsigned long get_total_items() {return TotalItems;}
  unsigned long get_current_items() {return CurrentItems;}

  void set_update(bool _Update) {Update=_Update;}

  SigC::Signal3<void, unsigned long, unsigned long,
		download_manager &> Fetched_sig;
  SigC::Signal3<bool, std::string, std::string,
		download_manager &> MediaChange_sig;
  SigC::Signal2<void, pkgAcquire::ItemDesc &, download_manager &> IMSHit_sig;
  SigC::Signal2<void, pkgAcquire::ItemDesc &, download_manager &> Fetch_sig;
  SigC::Signal2<void, pkgAcquire::ItemDesc &, download_manager &> Done_sig;
  SigC::Signal2<void, pkgAcquire::ItemDesc &, download_manager &> Fail_sig;
  SigC::Signal2<bool, pkgAcquire *, download_manager &> Pulse_sig;
  SigC::Signal1<void, download_manager &> Start_sig;
  SigC::Signal1<void, download_manager &> Stop_sig;
  SigC::Signal1<void, download_manager &> Complete_sig;

  void Fetched(unsigned long Size, unsigned long ResumePoint);
  bool MediaChange(std::string Media, std::string Drive);
  void IMSHit(pkgAcquire::ItemDesc &item);
  void Fetch(pkgAcquire::ItemDesc &item);
  void Done(pkgAcquire::ItemDesc &item);
  void Fail(pkgAcquire::ItemDesc &item);
  bool Pulse(pkgAcquire *Owner);
  void Start();
  void Stop();

  // Called when EVERYTHING is over.  "Stop" is not sufficient, since
  // it is potentially called multiple times (eg, for installs spread across
  // several CDs)
  void Complete();
};

#endif
