// vs_scrollbar.cc			-*-c++-*-

#include "vs_scrollbar.h"

#include <vscreen.h>

void vs_scrollbar::paint()
{
  if(dir==HORIZONTAL)
    {
      int width=getmaxx();
      int thumbloc=max==0?-1:width*val/max;

      for(int x=0; x<width; x++)
	if(x==thumbloc)
	  mvaddch(0, x, '#');
	else
	  mvaddch(0, x, ACS_CKBOARD);
    }
  else
    {
      int height=getmaxy();
      int thumbloc=max==0?-1:height*val/max;

      for(int y=0; y<height; y++)
	if(y==thumbloc)
	  mvaddch(y, 0, '#');
	else
	  mvaddch(y, 0, ACS_CKBOARD);
    }
}

size vs_scrollbar::size_request()
{
  return size(1, 1);
}

void vs_scrollbar::set_slider(int newval, int newmax)
{
  if(max!=newmax || val!=newval)
    {
      max=newmax;
      val=newval;

      vscreen_update();
    }
}

bool vs_scrollbar::get_cursorvisible()
{
  return false;
}

point vs_scrollbar::get_cursorloc()
{
  return point(0, 0);
}
