// vs_treeitem.cc
//
//  Copyright 1999 Daniel Burrows
//
//  Implementation of stuff in vs_treeitem.h

#include "vs_treeitem.h"
#include "vs_tree.h"

using namespace std;

void vs_treeitem::highlighted(vs_tree *win)
{
}

void vs_treeitem::paint(vs_tree *win, int y, bool hierarchical, string str,
			int depth_shift=2)
{
  int width, height;
  int basex=hierarchical?depth_shift*get_depth():0;
  win->getmaxyx(height,width);

  win->move(y,0);
  for(int i=0; i<basex && i<width; i++)
    win->addch(' ');

  if(basex>width)
    return;

  win->addnstr(str.c_str(), width-basex-1);

  int newy,newx;
  win->getyx(newy,newx);

  for( ; newx<width; newx++)
    win->addch(' ');
}      
