// THIS FILE IS AUTOMATICALLY GENERATED. DO NOT EDIT.

// Package iot provides a client for AWS IoT.
package iot

import (
	"time"

	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/restjson"
)

const opAcceptCertificateTransfer = "AcceptCertificateTransfer"

// AcceptCertificateTransferRequest generates a request for the AcceptCertificateTransfer operation.
func (c *IoT) AcceptCertificateTransferRequest(input *AcceptCertificateTransferInput) (req *request.Request, output *AcceptCertificateTransferOutput) {
	op := &request.Operation{
		Name:       opAcceptCertificateTransfer,
		HTTPMethod: "PATCH",
		HTTPPath:   "/accept-certificate-transfer/{certificateId}",
	}

	if input == nil {
		input = &AcceptCertificateTransferInput{}
	}

	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(restjson.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output = &AcceptCertificateTransferOutput{}
	req.Data = output
	return
}

// Accepts a pending certificate transfer. The default state of the certificate
// is INACTIVE.
//
// To check for pending certificate transfers, call ListCertificates to enumerate
// your certificates.
func (c *IoT) AcceptCertificateTransfer(input *AcceptCertificateTransferInput) (*AcceptCertificateTransferOutput, error) {
	req, out := c.AcceptCertificateTransferRequest(input)
	err := req.Send()
	return out, err
}

const opAttachPrincipalPolicy = "AttachPrincipalPolicy"

// AttachPrincipalPolicyRequest generates a request for the AttachPrincipalPolicy operation.
func (c *IoT) AttachPrincipalPolicyRequest(input *AttachPrincipalPolicyInput) (req *request.Request, output *AttachPrincipalPolicyOutput) {
	op := &request.Operation{
		Name:       opAttachPrincipalPolicy,
		HTTPMethod: "PUT",
		HTTPPath:   "/principal-policies/{policyName}",
	}

	if input == nil {
		input = &AttachPrincipalPolicyInput{}
	}

	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(restjson.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output = &AttachPrincipalPolicyOutput{}
	req.Data = output
	return
}

// Attaches the specified policy to the specified principal (certificate or
// other credential).
func (c *IoT) AttachPrincipalPolicy(input *AttachPrincipalPolicyInput) (*AttachPrincipalPolicyOutput, error) {
	req, out := c.AttachPrincipalPolicyRequest(input)
	err := req.Send()
	return out, err
}

const opAttachThingPrincipal = "AttachThingPrincipal"

// AttachThingPrincipalRequest generates a request for the AttachThingPrincipal operation.
func (c *IoT) AttachThingPrincipalRequest(input *AttachThingPrincipalInput) (req *request.Request, output *AttachThingPrincipalOutput) {
	op := &request.Operation{
		Name:       opAttachThingPrincipal,
		HTTPMethod: "PUT",
		HTTPPath:   "/things/{thingName}/principals",
	}

	if input == nil {
		input = &AttachThingPrincipalInput{}
	}

	req = c.newRequest(op, input, output)
	output = &AttachThingPrincipalOutput{}
	req.Data = output
	return
}

// Attaches the specified principal to the specified thing.
func (c *IoT) AttachThingPrincipal(input *AttachThingPrincipalInput) (*AttachThingPrincipalOutput, error) {
	req, out := c.AttachThingPrincipalRequest(input)
	err := req.Send()
	return out, err
}

const opCancelCertificateTransfer = "CancelCertificateTransfer"

// CancelCertificateTransferRequest generates a request for the CancelCertificateTransfer operation.
func (c *IoT) CancelCertificateTransferRequest(input *CancelCertificateTransferInput) (req *request.Request, output *CancelCertificateTransferOutput) {
	op := &request.Operation{
		Name:       opCancelCertificateTransfer,
		HTTPMethod: "PATCH",
		HTTPPath:   "/cancel-certificate-transfer/{certificateId}",
	}

	if input == nil {
		input = &CancelCertificateTransferInput{}
	}

	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(restjson.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output = &CancelCertificateTransferOutput{}
	req.Data = output
	return
}

// Cancels a pending transfer for the specified certificate.
//
// Note Only the transfer source account can use this operation to cancel a
// transfer (transfer destinations can use RejectCertificateTransfer instead).
// After transfer, AWS IoT returns the certificate to the source account in
// the INACTIVE state. Once the destination account has accepted the transfer,
// the transfer may no longer be cancelled.
//
// After a certificate transfer is cancelled, the status of the certificate
// changes from PENDING_TRANSFER to INACTIVE.
func (c *IoT) CancelCertificateTransfer(input *CancelCertificateTransferInput) (*CancelCertificateTransferOutput, error) {
	req, out := c.CancelCertificateTransferRequest(input)
	err := req.Send()
	return out, err
}

const opCreateCertificateFromCsr = "CreateCertificateFromCsr"

// CreateCertificateFromCsrRequest generates a request for the CreateCertificateFromCsr operation.
func (c *IoT) CreateCertificateFromCsrRequest(input *CreateCertificateFromCsrInput) (req *request.Request, output *CreateCertificateFromCsrOutput) {
	op := &request.Operation{
		Name:       opCreateCertificateFromCsr,
		HTTPMethod: "POST",
		HTTPPath:   "/certificates",
	}

	if input == nil {
		input = &CreateCertificateFromCsrInput{}
	}

	req = c.newRequest(op, input, output)
	output = &CreateCertificateFromCsrOutput{}
	req.Data = output
	return
}

// Creates an X.509 certificate using the specified certificate signing request.
//
// Note Reusing the same certificate signing request (CSR) results in a distinct
// certificate.
//
// You can create multiple certificates in a batch by creating a directory
// and copying multiple .csr files into that directory and specifying that directory
// on the command line. The following commands show how to create a batch of
// certificates given a batch of CSRs.
//
// Assuming a set of CSRs are located inside of the directory my-csr-directory:
//
// > On Linux and OSX, the command is:
//
// $ ls my-csr-directory/ | xargs -I {} aws iot create-certificate-from-csr
// --certificate-signing-request file://my-csr-directory/{}
//
//  This command lists all of the CSRs in my-csr-directory and pipes each CSR
// filename to the aws iot create-certificate-from-csr AWS CLI command to create
// a certificate for the corresponding CSR.
//
//  The aws iot create-certificate-from-csr part of the command can also be
// run in parallel to speed up the certificate creation process:
//
//  $ ls my-csr-directory/ | xargs -P 10 -I {} aws iot create-certificate-from-csr
// --certificate-signing-request file://my-csr-directory/{}
//
//  On Windows PowerShell, the command to create certificates for all CSRs
// in my-csr-directory is:
//
//  > ls -Name my-csr-directory | %{aws iot create-certificate-from-csr --certificate-signing-request
// file://my-csr-directory/$_}
//
//  On Windows Command Prompt, the command to create certificates for all CSRs
// in my-csr-directory is:
//
//  > forfiles /p my-csr-directory /c "cmd /c aws iot create-certificate-from-csr
// --certificate-signing-request file://@path"
func (c *IoT) CreateCertificateFromCsr(input *CreateCertificateFromCsrInput) (*CreateCertificateFromCsrOutput, error) {
	req, out := c.CreateCertificateFromCsrRequest(input)
	err := req.Send()
	return out, err
}

const opCreateKeysAndCertificate = "CreateKeysAndCertificate"

// CreateKeysAndCertificateRequest generates a request for the CreateKeysAndCertificate operation.
func (c *IoT) CreateKeysAndCertificateRequest(input *CreateKeysAndCertificateInput) (req *request.Request, output *CreateKeysAndCertificateOutput) {
	op := &request.Operation{
		Name:       opCreateKeysAndCertificate,
		HTTPMethod: "POST",
		HTTPPath:   "/keys-and-certificate",
	}

	if input == nil {
		input = &CreateKeysAndCertificateInput{}
	}

	req = c.newRequest(op, input, output)
	output = &CreateKeysAndCertificateOutput{}
	req.Data = output
	return
}

// Creates a 2048 bit RSA key pair and issues an X.509 certificate using the
// issued public key.
//
// Note This is the only time AWS IoT issues the private key for this certificate.
// It is important to keep track of the private key.
func (c *IoT) CreateKeysAndCertificate(input *CreateKeysAndCertificateInput) (*CreateKeysAndCertificateOutput, error) {
	req, out := c.CreateKeysAndCertificateRequest(input)
	err := req.Send()
	return out, err
}

const opCreatePolicy = "CreatePolicy"

// CreatePolicyRequest generates a request for the CreatePolicy operation.
func (c *IoT) CreatePolicyRequest(input *CreatePolicyInput) (req *request.Request, output *CreatePolicyOutput) {
	op := &request.Operation{
		Name:       opCreatePolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/policies/{policyName}",
	}

	if input == nil {
		input = &CreatePolicyInput{}
	}

	req = c.newRequest(op, input, output)
	output = &CreatePolicyOutput{}
	req.Data = output
	return
}

// Creates an AWS IoT policy.
//
// The created policy is the default version for the policy. This operation
// creates a policy version with a version identifier of 1 and sets 1 as the
// policy's default version.
func (c *IoT) CreatePolicy(input *CreatePolicyInput) (*CreatePolicyOutput, error) {
	req, out := c.CreatePolicyRequest(input)
	err := req.Send()
	return out, err
}

const opCreatePolicyVersion = "CreatePolicyVersion"

// CreatePolicyVersionRequest generates a request for the CreatePolicyVersion operation.
func (c *IoT) CreatePolicyVersionRequest(input *CreatePolicyVersionInput) (req *request.Request, output *CreatePolicyVersionOutput) {
	op := &request.Operation{
		Name:       opCreatePolicyVersion,
		HTTPMethod: "POST",
		HTTPPath:   "/policies/{policyName}/version",
	}

	if input == nil {
		input = &CreatePolicyVersionInput{}
	}

	req = c.newRequest(op, input, output)
	output = &CreatePolicyVersionOutput{}
	req.Data = output
	return
}

// Creates a new version of the specified AWS IoT policy. To update a policy,
// create a new policy version. A managed policy can have up to five versions.
// If the policy has five versions, you must delete an existing version using
// DeletePolicyVersion before you create a new version.
//
// Optionally, you can set the new version as the policy's default version.
// The default version is the operative version; that is, the version that is
// in effect for the certificates that the policy is attached to.
func (c *IoT) CreatePolicyVersion(input *CreatePolicyVersionInput) (*CreatePolicyVersionOutput, error) {
	req, out := c.CreatePolicyVersionRequest(input)
	err := req.Send()
	return out, err
}

const opCreateThing = "CreateThing"

// CreateThingRequest generates a request for the CreateThing operation.
func (c *IoT) CreateThingRequest(input *CreateThingInput) (req *request.Request, output *CreateThingOutput) {
	op := &request.Operation{
		Name:       opCreateThing,
		HTTPMethod: "POST",
		HTTPPath:   "/things/{thingName}",
	}

	if input == nil {
		input = &CreateThingInput{}
	}

	req = c.newRequest(op, input, output)
	output = &CreateThingOutput{}
	req.Data = output
	return
}

// Creates a thing in the thing registry.
func (c *IoT) CreateThing(input *CreateThingInput) (*CreateThingOutput, error) {
	req, out := c.CreateThingRequest(input)
	err := req.Send()
	return out, err
}

const opCreateTopicRule = "CreateTopicRule"

// CreateTopicRuleRequest generates a request for the CreateTopicRule operation.
func (c *IoT) CreateTopicRuleRequest(input *CreateTopicRuleInput) (req *request.Request, output *CreateTopicRuleOutput) {
	op := &request.Operation{
		Name:       opCreateTopicRule,
		HTTPMethod: "POST",
		HTTPPath:   "/rules/{ruleName}",
	}

	if input == nil {
		input = &CreateTopicRuleInput{}
	}

	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(restjson.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output = &CreateTopicRuleOutput{}
	req.Data = output
	return
}

// Creates a rule.
func (c *IoT) CreateTopicRule(input *CreateTopicRuleInput) (*CreateTopicRuleOutput, error) {
	req, out := c.CreateTopicRuleRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteCertificate = "DeleteCertificate"

// DeleteCertificateRequest generates a request for the DeleteCertificate operation.
func (c *IoT) DeleteCertificateRequest(input *DeleteCertificateInput) (req *request.Request, output *DeleteCertificateOutput) {
	op := &request.Operation{
		Name:       opDeleteCertificate,
		HTTPMethod: "DELETE",
		HTTPPath:   "/certificates/{certificateId}",
	}

	if input == nil {
		input = &DeleteCertificateInput{}
	}

	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(restjson.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output = &DeleteCertificateOutput{}
	req.Data = output
	return
}

// Deletes the specified certificate.
//
// A certificate cannot be deleted if it has a policy attached to it or if
// its status is set to ACTIVE. To delete a certificate, first detach all policies
// using the DetachPrincipalPolicy API. Next use the UpdateCertificate API to
// set the certificate to the INACTIVE status.
func (c *IoT) DeleteCertificate(input *DeleteCertificateInput) (*DeleteCertificateOutput, error) {
	req, out := c.DeleteCertificateRequest(input)
	err := req.Send()
	return out, err
}

const opDeletePolicy = "DeletePolicy"

// DeletePolicyRequest generates a request for the DeletePolicy operation.
func (c *IoT) DeletePolicyRequest(input *DeletePolicyInput) (req *request.Request, output *DeletePolicyOutput) {
	op := &request.Operation{
		Name:       opDeletePolicy,
		HTTPMethod: "DELETE",
		HTTPPath:   "/policies/{policyName}",
	}

	if input == nil {
		input = &DeletePolicyInput{}
	}

	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(restjson.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output = &DeletePolicyOutput{}
	req.Data = output
	return
}

// Deletes the specified policy.
//
// A policy cannot be deleted if it has non-default versions and/or it is attached
// to any certificate.
//
// To delete a policy, delete all non-default versions of the policy using
// the DeletePolicyVersion API, detach the policy from any certificate using
// the DetachPrincipalPolicy API, and then use the DeletePolicy API to delete
// the policy.
//
// When a policy is deleted using DeletePolicy, its default version is deleted
// with it.
func (c *IoT) DeletePolicy(input *DeletePolicyInput) (*DeletePolicyOutput, error) {
	req, out := c.DeletePolicyRequest(input)
	err := req.Send()
	return out, err
}

const opDeletePolicyVersion = "DeletePolicyVersion"

// DeletePolicyVersionRequest generates a request for the DeletePolicyVersion operation.
func (c *IoT) DeletePolicyVersionRequest(input *DeletePolicyVersionInput) (req *request.Request, output *DeletePolicyVersionOutput) {
	op := &request.Operation{
		Name:       opDeletePolicyVersion,
		HTTPMethod: "DELETE",
		HTTPPath:   "/policies/{policyName}/version/{policyVersionId}",
	}

	if input == nil {
		input = &DeletePolicyVersionInput{}
	}

	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(restjson.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output = &DeletePolicyVersionOutput{}
	req.Data = output
	return
}

// Deletes the specified version of the specified policy. You cannot delete
// the default version of a policy using this API. To delete the default version
// of a policy, use DeletePolicy. To find out which version of a policy is marked
// as the default version, use ListPolicyVersions.
func (c *IoT) DeletePolicyVersion(input *DeletePolicyVersionInput) (*DeletePolicyVersionOutput, error) {
	req, out := c.DeletePolicyVersionRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteThing = "DeleteThing"

// DeleteThingRequest generates a request for the DeleteThing operation.
func (c *IoT) DeleteThingRequest(input *DeleteThingInput) (req *request.Request, output *DeleteThingOutput) {
	op := &request.Operation{
		Name:       opDeleteThing,
		HTTPMethod: "DELETE",
		HTTPPath:   "/things/{thingName}",
	}

	if input == nil {
		input = &DeleteThingInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DeleteThingOutput{}
	req.Data = output
	return
}

// Deletes the specified thing from the Thing Registry.
func (c *IoT) DeleteThing(input *DeleteThingInput) (*DeleteThingOutput, error) {
	req, out := c.DeleteThingRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteTopicRule = "DeleteTopicRule"

// DeleteTopicRuleRequest generates a request for the DeleteTopicRule operation.
func (c *IoT) DeleteTopicRuleRequest(input *DeleteTopicRuleInput) (req *request.Request, output *DeleteTopicRuleOutput) {
	op := &request.Operation{
		Name:       opDeleteTopicRule,
		HTTPMethod: "DELETE",
		HTTPPath:   "/rules/{ruleName}",
	}

	if input == nil {
		input = &DeleteTopicRuleInput{}
	}

	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(restjson.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output = &DeleteTopicRuleOutput{}
	req.Data = output
	return
}

// Deletes the specified rule.
func (c *IoT) DeleteTopicRule(input *DeleteTopicRuleInput) (*DeleteTopicRuleOutput, error) {
	req, out := c.DeleteTopicRuleRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeCertificate = "DescribeCertificate"

// DescribeCertificateRequest generates a request for the DescribeCertificate operation.
func (c *IoT) DescribeCertificateRequest(input *DescribeCertificateInput) (req *request.Request, output *DescribeCertificateOutput) {
	op := &request.Operation{
		Name:       opDescribeCertificate,
		HTTPMethod: "GET",
		HTTPPath:   "/certificates/{certificateId}",
	}

	if input == nil {
		input = &DescribeCertificateInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeCertificateOutput{}
	req.Data = output
	return
}

// Gets information about the specified certificate.
func (c *IoT) DescribeCertificate(input *DescribeCertificateInput) (*DescribeCertificateOutput, error) {
	req, out := c.DescribeCertificateRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeEndpoint = "DescribeEndpoint"

// DescribeEndpointRequest generates a request for the DescribeEndpoint operation.
func (c *IoT) DescribeEndpointRequest(input *DescribeEndpointInput) (req *request.Request, output *DescribeEndpointOutput) {
	op := &request.Operation{
		Name:       opDescribeEndpoint,
		HTTPMethod: "GET",
		HTTPPath:   "/endpoint",
	}

	if input == nil {
		input = &DescribeEndpointInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeEndpointOutput{}
	req.Data = output
	return
}

// Returns a unique endpoint specific to the AWS account making the call. You
// specify the following URI when updating state information for your thing:
// https://endpoint/things/thingName/shadow.
func (c *IoT) DescribeEndpoint(input *DescribeEndpointInput) (*DescribeEndpointOutput, error) {
	req, out := c.DescribeEndpointRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeThing = "DescribeThing"

// DescribeThingRequest generates a request for the DescribeThing operation.
func (c *IoT) DescribeThingRequest(input *DescribeThingInput) (req *request.Request, output *DescribeThingOutput) {
	op := &request.Operation{
		Name:       opDescribeThing,
		HTTPMethod: "GET",
		HTTPPath:   "/things/{thingName}",
	}

	if input == nil {
		input = &DescribeThingInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeThingOutput{}
	req.Data = output
	return
}

// Gets information about the specified thing.
func (c *IoT) DescribeThing(input *DescribeThingInput) (*DescribeThingOutput, error) {
	req, out := c.DescribeThingRequest(input)
	err := req.Send()
	return out, err
}

const opDetachPrincipalPolicy = "DetachPrincipalPolicy"

// DetachPrincipalPolicyRequest generates a request for the DetachPrincipalPolicy operation.
func (c *IoT) DetachPrincipalPolicyRequest(input *DetachPrincipalPolicyInput) (req *request.Request, output *DetachPrincipalPolicyOutput) {
	op := &request.Operation{
		Name:       opDetachPrincipalPolicy,
		HTTPMethod: "DELETE",
		HTTPPath:   "/principal-policies/{policyName}",
	}

	if input == nil {
		input = &DetachPrincipalPolicyInput{}
	}

	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(restjson.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output = &DetachPrincipalPolicyOutput{}
	req.Data = output
	return
}

// Removes the specified policy from the specified certificate.
func (c *IoT) DetachPrincipalPolicy(input *DetachPrincipalPolicyInput) (*DetachPrincipalPolicyOutput, error) {
	req, out := c.DetachPrincipalPolicyRequest(input)
	err := req.Send()
	return out, err
}

const opDetachThingPrincipal = "DetachThingPrincipal"

// DetachThingPrincipalRequest generates a request for the DetachThingPrincipal operation.
func (c *IoT) DetachThingPrincipalRequest(input *DetachThingPrincipalInput) (req *request.Request, output *DetachThingPrincipalOutput) {
	op := &request.Operation{
		Name:       opDetachThingPrincipal,
		HTTPMethod: "DELETE",
		HTTPPath:   "/things/{thingName}/principals",
	}

	if input == nil {
		input = &DetachThingPrincipalInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DetachThingPrincipalOutput{}
	req.Data = output
	return
}

// Detaches the specified principal from the specified thing.
func (c *IoT) DetachThingPrincipal(input *DetachThingPrincipalInput) (*DetachThingPrincipalOutput, error) {
	req, out := c.DetachThingPrincipalRequest(input)
	err := req.Send()
	return out, err
}

const opDisableTopicRule = "DisableTopicRule"

// DisableTopicRuleRequest generates a request for the DisableTopicRule operation.
func (c *IoT) DisableTopicRuleRequest(input *DisableTopicRuleInput) (req *request.Request, output *DisableTopicRuleOutput) {
	op := &request.Operation{
		Name:       opDisableTopicRule,
		HTTPMethod: "POST",
		HTTPPath:   "/rules/{ruleName}/disable",
	}

	if input == nil {
		input = &DisableTopicRuleInput{}
	}

	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(restjson.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output = &DisableTopicRuleOutput{}
	req.Data = output
	return
}

// Disables the specified rule
func (c *IoT) DisableTopicRule(input *DisableTopicRuleInput) (*DisableTopicRuleOutput, error) {
	req, out := c.DisableTopicRuleRequest(input)
	err := req.Send()
	return out, err
}

const opEnableTopicRule = "EnableTopicRule"

// EnableTopicRuleRequest generates a request for the EnableTopicRule operation.
func (c *IoT) EnableTopicRuleRequest(input *EnableTopicRuleInput) (req *request.Request, output *EnableTopicRuleOutput) {
	op := &request.Operation{
		Name:       opEnableTopicRule,
		HTTPMethod: "POST",
		HTTPPath:   "/rules/{ruleName}/enable",
	}

	if input == nil {
		input = &EnableTopicRuleInput{}
	}

	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(restjson.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output = &EnableTopicRuleOutput{}
	req.Data = output
	return
}

// Enables the specified rule.
func (c *IoT) EnableTopicRule(input *EnableTopicRuleInput) (*EnableTopicRuleOutput, error) {
	req, out := c.EnableTopicRuleRequest(input)
	err := req.Send()
	return out, err
}

const opGetLoggingOptions = "GetLoggingOptions"

// GetLoggingOptionsRequest generates a request for the GetLoggingOptions operation.
func (c *IoT) GetLoggingOptionsRequest(input *GetLoggingOptionsInput) (req *request.Request, output *GetLoggingOptionsOutput) {
	op := &request.Operation{
		Name:       opGetLoggingOptions,
		HTTPMethod: "GET",
		HTTPPath:   "/loggingOptions",
	}

	if input == nil {
		input = &GetLoggingOptionsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &GetLoggingOptionsOutput{}
	req.Data = output
	return
}

// Gets the logging options.
func (c *IoT) GetLoggingOptions(input *GetLoggingOptionsInput) (*GetLoggingOptionsOutput, error) {
	req, out := c.GetLoggingOptionsRequest(input)
	err := req.Send()
	return out, err
}

const opGetPolicy = "GetPolicy"

// GetPolicyRequest generates a request for the GetPolicy operation.
func (c *IoT) GetPolicyRequest(input *GetPolicyInput) (req *request.Request, output *GetPolicyOutput) {
	op := &request.Operation{
		Name:       opGetPolicy,
		HTTPMethod: "GET",
		HTTPPath:   "/policies/{policyName}",
	}

	if input == nil {
		input = &GetPolicyInput{}
	}

	req = c.newRequest(op, input, output)
	output = &GetPolicyOutput{}
	req.Data = output
	return
}

// Gets information about the specified policy with the policy document of the
// default version.
func (c *IoT) GetPolicy(input *GetPolicyInput) (*GetPolicyOutput, error) {
	req, out := c.GetPolicyRequest(input)
	err := req.Send()
	return out, err
}

const opGetPolicyVersion = "GetPolicyVersion"

// GetPolicyVersionRequest generates a request for the GetPolicyVersion operation.
func (c *IoT) GetPolicyVersionRequest(input *GetPolicyVersionInput) (req *request.Request, output *GetPolicyVersionOutput) {
	op := &request.Operation{
		Name:       opGetPolicyVersion,
		HTTPMethod: "GET",
		HTTPPath:   "/policies/{policyName}/version/{policyVersionId}",
	}

	if input == nil {
		input = &GetPolicyVersionInput{}
	}

	req = c.newRequest(op, input, output)
	output = &GetPolicyVersionOutput{}
	req.Data = output
	return
}

// Gets information about the specified policy version.
func (c *IoT) GetPolicyVersion(input *GetPolicyVersionInput) (*GetPolicyVersionOutput, error) {
	req, out := c.GetPolicyVersionRequest(input)
	err := req.Send()
	return out, err
}

const opGetTopicRule = "GetTopicRule"

// GetTopicRuleRequest generates a request for the GetTopicRule operation.
func (c *IoT) GetTopicRuleRequest(input *GetTopicRuleInput) (req *request.Request, output *GetTopicRuleOutput) {
	op := &request.Operation{
		Name:       opGetTopicRule,
		HTTPMethod: "GET",
		HTTPPath:   "/rules/{ruleName}",
	}

	if input == nil {
		input = &GetTopicRuleInput{}
	}

	req = c.newRequest(op, input, output)
	output = &GetTopicRuleOutput{}
	req.Data = output
	return
}

// Gets information about the specified rule.
func (c *IoT) GetTopicRule(input *GetTopicRuleInput) (*GetTopicRuleOutput, error) {
	req, out := c.GetTopicRuleRequest(input)
	err := req.Send()
	return out, err
}

const opListCertificates = "ListCertificates"

// ListCertificatesRequest generates a request for the ListCertificates operation.
func (c *IoT) ListCertificatesRequest(input *ListCertificatesInput) (req *request.Request, output *ListCertificatesOutput) {
	op := &request.Operation{
		Name:       opListCertificates,
		HTTPMethod: "GET",
		HTTPPath:   "/certificates",
	}

	if input == nil {
		input = &ListCertificatesInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ListCertificatesOutput{}
	req.Data = output
	return
}

// Lists your certificates.
//
// The results are paginated with a default page size of 25. You can retrieve
// additional results using the returned marker.
func (c *IoT) ListCertificates(input *ListCertificatesInput) (*ListCertificatesOutput, error) {
	req, out := c.ListCertificatesRequest(input)
	err := req.Send()
	return out, err
}

const opListPolicies = "ListPolicies"

// ListPoliciesRequest generates a request for the ListPolicies operation.
func (c *IoT) ListPoliciesRequest(input *ListPoliciesInput) (req *request.Request, output *ListPoliciesOutput) {
	op := &request.Operation{
		Name:       opListPolicies,
		HTTPMethod: "GET",
		HTTPPath:   "/policies",
	}

	if input == nil {
		input = &ListPoliciesInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ListPoliciesOutput{}
	req.Data = output
	return
}

// Lists your policies.
func (c *IoT) ListPolicies(input *ListPoliciesInput) (*ListPoliciesOutput, error) {
	req, out := c.ListPoliciesRequest(input)
	err := req.Send()
	return out, err
}

const opListPolicyVersions = "ListPolicyVersions"

// ListPolicyVersionsRequest generates a request for the ListPolicyVersions operation.
func (c *IoT) ListPolicyVersionsRequest(input *ListPolicyVersionsInput) (req *request.Request, output *ListPolicyVersionsOutput) {
	op := &request.Operation{
		Name:       opListPolicyVersions,
		HTTPMethod: "GET",
		HTTPPath:   "/policies/{policyName}/version",
	}

	if input == nil {
		input = &ListPolicyVersionsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ListPolicyVersionsOutput{}
	req.Data = output
	return
}

// Lists the versions of the specified policy, and identifies the default version.
func (c *IoT) ListPolicyVersions(input *ListPolicyVersionsInput) (*ListPolicyVersionsOutput, error) {
	req, out := c.ListPolicyVersionsRequest(input)
	err := req.Send()
	return out, err
}

const opListPrincipalPolicies = "ListPrincipalPolicies"

// ListPrincipalPoliciesRequest generates a request for the ListPrincipalPolicies operation.
func (c *IoT) ListPrincipalPoliciesRequest(input *ListPrincipalPoliciesInput) (req *request.Request, output *ListPrincipalPoliciesOutput) {
	op := &request.Operation{
		Name:       opListPrincipalPolicies,
		HTTPMethod: "GET",
		HTTPPath:   "/principal-policies",
	}

	if input == nil {
		input = &ListPrincipalPoliciesInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ListPrincipalPoliciesOutput{}
	req.Data = output
	return
}

// Lists the policies attached to the specified principal. If you use an Amazon
// Cognito identity, the ID needs to be in Amazon Cognito Identity format (http://docs.aws.amazon.com/cognitoidentity/latest/APIReference/API_GetCredentialsForIdentity.html#API_GetCredentialsForIdentity_RequestSyntax).
func (c *IoT) ListPrincipalPolicies(input *ListPrincipalPoliciesInput) (*ListPrincipalPoliciesOutput, error) {
	req, out := c.ListPrincipalPoliciesRequest(input)
	err := req.Send()
	return out, err
}

const opListPrincipalThings = "ListPrincipalThings"

// ListPrincipalThingsRequest generates a request for the ListPrincipalThings operation.
func (c *IoT) ListPrincipalThingsRequest(input *ListPrincipalThingsInput) (req *request.Request, output *ListPrincipalThingsOutput) {
	op := &request.Operation{
		Name:       opListPrincipalThings,
		HTTPMethod: "GET",
		HTTPPath:   "/principals/things",
	}

	if input == nil {
		input = &ListPrincipalThingsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ListPrincipalThingsOutput{}
	req.Data = output
	return
}

// Lists the things associated with the specified principal.
func (c *IoT) ListPrincipalThings(input *ListPrincipalThingsInput) (*ListPrincipalThingsOutput, error) {
	req, out := c.ListPrincipalThingsRequest(input)
	err := req.Send()
	return out, err
}

const opListThingPrincipals = "ListThingPrincipals"

// ListThingPrincipalsRequest generates a request for the ListThingPrincipals operation.
func (c *IoT) ListThingPrincipalsRequest(input *ListThingPrincipalsInput) (req *request.Request, output *ListThingPrincipalsOutput) {
	op := &request.Operation{
		Name:       opListThingPrincipals,
		HTTPMethod: "GET",
		HTTPPath:   "/things/{thingName}/principals",
	}

	if input == nil {
		input = &ListThingPrincipalsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ListThingPrincipalsOutput{}
	req.Data = output
	return
}

// Lists the principals associated with the specified thing.
func (c *IoT) ListThingPrincipals(input *ListThingPrincipalsInput) (*ListThingPrincipalsOutput, error) {
	req, out := c.ListThingPrincipalsRequest(input)
	err := req.Send()
	return out, err
}

const opListThings = "ListThings"

// ListThingsRequest generates a request for the ListThings operation.
func (c *IoT) ListThingsRequest(input *ListThingsInput) (req *request.Request, output *ListThingsOutput) {
	op := &request.Operation{
		Name:       opListThings,
		HTTPMethod: "GET",
		HTTPPath:   "/things",
	}

	if input == nil {
		input = &ListThingsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ListThingsOutput{}
	req.Data = output
	return
}

// Lists your things. You can pass an AttributeName and/or AttributeValue to
// filter your things. For example: "ListThings where AttributeName=Color and
// AttributeValue=Red"
func (c *IoT) ListThings(input *ListThingsInput) (*ListThingsOutput, error) {
	req, out := c.ListThingsRequest(input)
	err := req.Send()
	return out, err
}

const opListTopicRules = "ListTopicRules"

// ListTopicRulesRequest generates a request for the ListTopicRules operation.
func (c *IoT) ListTopicRulesRequest(input *ListTopicRulesInput) (req *request.Request, output *ListTopicRulesOutput) {
	op := &request.Operation{
		Name:       opListTopicRules,
		HTTPMethod: "GET",
		HTTPPath:   "/rules",
	}

	if input == nil {
		input = &ListTopicRulesInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ListTopicRulesOutput{}
	req.Data = output
	return
}

// Lists the rules for the specific topic.
func (c *IoT) ListTopicRules(input *ListTopicRulesInput) (*ListTopicRulesOutput, error) {
	req, out := c.ListTopicRulesRequest(input)
	err := req.Send()
	return out, err
}

const opRejectCertificateTransfer = "RejectCertificateTransfer"

// RejectCertificateTransferRequest generates a request for the RejectCertificateTransfer operation.
func (c *IoT) RejectCertificateTransferRequest(input *RejectCertificateTransferInput) (req *request.Request, output *RejectCertificateTransferOutput) {
	op := &request.Operation{
		Name:       opRejectCertificateTransfer,
		HTTPMethod: "PATCH",
		HTTPPath:   "/reject-certificate-transfer/{certificateId}",
	}

	if input == nil {
		input = &RejectCertificateTransferInput{}
	}

	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(restjson.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output = &RejectCertificateTransferOutput{}
	req.Data = output
	return
}

// Rejects a pending certificate transfer. After AWS IoT rejects a certificate
// transfer, the certificate status changes from PENDING_TRANFER to INACTIVE.
//
// To check for pending certificate transfers, call ListCertificates to enumerate
// your certificates.
//
// This operation can only be called by the transfer destination. Once called,
// the certificate will be returned to the source's account in the INACTIVE
// state.
func (c *IoT) RejectCertificateTransfer(input *RejectCertificateTransferInput) (*RejectCertificateTransferOutput, error) {
	req, out := c.RejectCertificateTransferRequest(input)
	err := req.Send()
	return out, err
}

const opReplaceTopicRule = "ReplaceTopicRule"

// ReplaceTopicRuleRequest generates a request for the ReplaceTopicRule operation.
func (c *IoT) ReplaceTopicRuleRequest(input *ReplaceTopicRuleInput) (req *request.Request, output *ReplaceTopicRuleOutput) {
	op := &request.Operation{
		Name:       opReplaceTopicRule,
		HTTPMethod: "PATCH",
		HTTPPath:   "/rules/{ruleName}",
	}

	if input == nil {
		input = &ReplaceTopicRuleInput{}
	}

	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(restjson.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output = &ReplaceTopicRuleOutput{}
	req.Data = output
	return
}

// Replaces the specified rule. You must specify all parameters for the new
// rule.
func (c *IoT) ReplaceTopicRule(input *ReplaceTopicRuleInput) (*ReplaceTopicRuleOutput, error) {
	req, out := c.ReplaceTopicRuleRequest(input)
	err := req.Send()
	return out, err
}

const opSetDefaultPolicyVersion = "SetDefaultPolicyVersion"

// SetDefaultPolicyVersionRequest generates a request for the SetDefaultPolicyVersion operation.
func (c *IoT) SetDefaultPolicyVersionRequest(input *SetDefaultPolicyVersionInput) (req *request.Request, output *SetDefaultPolicyVersionOutput) {
	op := &request.Operation{
		Name:       opSetDefaultPolicyVersion,
		HTTPMethod: "PATCH",
		HTTPPath:   "/policies/{policyName}/version/{policyVersionId}",
	}

	if input == nil {
		input = &SetDefaultPolicyVersionInput{}
	}

	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(restjson.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output = &SetDefaultPolicyVersionOutput{}
	req.Data = output
	return
}

// Sets the specified version of the specified policy as the policy's default
// (operative) version. This action affects all certificates that the policy
// is attached to. To list the principals the policy is attached to, use the
// ListPrincipalPolicy API.
func (c *IoT) SetDefaultPolicyVersion(input *SetDefaultPolicyVersionInput) (*SetDefaultPolicyVersionOutput, error) {
	req, out := c.SetDefaultPolicyVersionRequest(input)
	err := req.Send()
	return out, err
}

const opSetLoggingOptions = "SetLoggingOptions"

// SetLoggingOptionsRequest generates a request for the SetLoggingOptions operation.
func (c *IoT) SetLoggingOptionsRequest(input *SetLoggingOptionsInput) (req *request.Request, output *SetLoggingOptionsOutput) {
	op := &request.Operation{
		Name:       opSetLoggingOptions,
		HTTPMethod: "POST",
		HTTPPath:   "/loggingOptions",
	}

	if input == nil {
		input = &SetLoggingOptionsInput{}
	}

	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(restjson.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output = &SetLoggingOptionsOutput{}
	req.Data = output
	return
}

// Sets the logging options.
func (c *IoT) SetLoggingOptions(input *SetLoggingOptionsInput) (*SetLoggingOptionsOutput, error) {
	req, out := c.SetLoggingOptionsRequest(input)
	err := req.Send()
	return out, err
}

const opTransferCertificate = "TransferCertificate"

// TransferCertificateRequest generates a request for the TransferCertificate operation.
func (c *IoT) TransferCertificateRequest(input *TransferCertificateInput) (req *request.Request, output *TransferCertificateOutput) {
	op := &request.Operation{
		Name:       opTransferCertificate,
		HTTPMethod: "PATCH",
		HTTPPath:   "/transfer-certificate/{certificateId}",
	}

	if input == nil {
		input = &TransferCertificateInput{}
	}

	req = c.newRequest(op, input, output)
	output = &TransferCertificateOutput{}
	req.Data = output
	return
}

// Transfers the specified certificate to the specified AWS account.
//
// You can cancel the transfer until it is acknowledged by the recipient.
//
// No notification is sent to the transfer destination's account, it is up
// to the caller to notify the transfer target.
//
// The certificate being transferred must not be in the ACTIVE state. It can
// be deactivated using the UpdateCertificate API.
//
// The certificate must not have any policies attached to it. These can be
// detached using the DetachPrincipalPolicy API.
func (c *IoT) TransferCertificate(input *TransferCertificateInput) (*TransferCertificateOutput, error) {
	req, out := c.TransferCertificateRequest(input)
	err := req.Send()
	return out, err
}

const opUpdateCertificate = "UpdateCertificate"

// UpdateCertificateRequest generates a request for the UpdateCertificate operation.
func (c *IoT) UpdateCertificateRequest(input *UpdateCertificateInput) (req *request.Request, output *UpdateCertificateOutput) {
	op := &request.Operation{
		Name:       opUpdateCertificate,
		HTTPMethod: "PUT",
		HTTPPath:   "/certificates/{certificateId}",
	}

	if input == nil {
		input = &UpdateCertificateInput{}
	}

	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(restjson.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output = &UpdateCertificateOutput{}
	req.Data = output
	return
}

// Updates the status of the specified certificate. This operation is idempotent.
//
// Moving a cert from the ACTIVE state (including REVOKED) will NOT disconnect
// currently-connected devices, although these devices will be unable to reconnect.
//
// The ACTIVE state is required to authenticate devices connecting to AWS IoT
// using a certificate.
func (c *IoT) UpdateCertificate(input *UpdateCertificateInput) (*UpdateCertificateOutput, error) {
	req, out := c.UpdateCertificateRequest(input)
	err := req.Send()
	return out, err
}

const opUpdateThing = "UpdateThing"

// UpdateThingRequest generates a request for the UpdateThing operation.
func (c *IoT) UpdateThingRequest(input *UpdateThingInput) (req *request.Request, output *UpdateThingOutput) {
	op := &request.Operation{
		Name:       opUpdateThing,
		HTTPMethod: "PATCH",
		HTTPPath:   "/things/{thingName}",
	}

	if input == nil {
		input = &UpdateThingInput{}
	}

	req = c.newRequest(op, input, output)
	output = &UpdateThingOutput{}
	req.Data = output
	return
}

// Updates the data for a thing.
func (c *IoT) UpdateThing(input *UpdateThingInput) (*UpdateThingOutput, error) {
	req, out := c.UpdateThingRequest(input)
	err := req.Send()
	return out, err
}

// The input for the AcceptCertificateTransfer operation.
type AcceptCertificateTransferInput struct {
	_ struct{} `type:"structure"`

	// The ID of the certificate.
	CertificateId *string `location:"uri" locationName:"certificateId" min:"64" type:"string" required:"true"`

	// Specifies whether the certificate is active.
	SetAsActive *bool `location:"querystring" locationName:"setAsActive" type:"boolean"`
}

// String returns the string representation
func (s AcceptCertificateTransferInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AcceptCertificateTransferInput) GoString() string {
	return s.String()
}

type AcceptCertificateTransferOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s AcceptCertificateTransferOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AcceptCertificateTransferOutput) GoString() string {
	return s.String()
}

// Describes the actions associated with a rule.
type Action struct {
	_ struct{} `type:"structure"`

	// Write to a DynamoDB table.
	DynamoDB *DynamoDBAction `locationName:"dynamoDB" type:"structure"`

	// Write to a Kinesis Firehose stream.
	Firehose *FirehoseAction `locationName:"firehose" type:"structure"`

	// Write data to a Kinesis stream.
	Kinesis *KinesisAction `locationName:"kinesis" type:"structure"`

	// Invoke a Lambda function.
	Lambda *LambdaAction `locationName:"lambda" type:"structure"`

	// Publish to another MQTT topic.
	Republish *RepublishAction `locationName:"republish" type:"structure"`

	// Write to an S3 bucket.
	S3 *S3Action `locationName:"s3" type:"structure"`

	// Publish to an SNS topic.
	Sns *SnsAction `locationName:"sns" type:"structure"`

	// Publish to an SQS queue.
	Sqs *SqsAction `locationName:"sqs" type:"structure"`
}

// String returns the string representation
func (s Action) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Action) GoString() string {
	return s.String()
}

// The input for the AttachPrincipalPolicy operation.
type AttachPrincipalPolicyInput struct {
	_ struct{} `type:"structure"`

	// The policy name.
	PolicyName *string `location:"uri" locationName:"policyName" min:"1" type:"string" required:"true"`

	// The principal which can be a certificate ARN (as returned from the CreateCertificate
	// operation) or a Cognito ID.
	Principal *string `location:"header" locationName:"x-amzn-iot-principal" type:"string" required:"true"`
}

// String returns the string representation
func (s AttachPrincipalPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AttachPrincipalPolicyInput) GoString() string {
	return s.String()
}

type AttachPrincipalPolicyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s AttachPrincipalPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AttachPrincipalPolicyOutput) GoString() string {
	return s.String()
}

// The input for the AttachThingPrincipal operation.
type AttachThingPrincipalInput struct {
	_ struct{} `type:"structure"`

	// The principal (certificate or other credential).
	Principal *string `location:"header" locationName:"x-amzn-principal" type:"string" required:"true"`

	// The name of the thing.
	ThingName *string `location:"uri" locationName:"thingName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s AttachThingPrincipalInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AttachThingPrincipalInput) GoString() string {
	return s.String()
}

// The output from the AttachThingPrincipal operation.
type AttachThingPrincipalOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s AttachThingPrincipalOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AttachThingPrincipalOutput) GoString() string {
	return s.String()
}

// The attribute payload, a JSON string containing up to three key-value pairs.
//
// For example: {\"attributes\":{\"string1\":\"string2\"}}
type AttributePayload struct {
	_ struct{} `type:"structure"`

	// A JSON string containing up to three key-value pair in JSON format.
	//
	// For example: {\"attributes\":{\"string1\":\"string2\"}}
	Attributes map[string]*string `locationName:"attributes" type:"map"`
}

// String returns the string representation
func (s AttributePayload) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AttributePayload) GoString() string {
	return s.String()
}

// The input for the CancelCertificateTransfer operation.
type CancelCertificateTransferInput struct {
	_ struct{} `type:"structure"`

	// The ID of the certificate.
	CertificateId *string `location:"uri" locationName:"certificateId" min:"64" type:"string" required:"true"`
}

// String returns the string representation
func (s CancelCertificateTransferInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CancelCertificateTransferInput) GoString() string {
	return s.String()
}

type CancelCertificateTransferOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s CancelCertificateTransferOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CancelCertificateTransferOutput) GoString() string {
	return s.String()
}

// Information about a certificate.
type Certificate struct {
	_ struct{} `type:"structure"`

	// The ARN of the certificate.
	CertificateArn *string `locationName:"certificateArn" type:"string"`

	// The ID of the certificate.
	CertificateId *string `locationName:"certificateId" min:"64" type:"string"`

	// The date and time the certificate was created.
	CreationDate *time.Time `locationName:"creationDate" type:"timestamp" timestampFormat:"unix"`

	// The status of the certificate.
	Status *string `locationName:"status" type:"string" enum:"CertificateStatus"`
}

// String returns the string representation
func (s Certificate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Certificate) GoString() string {
	return s.String()
}

// Describes a certificate.
type CertificateDescription struct {
	_ struct{} `type:"structure"`

	// The ARN of the certificate.
	CertificateArn *string `locationName:"certificateArn" type:"string"`

	// The ID of the certificate.
	CertificateId *string `locationName:"certificateId" min:"64" type:"string"`

	// The certificate data, in PEM format.
	CertificatePem *string `locationName:"certificatePem" min:"1" type:"string"`

	// The date and time the certificate was created.
	CreationDate *time.Time `locationName:"creationDate" type:"timestamp" timestampFormat:"unix"`

	// The date and time the certificate was last modified.
	LastModifiedDate *time.Time `locationName:"lastModifiedDate" type:"timestamp" timestampFormat:"unix"`

	// The ID of the AWS account that owns the certificate.
	OwnedBy *string `locationName:"ownedBy" type:"string"`

	// The status of the certificate.
	Status *string `locationName:"status" type:"string" enum:"CertificateStatus"`
}

// String returns the string representation
func (s CertificateDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CertificateDescription) GoString() string {
	return s.String()
}

// The input for the CreateCertificateFromCsr operation.
type CreateCertificateFromCsrInput struct {
	_ struct{} `type:"structure"`

	// The certificate signing request (CSR).
	CertificateSigningRequest *string `locationName:"certificateSigningRequest" min:"1" type:"string" required:"true"`

	// Specifies whether the certificate is active.
	SetAsActive *bool `location:"querystring" locationName:"setAsActive" type:"boolean"`
}

// String returns the string representation
func (s CreateCertificateFromCsrInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateCertificateFromCsrInput) GoString() string {
	return s.String()
}

// The output from the CreateCertificateFromCsr operation.
type CreateCertificateFromCsrOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the certificate. You can use the ARN as
	// a principal for policy operations.
	CertificateArn *string `locationName:"certificateArn" type:"string"`

	// The ID of the certificate. Certificate management operations only take a
	// certificateId.
	CertificateId *string `locationName:"certificateId" min:"64" type:"string"`

	// The certificate data, in PEM format.
	CertificatePem *string `locationName:"certificatePem" min:"1" type:"string"`
}

// String returns the string representation
func (s CreateCertificateFromCsrOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateCertificateFromCsrOutput) GoString() string {
	return s.String()
}

// The input for the CreateKeysAndCertificate operation.
type CreateKeysAndCertificateInput struct {
	_ struct{} `type:"structure"`

	// Specifies whether the certificate is active.
	SetAsActive *bool `location:"querystring" locationName:"setAsActive" type:"boolean"`
}

// String returns the string representation
func (s CreateKeysAndCertificateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateKeysAndCertificateInput) GoString() string {
	return s.String()
}

// The output of the CreateKeysAndCertificate operation.
type CreateKeysAndCertificateOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the certificate.
	CertificateArn *string `locationName:"certificateArn" type:"string"`

	// The ID of the certificate. AWS IoT issues a default subject name for the
	// certificate (e.g., AWS IoT Certificate).
	CertificateId *string `locationName:"certificateId" min:"64" type:"string"`

	// The certificate data, in PEM format.
	CertificatePem *string `locationName:"certificatePem" min:"1" type:"string"`

	// The generated key pair.
	KeyPair *KeyPair `locationName:"keyPair" type:"structure"`
}

// String returns the string representation
func (s CreateKeysAndCertificateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateKeysAndCertificateOutput) GoString() string {
	return s.String()
}

// The input for the CreatePolicy operation.
type CreatePolicyInput struct {
	_ struct{} `type:"structure"`

	// The JSON document that describes the policy. The length of the policyDocument
	// must be a minimum length of 1, with a maximum length of 2048, excluding whitespace.
	PolicyDocument *string `locationName:"policyDocument" type:"string" required:"true"`

	// The policy name.
	PolicyName *string `location:"uri" locationName:"policyName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CreatePolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreatePolicyInput) GoString() string {
	return s.String()
}

// The output from the CreatePolicy operation.
type CreatePolicyOutput struct {
	_ struct{} `type:"structure"`

	// The policy ARN.
	PolicyArn *string `locationName:"policyArn" type:"string"`

	// The JSON document that describes the policy.
	PolicyDocument *string `locationName:"policyDocument" type:"string"`

	// The policy name.
	PolicyName *string `locationName:"policyName" min:"1" type:"string"`

	// The policy version ID.
	PolicyVersionId *string `locationName:"policyVersionId" type:"string"`
}

// String returns the string representation
func (s CreatePolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreatePolicyOutput) GoString() string {
	return s.String()
}

// The input for the CreatePolicyVersion operation.
type CreatePolicyVersionInput struct {
	_ struct{} `type:"structure"`

	// The JSON document that describes the policy. Minimum length of 1. Maximum
	// length of 2048 excluding whitespaces
	PolicyDocument *string `locationName:"policyDocument" type:"string" required:"true"`

	// The policy name.
	PolicyName *string `location:"uri" locationName:"policyName" min:"1" type:"string" required:"true"`

	// Specifies whether the policy version is set as the default. When this parameter
	// is true, the new policy version becomes the operative version; that is, the
	// version that is in effect for the certificates that the policy is attached
	// to.
	SetAsDefault *bool `location:"querystring" locationName:"setAsDefault" type:"boolean"`
}

// String returns the string representation
func (s CreatePolicyVersionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreatePolicyVersionInput) GoString() string {
	return s.String()
}

// The output of the CreatePolicyVersion operation.
type CreatePolicyVersionOutput struct {
	_ struct{} `type:"structure"`

	// Specifies whether the policy version is the default.
	IsDefaultVersion *bool `locationName:"isDefaultVersion" type:"boolean"`

	// The policy ARN.
	PolicyArn *string `locationName:"policyArn" type:"string"`

	// The JSON document that describes the policy.
	PolicyDocument *string `locationName:"policyDocument" type:"string"`

	// The policy version ID.
	PolicyVersionId *string `locationName:"policyVersionId" type:"string"`
}

// String returns the string representation
func (s CreatePolicyVersionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreatePolicyVersionOutput) GoString() string {
	return s.String()
}

// The input for the CreateThing operation.
type CreateThingInput struct {
	_ struct{} `type:"structure"`

	// The attribute payload. Which consists of up to 3 name/value pairs in a JSON
	// document. For example: {\"attributes\":{\"string1\":\"string2\"}}
	AttributePayload *AttributePayload `locationName:"attributePayload" type:"structure"`

	// The name of the thing.
	ThingName *string `location:"uri" locationName:"thingName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateThingInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateThingInput) GoString() string {
	return s.String()
}

// The output of the CreateThing operation.
type CreateThingOutput struct {
	_ struct{} `type:"structure"`

	// The thing ARN.
	ThingArn *string `locationName:"thingArn" type:"string"`

	// The name of the thing.
	ThingName *string `locationName:"thingName" min:"1" type:"string"`
}

// String returns the string representation
func (s CreateThingOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateThingOutput) GoString() string {
	return s.String()
}

// The input for the CreateTopicRule operation.
type CreateTopicRuleInput struct {
	_ struct{} `type:"structure" payload:"TopicRulePayload"`

	// The name of the rule.
	RuleName *string `location:"uri" locationName:"ruleName" min:"1" type:"string" required:"true"`

	// The rule payload.
	TopicRulePayload *TopicRulePayload `locationName:"topicRulePayload" type:"structure" required:"true"`
}

// String returns the string representation
func (s CreateTopicRuleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateTopicRuleInput) GoString() string {
	return s.String()
}

type CreateTopicRuleOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s CreateTopicRuleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateTopicRuleOutput) GoString() string {
	return s.String()
}

// The input for the DeleteCertificate operation.
type DeleteCertificateInput struct {
	_ struct{} `type:"structure"`

	// The ID of the certificate.
	CertificateId *string `location:"uri" locationName:"certificateId" min:"64" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteCertificateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteCertificateInput) GoString() string {
	return s.String()
}

type DeleteCertificateOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteCertificateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteCertificateOutput) GoString() string {
	return s.String()
}

// The input for the DeletePolicy operation.
type DeletePolicyInput struct {
	_ struct{} `type:"structure"`

	// The name of the policy to delete.
	PolicyName *string `location:"uri" locationName:"policyName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeletePolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeletePolicyInput) GoString() string {
	return s.String()
}

type DeletePolicyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeletePolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeletePolicyOutput) GoString() string {
	return s.String()
}

// The input for the DeletePolicyVersion operation.
type DeletePolicyVersionInput struct {
	_ struct{} `type:"structure"`

	// The name of the policy.
	PolicyName *string `location:"uri" locationName:"policyName" min:"1" type:"string" required:"true"`

	// The policy version ID.
	PolicyVersionId *string `location:"uri" locationName:"policyVersionId" type:"string" required:"true"`
}

// String returns the string representation
func (s DeletePolicyVersionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeletePolicyVersionInput) GoString() string {
	return s.String()
}

type DeletePolicyVersionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeletePolicyVersionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeletePolicyVersionOutput) GoString() string {
	return s.String()
}

// The input for the DeleteThing operation.
type DeleteThingInput struct {
	_ struct{} `type:"structure"`

	// The thing name.
	ThingName *string `location:"uri" locationName:"thingName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteThingInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteThingInput) GoString() string {
	return s.String()
}

// The output of the DeleteThing operation.
type DeleteThingOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteThingOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteThingOutput) GoString() string {
	return s.String()
}

// The input for the DeleteTopicRule operation.
type DeleteTopicRuleInput struct {
	_ struct{} `type:"structure"`

	// The name of the rule.
	RuleName *string `location:"uri" locationName:"ruleName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteTopicRuleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteTopicRuleInput) GoString() string {
	return s.String()
}

type DeleteTopicRuleOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteTopicRuleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteTopicRuleOutput) GoString() string {
	return s.String()
}

// The input for the DescribeCertificate operation.
type DescribeCertificateInput struct {
	_ struct{} `type:"structure"`

	// The ID of the certificate.
	CertificateId *string `location:"uri" locationName:"certificateId" min:"64" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeCertificateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeCertificateInput) GoString() string {
	return s.String()
}

// The output of the DescribeCertificate operation.
type DescribeCertificateOutput struct {
	_ struct{} `type:"structure"`

	// The description of the certificate.
	CertificateDescription *CertificateDescription `locationName:"certificateDescription" type:"structure"`
}

// String returns the string representation
func (s DescribeCertificateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeCertificateOutput) GoString() string {
	return s.String()
}

// The input for the DescribeEndpoint operation.
type DescribeEndpointInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DescribeEndpointInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeEndpointInput) GoString() string {
	return s.String()
}

// The output from the DescribeEndpoint operation.
type DescribeEndpointOutput struct {
	_ struct{} `type:"structure"`

	// The endpoint. The format of the endpoint is as follows: identifier.iot.region.amazonaws.com.
	EndpointAddress *string `locationName:"endpointAddress" type:"string"`
}

// String returns the string representation
func (s DescribeEndpointOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeEndpointOutput) GoString() string {
	return s.String()
}

// The input for the DescribeThing operation.
type DescribeThingInput struct {
	_ struct{} `type:"structure"`

	// The name of the thing.
	ThingName *string `location:"uri" locationName:"thingName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeThingInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeThingInput) GoString() string {
	return s.String()
}

// The output from the DescribeThing operation.
type DescribeThingOutput struct {
	_ struct{} `type:"structure"`

	// The attributes which are name/value pairs in JSON format. For example:
	//
	// {\"attributes\":{\"some-name1\":\"some-value1\"}, {\"some-name2\":\"some-value2\"},
	// {\"some-name3\":\"some-value3\"}}
	Attributes map[string]*string `locationName:"attributes" type:"map"`

	// The default client ID.
	DefaultClientId *string `locationName:"defaultClientId" type:"string"`

	// The name of the thing.
	ThingName *string `locationName:"thingName" min:"1" type:"string"`
}

// String returns the string representation
func (s DescribeThingOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeThingOutput) GoString() string {
	return s.String()
}

// The input for the DetachPrincipalPolicy operation.
type DetachPrincipalPolicyInput struct {
	_ struct{} `type:"structure"`

	// The name of the policy to detach.
	PolicyName *string `location:"uri" locationName:"policyName" min:"1" type:"string" required:"true"`

	// The principal
	//
	// If the principal is a certificate, specify the certificate ARN. If the principal
	// is a Cognito identity specify the identity ID.
	Principal *string `location:"header" locationName:"x-amzn-iot-principal" type:"string" required:"true"`
}

// String returns the string representation
func (s DetachPrincipalPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DetachPrincipalPolicyInput) GoString() string {
	return s.String()
}

type DetachPrincipalPolicyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DetachPrincipalPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DetachPrincipalPolicyOutput) GoString() string {
	return s.String()
}

// The input for the DetachThingPrincipal operation.
type DetachThingPrincipalInput struct {
	_ struct{} `type:"structure"`

	// The principal.
	Principal *string `location:"header" locationName:"x-amzn-principal" type:"string" required:"true"`

	// The name of the thing.
	ThingName *string `location:"uri" locationName:"thingName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DetachThingPrincipalInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DetachThingPrincipalInput) GoString() string {
	return s.String()
}

// The output from the DetachThingPrincipal operation.
type DetachThingPrincipalOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DetachThingPrincipalOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DetachThingPrincipalOutput) GoString() string {
	return s.String()
}

// The input for the DisableTopicRuleRequest operation.
type DisableTopicRuleInput struct {
	_ struct{} `type:"structure"`

	// The name of the rule to disable.
	RuleName *string `location:"uri" locationName:"ruleName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DisableTopicRuleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisableTopicRuleInput) GoString() string {
	return s.String()
}

type DisableTopicRuleOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DisableTopicRuleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisableTopicRuleOutput) GoString() string {
	return s.String()
}

// Describes an action to write to a DynamoDB table.
//
// The tableName, hashKeyField, and rangeKeyField values must match the values
// used when you created the table.
//
// The hashKeyValue and rangeKeyvalue fields use a substitution template syntax.
// These templates provide data at runtime. The syntax is as follows: ${sql-expression}.
//
// You can specify any expression that's valid in a WHERE or SELECT clause,
// including JSON properties, comparisons, calculations, and functions. For
// example, the following field uses the third level of the topic:
//
// "hashKeyValue": "${topic(3)}"
//
// The following field uses the timestamp:
//
// "rangeKeyValue": "${timestamp()}"
type DynamoDBAction struct {
	_ struct{} `type:"structure"`

	// The hash key name.
	HashKeyField *string `locationName:"hashKeyField" type:"string" required:"true"`

	// The hash key value.
	HashKeyValue *string `locationName:"hashKeyValue" type:"string" required:"true"`

	// The action payload, this name can be customized.
	PayloadField *string `locationName:"payloadField" type:"string"`

	// The range key name.
	RangeKeyField *string `locationName:"rangeKeyField" type:"string" required:"true"`

	// The range key value.
	RangeKeyValue *string `locationName:"rangeKeyValue" type:"string" required:"true"`

	// The ARN of the IAM role that grants access to the DynamoDB table.
	RoleArn *string `locationName:"roleArn" type:"string" required:"true"`

	// The name of the DynamoDB table.
	TableName *string `locationName:"tableName" type:"string" required:"true"`
}

// String returns the string representation
func (s DynamoDBAction) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DynamoDBAction) GoString() string {
	return s.String()
}

// The input for the EnableTopicRuleRequest operation.
type EnableTopicRuleInput struct {
	_ struct{} `type:"structure"`

	// The name of the topic rule to enable.
	RuleName *string `location:"uri" locationName:"ruleName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s EnableTopicRuleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EnableTopicRuleInput) GoString() string {
	return s.String()
}

type EnableTopicRuleOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s EnableTopicRuleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EnableTopicRuleOutput) GoString() string {
	return s.String()
}

// Describes an action that writes data to a Kinesis Firehose stream.
type FirehoseAction struct {
	_ struct{} `type:"structure"`

	// The delivery stream name.
	DeliveryStreamName *string `locationName:"deliveryStreamName" type:"string" required:"true"`

	// The IAM role that grants access to the firehose stream.
	RoleArn *string `locationName:"roleArn" type:"string" required:"true"`
}

// String returns the string representation
func (s FirehoseAction) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s FirehoseAction) GoString() string {
	return s.String()
}

// The input for the GetLoggingOptions operation.
type GetLoggingOptionsInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s GetLoggingOptionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetLoggingOptionsInput) GoString() string {
	return s.String()
}

// The output from the GetLoggingOptions operation.
type GetLoggingOptionsOutput struct {
	_ struct{} `type:"structure"`

	// The logging level.
	LogLevel *string `locationName:"logLevel" type:"string" enum:"LogLevel"`

	// The ARN of the IAM role that grants access.
	RoleArn *string `locationName:"roleArn" type:"string"`
}

// String returns the string representation
func (s GetLoggingOptionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetLoggingOptionsOutput) GoString() string {
	return s.String()
}

// The input for the GetPolicy operation.
type GetPolicyInput struct {
	_ struct{} `type:"structure"`

	// The name of the policy.
	PolicyName *string `location:"uri" locationName:"policyName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetPolicyInput) GoString() string {
	return s.String()
}

// The output from the GetPolicy operation.
type GetPolicyOutput struct {
	_ struct{} `type:"structure"`

	// The default policy version ID.
	DefaultVersionId *string `locationName:"defaultVersionId" type:"string"`

	// The policy ARN.
	PolicyArn *string `locationName:"policyArn" type:"string"`

	// The JSON document that describes the policy.
	PolicyDocument *string `locationName:"policyDocument" type:"string"`

	// The policy name.
	PolicyName *string `locationName:"policyName" min:"1" type:"string"`
}

// String returns the string representation
func (s GetPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetPolicyOutput) GoString() string {
	return s.String()
}

// The input for the GetPolicyVersion operation.
type GetPolicyVersionInput struct {
	_ struct{} `type:"structure"`

	// The name of the policy.
	PolicyName *string `location:"uri" locationName:"policyName" min:"1" type:"string" required:"true"`

	// The policy version ID.
	PolicyVersionId *string `location:"uri" locationName:"policyVersionId" type:"string" required:"true"`
}

// String returns the string representation
func (s GetPolicyVersionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetPolicyVersionInput) GoString() string {
	return s.String()
}

// The output from the GetPolicyVersion operation.
type GetPolicyVersionOutput struct {
	_ struct{} `type:"structure"`

	// Specifies whether the policy version is the default.
	IsDefaultVersion *bool `locationName:"isDefaultVersion" type:"boolean"`

	// The policy ARN.
	PolicyArn *string `locationName:"policyArn" type:"string"`

	// The JSON document that describes the policy.
	PolicyDocument *string `locationName:"policyDocument" type:"string"`

	// The policy name.
	PolicyName *string `locationName:"policyName" min:"1" type:"string"`

	// The policy version ID.
	PolicyVersionId *string `locationName:"policyVersionId" type:"string"`
}

// String returns the string representation
func (s GetPolicyVersionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetPolicyVersionOutput) GoString() string {
	return s.String()
}

// The input for the GetTopicRule operation.
type GetTopicRuleInput struct {
	_ struct{} `type:"structure"`

	// The name of the rule.
	RuleName *string `location:"uri" locationName:"ruleName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetTopicRuleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetTopicRuleInput) GoString() string {
	return s.String()
}

// The output from the GetTopicRule operation.
type GetTopicRuleOutput struct {
	_ struct{} `type:"structure"`

	// The rule.
	Rule *TopicRule `locationName:"rule" type:"structure"`

	// The rule ARN.
	RuleArn *string `locationName:"ruleArn" type:"string"`
}

// String returns the string representation
func (s GetTopicRuleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetTopicRuleOutput) GoString() string {
	return s.String()
}

// Describes a key pair.
type KeyPair struct {
	_ struct{} `type:"structure"`

	// The private key.
	PrivateKey *string `min:"1" type:"string"`

	// The public key.
	PublicKey *string `min:"1" type:"string"`
}

// String returns the string representation
func (s KeyPair) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s KeyPair) GoString() string {
	return s.String()
}

// Describes an action to write data to an Amazon Kinesis stream.
type KinesisAction struct {
	_ struct{} `type:"structure"`

	// The partition key.
	PartitionKey *string `locationName:"partitionKey" type:"string"`

	// The ARN of the IAM role that grants access to the Kinesis stream.
	RoleArn *string `locationName:"roleArn" type:"string" required:"true"`

	// The name of the Kinesis stream.
	StreamName *string `locationName:"streamName" type:"string" required:"true"`
}

// String returns the string representation
func (s KinesisAction) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s KinesisAction) GoString() string {
	return s.String()
}

// Describes an action to invoke a Lamdba function.
type LambdaAction struct {
	_ struct{} `type:"structure"`

	// The ARN of the Lambda function.
	FunctionArn *string `locationName:"functionArn" type:"string" required:"true"`
}

// String returns the string representation
func (s LambdaAction) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LambdaAction) GoString() string {
	return s.String()
}

// The input for the ListCertificates operation.
type ListCertificatesInput struct {
	_ struct{} `type:"structure"`

	// Specifies the order for results. If True, the results are returned in ascending
	// order, based on the creation date.
	AscendingOrder *bool `location:"querystring" locationName:"isAscendingOrder" type:"boolean"`

	// The marker for the next set of results.
	Marker *string `location:"querystring" locationName:"marker" type:"string"`

	// The result page size.
	PageSize *int64 `location:"querystring" locationName:"pageSize" min:"1" type:"integer"`
}

// String returns the string representation
func (s ListCertificatesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListCertificatesInput) GoString() string {
	return s.String()
}

// The output of the ListCertificates operation.
type ListCertificatesOutput struct {
	_ struct{} `type:"structure"`

	// The descriptions of the certificates.
	Certificates []*Certificate `locationName:"certificates" type:"list"`

	// The marker for the next set of results, or null if there are no additional
	// results.
	NextMarker *string `locationName:"nextMarker" type:"string"`
}

// String returns the string representation
func (s ListCertificatesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListCertificatesOutput) GoString() string {
	return s.String()
}

// The input for the ListPolicies operation.
type ListPoliciesInput struct {
	_ struct{} `type:"structure"`

	// Specifies the order for results. If true, the results are returned in ascending
	// creation order.
	AscendingOrder *bool `location:"querystring" locationName:"isAscendingOrder" type:"boolean"`

	// The marker for the next set of results.
	Marker *string `location:"querystring" locationName:"marker" type:"string"`

	// The result page size.
	PageSize *int64 `location:"querystring" locationName:"pageSize" min:"1" type:"integer"`
}

// String returns the string representation
func (s ListPoliciesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListPoliciesInput) GoString() string {
	return s.String()
}

// The output from the ListPolicies operation.
type ListPoliciesOutput struct {
	_ struct{} `type:"structure"`

	// The marker for the next set of results, or null if there are no additional
	// results.
	NextMarker *string `locationName:"nextMarker" type:"string"`

	// The descriptions of the policies.
	Policies []*Policy `locationName:"policies" type:"list"`
}

// String returns the string representation
func (s ListPoliciesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListPoliciesOutput) GoString() string {
	return s.String()
}

// The input for the ListPolicyVersions operation.
type ListPolicyVersionsInput struct {
	_ struct{} `type:"structure"`

	// The policy name.
	PolicyName *string `location:"uri" locationName:"policyName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ListPolicyVersionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListPolicyVersionsInput) GoString() string {
	return s.String()
}

// The output from the ListPolicyVersions operation.
type ListPolicyVersionsOutput struct {
	_ struct{} `type:"structure"`

	// The policy versions.
	PolicyVersions []*PolicyVersion `locationName:"policyVersions" type:"list"`
}

// String returns the string representation
func (s ListPolicyVersionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListPolicyVersionsOutput) GoString() string {
	return s.String()
}

// The input for the ListPrincipalPolicies operation.
type ListPrincipalPoliciesInput struct {
	_ struct{} `type:"structure"`

	// Specifies the order for results. If true, results are returned in ascending
	// creation order.
	AscendingOrder *bool `location:"querystring" locationName:"isAscendingOrder" type:"boolean"`

	// The marker for the next set of results.
	Marker *string `location:"querystring" locationName:"marker" type:"string"`

	// The result page size.
	PageSize *int64 `location:"querystring" locationName:"pageSize" min:"1" type:"integer"`

	// The principal.
	Principal *string `location:"header" locationName:"x-amzn-iot-principal" type:"string" required:"true"`
}

// String returns the string representation
func (s ListPrincipalPoliciesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListPrincipalPoliciesInput) GoString() string {
	return s.String()
}

// The output from the ListPrincipalPolicies operation.
type ListPrincipalPoliciesOutput struct {
	_ struct{} `type:"structure"`

	// The marker for the next set of results, or null if there are no additional
	// results.
	NextMarker *string `locationName:"nextMarker" type:"string"`

	// The policies.
	Policies []*Policy `locationName:"policies" type:"list"`
}

// String returns the string representation
func (s ListPrincipalPoliciesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListPrincipalPoliciesOutput) GoString() string {
	return s.String()
}

// The input for the ListPrincipalThings operation.
type ListPrincipalThingsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of principals to return.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// A token used to retrieve the next value.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`

	// The principal.
	Principal *string `location:"header" locationName:"x-amzn-principal" type:"string" required:"true"`
}

// String returns the string representation
func (s ListPrincipalThingsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListPrincipalThingsInput) GoString() string {
	return s.String()
}

// The output from the ListPrincipalThings operation.
type ListPrincipalThingsOutput struct {
	_ struct{} `type:"structure"`

	// A token used to retrieve the next value.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The things.
	Things []*string `locationName:"things" type:"list"`
}

// String returns the string representation
func (s ListPrincipalThingsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListPrincipalThingsOutput) GoString() string {
	return s.String()
}

// The input for the ListThingPrincipal operation.
type ListThingPrincipalsInput struct {
	_ struct{} `type:"structure"`

	// The name of the thing.
	ThingName *string `location:"uri" locationName:"thingName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ListThingPrincipalsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListThingPrincipalsInput) GoString() string {
	return s.String()
}

// The output from the ListThingPrincipals operation.
type ListThingPrincipalsOutput struct {
	_ struct{} `type:"structure"`

	// The principals.
	Principals []*string `locationName:"principals" type:"list"`
}

// String returns the string representation
func (s ListThingPrincipalsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListThingPrincipalsOutput) GoString() string {
	return s.String()
}

// The input for the ListThings operation.
type ListThingsInput struct {
	_ struct{} `type:"structure"`

	// The attribute name.
	AttributeName *string `location:"querystring" locationName:"attributeName" type:"string"`

	// The attribute value.
	AttributeValue *string `location:"querystring" locationName:"attributeValue" type:"string"`

	// The maximum number of results.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The token for the next value.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListThingsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListThingsInput) GoString() string {
	return s.String()
}

// The output from the ListThings operation.
type ListThingsOutput struct {
	_ struct{} `type:"structure"`

	// A token used to retrieve the next value.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The things.
	Things []*ThingAttribute `locationName:"things" type:"list"`
}

// String returns the string representation
func (s ListThingsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListThingsOutput) GoString() string {
	return s.String()
}

// The input for the ListTopicRules operation.
type ListTopicRulesInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results to return.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// A token used to retrieve the next value.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`

	// Specifies whether the rule is disabled.
	RuleDisabled *bool `location:"querystring" locationName:"ruleDisabled" type:"boolean"`

	// The topic.
	Topic *string `location:"querystring" locationName:"topic" type:"string"`
}

// String returns the string representation
func (s ListTopicRulesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTopicRulesInput) GoString() string {
	return s.String()
}

// The output from the ListTopicRules operation.
type ListTopicRulesOutput struct {
	_ struct{} `type:"structure"`

	// A token used to retrieve the next value.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The rules.
	Rules []*TopicRuleListItem `locationName:"rules" type:"list"`
}

// String returns the string representation
func (s ListTopicRulesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTopicRulesOutput) GoString() string {
	return s.String()
}

// Describes the logging options payload.
type LoggingOptionsPayload struct {
	_ struct{} `type:"structure"`

	// The logging level.
	LogLevel *string `locationName:"logLevel" type:"string" enum:"LogLevel"`

	// The ARN of the IAM role that grants access.
	RoleArn *string `locationName:"roleArn" type:"string" required:"true"`
}

// String returns the string representation
func (s LoggingOptionsPayload) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LoggingOptionsPayload) GoString() string {
	return s.String()
}

// Describes an AWS IoT policy.
type Policy struct {
	_ struct{} `type:"structure"`

	// The policy ARN.
	PolicyArn *string `locationName:"policyArn" type:"string"`

	// The policy name.
	PolicyName *string `locationName:"policyName" min:"1" type:"string"`
}

// String returns the string representation
func (s Policy) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Policy) GoString() string {
	return s.String()
}

// Describes a policy version.
type PolicyVersion struct {
	_ struct{} `type:"structure"`

	// The date and time the policy was created.
	CreateDate *time.Time `locationName:"createDate" type:"timestamp" timestampFormat:"unix"`

	// Specifies whether the policy version is the default.
	IsDefaultVersion *bool `locationName:"isDefaultVersion" type:"boolean"`

	// The policy version ID.
	VersionId *string `locationName:"versionId" type:"string"`
}

// String returns the string representation
func (s PolicyVersion) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PolicyVersion) GoString() string {
	return s.String()
}

// The input for the RejectCertificateTransfer operation.
type RejectCertificateTransferInput struct {
	_ struct{} `type:"structure"`

	// The ID of the certificate.
	CertificateId *string `location:"uri" locationName:"certificateId" min:"64" type:"string" required:"true"`
}

// String returns the string representation
func (s RejectCertificateTransferInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RejectCertificateTransferInput) GoString() string {
	return s.String()
}

type RejectCertificateTransferOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s RejectCertificateTransferOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RejectCertificateTransferOutput) GoString() string {
	return s.String()
}

// The input for the ReplaceTopicRule operation.
type ReplaceTopicRuleInput struct {
	_ struct{} `type:"structure" payload:"TopicRulePayload"`

	// The name of the rule.
	RuleName *string `location:"uri" locationName:"ruleName" min:"1" type:"string" required:"true"`

	// The rule payload.
	TopicRulePayload *TopicRulePayload `locationName:"topicRulePayload" type:"structure" required:"true"`
}

// String returns the string representation
func (s ReplaceTopicRuleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ReplaceTopicRuleInput) GoString() string {
	return s.String()
}

type ReplaceTopicRuleOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s ReplaceTopicRuleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ReplaceTopicRuleOutput) GoString() string {
	return s.String()
}

// Describes an action to republish to another topic.
type RepublishAction struct {
	_ struct{} `type:"structure"`

	// The ARN of the IAM role that grants access.
	RoleArn *string `locationName:"roleArn" type:"string" required:"true"`

	// The name of the MQTT topic.
	Topic *string `locationName:"topic" type:"string" required:"true"`
}

// String returns the string representation
func (s RepublishAction) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RepublishAction) GoString() string {
	return s.String()
}

// Describes an action to write data to an Amazon S3 bucket.
type S3Action struct {
	_ struct{} `type:"structure"`

	// The S3 bucket.
	BucketName *string `locationName:"bucketName" type:"string" required:"true"`

	// The object key.
	Key *string `locationName:"key" type:"string" required:"true"`

	// The ARN of the IAM role that grants access.
	RoleArn *string `locationName:"roleArn" type:"string" required:"true"`
}

// String returns the string representation
func (s S3Action) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s S3Action) GoString() string {
	return s.String()
}

// The input for the SetDefaultPolicyVersion operation.
type SetDefaultPolicyVersionInput struct {
	_ struct{} `type:"structure"`

	// The policy name.
	PolicyName *string `location:"uri" locationName:"policyName" min:"1" type:"string" required:"true"`

	// The policy version ID.
	PolicyVersionId *string `location:"uri" locationName:"policyVersionId" type:"string" required:"true"`
}

// String returns the string representation
func (s SetDefaultPolicyVersionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SetDefaultPolicyVersionInput) GoString() string {
	return s.String()
}

type SetDefaultPolicyVersionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s SetDefaultPolicyVersionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SetDefaultPolicyVersionOutput) GoString() string {
	return s.String()
}

// The input for the SetLoggingOptions operation.
type SetLoggingOptionsInput struct {
	_ struct{} `type:"structure" payload:"LoggingOptionsPayload"`

	// The logging options payload.
	LoggingOptionsPayload *LoggingOptionsPayload `locationName:"loggingOptionsPayload" type:"structure" required:"true"`
}

// String returns the string representation
func (s SetLoggingOptionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SetLoggingOptionsInput) GoString() string {
	return s.String()
}

type SetLoggingOptionsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s SetLoggingOptionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SetLoggingOptionsOutput) GoString() string {
	return s.String()
}

// Describes an action to publish to an Amazon SNS topic.
type SnsAction struct {
	_ struct{} `type:"structure"`

	// The ARN of the IAM role that grants access.
	RoleArn *string `locationName:"roleArn" type:"string" required:"true"`

	// The ARN of the SNS topic.
	TargetArn *string `locationName:"targetArn" type:"string" required:"true"`
}

// String returns the string representation
func (s SnsAction) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SnsAction) GoString() string {
	return s.String()
}

// Describes an action to publish data to an SQS queue.
type SqsAction struct {
	_ struct{} `type:"structure"`

	// The URL of the Amazon SQS queue.
	QueueUrl *string `locationName:"queueUrl" type:"string" required:"true"`

	// The ARN of the IAM role that grants access.
	RoleArn *string `locationName:"roleArn" type:"string" required:"true"`

	// Specifies whether to use Base64 encoding.
	UseBase64 *bool `locationName:"useBase64" type:"boolean"`
}

// String returns the string representation
func (s SqsAction) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SqsAction) GoString() string {
	return s.String()
}

// Describes a thing attribute.
type ThingAttribute struct {
	_ struct{} `type:"structure"`

	// The attributes.
	Attributes map[string]*string `locationName:"attributes" type:"map"`

	// The name of the thing.
	ThingName *string `locationName:"thingName" min:"1" type:"string"`
}

// String returns the string representation
func (s ThingAttribute) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ThingAttribute) GoString() string {
	return s.String()
}

// Describes a rule.
type TopicRule struct {
	_ struct{} `type:"structure"`

	// The actions associated with the rule.
	Actions []*Action `locationName:"actions" type:"list"`

	// The date and time the rule was created.
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" timestampFormat:"unix"`

	// The description of the rule.
	Description *string `locationName:"description" type:"string"`

	// Specifies whether the rule is disabled.
	RuleDisabled *bool `locationName:"ruleDisabled" type:"boolean"`

	// The name of the rule.
	RuleName *string `locationName:"ruleName" min:"1" type:"string"`

	// The SQL statement used to query the topic. When using a SQL query with multiple
	// lines, be sure to escape the newline characters properly.
	Sql *string `locationName:"sql" type:"string"`
}

// String returns the string representation
func (s TopicRule) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TopicRule) GoString() string {
	return s.String()
}

// Describes a rule.
type TopicRuleListItem struct {
	_ struct{} `type:"structure"`

	// The date and time the rule was created.
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" timestampFormat:"unix"`

	// The rule ARN.
	RuleArn *string `locationName:"ruleArn" type:"string"`

	// Specifies whether the rule is disabled.
	RuleDisabled *bool `locationName:"ruleDisabled" type:"boolean"`

	// The name of the rule.
	RuleName *string `locationName:"ruleName" min:"1" type:"string"`

	// The pattern for the topic names that apply.
	TopicPattern *string `locationName:"topicPattern" type:"string"`
}

// String returns the string representation
func (s TopicRuleListItem) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TopicRuleListItem) GoString() string {
	return s.String()
}

// Describes a rule.
type TopicRulePayload struct {
	_ struct{} `type:"structure"`

	// The actions associated with the rule.
	Actions []*Action `locationName:"actions" type:"list" required:"true"`

	// The description of the rule.
	Description *string `locationName:"description" type:"string"`

	// Specifies whether the rule is disabled.
	RuleDisabled *bool `locationName:"ruleDisabled" type:"boolean"`

	// The SQL statement used to query the topic. For more information, see AWS
	// IoT SQL Reference (http://docs.aws.amazon.com/iot/latest/developerguide/iot-rules.html#aws-iot-sql-reference)
	// in the AWS IoT Developer Guide.
	Sql *string `locationName:"sql" type:"string" required:"true"`
}

// String returns the string representation
func (s TopicRulePayload) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TopicRulePayload) GoString() string {
	return s.String()
}

// The input for the TransferCertificate operation.
type TransferCertificateInput struct {
	_ struct{} `type:"structure"`

	// The ID of the certificate.
	CertificateId *string `location:"uri" locationName:"certificateId" min:"64" type:"string" required:"true"`

	// The AWS account.
	TargetAwsAccount *string `location:"querystring" locationName:"targetAwsAccount" type:"string" required:"true"`
}

// String returns the string representation
func (s TransferCertificateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TransferCertificateInput) GoString() string {
	return s.String()
}

// The output from the TransferCertificate operation.
type TransferCertificateOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the certificate.
	TransferredCertificateArn *string `locationName:"transferredCertificateArn" type:"string"`
}

// String returns the string representation
func (s TransferCertificateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TransferCertificateOutput) GoString() string {
	return s.String()
}

// The input for the UpdateCertificate operation.
type UpdateCertificateInput struct {
	_ struct{} `type:"structure"`

	// The ID of the certificate.
	CertificateId *string `location:"uri" locationName:"certificateId" min:"64" type:"string" required:"true"`

	// The new status.
	//
	// Note: setting the status to PENDING_TRANSFER will result in an exception
	// being thrown. PENDING_TRANSFER is a status used internally by AWS IoT and
	// is not meant to be used by developers.
	NewStatus *string `location:"querystring" locationName:"newStatus" type:"string" required:"true" enum:"CertificateStatus"`
}

// String returns the string representation
func (s UpdateCertificateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateCertificateInput) GoString() string {
	return s.String()
}

type UpdateCertificateOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateCertificateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateCertificateOutput) GoString() string {
	return s.String()
}

// The input for the UpdateThing operation.
type UpdateThingInput struct {
	_ struct{} `type:"structure"`

	// The attribute payload, a JSON string containing up to three key-value pairs.
	//
	// For example: {\"attributes\":{\"string1\":\"string2\"}}
	AttributePayload *AttributePayload `locationName:"attributePayload" type:"structure" required:"true"`

	// The thing name.
	ThingName *string `location:"uri" locationName:"thingName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateThingInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateThingInput) GoString() string {
	return s.String()
}

// The output from the UpdateThing operation.
type UpdateThingOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateThingOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateThingOutput) GoString() string {
	return s.String()
}

const (
	// @enum CertificateStatus
	CertificateStatusActive = "ACTIVE"
	// @enum CertificateStatus
	CertificateStatusInactive = "INACTIVE"
	// @enum CertificateStatus
	CertificateStatusRevoked = "REVOKED"
	// @enum CertificateStatus
	CertificateStatusPendingTransfer = "PENDING_TRANSFER"
)

const (
	// @enum LogLevel
	LogLevelDebug = "DEBUG"
	// @enum LogLevel
	LogLevelInfo = "INFO"
	// @enum LogLevel
	LogLevelError = "ERROR"
	// @enum LogLevel
	LogLevelWarn = "WARN"
	// @enum LogLevel
	LogLevelDisabled = "DISABLED"
)
