// THIS FILE IS AUTOMATICALLY GENERATED. DO NOT EDIT.

// Package servicecatalog provides a client for AWS Service Catalog.
package servicecatalog

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
)

const opAcceptPortfolioShare = "AcceptPortfolioShare"

// AcceptPortfolioShareRequest generates a "aws/request.Request" representing the
// client's request for the AcceptPortfolioShare operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See AcceptPortfolioShare for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the AcceptPortfolioShare method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the AcceptPortfolioShareRequest method.
//    req, resp := client.AcceptPortfolioShareRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/AcceptPortfolioShare
func (c *ServiceCatalog) AcceptPortfolioShareRequest(input *AcceptPortfolioShareInput) (req *request.Request, output *AcceptPortfolioShareOutput) {
	op := &request.Operation{
		Name:       opAcceptPortfolioShare,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AcceptPortfolioShareInput{}
	}

	output = &AcceptPortfolioShareOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AcceptPortfolioShare API operation for AWS Service Catalog.
//
// Accepts an offer to share a portfolio.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Service Catalog's
// API operation AcceptPortfolioShare for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidParametersException "InvalidParametersException"
//   One or more parameters provided to the operation are invalid.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource was not found.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   The current limits of the service would have been exceeded by this operation.
//   Reduce the resource use or increase the service limits and retry the operation.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/AcceptPortfolioShare
func (c *ServiceCatalog) AcceptPortfolioShare(input *AcceptPortfolioShareInput) (*AcceptPortfolioShareOutput, error) {
	req, out := c.AcceptPortfolioShareRequest(input)
	return out, req.Send()
}

// AcceptPortfolioShareWithContext is the same as AcceptPortfolioShare with the addition of
// the ability to pass a context and additional request options.
//
// See AcceptPortfolioShare for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ServiceCatalog) AcceptPortfolioShareWithContext(ctx aws.Context, input *AcceptPortfolioShareInput, opts ...request.Option) (*AcceptPortfolioShareOutput, error) {
	req, out := c.AcceptPortfolioShareRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAssociatePrincipalWithPortfolio = "AssociatePrincipalWithPortfolio"

// AssociatePrincipalWithPortfolioRequest generates a "aws/request.Request" representing the
// client's request for the AssociatePrincipalWithPortfolio operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See AssociatePrincipalWithPortfolio for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the AssociatePrincipalWithPortfolio method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the AssociatePrincipalWithPortfolioRequest method.
//    req, resp := client.AssociatePrincipalWithPortfolioRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/AssociatePrincipalWithPortfolio
func (c *ServiceCatalog) AssociatePrincipalWithPortfolioRequest(input *AssociatePrincipalWithPortfolioInput) (req *request.Request, output *AssociatePrincipalWithPortfolioOutput) {
	op := &request.Operation{
		Name:       opAssociatePrincipalWithPortfolio,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AssociatePrincipalWithPortfolioInput{}
	}

	output = &AssociatePrincipalWithPortfolioOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AssociatePrincipalWithPortfolio API operation for AWS Service Catalog.
//
// Associates the specified principal ARN with the specified portfolio.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Service Catalog's
// API operation AssociatePrincipalWithPortfolio for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidParametersException "InvalidParametersException"
//   One or more parameters provided to the operation are invalid.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource was not found.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   The current limits of the service would have been exceeded by this operation.
//   Reduce the resource use or increase the service limits and retry the operation.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/AssociatePrincipalWithPortfolio
func (c *ServiceCatalog) AssociatePrincipalWithPortfolio(input *AssociatePrincipalWithPortfolioInput) (*AssociatePrincipalWithPortfolioOutput, error) {
	req, out := c.AssociatePrincipalWithPortfolioRequest(input)
	return out, req.Send()
}

// AssociatePrincipalWithPortfolioWithContext is the same as AssociatePrincipalWithPortfolio with the addition of
// the ability to pass a context and additional request options.
//
// See AssociatePrincipalWithPortfolio for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ServiceCatalog) AssociatePrincipalWithPortfolioWithContext(ctx aws.Context, input *AssociatePrincipalWithPortfolioInput, opts ...request.Option) (*AssociatePrincipalWithPortfolioOutput, error) {
	req, out := c.AssociatePrincipalWithPortfolioRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAssociateProductWithPortfolio = "AssociateProductWithPortfolio"

// AssociateProductWithPortfolioRequest generates a "aws/request.Request" representing the
// client's request for the AssociateProductWithPortfolio operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See AssociateProductWithPortfolio for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the AssociateProductWithPortfolio method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the AssociateProductWithPortfolioRequest method.
//    req, resp := client.AssociateProductWithPortfolioRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/AssociateProductWithPortfolio
func (c *ServiceCatalog) AssociateProductWithPortfolioRequest(input *AssociateProductWithPortfolioInput) (req *request.Request, output *AssociateProductWithPortfolioOutput) {
	op := &request.Operation{
		Name:       opAssociateProductWithPortfolio,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AssociateProductWithPortfolioInput{}
	}

	output = &AssociateProductWithPortfolioOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AssociateProductWithPortfolio API operation for AWS Service Catalog.
//
// Associates a product with a portfolio.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Service Catalog's
// API operation AssociateProductWithPortfolio for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidParametersException "InvalidParametersException"
//   One or more parameters provided to the operation are invalid.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource was not found.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   The current limits of the service would have been exceeded by this operation.
//   Reduce the resource use or increase the service limits and retry the operation.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/AssociateProductWithPortfolio
func (c *ServiceCatalog) AssociateProductWithPortfolio(input *AssociateProductWithPortfolioInput) (*AssociateProductWithPortfolioOutput, error) {
	req, out := c.AssociateProductWithPortfolioRequest(input)
	return out, req.Send()
}

// AssociateProductWithPortfolioWithContext is the same as AssociateProductWithPortfolio with the addition of
// the ability to pass a context and additional request options.
//
// See AssociateProductWithPortfolio for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ServiceCatalog) AssociateProductWithPortfolioWithContext(ctx aws.Context, input *AssociateProductWithPortfolioInput, opts ...request.Option) (*AssociateProductWithPortfolioOutput, error) {
	req, out := c.AssociateProductWithPortfolioRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateConstraint = "CreateConstraint"

// CreateConstraintRequest generates a "aws/request.Request" representing the
// client's request for the CreateConstraint operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See CreateConstraint for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the CreateConstraint method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the CreateConstraintRequest method.
//    req, resp := client.CreateConstraintRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/CreateConstraint
func (c *ServiceCatalog) CreateConstraintRequest(input *CreateConstraintInput) (req *request.Request, output *CreateConstraintOutput) {
	op := &request.Operation{
		Name:       opCreateConstraint,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateConstraintInput{}
	}

	output = &CreateConstraintOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateConstraint API operation for AWS Service Catalog.
//
// Creates a new constraint.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Service Catalog's
// API operation CreateConstraint for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource was not found.
//
//   * ErrCodeInvalidParametersException "InvalidParametersException"
//   One or more parameters provided to the operation are invalid.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   The current limits of the service would have been exceeded by this operation.
//   Reduce the resource use or increase the service limits and retry the operation.
//
//   * ErrCodeDuplicateResourceException "DuplicateResourceException"
//   The specified resource is a duplicate.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/CreateConstraint
func (c *ServiceCatalog) CreateConstraint(input *CreateConstraintInput) (*CreateConstraintOutput, error) {
	req, out := c.CreateConstraintRequest(input)
	return out, req.Send()
}

// CreateConstraintWithContext is the same as CreateConstraint with the addition of
// the ability to pass a context and additional request options.
//
// See CreateConstraint for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ServiceCatalog) CreateConstraintWithContext(ctx aws.Context, input *CreateConstraintInput, opts ...request.Option) (*CreateConstraintOutput, error) {
	req, out := c.CreateConstraintRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreatePortfolio = "CreatePortfolio"

// CreatePortfolioRequest generates a "aws/request.Request" representing the
// client's request for the CreatePortfolio operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See CreatePortfolio for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the CreatePortfolio method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the CreatePortfolioRequest method.
//    req, resp := client.CreatePortfolioRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/CreatePortfolio
func (c *ServiceCatalog) CreatePortfolioRequest(input *CreatePortfolioInput) (req *request.Request, output *CreatePortfolioOutput) {
	op := &request.Operation{
		Name:       opCreatePortfolio,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreatePortfolioInput{}
	}

	output = &CreatePortfolioOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreatePortfolio API operation for AWS Service Catalog.
//
// Creates a new portfolio.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Service Catalog's
// API operation CreatePortfolio for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidParametersException "InvalidParametersException"
//   One or more parameters provided to the operation are invalid.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   The current limits of the service would have been exceeded by this operation.
//   Reduce the resource use or increase the service limits and retry the operation.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/CreatePortfolio
func (c *ServiceCatalog) CreatePortfolio(input *CreatePortfolioInput) (*CreatePortfolioOutput, error) {
	req, out := c.CreatePortfolioRequest(input)
	return out, req.Send()
}

// CreatePortfolioWithContext is the same as CreatePortfolio with the addition of
// the ability to pass a context and additional request options.
//
// See CreatePortfolio for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ServiceCatalog) CreatePortfolioWithContext(ctx aws.Context, input *CreatePortfolioInput, opts ...request.Option) (*CreatePortfolioOutput, error) {
	req, out := c.CreatePortfolioRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreatePortfolioShare = "CreatePortfolioShare"

// CreatePortfolioShareRequest generates a "aws/request.Request" representing the
// client's request for the CreatePortfolioShare operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See CreatePortfolioShare for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the CreatePortfolioShare method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the CreatePortfolioShareRequest method.
//    req, resp := client.CreatePortfolioShareRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/CreatePortfolioShare
func (c *ServiceCatalog) CreatePortfolioShareRequest(input *CreatePortfolioShareInput) (req *request.Request, output *CreatePortfolioShareOutput) {
	op := &request.Operation{
		Name:       opCreatePortfolioShare,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreatePortfolioShareInput{}
	}

	output = &CreatePortfolioShareOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreatePortfolioShare API operation for AWS Service Catalog.
//
// Creates a new portfolio share.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Service Catalog's
// API operation CreatePortfolioShare for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource was not found.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   The current limits of the service would have been exceeded by this operation.
//   Reduce the resource use or increase the service limits and retry the operation.
//
//   * ErrCodeInvalidParametersException "InvalidParametersException"
//   One or more parameters provided to the operation are invalid.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/CreatePortfolioShare
func (c *ServiceCatalog) CreatePortfolioShare(input *CreatePortfolioShareInput) (*CreatePortfolioShareOutput, error) {
	req, out := c.CreatePortfolioShareRequest(input)
	return out, req.Send()
}

// CreatePortfolioShareWithContext is the same as CreatePortfolioShare with the addition of
// the ability to pass a context and additional request options.
//
// See CreatePortfolioShare for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ServiceCatalog) CreatePortfolioShareWithContext(ctx aws.Context, input *CreatePortfolioShareInput, opts ...request.Option) (*CreatePortfolioShareOutput, error) {
	req, out := c.CreatePortfolioShareRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateProduct = "CreateProduct"

// CreateProductRequest generates a "aws/request.Request" representing the
// client's request for the CreateProduct operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See CreateProduct for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the CreateProduct method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the CreateProductRequest method.
//    req, resp := client.CreateProductRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/CreateProduct
func (c *ServiceCatalog) CreateProductRequest(input *CreateProductInput) (req *request.Request, output *CreateProductOutput) {
	op := &request.Operation{
		Name:       opCreateProduct,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateProductInput{}
	}

	output = &CreateProductOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateProduct API operation for AWS Service Catalog.
//
// Creates a new product.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Service Catalog's
// API operation CreateProduct for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidParametersException "InvalidParametersException"
//   One or more parameters provided to the operation are invalid.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   The current limits of the service would have been exceeded by this operation.
//   Reduce the resource use or increase the service limits and retry the operation.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/CreateProduct
func (c *ServiceCatalog) CreateProduct(input *CreateProductInput) (*CreateProductOutput, error) {
	req, out := c.CreateProductRequest(input)
	return out, req.Send()
}

// CreateProductWithContext is the same as CreateProduct with the addition of
// the ability to pass a context and additional request options.
//
// See CreateProduct for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ServiceCatalog) CreateProductWithContext(ctx aws.Context, input *CreateProductInput, opts ...request.Option) (*CreateProductOutput, error) {
	req, out := c.CreateProductRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateProvisioningArtifact = "CreateProvisioningArtifact"

// CreateProvisioningArtifactRequest generates a "aws/request.Request" representing the
// client's request for the CreateProvisioningArtifact operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See CreateProvisioningArtifact for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the CreateProvisioningArtifact method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the CreateProvisioningArtifactRequest method.
//    req, resp := client.CreateProvisioningArtifactRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/CreateProvisioningArtifact
func (c *ServiceCatalog) CreateProvisioningArtifactRequest(input *CreateProvisioningArtifactInput) (req *request.Request, output *CreateProvisioningArtifactOutput) {
	op := &request.Operation{
		Name:       opCreateProvisioningArtifact,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateProvisioningArtifactInput{}
	}

	output = &CreateProvisioningArtifactOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateProvisioningArtifact API operation for AWS Service Catalog.
//
// Create a new provisioning artifact for the specified product. This operation
// will not work with a product that has been shared with you.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Service Catalog's
// API operation CreateProvisioningArtifact for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource was not found.
//
//   * ErrCodeInvalidParametersException "InvalidParametersException"
//   One or more parameters provided to the operation are invalid.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   The current limits of the service would have been exceeded by this operation.
//   Reduce the resource use or increase the service limits and retry the operation.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/CreateProvisioningArtifact
func (c *ServiceCatalog) CreateProvisioningArtifact(input *CreateProvisioningArtifactInput) (*CreateProvisioningArtifactOutput, error) {
	req, out := c.CreateProvisioningArtifactRequest(input)
	return out, req.Send()
}

// CreateProvisioningArtifactWithContext is the same as CreateProvisioningArtifact with the addition of
// the ability to pass a context and additional request options.
//
// See CreateProvisioningArtifact for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ServiceCatalog) CreateProvisioningArtifactWithContext(ctx aws.Context, input *CreateProvisioningArtifactInput, opts ...request.Option) (*CreateProvisioningArtifactOutput, error) {
	req, out := c.CreateProvisioningArtifactRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteConstraint = "DeleteConstraint"

// DeleteConstraintRequest generates a "aws/request.Request" representing the
// client's request for the DeleteConstraint operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DeleteConstraint for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DeleteConstraint method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DeleteConstraintRequest method.
//    req, resp := client.DeleteConstraintRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/DeleteConstraint
func (c *ServiceCatalog) DeleteConstraintRequest(input *DeleteConstraintInput) (req *request.Request, output *DeleteConstraintOutput) {
	op := &request.Operation{
		Name:       opDeleteConstraint,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteConstraintInput{}
	}

	output = &DeleteConstraintOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteConstraint API operation for AWS Service Catalog.
//
// Deletes the specified constraint.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Service Catalog's
// API operation DeleteConstraint for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource was not found.
//
//   * ErrCodeInvalidParametersException "InvalidParametersException"
//   One or more parameters provided to the operation are invalid.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/DeleteConstraint
func (c *ServiceCatalog) DeleteConstraint(input *DeleteConstraintInput) (*DeleteConstraintOutput, error) {
	req, out := c.DeleteConstraintRequest(input)
	return out, req.Send()
}

// DeleteConstraintWithContext is the same as DeleteConstraint with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteConstraint for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ServiceCatalog) DeleteConstraintWithContext(ctx aws.Context, input *DeleteConstraintInput, opts ...request.Option) (*DeleteConstraintOutput, error) {
	req, out := c.DeleteConstraintRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeletePortfolio = "DeletePortfolio"

// DeletePortfolioRequest generates a "aws/request.Request" representing the
// client's request for the DeletePortfolio operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DeletePortfolio for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DeletePortfolio method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DeletePortfolioRequest method.
//    req, resp := client.DeletePortfolioRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/DeletePortfolio
func (c *ServiceCatalog) DeletePortfolioRequest(input *DeletePortfolioInput) (req *request.Request, output *DeletePortfolioOutput) {
	op := &request.Operation{
		Name:       opDeletePortfolio,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeletePortfolioInput{}
	}

	output = &DeletePortfolioOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeletePortfolio API operation for AWS Service Catalog.
//
// Deletes the specified portfolio. This operation will not work with a portfolio
// that has been shared with you or if it has products, users, constraints,
// or shared accounts associated with it.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Service Catalog's
// API operation DeletePortfolio for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource was not found.
//
//   * ErrCodeInvalidParametersException "InvalidParametersException"
//   One or more parameters provided to the operation are invalid.
//
//   * ErrCodeResourceInUseException "ResourceInUseException"
//   The operation was requested against a resource that is currently in use.
//   Free the resource from use and retry the operation.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/DeletePortfolio
func (c *ServiceCatalog) DeletePortfolio(input *DeletePortfolioInput) (*DeletePortfolioOutput, error) {
	req, out := c.DeletePortfolioRequest(input)
	return out, req.Send()
}

// DeletePortfolioWithContext is the same as DeletePortfolio with the addition of
// the ability to pass a context and additional request options.
//
// See DeletePortfolio for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ServiceCatalog) DeletePortfolioWithContext(ctx aws.Context, input *DeletePortfolioInput, opts ...request.Option) (*DeletePortfolioOutput, error) {
	req, out := c.DeletePortfolioRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeletePortfolioShare = "DeletePortfolioShare"

// DeletePortfolioShareRequest generates a "aws/request.Request" representing the
// client's request for the DeletePortfolioShare operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DeletePortfolioShare for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DeletePortfolioShare method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DeletePortfolioShareRequest method.
//    req, resp := client.DeletePortfolioShareRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/DeletePortfolioShare
func (c *ServiceCatalog) DeletePortfolioShareRequest(input *DeletePortfolioShareInput) (req *request.Request, output *DeletePortfolioShareOutput) {
	op := &request.Operation{
		Name:       opDeletePortfolioShare,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeletePortfolioShareInput{}
	}

	output = &DeletePortfolioShareOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeletePortfolioShare API operation for AWS Service Catalog.
//
// Deletes the specified portfolio share.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Service Catalog's
// API operation DeletePortfolioShare for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource was not found.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/DeletePortfolioShare
func (c *ServiceCatalog) DeletePortfolioShare(input *DeletePortfolioShareInput) (*DeletePortfolioShareOutput, error) {
	req, out := c.DeletePortfolioShareRequest(input)
	return out, req.Send()
}

// DeletePortfolioShareWithContext is the same as DeletePortfolioShare with the addition of
// the ability to pass a context and additional request options.
//
// See DeletePortfolioShare for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ServiceCatalog) DeletePortfolioShareWithContext(ctx aws.Context, input *DeletePortfolioShareInput, opts ...request.Option) (*DeletePortfolioShareOutput, error) {
	req, out := c.DeletePortfolioShareRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteProduct = "DeleteProduct"

// DeleteProductRequest generates a "aws/request.Request" representing the
// client's request for the DeleteProduct operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DeleteProduct for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DeleteProduct method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DeleteProductRequest method.
//    req, resp := client.DeleteProductRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/DeleteProduct
func (c *ServiceCatalog) DeleteProductRequest(input *DeleteProductInput) (req *request.Request, output *DeleteProductOutput) {
	op := &request.Operation{
		Name:       opDeleteProduct,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteProductInput{}
	}

	output = &DeleteProductOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteProduct API operation for AWS Service Catalog.
//
// Deletes the specified product. This operation will not work with a product
// that has been shared with you or is associated with a portfolio.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Service Catalog's
// API operation DeleteProduct for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource was not found.
//
//   * ErrCodeResourceInUseException "ResourceInUseException"
//   The operation was requested against a resource that is currently in use.
//   Free the resource from use and retry the operation.
//
//   * ErrCodeInvalidParametersException "InvalidParametersException"
//   One or more parameters provided to the operation are invalid.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/DeleteProduct
func (c *ServiceCatalog) DeleteProduct(input *DeleteProductInput) (*DeleteProductOutput, error) {
	req, out := c.DeleteProductRequest(input)
	return out, req.Send()
}

// DeleteProductWithContext is the same as DeleteProduct with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteProduct for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ServiceCatalog) DeleteProductWithContext(ctx aws.Context, input *DeleteProductInput, opts ...request.Option) (*DeleteProductOutput, error) {
	req, out := c.DeleteProductRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteProvisioningArtifact = "DeleteProvisioningArtifact"

// DeleteProvisioningArtifactRequest generates a "aws/request.Request" representing the
// client's request for the DeleteProvisioningArtifact operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DeleteProvisioningArtifact for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DeleteProvisioningArtifact method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DeleteProvisioningArtifactRequest method.
//    req, resp := client.DeleteProvisioningArtifactRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/DeleteProvisioningArtifact
func (c *ServiceCatalog) DeleteProvisioningArtifactRequest(input *DeleteProvisioningArtifactInput) (req *request.Request, output *DeleteProvisioningArtifactOutput) {
	op := &request.Operation{
		Name:       opDeleteProvisioningArtifact,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteProvisioningArtifactInput{}
	}

	output = &DeleteProvisioningArtifactOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteProvisioningArtifact API operation for AWS Service Catalog.
//
// Deletes the specified provisioning artifact. This operation will not work
// on a provisioning artifact associated with a product that has been shared
// with you, or on the last provisioning artifact associated with a product
// (a product must have at least one provisioning artifact).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Service Catalog's
// API operation DeleteProvisioningArtifact for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource was not found.
//
//   * ErrCodeResourceInUseException "ResourceInUseException"
//   The operation was requested against a resource that is currently in use.
//   Free the resource from use and retry the operation.
//
//   * ErrCodeInvalidParametersException "InvalidParametersException"
//   One or more parameters provided to the operation are invalid.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/DeleteProvisioningArtifact
func (c *ServiceCatalog) DeleteProvisioningArtifact(input *DeleteProvisioningArtifactInput) (*DeleteProvisioningArtifactOutput, error) {
	req, out := c.DeleteProvisioningArtifactRequest(input)
	return out, req.Send()
}

// DeleteProvisioningArtifactWithContext is the same as DeleteProvisioningArtifact with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteProvisioningArtifact for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ServiceCatalog) DeleteProvisioningArtifactWithContext(ctx aws.Context, input *DeleteProvisioningArtifactInput, opts ...request.Option) (*DeleteProvisioningArtifactOutput, error) {
	req, out := c.DeleteProvisioningArtifactRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeConstraint = "DescribeConstraint"

// DescribeConstraintRequest generates a "aws/request.Request" representing the
// client's request for the DescribeConstraint operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeConstraint for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeConstraint method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeConstraintRequest method.
//    req, resp := client.DescribeConstraintRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/DescribeConstraint
func (c *ServiceCatalog) DescribeConstraintRequest(input *DescribeConstraintInput) (req *request.Request, output *DescribeConstraintOutput) {
	op := &request.Operation{
		Name:       opDescribeConstraint,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeConstraintInput{}
	}

	output = &DescribeConstraintOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeConstraint API operation for AWS Service Catalog.
//
// Retrieves detailed information for a specified constraint.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Service Catalog's
// API operation DescribeConstraint for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource was not found.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/DescribeConstraint
func (c *ServiceCatalog) DescribeConstraint(input *DescribeConstraintInput) (*DescribeConstraintOutput, error) {
	req, out := c.DescribeConstraintRequest(input)
	return out, req.Send()
}

// DescribeConstraintWithContext is the same as DescribeConstraint with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeConstraint for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ServiceCatalog) DescribeConstraintWithContext(ctx aws.Context, input *DescribeConstraintInput, opts ...request.Option) (*DescribeConstraintOutput, error) {
	req, out := c.DescribeConstraintRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribePortfolio = "DescribePortfolio"

// DescribePortfolioRequest generates a "aws/request.Request" representing the
// client's request for the DescribePortfolio operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribePortfolio for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribePortfolio method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribePortfolioRequest method.
//    req, resp := client.DescribePortfolioRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/DescribePortfolio
func (c *ServiceCatalog) DescribePortfolioRequest(input *DescribePortfolioInput) (req *request.Request, output *DescribePortfolioOutput) {
	op := &request.Operation{
		Name:       opDescribePortfolio,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribePortfolioInput{}
	}

	output = &DescribePortfolioOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribePortfolio API operation for AWS Service Catalog.
//
// Retrieves detailed information and any tags associated with the specified
// portfolio.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Service Catalog's
// API operation DescribePortfolio for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource was not found.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/DescribePortfolio
func (c *ServiceCatalog) DescribePortfolio(input *DescribePortfolioInput) (*DescribePortfolioOutput, error) {
	req, out := c.DescribePortfolioRequest(input)
	return out, req.Send()
}

// DescribePortfolioWithContext is the same as DescribePortfolio with the addition of
// the ability to pass a context and additional request options.
//
// See DescribePortfolio for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ServiceCatalog) DescribePortfolioWithContext(ctx aws.Context, input *DescribePortfolioInput, opts ...request.Option) (*DescribePortfolioOutput, error) {
	req, out := c.DescribePortfolioRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeProduct = "DescribeProduct"

// DescribeProductRequest generates a "aws/request.Request" representing the
// client's request for the DescribeProduct operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeProduct for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeProduct method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeProductRequest method.
//    req, resp := client.DescribeProductRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/DescribeProduct
func (c *ServiceCatalog) DescribeProductRequest(input *DescribeProductInput) (req *request.Request, output *DescribeProductOutput) {
	op := &request.Operation{
		Name:       opDescribeProduct,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeProductInput{}
	}

	output = &DescribeProductOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeProduct API operation for AWS Service Catalog.
//
// Retrieves information about a specified product.
//
// This operation is functionally identical to DescribeProductView except that
// it takes as input ProductId instead of ProductViewId.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Service Catalog's
// API operation DescribeProduct for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource was not found.
//
//   * ErrCodeInvalidParametersException "InvalidParametersException"
//   One or more parameters provided to the operation are invalid.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/DescribeProduct
func (c *ServiceCatalog) DescribeProduct(input *DescribeProductInput) (*DescribeProductOutput, error) {
	req, out := c.DescribeProductRequest(input)
	return out, req.Send()
}

// DescribeProductWithContext is the same as DescribeProduct with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeProduct for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ServiceCatalog) DescribeProductWithContext(ctx aws.Context, input *DescribeProductInput, opts ...request.Option) (*DescribeProductOutput, error) {
	req, out := c.DescribeProductRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeProductAsAdmin = "DescribeProductAsAdmin"

// DescribeProductAsAdminRequest generates a "aws/request.Request" representing the
// client's request for the DescribeProductAsAdmin operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeProductAsAdmin for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeProductAsAdmin method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeProductAsAdminRequest method.
//    req, resp := client.DescribeProductAsAdminRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/DescribeProductAsAdmin
func (c *ServiceCatalog) DescribeProductAsAdminRequest(input *DescribeProductAsAdminInput) (req *request.Request, output *DescribeProductAsAdminOutput) {
	op := &request.Operation{
		Name:       opDescribeProductAsAdmin,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeProductAsAdminInput{}
	}

	output = &DescribeProductAsAdminOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeProductAsAdmin API operation for AWS Service Catalog.
//
// Retrieves information about a specified product, run with administrator access.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Service Catalog's
// API operation DescribeProductAsAdmin for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource was not found.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/DescribeProductAsAdmin
func (c *ServiceCatalog) DescribeProductAsAdmin(input *DescribeProductAsAdminInput) (*DescribeProductAsAdminOutput, error) {
	req, out := c.DescribeProductAsAdminRequest(input)
	return out, req.Send()
}

// DescribeProductAsAdminWithContext is the same as DescribeProductAsAdmin with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeProductAsAdmin for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ServiceCatalog) DescribeProductAsAdminWithContext(ctx aws.Context, input *DescribeProductAsAdminInput, opts ...request.Option) (*DescribeProductAsAdminOutput, error) {
	req, out := c.DescribeProductAsAdminRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeProductView = "DescribeProductView"

// DescribeProductViewRequest generates a "aws/request.Request" representing the
// client's request for the DescribeProductView operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeProductView for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeProductView method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeProductViewRequest method.
//    req, resp := client.DescribeProductViewRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/DescribeProductView
func (c *ServiceCatalog) DescribeProductViewRequest(input *DescribeProductViewInput) (req *request.Request, output *DescribeProductViewOutput) {
	op := &request.Operation{
		Name:       opDescribeProductView,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeProductViewInput{}
	}

	output = &DescribeProductViewOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeProductView API operation for AWS Service Catalog.
//
// Retrieves information about a specified product.
//
// This operation is functionally identical to DescribeProduct except that it
// takes as input ProductViewId instead of ProductId.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Service Catalog's
// API operation DescribeProductView for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource was not found.
//
//   * ErrCodeInvalidParametersException "InvalidParametersException"
//   One or more parameters provided to the operation are invalid.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/DescribeProductView
func (c *ServiceCatalog) DescribeProductView(input *DescribeProductViewInput) (*DescribeProductViewOutput, error) {
	req, out := c.DescribeProductViewRequest(input)
	return out, req.Send()
}

// DescribeProductViewWithContext is the same as DescribeProductView with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeProductView for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ServiceCatalog) DescribeProductViewWithContext(ctx aws.Context, input *DescribeProductViewInput, opts ...request.Option) (*DescribeProductViewOutput, error) {
	req, out := c.DescribeProductViewRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeProvisioningArtifact = "DescribeProvisioningArtifact"

// DescribeProvisioningArtifactRequest generates a "aws/request.Request" representing the
// client's request for the DescribeProvisioningArtifact operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeProvisioningArtifact for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeProvisioningArtifact method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeProvisioningArtifactRequest method.
//    req, resp := client.DescribeProvisioningArtifactRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/DescribeProvisioningArtifact
func (c *ServiceCatalog) DescribeProvisioningArtifactRequest(input *DescribeProvisioningArtifactInput) (req *request.Request, output *DescribeProvisioningArtifactOutput) {
	op := &request.Operation{
		Name:       opDescribeProvisioningArtifact,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeProvisioningArtifactInput{}
	}

	output = &DescribeProvisioningArtifactOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeProvisioningArtifact API operation for AWS Service Catalog.
//
// Retrieves detailed information about the specified provisioning artifact.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Service Catalog's
// API operation DescribeProvisioningArtifact for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource was not found.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/DescribeProvisioningArtifact
func (c *ServiceCatalog) DescribeProvisioningArtifact(input *DescribeProvisioningArtifactInput) (*DescribeProvisioningArtifactOutput, error) {
	req, out := c.DescribeProvisioningArtifactRequest(input)
	return out, req.Send()
}

// DescribeProvisioningArtifactWithContext is the same as DescribeProvisioningArtifact with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeProvisioningArtifact for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ServiceCatalog) DescribeProvisioningArtifactWithContext(ctx aws.Context, input *DescribeProvisioningArtifactInput, opts ...request.Option) (*DescribeProvisioningArtifactOutput, error) {
	req, out := c.DescribeProvisioningArtifactRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeProvisioningParameters = "DescribeProvisioningParameters"

// DescribeProvisioningParametersRequest generates a "aws/request.Request" representing the
// client's request for the DescribeProvisioningParameters operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeProvisioningParameters for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeProvisioningParameters method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeProvisioningParametersRequest method.
//    req, resp := client.DescribeProvisioningParametersRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/DescribeProvisioningParameters
func (c *ServiceCatalog) DescribeProvisioningParametersRequest(input *DescribeProvisioningParametersInput) (req *request.Request, output *DescribeProvisioningParametersOutput) {
	op := &request.Operation{
		Name:       opDescribeProvisioningParameters,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeProvisioningParametersInput{}
	}

	output = &DescribeProvisioningParametersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeProvisioningParameters API operation for AWS Service Catalog.
//
// Provides information about parameters required to provision a specified product
// in a specified manner. Use this operation to obtain the list of ProvisioningArtifactParameters
// parameters available to call the ProvisionProduct operation for the specified
// product.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Service Catalog's
// API operation DescribeProvisioningParameters for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidParametersException "InvalidParametersException"
//   One or more parameters provided to the operation are invalid.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource was not found.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/DescribeProvisioningParameters
func (c *ServiceCatalog) DescribeProvisioningParameters(input *DescribeProvisioningParametersInput) (*DescribeProvisioningParametersOutput, error) {
	req, out := c.DescribeProvisioningParametersRequest(input)
	return out, req.Send()
}

// DescribeProvisioningParametersWithContext is the same as DescribeProvisioningParameters with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeProvisioningParameters for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ServiceCatalog) DescribeProvisioningParametersWithContext(ctx aws.Context, input *DescribeProvisioningParametersInput, opts ...request.Option) (*DescribeProvisioningParametersOutput, error) {
	req, out := c.DescribeProvisioningParametersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeRecord = "DescribeRecord"

// DescribeRecordRequest generates a "aws/request.Request" representing the
// client's request for the DescribeRecord operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeRecord for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeRecord method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeRecordRequest method.
//    req, resp := client.DescribeRecordRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/DescribeRecord
func (c *ServiceCatalog) DescribeRecordRequest(input *DescribeRecordInput) (req *request.Request, output *DescribeRecordOutput) {
	op := &request.Operation{
		Name:       opDescribeRecord,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeRecordInput{}
	}

	output = &DescribeRecordOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeRecord API operation for AWS Service Catalog.
//
// Retrieves a paginated list of the full details of a specific request. Use
// this operation after calling a request operation (ProvisionProduct, TerminateProvisionedProduct,
// or UpdateProvisionedProduct).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Service Catalog's
// API operation DescribeRecord for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource was not found.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/DescribeRecord
func (c *ServiceCatalog) DescribeRecord(input *DescribeRecordInput) (*DescribeRecordOutput, error) {
	req, out := c.DescribeRecordRequest(input)
	return out, req.Send()
}

// DescribeRecordWithContext is the same as DescribeRecord with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeRecord for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ServiceCatalog) DescribeRecordWithContext(ctx aws.Context, input *DescribeRecordInput, opts ...request.Option) (*DescribeRecordOutput, error) {
	req, out := c.DescribeRecordRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDisassociatePrincipalFromPortfolio = "DisassociatePrincipalFromPortfolio"

// DisassociatePrincipalFromPortfolioRequest generates a "aws/request.Request" representing the
// client's request for the DisassociatePrincipalFromPortfolio operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DisassociatePrincipalFromPortfolio for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DisassociatePrincipalFromPortfolio method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DisassociatePrincipalFromPortfolioRequest method.
//    req, resp := client.DisassociatePrincipalFromPortfolioRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/DisassociatePrincipalFromPortfolio
func (c *ServiceCatalog) DisassociatePrincipalFromPortfolioRequest(input *DisassociatePrincipalFromPortfolioInput) (req *request.Request, output *DisassociatePrincipalFromPortfolioOutput) {
	op := &request.Operation{
		Name:       opDisassociatePrincipalFromPortfolio,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DisassociatePrincipalFromPortfolioInput{}
	}

	output = &DisassociatePrincipalFromPortfolioOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DisassociatePrincipalFromPortfolio API operation for AWS Service Catalog.
//
// Disassociates a previously associated principal ARN from a specified portfolio.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Service Catalog's
// API operation DisassociatePrincipalFromPortfolio for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidParametersException "InvalidParametersException"
//   One or more parameters provided to the operation are invalid.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource was not found.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/DisassociatePrincipalFromPortfolio
func (c *ServiceCatalog) DisassociatePrincipalFromPortfolio(input *DisassociatePrincipalFromPortfolioInput) (*DisassociatePrincipalFromPortfolioOutput, error) {
	req, out := c.DisassociatePrincipalFromPortfolioRequest(input)
	return out, req.Send()
}

// DisassociatePrincipalFromPortfolioWithContext is the same as DisassociatePrincipalFromPortfolio with the addition of
// the ability to pass a context and additional request options.
//
// See DisassociatePrincipalFromPortfolio for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ServiceCatalog) DisassociatePrincipalFromPortfolioWithContext(ctx aws.Context, input *DisassociatePrincipalFromPortfolioInput, opts ...request.Option) (*DisassociatePrincipalFromPortfolioOutput, error) {
	req, out := c.DisassociatePrincipalFromPortfolioRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDisassociateProductFromPortfolio = "DisassociateProductFromPortfolio"

// DisassociateProductFromPortfolioRequest generates a "aws/request.Request" representing the
// client's request for the DisassociateProductFromPortfolio operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DisassociateProductFromPortfolio for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DisassociateProductFromPortfolio method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DisassociateProductFromPortfolioRequest method.
//    req, resp := client.DisassociateProductFromPortfolioRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/DisassociateProductFromPortfolio
func (c *ServiceCatalog) DisassociateProductFromPortfolioRequest(input *DisassociateProductFromPortfolioInput) (req *request.Request, output *DisassociateProductFromPortfolioOutput) {
	op := &request.Operation{
		Name:       opDisassociateProductFromPortfolio,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DisassociateProductFromPortfolioInput{}
	}

	output = &DisassociateProductFromPortfolioOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DisassociateProductFromPortfolio API operation for AWS Service Catalog.
//
// Disassociates the specified product from the specified portfolio.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Service Catalog's
// API operation DisassociateProductFromPortfolio for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource was not found.
//
//   * ErrCodeInvalidParametersException "InvalidParametersException"
//   One or more parameters provided to the operation are invalid.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/DisassociateProductFromPortfolio
func (c *ServiceCatalog) DisassociateProductFromPortfolio(input *DisassociateProductFromPortfolioInput) (*DisassociateProductFromPortfolioOutput, error) {
	req, out := c.DisassociateProductFromPortfolioRequest(input)
	return out, req.Send()
}

// DisassociateProductFromPortfolioWithContext is the same as DisassociateProductFromPortfolio with the addition of
// the ability to pass a context and additional request options.
//
// See DisassociateProductFromPortfolio for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ServiceCatalog) DisassociateProductFromPortfolioWithContext(ctx aws.Context, input *DisassociateProductFromPortfolioInput, opts ...request.Option) (*DisassociateProductFromPortfolioOutput, error) {
	req, out := c.DisassociateProductFromPortfolioRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListAcceptedPortfolioShares = "ListAcceptedPortfolioShares"

// ListAcceptedPortfolioSharesRequest generates a "aws/request.Request" representing the
// client's request for the ListAcceptedPortfolioShares operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ListAcceptedPortfolioShares for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ListAcceptedPortfolioShares method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ListAcceptedPortfolioSharesRequest method.
//    req, resp := client.ListAcceptedPortfolioSharesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListAcceptedPortfolioShares
func (c *ServiceCatalog) ListAcceptedPortfolioSharesRequest(input *ListAcceptedPortfolioSharesInput) (req *request.Request, output *ListAcceptedPortfolioSharesOutput) {
	op := &request.Operation{
		Name:       opListAcceptedPortfolioShares,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListAcceptedPortfolioSharesInput{}
	}

	output = &ListAcceptedPortfolioSharesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListAcceptedPortfolioShares API operation for AWS Service Catalog.
//
// Lists details of all portfolios for which sharing was accepted by this account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Service Catalog's
// API operation ListAcceptedPortfolioShares for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidParametersException "InvalidParametersException"
//   One or more parameters provided to the operation are invalid.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListAcceptedPortfolioShares
func (c *ServiceCatalog) ListAcceptedPortfolioShares(input *ListAcceptedPortfolioSharesInput) (*ListAcceptedPortfolioSharesOutput, error) {
	req, out := c.ListAcceptedPortfolioSharesRequest(input)
	return out, req.Send()
}

// ListAcceptedPortfolioSharesWithContext is the same as ListAcceptedPortfolioShares with the addition of
// the ability to pass a context and additional request options.
//
// See ListAcceptedPortfolioShares for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ServiceCatalog) ListAcceptedPortfolioSharesWithContext(ctx aws.Context, input *ListAcceptedPortfolioSharesInput, opts ...request.Option) (*ListAcceptedPortfolioSharesOutput, error) {
	req, out := c.ListAcceptedPortfolioSharesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListConstraintsForPortfolio = "ListConstraintsForPortfolio"

// ListConstraintsForPortfolioRequest generates a "aws/request.Request" representing the
// client's request for the ListConstraintsForPortfolio operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ListConstraintsForPortfolio for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ListConstraintsForPortfolio method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ListConstraintsForPortfolioRequest method.
//    req, resp := client.ListConstraintsForPortfolioRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListConstraintsForPortfolio
func (c *ServiceCatalog) ListConstraintsForPortfolioRequest(input *ListConstraintsForPortfolioInput) (req *request.Request, output *ListConstraintsForPortfolioOutput) {
	op := &request.Operation{
		Name:       opListConstraintsForPortfolio,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListConstraintsForPortfolioInput{}
	}

	output = &ListConstraintsForPortfolioOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListConstraintsForPortfolio API operation for AWS Service Catalog.
//
// Retrieves detailed constraint information for the specified portfolio and
// product.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Service Catalog's
// API operation ListConstraintsForPortfolio for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource was not found.
//
//   * ErrCodeInvalidParametersException "InvalidParametersException"
//   One or more parameters provided to the operation are invalid.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListConstraintsForPortfolio
func (c *ServiceCatalog) ListConstraintsForPortfolio(input *ListConstraintsForPortfolioInput) (*ListConstraintsForPortfolioOutput, error) {
	req, out := c.ListConstraintsForPortfolioRequest(input)
	return out, req.Send()
}

// ListConstraintsForPortfolioWithContext is the same as ListConstraintsForPortfolio with the addition of
// the ability to pass a context and additional request options.
//
// See ListConstraintsForPortfolio for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ServiceCatalog) ListConstraintsForPortfolioWithContext(ctx aws.Context, input *ListConstraintsForPortfolioInput, opts ...request.Option) (*ListConstraintsForPortfolioOutput, error) {
	req, out := c.ListConstraintsForPortfolioRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListLaunchPaths = "ListLaunchPaths"

// ListLaunchPathsRequest generates a "aws/request.Request" representing the
// client's request for the ListLaunchPaths operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ListLaunchPaths for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ListLaunchPaths method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ListLaunchPathsRequest method.
//    req, resp := client.ListLaunchPathsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListLaunchPaths
func (c *ServiceCatalog) ListLaunchPathsRequest(input *ListLaunchPathsInput) (req *request.Request, output *ListLaunchPathsOutput) {
	op := &request.Operation{
		Name:       opListLaunchPaths,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListLaunchPathsInput{}
	}

	output = &ListLaunchPathsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListLaunchPaths API operation for AWS Service Catalog.
//
// Returns a paginated list of all paths to a specified product. A path is how
// the user has access to a specified product, and is necessary when provisioning
// a product. A path also determines the constraints put on the product.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Service Catalog's
// API operation ListLaunchPaths for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidParametersException "InvalidParametersException"
//   One or more parameters provided to the operation are invalid.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource was not found.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListLaunchPaths
func (c *ServiceCatalog) ListLaunchPaths(input *ListLaunchPathsInput) (*ListLaunchPathsOutput, error) {
	req, out := c.ListLaunchPathsRequest(input)
	return out, req.Send()
}

// ListLaunchPathsWithContext is the same as ListLaunchPaths with the addition of
// the ability to pass a context and additional request options.
//
// See ListLaunchPaths for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ServiceCatalog) ListLaunchPathsWithContext(ctx aws.Context, input *ListLaunchPathsInput, opts ...request.Option) (*ListLaunchPathsOutput, error) {
	req, out := c.ListLaunchPathsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListPortfolioAccess = "ListPortfolioAccess"

// ListPortfolioAccessRequest generates a "aws/request.Request" representing the
// client's request for the ListPortfolioAccess operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ListPortfolioAccess for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ListPortfolioAccess method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ListPortfolioAccessRequest method.
//    req, resp := client.ListPortfolioAccessRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListPortfolioAccess
func (c *ServiceCatalog) ListPortfolioAccessRequest(input *ListPortfolioAccessInput) (req *request.Request, output *ListPortfolioAccessOutput) {
	op := &request.Operation{
		Name:       opListPortfolioAccess,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListPortfolioAccessInput{}
	}

	output = &ListPortfolioAccessOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListPortfolioAccess API operation for AWS Service Catalog.
//
// Lists the account IDs that have been authorized sharing of the specified
// portfolio.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Service Catalog's
// API operation ListPortfolioAccess for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource was not found.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListPortfolioAccess
func (c *ServiceCatalog) ListPortfolioAccess(input *ListPortfolioAccessInput) (*ListPortfolioAccessOutput, error) {
	req, out := c.ListPortfolioAccessRequest(input)
	return out, req.Send()
}

// ListPortfolioAccessWithContext is the same as ListPortfolioAccess with the addition of
// the ability to pass a context and additional request options.
//
// See ListPortfolioAccess for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ServiceCatalog) ListPortfolioAccessWithContext(ctx aws.Context, input *ListPortfolioAccessInput, opts ...request.Option) (*ListPortfolioAccessOutput, error) {
	req, out := c.ListPortfolioAccessRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListPortfolios = "ListPortfolios"

// ListPortfoliosRequest generates a "aws/request.Request" representing the
// client's request for the ListPortfolios operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ListPortfolios for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ListPortfolios method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ListPortfoliosRequest method.
//    req, resp := client.ListPortfoliosRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListPortfolios
func (c *ServiceCatalog) ListPortfoliosRequest(input *ListPortfoliosInput) (req *request.Request, output *ListPortfoliosOutput) {
	op := &request.Operation{
		Name:       opListPortfolios,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListPortfoliosInput{}
	}

	output = &ListPortfoliosOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListPortfolios API operation for AWS Service Catalog.
//
// Lists all portfolios in the catalog.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Service Catalog's
// API operation ListPortfolios for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidParametersException "InvalidParametersException"
//   One or more parameters provided to the operation are invalid.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListPortfolios
func (c *ServiceCatalog) ListPortfolios(input *ListPortfoliosInput) (*ListPortfoliosOutput, error) {
	req, out := c.ListPortfoliosRequest(input)
	return out, req.Send()
}

// ListPortfoliosWithContext is the same as ListPortfolios with the addition of
// the ability to pass a context and additional request options.
//
// See ListPortfolios for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ServiceCatalog) ListPortfoliosWithContext(ctx aws.Context, input *ListPortfoliosInput, opts ...request.Option) (*ListPortfoliosOutput, error) {
	req, out := c.ListPortfoliosRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListPortfoliosForProduct = "ListPortfoliosForProduct"

// ListPortfoliosForProductRequest generates a "aws/request.Request" representing the
// client's request for the ListPortfoliosForProduct operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ListPortfoliosForProduct for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ListPortfoliosForProduct method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ListPortfoliosForProductRequest method.
//    req, resp := client.ListPortfoliosForProductRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListPortfoliosForProduct
func (c *ServiceCatalog) ListPortfoliosForProductRequest(input *ListPortfoliosForProductInput) (req *request.Request, output *ListPortfoliosForProductOutput) {
	op := &request.Operation{
		Name:       opListPortfoliosForProduct,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListPortfoliosForProductInput{}
	}

	output = &ListPortfoliosForProductOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListPortfoliosForProduct API operation for AWS Service Catalog.
//
// Lists all portfolios that the specified product is associated with.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Service Catalog's
// API operation ListPortfoliosForProduct for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidParametersException "InvalidParametersException"
//   One or more parameters provided to the operation are invalid.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource was not found.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListPortfoliosForProduct
func (c *ServiceCatalog) ListPortfoliosForProduct(input *ListPortfoliosForProductInput) (*ListPortfoliosForProductOutput, error) {
	req, out := c.ListPortfoliosForProductRequest(input)
	return out, req.Send()
}

// ListPortfoliosForProductWithContext is the same as ListPortfoliosForProduct with the addition of
// the ability to pass a context and additional request options.
//
// See ListPortfoliosForProduct for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ServiceCatalog) ListPortfoliosForProductWithContext(ctx aws.Context, input *ListPortfoliosForProductInput, opts ...request.Option) (*ListPortfoliosForProductOutput, error) {
	req, out := c.ListPortfoliosForProductRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListPrincipalsForPortfolio = "ListPrincipalsForPortfolio"

// ListPrincipalsForPortfolioRequest generates a "aws/request.Request" representing the
// client's request for the ListPrincipalsForPortfolio operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ListPrincipalsForPortfolio for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ListPrincipalsForPortfolio method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ListPrincipalsForPortfolioRequest method.
//    req, resp := client.ListPrincipalsForPortfolioRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListPrincipalsForPortfolio
func (c *ServiceCatalog) ListPrincipalsForPortfolioRequest(input *ListPrincipalsForPortfolioInput) (req *request.Request, output *ListPrincipalsForPortfolioOutput) {
	op := &request.Operation{
		Name:       opListPrincipalsForPortfolio,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListPrincipalsForPortfolioInput{}
	}

	output = &ListPrincipalsForPortfolioOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListPrincipalsForPortfolio API operation for AWS Service Catalog.
//
// Lists all principal ARNs associated with the specified portfolio.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Service Catalog's
// API operation ListPrincipalsForPortfolio for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource was not found.
//
//   * ErrCodeInvalidParametersException "InvalidParametersException"
//   One or more parameters provided to the operation are invalid.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListPrincipalsForPortfolio
func (c *ServiceCatalog) ListPrincipalsForPortfolio(input *ListPrincipalsForPortfolioInput) (*ListPrincipalsForPortfolioOutput, error) {
	req, out := c.ListPrincipalsForPortfolioRequest(input)
	return out, req.Send()
}

// ListPrincipalsForPortfolioWithContext is the same as ListPrincipalsForPortfolio with the addition of
// the ability to pass a context and additional request options.
//
// See ListPrincipalsForPortfolio for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ServiceCatalog) ListPrincipalsForPortfolioWithContext(ctx aws.Context, input *ListPrincipalsForPortfolioInput, opts ...request.Option) (*ListPrincipalsForPortfolioOutput, error) {
	req, out := c.ListPrincipalsForPortfolioRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListProvisioningArtifacts = "ListProvisioningArtifacts"

// ListProvisioningArtifactsRequest generates a "aws/request.Request" representing the
// client's request for the ListProvisioningArtifacts operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ListProvisioningArtifacts for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ListProvisioningArtifacts method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ListProvisioningArtifactsRequest method.
//    req, resp := client.ListProvisioningArtifactsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListProvisioningArtifacts
func (c *ServiceCatalog) ListProvisioningArtifactsRequest(input *ListProvisioningArtifactsInput) (req *request.Request, output *ListProvisioningArtifactsOutput) {
	op := &request.Operation{
		Name:       opListProvisioningArtifacts,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListProvisioningArtifactsInput{}
	}

	output = &ListProvisioningArtifactsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListProvisioningArtifacts API operation for AWS Service Catalog.
//
// Lists all provisioning artifacts associated with the specified product.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Service Catalog's
// API operation ListProvisioningArtifacts for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource was not found.
//
//   * ErrCodeInvalidParametersException "InvalidParametersException"
//   One or more parameters provided to the operation are invalid.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListProvisioningArtifacts
func (c *ServiceCatalog) ListProvisioningArtifacts(input *ListProvisioningArtifactsInput) (*ListProvisioningArtifactsOutput, error) {
	req, out := c.ListProvisioningArtifactsRequest(input)
	return out, req.Send()
}

// ListProvisioningArtifactsWithContext is the same as ListProvisioningArtifacts with the addition of
// the ability to pass a context and additional request options.
//
// See ListProvisioningArtifacts for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ServiceCatalog) ListProvisioningArtifactsWithContext(ctx aws.Context, input *ListProvisioningArtifactsInput, opts ...request.Option) (*ListProvisioningArtifactsOutput, error) {
	req, out := c.ListProvisioningArtifactsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListRecordHistory = "ListRecordHistory"

// ListRecordHistoryRequest generates a "aws/request.Request" representing the
// client's request for the ListRecordHistory operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ListRecordHistory for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ListRecordHistory method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ListRecordHistoryRequest method.
//    req, resp := client.ListRecordHistoryRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListRecordHistory
func (c *ServiceCatalog) ListRecordHistoryRequest(input *ListRecordHistoryInput) (req *request.Request, output *ListRecordHistoryOutput) {
	op := &request.Operation{
		Name:       opListRecordHistory,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListRecordHistoryInput{}
	}

	output = &ListRecordHistoryOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListRecordHistory API operation for AWS Service Catalog.
//
// Returns a paginated list of all performed requests, in the form of RecordDetails
// objects that are filtered as specified.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Service Catalog's
// API operation ListRecordHistory for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidParametersException "InvalidParametersException"
//   One or more parameters provided to the operation are invalid.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListRecordHistory
func (c *ServiceCatalog) ListRecordHistory(input *ListRecordHistoryInput) (*ListRecordHistoryOutput, error) {
	req, out := c.ListRecordHistoryRequest(input)
	return out, req.Send()
}

// ListRecordHistoryWithContext is the same as ListRecordHistory with the addition of
// the ability to pass a context and additional request options.
//
// See ListRecordHistory for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ServiceCatalog) ListRecordHistoryWithContext(ctx aws.Context, input *ListRecordHistoryInput, opts ...request.Option) (*ListRecordHistoryOutput, error) {
	req, out := c.ListRecordHistoryRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opProvisionProduct = "ProvisionProduct"

// ProvisionProductRequest generates a "aws/request.Request" representing the
// client's request for the ProvisionProduct operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ProvisionProduct for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ProvisionProduct method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ProvisionProductRequest method.
//    req, resp := client.ProvisionProductRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ProvisionProduct
func (c *ServiceCatalog) ProvisionProductRequest(input *ProvisionProductInput) (req *request.Request, output *ProvisionProductOutput) {
	op := &request.Operation{
		Name:       opProvisionProduct,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ProvisionProductInput{}
	}

	output = &ProvisionProductOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ProvisionProduct API operation for AWS Service Catalog.
//
// Requests a Provision of a specified product. A ProvisionedProduct is a resourced
// instance for a product. For example, provisioning a CloudFormation-template-backed
// product results in launching a CloudFormation stack and all the underlying
// resources that come with it.
//
// You can check the status of this request using the DescribeRecord operation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Service Catalog's
// API operation ProvisionProduct for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidParametersException "InvalidParametersException"
//   One or more parameters provided to the operation are invalid.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource was not found.
//
//   * ErrCodeDuplicateResourceException "DuplicateResourceException"
//   The specified resource is a duplicate.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ProvisionProduct
func (c *ServiceCatalog) ProvisionProduct(input *ProvisionProductInput) (*ProvisionProductOutput, error) {
	req, out := c.ProvisionProductRequest(input)
	return out, req.Send()
}

// ProvisionProductWithContext is the same as ProvisionProduct with the addition of
// the ability to pass a context and additional request options.
//
// See ProvisionProduct for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ServiceCatalog) ProvisionProductWithContext(ctx aws.Context, input *ProvisionProductInput, opts ...request.Option) (*ProvisionProductOutput, error) {
	req, out := c.ProvisionProductRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRejectPortfolioShare = "RejectPortfolioShare"

// RejectPortfolioShareRequest generates a "aws/request.Request" representing the
// client's request for the RejectPortfolioShare operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See RejectPortfolioShare for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the RejectPortfolioShare method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the RejectPortfolioShareRequest method.
//    req, resp := client.RejectPortfolioShareRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/RejectPortfolioShare
func (c *ServiceCatalog) RejectPortfolioShareRequest(input *RejectPortfolioShareInput) (req *request.Request, output *RejectPortfolioShareOutput) {
	op := &request.Operation{
		Name:       opRejectPortfolioShare,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RejectPortfolioShareInput{}
	}

	output = &RejectPortfolioShareOutput{}
	req = c.newRequest(op, input, output)
	return
}

// RejectPortfolioShare API operation for AWS Service Catalog.
//
// Rejects an offer to share a portfolio.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Service Catalog's
// API operation RejectPortfolioShare for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource was not found.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/RejectPortfolioShare
func (c *ServiceCatalog) RejectPortfolioShare(input *RejectPortfolioShareInput) (*RejectPortfolioShareOutput, error) {
	req, out := c.RejectPortfolioShareRequest(input)
	return out, req.Send()
}

// RejectPortfolioShareWithContext is the same as RejectPortfolioShare with the addition of
// the ability to pass a context and additional request options.
//
// See RejectPortfolioShare for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ServiceCatalog) RejectPortfolioShareWithContext(ctx aws.Context, input *RejectPortfolioShareInput, opts ...request.Option) (*RejectPortfolioShareOutput, error) {
	req, out := c.RejectPortfolioShareRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opScanProvisionedProducts = "ScanProvisionedProducts"

// ScanProvisionedProductsRequest generates a "aws/request.Request" representing the
// client's request for the ScanProvisionedProducts operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ScanProvisionedProducts for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ScanProvisionedProducts method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ScanProvisionedProductsRequest method.
//    req, resp := client.ScanProvisionedProductsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ScanProvisionedProducts
func (c *ServiceCatalog) ScanProvisionedProductsRequest(input *ScanProvisionedProductsInput) (req *request.Request, output *ScanProvisionedProductsOutput) {
	op := &request.Operation{
		Name:       opScanProvisionedProducts,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ScanProvisionedProductsInput{}
	}

	output = &ScanProvisionedProductsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ScanProvisionedProducts API operation for AWS Service Catalog.
//
// Returns a paginated list of all the ProvisionedProduct objects that are currently
// available (not terminated).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Service Catalog's
// API operation ScanProvisionedProducts for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidParametersException "InvalidParametersException"
//   One or more parameters provided to the operation are invalid.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ScanProvisionedProducts
func (c *ServiceCatalog) ScanProvisionedProducts(input *ScanProvisionedProductsInput) (*ScanProvisionedProductsOutput, error) {
	req, out := c.ScanProvisionedProductsRequest(input)
	return out, req.Send()
}

// ScanProvisionedProductsWithContext is the same as ScanProvisionedProducts with the addition of
// the ability to pass a context and additional request options.
//
// See ScanProvisionedProducts for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ServiceCatalog) ScanProvisionedProductsWithContext(ctx aws.Context, input *ScanProvisionedProductsInput, opts ...request.Option) (*ScanProvisionedProductsOutput, error) {
	req, out := c.ScanProvisionedProductsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opSearchProducts = "SearchProducts"

// SearchProductsRequest generates a "aws/request.Request" representing the
// client's request for the SearchProducts operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See SearchProducts for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the SearchProducts method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the SearchProductsRequest method.
//    req, resp := client.SearchProductsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/SearchProducts
func (c *ServiceCatalog) SearchProductsRequest(input *SearchProductsInput) (req *request.Request, output *SearchProductsOutput) {
	op := &request.Operation{
		Name:       opSearchProducts,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &SearchProductsInput{}
	}

	output = &SearchProductsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// SearchProducts API operation for AWS Service Catalog.
//
// Returns a paginated list all of the Products objects to which the caller
// has access.
//
// The output of this operation can be used as input for other operations, such
// as DescribeProductView.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Service Catalog's
// API operation SearchProducts for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidParametersException "InvalidParametersException"
//   One or more parameters provided to the operation are invalid.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/SearchProducts
func (c *ServiceCatalog) SearchProducts(input *SearchProductsInput) (*SearchProductsOutput, error) {
	req, out := c.SearchProductsRequest(input)
	return out, req.Send()
}

// SearchProductsWithContext is the same as SearchProducts with the addition of
// the ability to pass a context and additional request options.
//
// See SearchProducts for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ServiceCatalog) SearchProductsWithContext(ctx aws.Context, input *SearchProductsInput, opts ...request.Option) (*SearchProductsOutput, error) {
	req, out := c.SearchProductsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opSearchProductsAsAdmin = "SearchProductsAsAdmin"

// SearchProductsAsAdminRequest generates a "aws/request.Request" representing the
// client's request for the SearchProductsAsAdmin operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See SearchProductsAsAdmin for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the SearchProductsAsAdmin method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the SearchProductsAsAdminRequest method.
//    req, resp := client.SearchProductsAsAdminRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/SearchProductsAsAdmin
func (c *ServiceCatalog) SearchProductsAsAdminRequest(input *SearchProductsAsAdminInput) (req *request.Request, output *SearchProductsAsAdminOutput) {
	op := &request.Operation{
		Name:       opSearchProductsAsAdmin,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &SearchProductsAsAdminInput{}
	}

	output = &SearchProductsAsAdminOutput{}
	req = c.newRequest(op, input, output)
	return
}

// SearchProductsAsAdmin API operation for AWS Service Catalog.
//
// Retrieves summary and status information about all products created within
// the caller's account. If a portfolio ID is provided, this operation retrieves
// information for only those products that are associated with the specified
// portfolio.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Service Catalog's
// API operation SearchProductsAsAdmin for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource was not found.
//
//   * ErrCodeInvalidParametersException "InvalidParametersException"
//   One or more parameters provided to the operation are invalid.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/SearchProductsAsAdmin
func (c *ServiceCatalog) SearchProductsAsAdmin(input *SearchProductsAsAdminInput) (*SearchProductsAsAdminOutput, error) {
	req, out := c.SearchProductsAsAdminRequest(input)
	return out, req.Send()
}

// SearchProductsAsAdminWithContext is the same as SearchProductsAsAdmin with the addition of
// the ability to pass a context and additional request options.
//
// See SearchProductsAsAdmin for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ServiceCatalog) SearchProductsAsAdminWithContext(ctx aws.Context, input *SearchProductsAsAdminInput, opts ...request.Option) (*SearchProductsAsAdminOutput, error) {
	req, out := c.SearchProductsAsAdminRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTerminateProvisionedProduct = "TerminateProvisionedProduct"

// TerminateProvisionedProductRequest generates a "aws/request.Request" representing the
// client's request for the TerminateProvisionedProduct operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See TerminateProvisionedProduct for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the TerminateProvisionedProduct method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the TerminateProvisionedProductRequest method.
//    req, resp := client.TerminateProvisionedProductRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/TerminateProvisionedProduct
func (c *ServiceCatalog) TerminateProvisionedProductRequest(input *TerminateProvisionedProductInput) (req *request.Request, output *TerminateProvisionedProductOutput) {
	op := &request.Operation{
		Name:       opTerminateProvisionedProduct,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &TerminateProvisionedProductInput{}
	}

	output = &TerminateProvisionedProductOutput{}
	req = c.newRequest(op, input, output)
	return
}

// TerminateProvisionedProduct API operation for AWS Service Catalog.
//
// Requests termination of an existing ProvisionedProduct object. If there are
// Tags associated with the object, they are terminated when the ProvisionedProduct
// object is terminated.
//
// This operation does not delete any records associated with the ProvisionedProduct
// object.
//
// You can check the status of this request using the DescribeRecord operation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Service Catalog's
// API operation TerminateProvisionedProduct for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource was not found.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/TerminateProvisionedProduct
func (c *ServiceCatalog) TerminateProvisionedProduct(input *TerminateProvisionedProductInput) (*TerminateProvisionedProductOutput, error) {
	req, out := c.TerminateProvisionedProductRequest(input)
	return out, req.Send()
}

// TerminateProvisionedProductWithContext is the same as TerminateProvisionedProduct with the addition of
// the ability to pass a context and additional request options.
//
// See TerminateProvisionedProduct for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ServiceCatalog) TerminateProvisionedProductWithContext(ctx aws.Context, input *TerminateProvisionedProductInput, opts ...request.Option) (*TerminateProvisionedProductOutput, error) {
	req, out := c.TerminateProvisionedProductRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateConstraint = "UpdateConstraint"

// UpdateConstraintRequest generates a "aws/request.Request" representing the
// client's request for the UpdateConstraint operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See UpdateConstraint for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the UpdateConstraint method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the UpdateConstraintRequest method.
//    req, resp := client.UpdateConstraintRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/UpdateConstraint
func (c *ServiceCatalog) UpdateConstraintRequest(input *UpdateConstraintInput) (req *request.Request, output *UpdateConstraintOutput) {
	op := &request.Operation{
		Name:       opUpdateConstraint,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateConstraintInput{}
	}

	output = &UpdateConstraintOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateConstraint API operation for AWS Service Catalog.
//
// Updates an existing constraint.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Service Catalog's
// API operation UpdateConstraint for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource was not found.
//
//   * ErrCodeInvalidParametersException "InvalidParametersException"
//   One or more parameters provided to the operation are invalid.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/UpdateConstraint
func (c *ServiceCatalog) UpdateConstraint(input *UpdateConstraintInput) (*UpdateConstraintOutput, error) {
	req, out := c.UpdateConstraintRequest(input)
	return out, req.Send()
}

// UpdateConstraintWithContext is the same as UpdateConstraint with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateConstraint for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ServiceCatalog) UpdateConstraintWithContext(ctx aws.Context, input *UpdateConstraintInput, opts ...request.Option) (*UpdateConstraintOutput, error) {
	req, out := c.UpdateConstraintRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdatePortfolio = "UpdatePortfolio"

// UpdatePortfolioRequest generates a "aws/request.Request" representing the
// client's request for the UpdatePortfolio operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See UpdatePortfolio for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the UpdatePortfolio method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the UpdatePortfolioRequest method.
//    req, resp := client.UpdatePortfolioRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/UpdatePortfolio
func (c *ServiceCatalog) UpdatePortfolioRequest(input *UpdatePortfolioInput) (req *request.Request, output *UpdatePortfolioOutput) {
	op := &request.Operation{
		Name:       opUpdatePortfolio,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdatePortfolioInput{}
	}

	output = &UpdatePortfolioOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdatePortfolio API operation for AWS Service Catalog.
//
// Updates the specified portfolio's details. This operation will not work with
// a product that has been shared with you.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Service Catalog's
// API operation UpdatePortfolio for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidParametersException "InvalidParametersException"
//   One or more parameters provided to the operation are invalid.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource was not found.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   The current limits of the service would have been exceeded by this operation.
//   Reduce the resource use or increase the service limits and retry the operation.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/UpdatePortfolio
func (c *ServiceCatalog) UpdatePortfolio(input *UpdatePortfolioInput) (*UpdatePortfolioOutput, error) {
	req, out := c.UpdatePortfolioRequest(input)
	return out, req.Send()
}

// UpdatePortfolioWithContext is the same as UpdatePortfolio with the addition of
// the ability to pass a context and additional request options.
//
// See UpdatePortfolio for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ServiceCatalog) UpdatePortfolioWithContext(ctx aws.Context, input *UpdatePortfolioInput, opts ...request.Option) (*UpdatePortfolioOutput, error) {
	req, out := c.UpdatePortfolioRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateProduct = "UpdateProduct"

// UpdateProductRequest generates a "aws/request.Request" representing the
// client's request for the UpdateProduct operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See UpdateProduct for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the UpdateProduct method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the UpdateProductRequest method.
//    req, resp := client.UpdateProductRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/UpdateProduct
func (c *ServiceCatalog) UpdateProductRequest(input *UpdateProductInput) (req *request.Request, output *UpdateProductOutput) {
	op := &request.Operation{
		Name:       opUpdateProduct,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateProductInput{}
	}

	output = &UpdateProductOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateProduct API operation for AWS Service Catalog.
//
// Updates an existing product.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Service Catalog's
// API operation UpdateProduct for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource was not found.
//
//   * ErrCodeInvalidParametersException "InvalidParametersException"
//   One or more parameters provided to the operation are invalid.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/UpdateProduct
func (c *ServiceCatalog) UpdateProduct(input *UpdateProductInput) (*UpdateProductOutput, error) {
	req, out := c.UpdateProductRequest(input)
	return out, req.Send()
}

// UpdateProductWithContext is the same as UpdateProduct with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateProduct for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ServiceCatalog) UpdateProductWithContext(ctx aws.Context, input *UpdateProductInput, opts ...request.Option) (*UpdateProductOutput, error) {
	req, out := c.UpdateProductRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateProvisionedProduct = "UpdateProvisionedProduct"

// UpdateProvisionedProductRequest generates a "aws/request.Request" representing the
// client's request for the UpdateProvisionedProduct operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See UpdateProvisionedProduct for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the UpdateProvisionedProduct method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the UpdateProvisionedProductRequest method.
//    req, resp := client.UpdateProvisionedProductRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/UpdateProvisionedProduct
func (c *ServiceCatalog) UpdateProvisionedProductRequest(input *UpdateProvisionedProductInput) (req *request.Request, output *UpdateProvisionedProductOutput) {
	op := &request.Operation{
		Name:       opUpdateProvisionedProduct,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateProvisionedProductInput{}
	}

	output = &UpdateProvisionedProductOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateProvisionedProduct API operation for AWS Service Catalog.
//
// Requests updates to the configuration of an existing ProvisionedProduct object.
// If there are tags associated with the object, they cannot be updated or added
// with this operation. Depending on the specific updates requested, this operation
// may update with no interruption, with some interruption, or replace the ProvisionedProduct
// object entirely.
//
// You can check the status of this request using the DescribeRecord operation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Service Catalog's
// API operation UpdateProvisionedProduct for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidParametersException "InvalidParametersException"
//   One or more parameters provided to the operation are invalid.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource was not found.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/UpdateProvisionedProduct
func (c *ServiceCatalog) UpdateProvisionedProduct(input *UpdateProvisionedProductInput) (*UpdateProvisionedProductOutput, error) {
	req, out := c.UpdateProvisionedProductRequest(input)
	return out, req.Send()
}

// UpdateProvisionedProductWithContext is the same as UpdateProvisionedProduct with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateProvisionedProduct for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ServiceCatalog) UpdateProvisionedProductWithContext(ctx aws.Context, input *UpdateProvisionedProductInput, opts ...request.Option) (*UpdateProvisionedProductOutput, error) {
	req, out := c.UpdateProvisionedProductRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateProvisioningArtifact = "UpdateProvisioningArtifact"

// UpdateProvisioningArtifactRequest generates a "aws/request.Request" representing the
// client's request for the UpdateProvisioningArtifact operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See UpdateProvisioningArtifact for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the UpdateProvisioningArtifact method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the UpdateProvisioningArtifactRequest method.
//    req, resp := client.UpdateProvisioningArtifactRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/UpdateProvisioningArtifact
func (c *ServiceCatalog) UpdateProvisioningArtifactRequest(input *UpdateProvisioningArtifactInput) (req *request.Request, output *UpdateProvisioningArtifactOutput) {
	op := &request.Operation{
		Name:       opUpdateProvisioningArtifact,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateProvisioningArtifactInput{}
	}

	output = &UpdateProvisioningArtifactOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateProvisioningArtifact API operation for AWS Service Catalog.
//
// Updates an existing provisioning artifact's information. This operation will
// not work on a provisioning artifact associated with a product that has been
// shared with you.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Service Catalog's
// API operation UpdateProvisioningArtifact for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource was not found.
//
//   * ErrCodeInvalidParametersException "InvalidParametersException"
//   One or more parameters provided to the operation are invalid.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/UpdateProvisioningArtifact
func (c *ServiceCatalog) UpdateProvisioningArtifact(input *UpdateProvisioningArtifactInput) (*UpdateProvisioningArtifactOutput, error) {
	req, out := c.UpdateProvisioningArtifactRequest(input)
	return out, req.Send()
}

// UpdateProvisioningArtifactWithContext is the same as UpdateProvisioningArtifact with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateProvisioningArtifact for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ServiceCatalog) UpdateProvisioningArtifactWithContext(ctx aws.Context, input *UpdateProvisioningArtifactInput, opts ...request.Option) (*UpdateProvisioningArtifactOutput, error) {
	req, out := c.UpdateProvisioningArtifactRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/AcceptPortfolioShareInput
type AcceptPortfolioShareInput struct {
	_ struct{} `type:"structure"`

	// The language code to use for this operation. Supported language codes are
	// as follows:
	//
	// "en" (English)
	//
	// "jp" (Japanese)
	//
	// "zh" (Chinese)
	//
	// If no code is specified, "en" is used as the default.
	AcceptLanguage *string `type:"string"`

	// The portfolio identifier.
	//
	// PortfolioId is a required field
	PortfolioId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s AcceptPortfolioShareInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AcceptPortfolioShareInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AcceptPortfolioShareInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AcceptPortfolioShareInput"}
	if s.PortfolioId == nil {
		invalidParams.Add(request.NewErrParamRequired("PortfolioId"))
	}
	if s.PortfolioId != nil && len(*s.PortfolioId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PortfolioId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAcceptLanguage sets the AcceptLanguage field's value.
func (s *AcceptPortfolioShareInput) SetAcceptLanguage(v string) *AcceptPortfolioShareInput {
	s.AcceptLanguage = &v
	return s
}

// SetPortfolioId sets the PortfolioId field's value.
func (s *AcceptPortfolioShareInput) SetPortfolioId(v string) *AcceptPortfolioShareInput {
	s.PortfolioId = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/AcceptPortfolioShareOutput
type AcceptPortfolioShareOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s AcceptPortfolioShareOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AcceptPortfolioShareOutput) GoString() string {
	return s.String()
}

// The access level to limit results.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/AccessLevelFilter
type AccessLevelFilter struct {
	_ struct{} `type:"structure"`

	// Specifies the access level.
	//
	// Account allows results at the account level.
	//
	// Role allows results based on the federated role of the specified user.
	//
	// User allows results limited to the specified user.
	Key *string `type:"string" enum:"AccessLevelFilterKey"`

	// Specifies the user to which the access level applies. A value of Self is
	// currently supported.
	Value *string `type:"string"`
}

// String returns the string representation
func (s AccessLevelFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AccessLevelFilter) GoString() string {
	return s.String()
}

// SetKey sets the Key field's value.
func (s *AccessLevelFilter) SetKey(v string) *AccessLevelFilter {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *AccessLevelFilter) SetValue(v string) *AccessLevelFilter {
	s.Value = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/AssociatePrincipalWithPortfolioInput
type AssociatePrincipalWithPortfolioInput struct {
	_ struct{} `type:"structure"`

	// The language code to use for this operation. Supported language codes are
	// as follows:
	//
	// "en" (English)
	//
	// "jp" (Japanese)
	//
	// "zh" (Chinese)
	//
	// If no code is specified, "en" is used as the default.
	AcceptLanguage *string `type:"string"`

	// The portfolio identifier.
	//
	// PortfolioId is a required field
	PortfolioId *string `min:"1" type:"string" required:"true"`

	// The ARN representing the principal (IAM user, role, or group).
	//
	// PrincipalARN is a required field
	PrincipalARN *string `min:"1" type:"string" required:"true"`

	// The principal type. Must be IAM
	//
	// PrincipalType is a required field
	PrincipalType *string `type:"string" required:"true" enum:"PrincipalType"`
}

// String returns the string representation
func (s AssociatePrincipalWithPortfolioInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AssociatePrincipalWithPortfolioInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssociatePrincipalWithPortfolioInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AssociatePrincipalWithPortfolioInput"}
	if s.PortfolioId == nil {
		invalidParams.Add(request.NewErrParamRequired("PortfolioId"))
	}
	if s.PortfolioId != nil && len(*s.PortfolioId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PortfolioId", 1))
	}
	if s.PrincipalARN == nil {
		invalidParams.Add(request.NewErrParamRequired("PrincipalARN"))
	}
	if s.PrincipalARN != nil && len(*s.PrincipalARN) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PrincipalARN", 1))
	}
	if s.PrincipalType == nil {
		invalidParams.Add(request.NewErrParamRequired("PrincipalType"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAcceptLanguage sets the AcceptLanguage field's value.
func (s *AssociatePrincipalWithPortfolioInput) SetAcceptLanguage(v string) *AssociatePrincipalWithPortfolioInput {
	s.AcceptLanguage = &v
	return s
}

// SetPortfolioId sets the PortfolioId field's value.
func (s *AssociatePrincipalWithPortfolioInput) SetPortfolioId(v string) *AssociatePrincipalWithPortfolioInput {
	s.PortfolioId = &v
	return s
}

// SetPrincipalARN sets the PrincipalARN field's value.
func (s *AssociatePrincipalWithPortfolioInput) SetPrincipalARN(v string) *AssociatePrincipalWithPortfolioInput {
	s.PrincipalARN = &v
	return s
}

// SetPrincipalType sets the PrincipalType field's value.
func (s *AssociatePrincipalWithPortfolioInput) SetPrincipalType(v string) *AssociatePrincipalWithPortfolioInput {
	s.PrincipalType = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/AssociatePrincipalWithPortfolioOutput
type AssociatePrincipalWithPortfolioOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s AssociatePrincipalWithPortfolioOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AssociatePrincipalWithPortfolioOutput) GoString() string {
	return s.String()
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/AssociateProductWithPortfolioInput
type AssociateProductWithPortfolioInput struct {
	_ struct{} `type:"structure"`

	// The language code to use for this operation. Supported language codes are
	// as follows:
	//
	// "en" (English)
	//
	// "jp" (Japanese)
	//
	// "zh" (Chinese)
	//
	// If no code is specified, "en" is used as the default.
	AcceptLanguage *string `type:"string"`

	// The portfolio identifier.
	//
	// PortfolioId is a required field
	PortfolioId *string `min:"1" type:"string" required:"true"`

	// The product identifier.
	//
	// ProductId is a required field
	ProductId *string `min:"1" type:"string" required:"true"`

	// The identifier of the source portfolio to use with this association.
	SourcePortfolioId *string `min:"1" type:"string"`
}

// String returns the string representation
func (s AssociateProductWithPortfolioInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AssociateProductWithPortfolioInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssociateProductWithPortfolioInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AssociateProductWithPortfolioInput"}
	if s.PortfolioId == nil {
		invalidParams.Add(request.NewErrParamRequired("PortfolioId"))
	}
	if s.PortfolioId != nil && len(*s.PortfolioId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PortfolioId", 1))
	}
	if s.ProductId == nil {
		invalidParams.Add(request.NewErrParamRequired("ProductId"))
	}
	if s.ProductId != nil && len(*s.ProductId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ProductId", 1))
	}
	if s.SourcePortfolioId != nil && len(*s.SourcePortfolioId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SourcePortfolioId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAcceptLanguage sets the AcceptLanguage field's value.
func (s *AssociateProductWithPortfolioInput) SetAcceptLanguage(v string) *AssociateProductWithPortfolioInput {
	s.AcceptLanguage = &v
	return s
}

// SetPortfolioId sets the PortfolioId field's value.
func (s *AssociateProductWithPortfolioInput) SetPortfolioId(v string) *AssociateProductWithPortfolioInput {
	s.PortfolioId = &v
	return s
}

// SetProductId sets the ProductId field's value.
func (s *AssociateProductWithPortfolioInput) SetProductId(v string) *AssociateProductWithPortfolioInput {
	s.ProductId = &v
	return s
}

// SetSourcePortfolioId sets the SourcePortfolioId field's value.
func (s *AssociateProductWithPortfolioInput) SetSourcePortfolioId(v string) *AssociateProductWithPortfolioInput {
	s.SourcePortfolioId = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/AssociateProductWithPortfolioOutput
type AssociateProductWithPortfolioOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s AssociateProductWithPortfolioOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AssociateProductWithPortfolioOutput) GoString() string {
	return s.String()
}

// Detailed constraint information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ConstraintDetail
type ConstraintDetail struct {
	_ struct{} `type:"structure"`

	// The identifier of the constraint.
	ConstraintId *string `min:"1" type:"string"`

	// The text description of the constraint.
	Description *string `type:"string"`

	// The owner of the constraint.
	Owner *string `type:"string"`

	// The type of the constraint.
	Type *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ConstraintDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ConstraintDetail) GoString() string {
	return s.String()
}

// SetConstraintId sets the ConstraintId field's value.
func (s *ConstraintDetail) SetConstraintId(v string) *ConstraintDetail {
	s.ConstraintId = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *ConstraintDetail) SetDescription(v string) *ConstraintDetail {
	s.Description = &v
	return s
}

// SetOwner sets the Owner field's value.
func (s *ConstraintDetail) SetOwner(v string) *ConstraintDetail {
	s.Owner = &v
	return s
}

// SetType sets the Type field's value.
func (s *ConstraintDetail) SetType(v string) *ConstraintDetail {
	s.Type = &v
	return s
}

// An administrator-specified constraint to apply when provisioning a product.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ConstraintSummary
type ConstraintSummary struct {
	_ struct{} `type:"structure"`

	// The text description of the constraint.
	Description *string `type:"string"`

	// The type of the constraint.
	Type *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ConstraintSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ConstraintSummary) GoString() string {
	return s.String()
}

// SetDescription sets the Description field's value.
func (s *ConstraintSummary) SetDescription(v string) *ConstraintSummary {
	s.Description = &v
	return s
}

// SetType sets the Type field's value.
func (s *ConstraintSummary) SetType(v string) *ConstraintSummary {
	s.Type = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/CreateConstraintInput
type CreateConstraintInput struct {
	_ struct{} `type:"structure"`

	// The language code to use for this operation. Supported language codes are
	// as follows:
	//
	// "en" (English)
	//
	// "jp" (Japanese)
	//
	// "zh" (Chinese)
	//
	// If no code is specified, "en" is used as the default.
	AcceptLanguage *string `type:"string"`

	// The text description of the constraint.
	Description *string `type:"string"`

	// A token to disambiguate duplicate requests. You can create multiple resources
	// using the same input in multiple requests, provided that you also specify
	// a different idempotency token for each request.
	//
	// IdempotencyToken is a required field
	IdempotencyToken *string `min:"1" type:"string" required:"true" idempotencyToken:"true"`

	// The constraint parameters.
	//
	// Parameters is a required field
	Parameters *string `type:"string" required:"true"`

	// The portfolio identifier.
	//
	// PortfolioId is a required field
	PortfolioId *string `min:"1" type:"string" required:"true"`

	// The product identifier.
	//
	// ProductId is a required field
	ProductId *string `min:"1" type:"string" required:"true"`

	// The type of the constraint.
	//
	// Type is a required field
	Type *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateConstraintInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateConstraintInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateConstraintInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateConstraintInput"}
	if s.IdempotencyToken == nil {
		invalidParams.Add(request.NewErrParamRequired("IdempotencyToken"))
	}
	if s.IdempotencyToken != nil && len(*s.IdempotencyToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("IdempotencyToken", 1))
	}
	if s.Parameters == nil {
		invalidParams.Add(request.NewErrParamRequired("Parameters"))
	}
	if s.PortfolioId == nil {
		invalidParams.Add(request.NewErrParamRequired("PortfolioId"))
	}
	if s.PortfolioId != nil && len(*s.PortfolioId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PortfolioId", 1))
	}
	if s.ProductId == nil {
		invalidParams.Add(request.NewErrParamRequired("ProductId"))
	}
	if s.ProductId != nil && len(*s.ProductId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ProductId", 1))
	}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}
	if s.Type != nil && len(*s.Type) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Type", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAcceptLanguage sets the AcceptLanguage field's value.
func (s *CreateConstraintInput) SetAcceptLanguage(v string) *CreateConstraintInput {
	s.AcceptLanguage = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateConstraintInput) SetDescription(v string) *CreateConstraintInput {
	s.Description = &v
	return s
}

// SetIdempotencyToken sets the IdempotencyToken field's value.
func (s *CreateConstraintInput) SetIdempotencyToken(v string) *CreateConstraintInput {
	s.IdempotencyToken = &v
	return s
}

// SetParameters sets the Parameters field's value.
func (s *CreateConstraintInput) SetParameters(v string) *CreateConstraintInput {
	s.Parameters = &v
	return s
}

// SetPortfolioId sets the PortfolioId field's value.
func (s *CreateConstraintInput) SetPortfolioId(v string) *CreateConstraintInput {
	s.PortfolioId = &v
	return s
}

// SetProductId sets the ProductId field's value.
func (s *CreateConstraintInput) SetProductId(v string) *CreateConstraintInput {
	s.ProductId = &v
	return s
}

// SetType sets the Type field's value.
func (s *CreateConstraintInput) SetType(v string) *CreateConstraintInput {
	s.Type = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/CreateConstraintOutput
type CreateConstraintOutput struct {
	_ struct{} `type:"structure"`

	// The resulting detailed constraint information.
	ConstraintDetail *ConstraintDetail `type:"structure"`

	// The resulting constraint parameters.
	ConstraintParameters *string `type:"string"`

	// The status of the current request.
	Status *string `type:"string" enum:"Status"`
}

// String returns the string representation
func (s CreateConstraintOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateConstraintOutput) GoString() string {
	return s.String()
}

// SetConstraintDetail sets the ConstraintDetail field's value.
func (s *CreateConstraintOutput) SetConstraintDetail(v *ConstraintDetail) *CreateConstraintOutput {
	s.ConstraintDetail = v
	return s
}

// SetConstraintParameters sets the ConstraintParameters field's value.
func (s *CreateConstraintOutput) SetConstraintParameters(v string) *CreateConstraintOutput {
	s.ConstraintParameters = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *CreateConstraintOutput) SetStatus(v string) *CreateConstraintOutput {
	s.Status = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/CreatePortfolioInput
type CreatePortfolioInput struct {
	_ struct{} `type:"structure"`

	// The language code to use for this operation. Supported language codes are
	// as follows:
	//
	// "en" (English)
	//
	// "jp" (Japanese)
	//
	// "zh" (Chinese)
	//
	// If no code is specified, "en" is used as the default.
	AcceptLanguage *string `type:"string"`

	// The text description of the portfolio.
	Description *string `type:"string"`

	// The name to use for display purposes.
	//
	// DisplayName is a required field
	DisplayName *string `min:"1" type:"string" required:"true"`

	// A token to disambiguate duplicate requests. You can create multiple resources
	// using the same input in multiple requests, provided that you also specify
	// a different idempotency token for each request.
	//
	// IdempotencyToken is a required field
	IdempotencyToken *string `min:"1" type:"string" required:"true" idempotencyToken:"true"`

	// The name of the portfolio provider.
	//
	// ProviderName is a required field
	ProviderName *string `min:"1" type:"string" required:"true"`

	// Tags to associate with the new portfolio.
	Tags []*Tag `type:"list"`
}

// String returns the string representation
func (s CreatePortfolioInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreatePortfolioInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreatePortfolioInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreatePortfolioInput"}
	if s.DisplayName == nil {
		invalidParams.Add(request.NewErrParamRequired("DisplayName"))
	}
	if s.DisplayName != nil && len(*s.DisplayName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DisplayName", 1))
	}
	if s.IdempotencyToken == nil {
		invalidParams.Add(request.NewErrParamRequired("IdempotencyToken"))
	}
	if s.IdempotencyToken != nil && len(*s.IdempotencyToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("IdempotencyToken", 1))
	}
	if s.ProviderName == nil {
		invalidParams.Add(request.NewErrParamRequired("ProviderName"))
	}
	if s.ProviderName != nil && len(*s.ProviderName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ProviderName", 1))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAcceptLanguage sets the AcceptLanguage field's value.
func (s *CreatePortfolioInput) SetAcceptLanguage(v string) *CreatePortfolioInput {
	s.AcceptLanguage = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreatePortfolioInput) SetDescription(v string) *CreatePortfolioInput {
	s.Description = &v
	return s
}

// SetDisplayName sets the DisplayName field's value.
func (s *CreatePortfolioInput) SetDisplayName(v string) *CreatePortfolioInput {
	s.DisplayName = &v
	return s
}

// SetIdempotencyToken sets the IdempotencyToken field's value.
func (s *CreatePortfolioInput) SetIdempotencyToken(v string) *CreatePortfolioInput {
	s.IdempotencyToken = &v
	return s
}

// SetProviderName sets the ProviderName field's value.
func (s *CreatePortfolioInput) SetProviderName(v string) *CreatePortfolioInput {
	s.ProviderName = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreatePortfolioInput) SetTags(v []*Tag) *CreatePortfolioInput {
	s.Tags = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/CreatePortfolioOutput
type CreatePortfolioOutput struct {
	_ struct{} `type:"structure"`

	// The resulting detailed portfolio information.
	PortfolioDetail *PortfolioDetail `type:"structure"`

	// Tags successfully associated with the new portfolio.
	Tags []*Tag `type:"list"`
}

// String returns the string representation
func (s CreatePortfolioOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreatePortfolioOutput) GoString() string {
	return s.String()
}

// SetPortfolioDetail sets the PortfolioDetail field's value.
func (s *CreatePortfolioOutput) SetPortfolioDetail(v *PortfolioDetail) *CreatePortfolioOutput {
	s.PortfolioDetail = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreatePortfolioOutput) SetTags(v []*Tag) *CreatePortfolioOutput {
	s.Tags = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/CreatePortfolioShareInput
type CreatePortfolioShareInput struct {
	_ struct{} `type:"structure"`

	// The language code to use for this operation. Supported language codes are
	// as follows:
	//
	// "en" (English)
	//
	// "jp" (Japanese)
	//
	// "zh" (Chinese)
	//
	// If no code is specified, "en" is used as the default.
	AcceptLanguage *string `type:"string"`

	// The account ID with which to share the portfolio.
	//
	// AccountId is a required field
	AccountId *string `type:"string" required:"true"`

	// The portfolio identifier.
	//
	// PortfolioId is a required field
	PortfolioId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CreatePortfolioShareInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreatePortfolioShareInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreatePortfolioShareInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreatePortfolioShareInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.PortfolioId == nil {
		invalidParams.Add(request.NewErrParamRequired("PortfolioId"))
	}
	if s.PortfolioId != nil && len(*s.PortfolioId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PortfolioId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAcceptLanguage sets the AcceptLanguage field's value.
func (s *CreatePortfolioShareInput) SetAcceptLanguage(v string) *CreatePortfolioShareInput {
	s.AcceptLanguage = &v
	return s
}

// SetAccountId sets the AccountId field's value.
func (s *CreatePortfolioShareInput) SetAccountId(v string) *CreatePortfolioShareInput {
	s.AccountId = &v
	return s
}

// SetPortfolioId sets the PortfolioId field's value.
func (s *CreatePortfolioShareInput) SetPortfolioId(v string) *CreatePortfolioShareInput {
	s.PortfolioId = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/CreatePortfolioShareOutput
type CreatePortfolioShareOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s CreatePortfolioShareOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreatePortfolioShareOutput) GoString() string {
	return s.String()
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/CreateProductInput
type CreateProductInput struct {
	_ struct{} `type:"structure"`

	// The language code to use for this operation. Supported language codes are
	// as follows:
	//
	// "en" (English)
	//
	// "jp" (Japanese)
	//
	// "zh" (Chinese)
	//
	// If no code is specified, "en" is used as the default.
	AcceptLanguage *string `type:"string"`

	// The text description of the product.
	Description *string `type:"string"`

	// The distributor of the product.
	Distributor *string `type:"string"`

	// A token to disambiguate duplicate requests. You can create multiple resources
	// using the same input in multiple requests, provided that you also specify
	// a different idempotency token for each request.
	//
	// IdempotencyToken is a required field
	IdempotencyToken *string `min:"1" type:"string" required:"true" idempotencyToken:"true"`

	// The name of the product.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`

	// The owner of the product.
	//
	// Owner is a required field
	Owner *string `type:"string" required:"true"`

	// The type of the product to create.
	//
	// ProductType is a required field
	ProductType *string `type:"string" required:"true" enum:"ProductType"`

	// Parameters for the provisioning artifact.
	//
	// ProvisioningArtifactParameters is a required field
	ProvisioningArtifactParameters *ProvisioningArtifactProperties `type:"structure" required:"true"`

	// Support information about the product.
	SupportDescription *string `type:"string"`

	// Contact email for product support.
	SupportEmail *string `type:"string"`

	// Contact URL for product support.
	SupportUrl *string `type:"string"`

	// Tags to associate with the new product.
	Tags []*Tag `type:"list"`
}

// String returns the string representation
func (s CreateProductInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateProductInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateProductInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateProductInput"}
	if s.IdempotencyToken == nil {
		invalidParams.Add(request.NewErrParamRequired("IdempotencyToken"))
	}
	if s.IdempotencyToken != nil && len(*s.IdempotencyToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("IdempotencyToken", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Owner == nil {
		invalidParams.Add(request.NewErrParamRequired("Owner"))
	}
	if s.ProductType == nil {
		invalidParams.Add(request.NewErrParamRequired("ProductType"))
	}
	if s.ProvisioningArtifactParameters == nil {
		invalidParams.Add(request.NewErrParamRequired("ProvisioningArtifactParameters"))
	}
	if s.ProvisioningArtifactParameters != nil {
		if err := s.ProvisioningArtifactParameters.Validate(); err != nil {
			invalidParams.AddNested("ProvisioningArtifactParameters", err.(request.ErrInvalidParams))
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAcceptLanguage sets the AcceptLanguage field's value.
func (s *CreateProductInput) SetAcceptLanguage(v string) *CreateProductInput {
	s.AcceptLanguage = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateProductInput) SetDescription(v string) *CreateProductInput {
	s.Description = &v
	return s
}

// SetDistributor sets the Distributor field's value.
func (s *CreateProductInput) SetDistributor(v string) *CreateProductInput {
	s.Distributor = &v
	return s
}

// SetIdempotencyToken sets the IdempotencyToken field's value.
func (s *CreateProductInput) SetIdempotencyToken(v string) *CreateProductInput {
	s.IdempotencyToken = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateProductInput) SetName(v string) *CreateProductInput {
	s.Name = &v
	return s
}

// SetOwner sets the Owner field's value.
func (s *CreateProductInput) SetOwner(v string) *CreateProductInput {
	s.Owner = &v
	return s
}

// SetProductType sets the ProductType field's value.
func (s *CreateProductInput) SetProductType(v string) *CreateProductInput {
	s.ProductType = &v
	return s
}

// SetProvisioningArtifactParameters sets the ProvisioningArtifactParameters field's value.
func (s *CreateProductInput) SetProvisioningArtifactParameters(v *ProvisioningArtifactProperties) *CreateProductInput {
	s.ProvisioningArtifactParameters = v
	return s
}

// SetSupportDescription sets the SupportDescription field's value.
func (s *CreateProductInput) SetSupportDescription(v string) *CreateProductInput {
	s.SupportDescription = &v
	return s
}

// SetSupportEmail sets the SupportEmail field's value.
func (s *CreateProductInput) SetSupportEmail(v string) *CreateProductInput {
	s.SupportEmail = &v
	return s
}

// SetSupportUrl sets the SupportUrl field's value.
func (s *CreateProductInput) SetSupportUrl(v string) *CreateProductInput {
	s.SupportUrl = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateProductInput) SetTags(v []*Tag) *CreateProductInput {
	s.Tags = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/CreateProductOutput
type CreateProductOutput struct {
	_ struct{} `type:"structure"`

	// The resulting detailed product view information.
	ProductViewDetail *ProductViewDetail `type:"structure"`

	// The resulting detailed provisioning artifact information.
	ProvisioningArtifactDetail *ProvisioningArtifactDetail `type:"structure"`

	// Tags successfully associated with the new product.
	Tags []*Tag `type:"list"`
}

// String returns the string representation
func (s CreateProductOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateProductOutput) GoString() string {
	return s.String()
}

// SetProductViewDetail sets the ProductViewDetail field's value.
func (s *CreateProductOutput) SetProductViewDetail(v *ProductViewDetail) *CreateProductOutput {
	s.ProductViewDetail = v
	return s
}

// SetProvisioningArtifactDetail sets the ProvisioningArtifactDetail field's value.
func (s *CreateProductOutput) SetProvisioningArtifactDetail(v *ProvisioningArtifactDetail) *CreateProductOutput {
	s.ProvisioningArtifactDetail = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateProductOutput) SetTags(v []*Tag) *CreateProductOutput {
	s.Tags = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/CreateProvisioningArtifactInput
type CreateProvisioningArtifactInput struct {
	_ struct{} `type:"structure"`

	// The language code to use for this operation. Supported language codes are
	// as follows:
	//
	// "en" (English)
	//
	// "jp" (Japanese)
	//
	// "zh" (Chinese)
	//
	// If no code is specified, "en" is used as the default.
	AcceptLanguage *string `type:"string"`

	// A token to disambiguate duplicate requests. You can create multiple resources
	// using the same input in multiple requests, provided that you also specify
	// a different idempotency token for each request.
	//
	// IdempotencyToken is a required field
	IdempotencyToken *string `min:"1" type:"string" required:"true" idempotencyToken:"true"`

	// The parameters to use when creating the new provisioning artifact.
	//
	// Parameters is a required field
	Parameters *ProvisioningArtifactProperties `type:"structure" required:"true"`

	// The product identifier.
	//
	// ProductId is a required field
	ProductId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateProvisioningArtifactInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateProvisioningArtifactInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateProvisioningArtifactInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateProvisioningArtifactInput"}
	if s.IdempotencyToken == nil {
		invalidParams.Add(request.NewErrParamRequired("IdempotencyToken"))
	}
	if s.IdempotencyToken != nil && len(*s.IdempotencyToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("IdempotencyToken", 1))
	}
	if s.Parameters == nil {
		invalidParams.Add(request.NewErrParamRequired("Parameters"))
	}
	if s.ProductId == nil {
		invalidParams.Add(request.NewErrParamRequired("ProductId"))
	}
	if s.ProductId != nil && len(*s.ProductId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ProductId", 1))
	}
	if s.Parameters != nil {
		if err := s.Parameters.Validate(); err != nil {
			invalidParams.AddNested("Parameters", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAcceptLanguage sets the AcceptLanguage field's value.
func (s *CreateProvisioningArtifactInput) SetAcceptLanguage(v string) *CreateProvisioningArtifactInput {
	s.AcceptLanguage = &v
	return s
}

// SetIdempotencyToken sets the IdempotencyToken field's value.
func (s *CreateProvisioningArtifactInput) SetIdempotencyToken(v string) *CreateProvisioningArtifactInput {
	s.IdempotencyToken = &v
	return s
}

// SetParameters sets the Parameters field's value.
func (s *CreateProvisioningArtifactInput) SetParameters(v *ProvisioningArtifactProperties) *CreateProvisioningArtifactInput {
	s.Parameters = v
	return s
}

// SetProductId sets the ProductId field's value.
func (s *CreateProvisioningArtifactInput) SetProductId(v string) *CreateProvisioningArtifactInput {
	s.ProductId = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/CreateProvisioningArtifactOutput
type CreateProvisioningArtifactOutput struct {
	_ struct{} `type:"structure"`

	// Additional information about the provisioning artifact create request.
	Info map[string]*string `min:"1" type:"map"`

	// The resulting detailed provisioning artifact information.
	ProvisioningArtifactDetail *ProvisioningArtifactDetail `type:"structure"`

	// The status of the current request.
	Status *string `type:"string" enum:"Status"`
}

// String returns the string representation
func (s CreateProvisioningArtifactOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateProvisioningArtifactOutput) GoString() string {
	return s.String()
}

// SetInfo sets the Info field's value.
func (s *CreateProvisioningArtifactOutput) SetInfo(v map[string]*string) *CreateProvisioningArtifactOutput {
	s.Info = v
	return s
}

// SetProvisioningArtifactDetail sets the ProvisioningArtifactDetail field's value.
func (s *CreateProvisioningArtifactOutput) SetProvisioningArtifactDetail(v *ProvisioningArtifactDetail) *CreateProvisioningArtifactOutput {
	s.ProvisioningArtifactDetail = v
	return s
}

// SetStatus sets the Status field's value.
func (s *CreateProvisioningArtifactOutput) SetStatus(v string) *CreateProvisioningArtifactOutput {
	s.Status = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/DeleteConstraintInput
type DeleteConstraintInput struct {
	_ struct{} `type:"structure"`

	// The language code to use for this operation. Supported language codes are
	// as follows:
	//
	// "en" (English)
	//
	// "jp" (Japanese)
	//
	// "zh" (Chinese)
	//
	// If no code is specified, "en" is used as the default.
	AcceptLanguage *string `type:"string"`

	// The identifier of the constraint to delete.
	//
	// Id is a required field
	Id *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteConstraintInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteConstraintInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteConstraintInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteConstraintInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAcceptLanguage sets the AcceptLanguage field's value.
func (s *DeleteConstraintInput) SetAcceptLanguage(v string) *DeleteConstraintInput {
	s.AcceptLanguage = &v
	return s
}

// SetId sets the Id field's value.
func (s *DeleteConstraintInput) SetId(v string) *DeleteConstraintInput {
	s.Id = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/DeleteConstraintOutput
type DeleteConstraintOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteConstraintOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteConstraintOutput) GoString() string {
	return s.String()
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/DeletePortfolioInput
type DeletePortfolioInput struct {
	_ struct{} `type:"structure"`

	// The language code to use for this operation. Supported language codes are
	// as follows:
	//
	// "en" (English)
	//
	// "jp" (Japanese)
	//
	// "zh" (Chinese)
	//
	// If no code is specified, "en" is used as the default.
	AcceptLanguage *string `type:"string"`

	// The identifier of the portfolio for the delete request.
	//
	// Id is a required field
	Id *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeletePortfolioInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeletePortfolioInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeletePortfolioInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeletePortfolioInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAcceptLanguage sets the AcceptLanguage field's value.
func (s *DeletePortfolioInput) SetAcceptLanguage(v string) *DeletePortfolioInput {
	s.AcceptLanguage = &v
	return s
}

// SetId sets the Id field's value.
func (s *DeletePortfolioInput) SetId(v string) *DeletePortfolioInput {
	s.Id = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/DeletePortfolioOutput
type DeletePortfolioOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeletePortfolioOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeletePortfolioOutput) GoString() string {
	return s.String()
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/DeletePortfolioShareInput
type DeletePortfolioShareInput struct {
	_ struct{} `type:"structure"`

	// The language code to use for this operation. Supported language codes are
	// as follows:
	//
	// "en" (English)
	//
	// "jp" (Japanese)
	//
	// "zh" (Chinese)
	//
	// If no code is specified, "en" is used as the default.
	AcceptLanguage *string `type:"string"`

	// The account ID associated with the share to delete.
	//
	// AccountId is a required field
	AccountId *string `type:"string" required:"true"`

	// The portfolio identifier.
	//
	// PortfolioId is a required field
	PortfolioId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeletePortfolioShareInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeletePortfolioShareInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeletePortfolioShareInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeletePortfolioShareInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.PortfolioId == nil {
		invalidParams.Add(request.NewErrParamRequired("PortfolioId"))
	}
	if s.PortfolioId != nil && len(*s.PortfolioId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PortfolioId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAcceptLanguage sets the AcceptLanguage field's value.
func (s *DeletePortfolioShareInput) SetAcceptLanguage(v string) *DeletePortfolioShareInput {
	s.AcceptLanguage = &v
	return s
}

// SetAccountId sets the AccountId field's value.
func (s *DeletePortfolioShareInput) SetAccountId(v string) *DeletePortfolioShareInput {
	s.AccountId = &v
	return s
}

// SetPortfolioId sets the PortfolioId field's value.
func (s *DeletePortfolioShareInput) SetPortfolioId(v string) *DeletePortfolioShareInput {
	s.PortfolioId = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/DeletePortfolioShareOutput
type DeletePortfolioShareOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeletePortfolioShareOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeletePortfolioShareOutput) GoString() string {
	return s.String()
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/DeleteProductInput
type DeleteProductInput struct {
	_ struct{} `type:"structure"`

	// The language code to use for this operation. Supported language codes are
	// as follows:
	//
	// "en" (English)
	//
	// "jp" (Japanese)
	//
	// "zh" (Chinese)
	//
	// If no code is specified, "en" is used as the default.
	AcceptLanguage *string `type:"string"`

	// The identifier of the product for the delete request.
	//
	// Id is a required field
	Id *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteProductInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteProductInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteProductInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteProductInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAcceptLanguage sets the AcceptLanguage field's value.
func (s *DeleteProductInput) SetAcceptLanguage(v string) *DeleteProductInput {
	s.AcceptLanguage = &v
	return s
}

// SetId sets the Id field's value.
func (s *DeleteProductInput) SetId(v string) *DeleteProductInput {
	s.Id = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/DeleteProductOutput
type DeleteProductOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteProductOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteProductOutput) GoString() string {
	return s.String()
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/DeleteProvisioningArtifactInput
type DeleteProvisioningArtifactInput struct {
	_ struct{} `type:"structure"`

	// The language code to use for this operation. Supported language codes are
	// as follows:
	//
	// "en" (English)
	//
	// "jp" (Japanese)
	//
	// "zh" (Chinese)
	//
	// If no code is specified, "en" is used as the default.
	AcceptLanguage *string `type:"string"`

	// The product identifier.
	//
	// ProductId is a required field
	ProductId *string `min:"1" type:"string" required:"true"`

	// The identifier of the provisioning artifact for the delete request.
	//
	// ProvisioningArtifactId is a required field
	ProvisioningArtifactId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteProvisioningArtifactInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteProvisioningArtifactInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteProvisioningArtifactInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteProvisioningArtifactInput"}
	if s.ProductId == nil {
		invalidParams.Add(request.NewErrParamRequired("ProductId"))
	}
	if s.ProductId != nil && len(*s.ProductId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ProductId", 1))
	}
	if s.ProvisioningArtifactId == nil {
		invalidParams.Add(request.NewErrParamRequired("ProvisioningArtifactId"))
	}
	if s.ProvisioningArtifactId != nil && len(*s.ProvisioningArtifactId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ProvisioningArtifactId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAcceptLanguage sets the AcceptLanguage field's value.
func (s *DeleteProvisioningArtifactInput) SetAcceptLanguage(v string) *DeleteProvisioningArtifactInput {
	s.AcceptLanguage = &v
	return s
}

// SetProductId sets the ProductId field's value.
func (s *DeleteProvisioningArtifactInput) SetProductId(v string) *DeleteProvisioningArtifactInput {
	s.ProductId = &v
	return s
}

// SetProvisioningArtifactId sets the ProvisioningArtifactId field's value.
func (s *DeleteProvisioningArtifactInput) SetProvisioningArtifactId(v string) *DeleteProvisioningArtifactInput {
	s.ProvisioningArtifactId = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/DeleteProvisioningArtifactOutput
type DeleteProvisioningArtifactOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteProvisioningArtifactOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteProvisioningArtifactOutput) GoString() string {
	return s.String()
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/DescribeConstraintInput
type DescribeConstraintInput struct {
	_ struct{} `type:"structure"`

	// The language code to use for this operation. Supported language codes are
	// as follows:
	//
	// "en" (English)
	//
	// "jp" (Japanese)
	//
	// "zh" (Chinese)
	//
	// If no code is specified, "en" is used as the default.
	AcceptLanguage *string `type:"string"`

	// The identifier of the constraint.
	//
	// Id is a required field
	Id *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeConstraintInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeConstraintInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeConstraintInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeConstraintInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAcceptLanguage sets the AcceptLanguage field's value.
func (s *DescribeConstraintInput) SetAcceptLanguage(v string) *DescribeConstraintInput {
	s.AcceptLanguage = &v
	return s
}

// SetId sets the Id field's value.
func (s *DescribeConstraintInput) SetId(v string) *DescribeConstraintInput {
	s.Id = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/DescribeConstraintOutput
type DescribeConstraintOutput struct {
	_ struct{} `type:"structure"`

	// Detailed constraint information.
	ConstraintDetail *ConstraintDetail `type:"structure"`

	// The current parameters associated with the specified constraint.
	ConstraintParameters *string `type:"string"`

	// The status of the current request.
	Status *string `type:"string" enum:"Status"`
}

// String returns the string representation
func (s DescribeConstraintOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeConstraintOutput) GoString() string {
	return s.String()
}

// SetConstraintDetail sets the ConstraintDetail field's value.
func (s *DescribeConstraintOutput) SetConstraintDetail(v *ConstraintDetail) *DescribeConstraintOutput {
	s.ConstraintDetail = v
	return s
}

// SetConstraintParameters sets the ConstraintParameters field's value.
func (s *DescribeConstraintOutput) SetConstraintParameters(v string) *DescribeConstraintOutput {
	s.ConstraintParameters = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DescribeConstraintOutput) SetStatus(v string) *DescribeConstraintOutput {
	s.Status = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/DescribePortfolioInput
type DescribePortfolioInput struct {
	_ struct{} `type:"structure"`

	// The language code to use for this operation. Supported language codes are
	// as follows:
	//
	// "en" (English)
	//
	// "jp" (Japanese)
	//
	// "zh" (Chinese)
	//
	// If no code is specified, "en" is used as the default.
	AcceptLanguage *string `type:"string"`

	// The identifier of the portfolio for which to retrieve information.
	//
	// Id is a required field
	Id *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribePortfolioInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribePortfolioInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribePortfolioInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribePortfolioInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAcceptLanguage sets the AcceptLanguage field's value.
func (s *DescribePortfolioInput) SetAcceptLanguage(v string) *DescribePortfolioInput {
	s.AcceptLanguage = &v
	return s
}

// SetId sets the Id field's value.
func (s *DescribePortfolioInput) SetId(v string) *DescribePortfolioInput {
	s.Id = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/DescribePortfolioOutput
type DescribePortfolioOutput struct {
	_ struct{} `type:"structure"`

	// Detailed portfolio information.
	PortfolioDetail *PortfolioDetail `type:"structure"`

	// Tags associated with the portfolio.
	Tags []*Tag `type:"list"`
}

// String returns the string representation
func (s DescribePortfolioOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribePortfolioOutput) GoString() string {
	return s.String()
}

// SetPortfolioDetail sets the PortfolioDetail field's value.
func (s *DescribePortfolioOutput) SetPortfolioDetail(v *PortfolioDetail) *DescribePortfolioOutput {
	s.PortfolioDetail = v
	return s
}

// SetTags sets the Tags field's value.
func (s *DescribePortfolioOutput) SetTags(v []*Tag) *DescribePortfolioOutput {
	s.Tags = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/DescribeProductAsAdminInput
type DescribeProductAsAdminInput struct {
	_ struct{} `type:"structure"`

	// The language code to use for this operation. Supported language codes are
	// as follows:
	//
	// "en" (English)
	//
	// "jp" (Japanese)
	//
	// "zh" (Chinese)
	//
	// If no code is specified, "en" is used as the default.
	AcceptLanguage *string `type:"string"`

	// The identifier of the product for which to retrieve information.
	//
	// Id is a required field
	Id *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeProductAsAdminInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeProductAsAdminInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeProductAsAdminInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeProductAsAdminInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAcceptLanguage sets the AcceptLanguage field's value.
func (s *DescribeProductAsAdminInput) SetAcceptLanguage(v string) *DescribeProductAsAdminInput {
	s.AcceptLanguage = &v
	return s
}

// SetId sets the Id field's value.
func (s *DescribeProductAsAdminInput) SetId(v string) *DescribeProductAsAdminInput {
	s.Id = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/DescribeProductAsAdminOutput
type DescribeProductAsAdminOutput struct {
	_ struct{} `type:"structure"`

	// Detailed product view information.
	ProductViewDetail *ProductViewDetail `type:"structure"`

	// Tags associated with the product.
	Tags []*Tag `type:"list"`
}

// String returns the string representation
func (s DescribeProductAsAdminOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeProductAsAdminOutput) GoString() string {
	return s.String()
}

// SetProductViewDetail sets the ProductViewDetail field's value.
func (s *DescribeProductAsAdminOutput) SetProductViewDetail(v *ProductViewDetail) *DescribeProductAsAdminOutput {
	s.ProductViewDetail = v
	return s
}

// SetTags sets the Tags field's value.
func (s *DescribeProductAsAdminOutput) SetTags(v []*Tag) *DescribeProductAsAdminOutput {
	s.Tags = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/DescribeProductInput
type DescribeProductInput struct {
	_ struct{} `type:"structure"`

	// The language code to use for this operation. Supported language codes are
	// as follows:
	//
	// "en" (English)
	//
	// "jp" (Japanese)
	//
	// "zh" (Chinese)
	//
	// If no code is specified, "en" is used as the default.
	AcceptLanguage *string `type:"string"`

	// The ProductId of the product to describe.
	//
	// Id is a required field
	Id *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeProductInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeProductInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeProductInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeProductInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAcceptLanguage sets the AcceptLanguage field's value.
func (s *DescribeProductInput) SetAcceptLanguage(v string) *DescribeProductInput {
	s.AcceptLanguage = &v
	return s
}

// SetId sets the Id field's value.
func (s *DescribeProductInput) SetId(v string) *DescribeProductInput {
	s.Id = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/DescribeProductOutput
type DescribeProductOutput struct {
	_ struct{} `type:"structure"`

	// The summary metadata about the specified product.
	ProductViewSummary *ProductViewSummary `type:"structure"`

	// A list of provisioning artifact objects for the specified product. The ProvisioningArtifacts
	// parameter represent the ways the specified product can be provisioned.
	ProvisioningArtifacts []*ProvisioningArtifact `type:"list"`
}

// String returns the string representation
func (s DescribeProductOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeProductOutput) GoString() string {
	return s.String()
}

// SetProductViewSummary sets the ProductViewSummary field's value.
func (s *DescribeProductOutput) SetProductViewSummary(v *ProductViewSummary) *DescribeProductOutput {
	s.ProductViewSummary = v
	return s
}

// SetProvisioningArtifacts sets the ProvisioningArtifacts field's value.
func (s *DescribeProductOutput) SetProvisioningArtifacts(v []*ProvisioningArtifact) *DescribeProductOutput {
	s.ProvisioningArtifacts = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/DescribeProductViewInput
type DescribeProductViewInput struct {
	_ struct{} `type:"structure"`

	// The language code to use for this operation. Supported language codes are
	// as follows:
	//
	// "en" (English)
	//
	// "jp" (Japanese)
	//
	// "zh" (Chinese)
	//
	// If no code is specified, "en" is used as the default.
	AcceptLanguage *string `type:"string"`

	// The ProductViewId of the product to describe.
	//
	// Id is a required field
	Id *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeProductViewInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeProductViewInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeProductViewInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeProductViewInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAcceptLanguage sets the AcceptLanguage field's value.
func (s *DescribeProductViewInput) SetAcceptLanguage(v string) *DescribeProductViewInput {
	s.AcceptLanguage = &v
	return s
}

// SetId sets the Id field's value.
func (s *DescribeProductViewInput) SetId(v string) *DescribeProductViewInput {
	s.Id = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/DescribeProductViewOutput
type DescribeProductViewOutput struct {
	_ struct{} `type:"structure"`

	// The summary metadata about the specified product.
	ProductViewSummary *ProductViewSummary `type:"structure"`

	// A list of provisioning artifact objects for the specified product. The ProvisioningArtifacts
	// represent the ways in which the specified product can be provisioned.
	ProvisioningArtifacts []*ProvisioningArtifact `type:"list"`
}

// String returns the string representation
func (s DescribeProductViewOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeProductViewOutput) GoString() string {
	return s.String()
}

// SetProductViewSummary sets the ProductViewSummary field's value.
func (s *DescribeProductViewOutput) SetProductViewSummary(v *ProductViewSummary) *DescribeProductViewOutput {
	s.ProductViewSummary = v
	return s
}

// SetProvisioningArtifacts sets the ProvisioningArtifacts field's value.
func (s *DescribeProductViewOutput) SetProvisioningArtifacts(v []*ProvisioningArtifact) *DescribeProductViewOutput {
	s.ProvisioningArtifacts = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/DescribeProvisioningArtifactInput
type DescribeProvisioningArtifactInput struct {
	_ struct{} `type:"structure"`

	// The language code to use for this operation. Supported language codes are
	// as follows:
	//
	// "en" (English)
	//
	// "jp" (Japanese)
	//
	// "zh" (Chinese)
	//
	// If no code is specified, "en" is used as the default.
	AcceptLanguage *string `type:"string"`

	// The product identifier.
	//
	// ProductId is a required field
	ProductId *string `min:"1" type:"string" required:"true"`

	// The identifier of the provisioning artifact.
	//
	// ProvisioningArtifactId is a required field
	ProvisioningArtifactId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeProvisioningArtifactInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeProvisioningArtifactInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeProvisioningArtifactInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeProvisioningArtifactInput"}
	if s.ProductId == nil {
		invalidParams.Add(request.NewErrParamRequired("ProductId"))
	}
	if s.ProductId != nil && len(*s.ProductId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ProductId", 1))
	}
	if s.ProvisioningArtifactId == nil {
		invalidParams.Add(request.NewErrParamRequired("ProvisioningArtifactId"))
	}
	if s.ProvisioningArtifactId != nil && len(*s.ProvisioningArtifactId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ProvisioningArtifactId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAcceptLanguage sets the AcceptLanguage field's value.
func (s *DescribeProvisioningArtifactInput) SetAcceptLanguage(v string) *DescribeProvisioningArtifactInput {
	s.AcceptLanguage = &v
	return s
}

// SetProductId sets the ProductId field's value.
func (s *DescribeProvisioningArtifactInput) SetProductId(v string) *DescribeProvisioningArtifactInput {
	s.ProductId = &v
	return s
}

// SetProvisioningArtifactId sets the ProvisioningArtifactId field's value.
func (s *DescribeProvisioningArtifactInput) SetProvisioningArtifactId(v string) *DescribeProvisioningArtifactInput {
	s.ProvisioningArtifactId = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/DescribeProvisioningArtifactOutput
type DescribeProvisioningArtifactOutput struct {
	_ struct{} `type:"structure"`

	// Additional information about the provisioning artifact.
	Info map[string]*string `min:"1" type:"map"`

	// Detailed provisioning artifact information.
	ProvisioningArtifactDetail *ProvisioningArtifactDetail `type:"structure"`

	// The status of the current request.
	Status *string `type:"string" enum:"Status"`
}

// String returns the string representation
func (s DescribeProvisioningArtifactOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeProvisioningArtifactOutput) GoString() string {
	return s.String()
}

// SetInfo sets the Info field's value.
func (s *DescribeProvisioningArtifactOutput) SetInfo(v map[string]*string) *DescribeProvisioningArtifactOutput {
	s.Info = v
	return s
}

// SetProvisioningArtifactDetail sets the ProvisioningArtifactDetail field's value.
func (s *DescribeProvisioningArtifactOutput) SetProvisioningArtifactDetail(v *ProvisioningArtifactDetail) *DescribeProvisioningArtifactOutput {
	s.ProvisioningArtifactDetail = v
	return s
}

// SetStatus sets the Status field's value.
func (s *DescribeProvisioningArtifactOutput) SetStatus(v string) *DescribeProvisioningArtifactOutput {
	s.Status = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/DescribeProvisioningParametersInput
type DescribeProvisioningParametersInput struct {
	_ struct{} `type:"structure"`

	// The language code to use for this operation. Supported language codes are
	// as follows:
	//
	// "en" (English)
	//
	// "jp" (Japanese)
	//
	// "zh" (Chinese)
	//
	// If no code is specified, "en" is used as the default.
	AcceptLanguage *string `type:"string"`

	// The identifier of the path for this product's provisioning. This value is
	// optional if the product has a default path, and is required if there is more
	// than one path for the specified product.
	PathId *string `min:"1" type:"string"`

	// The product identifier.
	//
	// ProductId is a required field
	ProductId *string `min:"1" type:"string" required:"true"`

	// The provisioning artifact identifier for this product.
	//
	// ProvisioningArtifactId is a required field
	ProvisioningArtifactId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeProvisioningParametersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeProvisioningParametersInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeProvisioningParametersInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeProvisioningParametersInput"}
	if s.PathId != nil && len(*s.PathId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PathId", 1))
	}
	if s.ProductId == nil {
		invalidParams.Add(request.NewErrParamRequired("ProductId"))
	}
	if s.ProductId != nil && len(*s.ProductId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ProductId", 1))
	}
	if s.ProvisioningArtifactId == nil {
		invalidParams.Add(request.NewErrParamRequired("ProvisioningArtifactId"))
	}
	if s.ProvisioningArtifactId != nil && len(*s.ProvisioningArtifactId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ProvisioningArtifactId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAcceptLanguage sets the AcceptLanguage field's value.
func (s *DescribeProvisioningParametersInput) SetAcceptLanguage(v string) *DescribeProvisioningParametersInput {
	s.AcceptLanguage = &v
	return s
}

// SetPathId sets the PathId field's value.
func (s *DescribeProvisioningParametersInput) SetPathId(v string) *DescribeProvisioningParametersInput {
	s.PathId = &v
	return s
}

// SetProductId sets the ProductId field's value.
func (s *DescribeProvisioningParametersInput) SetProductId(v string) *DescribeProvisioningParametersInput {
	s.ProductId = &v
	return s
}

// SetProvisioningArtifactId sets the ProvisioningArtifactId field's value.
func (s *DescribeProvisioningParametersInput) SetProvisioningArtifactId(v string) *DescribeProvisioningParametersInput {
	s.ProvisioningArtifactId = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/DescribeProvisioningParametersOutput
type DescribeProvisioningParametersOutput struct {
	_ struct{} `type:"structure"`

	// The list of constraint summaries that apply to provisioning this product.
	ConstraintSummaries []*ConstraintSummary `type:"list"`

	// The list of parameters used to successfully provision the product. Each parameter
	// includes a list of allowable values and additional metadata about each parameter.
	ProvisioningArtifactParameters []*ProvisioningArtifactParameter `type:"list"`

	// Any additional metadata specifically related to the provisioning of the product.
	// For example, see the Version field of the CloudFormation template.
	UsageInstructions []*UsageInstruction `type:"list"`
}

// String returns the string representation
func (s DescribeProvisioningParametersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeProvisioningParametersOutput) GoString() string {
	return s.String()
}

// SetConstraintSummaries sets the ConstraintSummaries field's value.
func (s *DescribeProvisioningParametersOutput) SetConstraintSummaries(v []*ConstraintSummary) *DescribeProvisioningParametersOutput {
	s.ConstraintSummaries = v
	return s
}

// SetProvisioningArtifactParameters sets the ProvisioningArtifactParameters field's value.
func (s *DescribeProvisioningParametersOutput) SetProvisioningArtifactParameters(v []*ProvisioningArtifactParameter) *DescribeProvisioningParametersOutput {
	s.ProvisioningArtifactParameters = v
	return s
}

// SetUsageInstructions sets the UsageInstructions field's value.
func (s *DescribeProvisioningParametersOutput) SetUsageInstructions(v []*UsageInstruction) *DescribeProvisioningParametersOutput {
	s.UsageInstructions = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/DescribeRecordInput
type DescribeRecordInput struct {
	_ struct{} `type:"structure"`

	// The language code to use for this operation. Supported language codes are
	// as follows:
	//
	// "en" (English)
	//
	// "jp" (Japanese)
	//
	// "zh" (Chinese)
	//
	// If no code is specified, "en" is used as the default.
	AcceptLanguage *string `type:"string"`

	// The record identifier of the ProvisionedProduct object for which to retrieve
	// output information. This is the RecordDetail.RecordId obtained from the request
	// operation's response.
	//
	// Id is a required field
	Id *string `min:"1" type:"string" required:"true"`

	// The maximum number of items to return in the results. If more results exist
	// than fit in the specified PageSize, the value of NextPageToken in the response
	// is non-null.
	PageSize *int64 `type:"integer"`

	// The page token of the first page retrieved. If null, this retrieves the first
	// page of size PageSize.
	PageToken *string `type:"string"`
}

// String returns the string representation
func (s DescribeRecordInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeRecordInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeRecordInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeRecordInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAcceptLanguage sets the AcceptLanguage field's value.
func (s *DescribeRecordInput) SetAcceptLanguage(v string) *DescribeRecordInput {
	s.AcceptLanguage = &v
	return s
}

// SetId sets the Id field's value.
func (s *DescribeRecordInput) SetId(v string) *DescribeRecordInput {
	s.Id = &v
	return s
}

// SetPageSize sets the PageSize field's value.
func (s *DescribeRecordInput) SetPageSize(v int64) *DescribeRecordInput {
	s.PageSize = &v
	return s
}

// SetPageToken sets the PageToken field's value.
func (s *DescribeRecordInput) SetPageToken(v string) *DescribeRecordInput {
	s.PageToken = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/DescribeRecordOutput
type DescribeRecordOutput struct {
	_ struct{} `type:"structure"`

	// The page token to use to retrieve the next page of results for this operation.
	// If there are no more pages, this value is null.
	NextPageToken *string `type:"string"`

	// Detailed record information for the specified product.
	RecordDetail *RecordDetail `type:"structure"`

	// A list of outputs for the specified Product object created as the result
	// of a request. For example, a CloudFormation-backed product that creates an
	// S3 bucket would have an output for the S3 bucket URL.
	RecordOutputs []*RecordOutput `type:"list"`
}

// String returns the string representation
func (s DescribeRecordOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeRecordOutput) GoString() string {
	return s.String()
}

// SetNextPageToken sets the NextPageToken field's value.
func (s *DescribeRecordOutput) SetNextPageToken(v string) *DescribeRecordOutput {
	s.NextPageToken = &v
	return s
}

// SetRecordDetail sets the RecordDetail field's value.
func (s *DescribeRecordOutput) SetRecordDetail(v *RecordDetail) *DescribeRecordOutput {
	s.RecordDetail = v
	return s
}

// SetRecordOutputs sets the RecordOutputs field's value.
func (s *DescribeRecordOutput) SetRecordOutputs(v []*RecordOutput) *DescribeRecordOutput {
	s.RecordOutputs = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/DisassociatePrincipalFromPortfolioInput
type DisassociatePrincipalFromPortfolioInput struct {
	_ struct{} `type:"structure"`

	// The language code to use for this operation. Supported language codes are
	// as follows:
	//
	// "en" (English)
	//
	// "jp" (Japanese)
	//
	// "zh" (Chinese)
	//
	// If no code is specified, "en" is used as the default.
	AcceptLanguage *string `type:"string"`

	// The portfolio identifier.
	//
	// PortfolioId is a required field
	PortfolioId *string `min:"1" type:"string" required:"true"`

	// The ARN representing the principal (IAM user, role, or group).
	//
	// PrincipalARN is a required field
	PrincipalARN *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DisassociatePrincipalFromPortfolioInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisassociatePrincipalFromPortfolioInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DisassociatePrincipalFromPortfolioInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DisassociatePrincipalFromPortfolioInput"}
	if s.PortfolioId == nil {
		invalidParams.Add(request.NewErrParamRequired("PortfolioId"))
	}
	if s.PortfolioId != nil && len(*s.PortfolioId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PortfolioId", 1))
	}
	if s.PrincipalARN == nil {
		invalidParams.Add(request.NewErrParamRequired("PrincipalARN"))
	}
	if s.PrincipalARN != nil && len(*s.PrincipalARN) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PrincipalARN", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAcceptLanguage sets the AcceptLanguage field's value.
func (s *DisassociatePrincipalFromPortfolioInput) SetAcceptLanguage(v string) *DisassociatePrincipalFromPortfolioInput {
	s.AcceptLanguage = &v
	return s
}

// SetPortfolioId sets the PortfolioId field's value.
func (s *DisassociatePrincipalFromPortfolioInput) SetPortfolioId(v string) *DisassociatePrincipalFromPortfolioInput {
	s.PortfolioId = &v
	return s
}

// SetPrincipalARN sets the PrincipalARN field's value.
func (s *DisassociatePrincipalFromPortfolioInput) SetPrincipalARN(v string) *DisassociatePrincipalFromPortfolioInput {
	s.PrincipalARN = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/DisassociatePrincipalFromPortfolioOutput
type DisassociatePrincipalFromPortfolioOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DisassociatePrincipalFromPortfolioOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisassociatePrincipalFromPortfolioOutput) GoString() string {
	return s.String()
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/DisassociateProductFromPortfolioInput
type DisassociateProductFromPortfolioInput struct {
	_ struct{} `type:"structure"`

	// The language code to use for this operation. Supported language codes are
	// as follows:
	//
	// "en" (English)
	//
	// "jp" (Japanese)
	//
	// "zh" (Chinese)
	//
	// If no code is specified, "en" is used as the default.
	AcceptLanguage *string `type:"string"`

	// The portfolio identifier.
	//
	// PortfolioId is a required field
	PortfolioId *string `min:"1" type:"string" required:"true"`

	// The product identifier.
	//
	// ProductId is a required field
	ProductId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DisassociateProductFromPortfolioInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisassociateProductFromPortfolioInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DisassociateProductFromPortfolioInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DisassociateProductFromPortfolioInput"}
	if s.PortfolioId == nil {
		invalidParams.Add(request.NewErrParamRequired("PortfolioId"))
	}
	if s.PortfolioId != nil && len(*s.PortfolioId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PortfolioId", 1))
	}
	if s.ProductId == nil {
		invalidParams.Add(request.NewErrParamRequired("ProductId"))
	}
	if s.ProductId != nil && len(*s.ProductId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ProductId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAcceptLanguage sets the AcceptLanguage field's value.
func (s *DisassociateProductFromPortfolioInput) SetAcceptLanguage(v string) *DisassociateProductFromPortfolioInput {
	s.AcceptLanguage = &v
	return s
}

// SetPortfolioId sets the PortfolioId field's value.
func (s *DisassociateProductFromPortfolioInput) SetPortfolioId(v string) *DisassociateProductFromPortfolioInput {
	s.PortfolioId = &v
	return s
}

// SetProductId sets the ProductId field's value.
func (s *DisassociateProductFromPortfolioInput) SetProductId(v string) *DisassociateProductFromPortfolioInput {
	s.ProductId = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/DisassociateProductFromPortfolioOutput
type DisassociateProductFromPortfolioOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DisassociateProductFromPortfolioOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisassociateProductFromPortfolioOutput) GoString() string {
	return s.String()
}

// Summary information about a path for a user to have access to a specified
// product.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/LaunchPathSummary
type LaunchPathSummary struct {
	_ struct{} `type:"structure"`

	// List of constraints on the portfolio-product relationship.
	ConstraintSummaries []*ConstraintSummary `type:"list"`

	// The unique identifier of the product path.
	Id *string `min:"1" type:"string"`

	// Corresponds to the name of the portfolio to which the user was assigned.
	Name *string `type:"string"`

	// List of tags used by this launch path.
	Tags []*Tag `type:"list"`
}

// String returns the string representation
func (s LaunchPathSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LaunchPathSummary) GoString() string {
	return s.String()
}

// SetConstraintSummaries sets the ConstraintSummaries field's value.
func (s *LaunchPathSummary) SetConstraintSummaries(v []*ConstraintSummary) *LaunchPathSummary {
	s.ConstraintSummaries = v
	return s
}

// SetId sets the Id field's value.
func (s *LaunchPathSummary) SetId(v string) *LaunchPathSummary {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *LaunchPathSummary) SetName(v string) *LaunchPathSummary {
	s.Name = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *LaunchPathSummary) SetTags(v []*Tag) *LaunchPathSummary {
	s.Tags = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListAcceptedPortfolioSharesInput
type ListAcceptedPortfolioSharesInput struct {
	_ struct{} `type:"structure"`

	// The language code to use for this operation. Supported language codes are
	// as follows:
	//
	// "en" (English)
	//
	// "jp" (Japanese)
	//
	// "zh" (Chinese)
	//
	// If no code is specified, "en" is used as the default.
	AcceptLanguage *string `type:"string"`

	// The maximum number of items to return in the results. If more results exist
	// than fit in the specified PageSize, the value of NextPageToken in the response
	// is non-null.
	PageSize *int64 `type:"integer"`

	// The page token of the first page retrieved. If null, this retrieves the first
	// page of size PageSize.
	PageToken *string `type:"string"`
}

// String returns the string representation
func (s ListAcceptedPortfolioSharesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListAcceptedPortfolioSharesInput) GoString() string {
	return s.String()
}

// SetAcceptLanguage sets the AcceptLanguage field's value.
func (s *ListAcceptedPortfolioSharesInput) SetAcceptLanguage(v string) *ListAcceptedPortfolioSharesInput {
	s.AcceptLanguage = &v
	return s
}

// SetPageSize sets the PageSize field's value.
func (s *ListAcceptedPortfolioSharesInput) SetPageSize(v int64) *ListAcceptedPortfolioSharesInput {
	s.PageSize = &v
	return s
}

// SetPageToken sets the PageToken field's value.
func (s *ListAcceptedPortfolioSharesInput) SetPageToken(v string) *ListAcceptedPortfolioSharesInput {
	s.PageToken = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListAcceptedPortfolioSharesOutput
type ListAcceptedPortfolioSharesOutput struct {
	_ struct{} `type:"structure"`

	// The page token to use to retrieve the next page of results for this operation.
	// If there are no more pages, this value is null.
	NextPageToken *string `type:"string"`

	// List of detailed portfolio information objects.
	PortfolioDetails []*PortfolioDetail `type:"list"`
}

// String returns the string representation
func (s ListAcceptedPortfolioSharesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListAcceptedPortfolioSharesOutput) GoString() string {
	return s.String()
}

// SetNextPageToken sets the NextPageToken field's value.
func (s *ListAcceptedPortfolioSharesOutput) SetNextPageToken(v string) *ListAcceptedPortfolioSharesOutput {
	s.NextPageToken = &v
	return s
}

// SetPortfolioDetails sets the PortfolioDetails field's value.
func (s *ListAcceptedPortfolioSharesOutput) SetPortfolioDetails(v []*PortfolioDetail) *ListAcceptedPortfolioSharesOutput {
	s.PortfolioDetails = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListConstraintsForPortfolioInput
type ListConstraintsForPortfolioInput struct {
	_ struct{} `type:"structure"`

	// The language code to use for this operation. Supported language codes are
	// as follows:
	//
	// "en" (English)
	//
	// "jp" (Japanese)
	//
	// "zh" (Chinese)
	//
	// If no code is specified, "en" is used as the default.
	AcceptLanguage *string `type:"string"`

	// The maximum number of items to return in the results. If more results exist
	// than fit in the specified PageSize, the value of NextPageToken in the response
	// is non-null.
	PageSize *int64 `type:"integer"`

	// The page token of the first page retrieved. If null, this retrieves the first
	// page of size PageSize.
	PageToken *string `type:"string"`

	// The portfolio identifier.
	//
	// PortfolioId is a required field
	PortfolioId *string `min:"1" type:"string" required:"true"`

	// The product identifier.
	ProductId *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListConstraintsForPortfolioInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListConstraintsForPortfolioInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListConstraintsForPortfolioInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListConstraintsForPortfolioInput"}
	if s.PortfolioId == nil {
		invalidParams.Add(request.NewErrParamRequired("PortfolioId"))
	}
	if s.PortfolioId != nil && len(*s.PortfolioId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PortfolioId", 1))
	}
	if s.ProductId != nil && len(*s.ProductId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ProductId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAcceptLanguage sets the AcceptLanguage field's value.
func (s *ListConstraintsForPortfolioInput) SetAcceptLanguage(v string) *ListConstraintsForPortfolioInput {
	s.AcceptLanguage = &v
	return s
}

// SetPageSize sets the PageSize field's value.
func (s *ListConstraintsForPortfolioInput) SetPageSize(v int64) *ListConstraintsForPortfolioInput {
	s.PageSize = &v
	return s
}

// SetPageToken sets the PageToken field's value.
func (s *ListConstraintsForPortfolioInput) SetPageToken(v string) *ListConstraintsForPortfolioInput {
	s.PageToken = &v
	return s
}

// SetPortfolioId sets the PortfolioId field's value.
func (s *ListConstraintsForPortfolioInput) SetPortfolioId(v string) *ListConstraintsForPortfolioInput {
	s.PortfolioId = &v
	return s
}

// SetProductId sets the ProductId field's value.
func (s *ListConstraintsForPortfolioInput) SetProductId(v string) *ListConstraintsForPortfolioInput {
	s.ProductId = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListConstraintsForPortfolioOutput
type ListConstraintsForPortfolioOutput struct {
	_ struct{} `type:"structure"`

	// List of detailed constraint information objects.
	ConstraintDetails []*ConstraintDetail `type:"list"`

	// The page token to use to retrieve the next page of results for this operation.
	// If there are no more pages, this value is null.
	NextPageToken *string `type:"string"`
}

// String returns the string representation
func (s ListConstraintsForPortfolioOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListConstraintsForPortfolioOutput) GoString() string {
	return s.String()
}

// SetConstraintDetails sets the ConstraintDetails field's value.
func (s *ListConstraintsForPortfolioOutput) SetConstraintDetails(v []*ConstraintDetail) *ListConstraintsForPortfolioOutput {
	s.ConstraintDetails = v
	return s
}

// SetNextPageToken sets the NextPageToken field's value.
func (s *ListConstraintsForPortfolioOutput) SetNextPageToken(v string) *ListConstraintsForPortfolioOutput {
	s.NextPageToken = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListLaunchPathsInput
type ListLaunchPathsInput struct {
	_ struct{} `type:"structure"`

	// The language code to use for this operation. Supported language codes are
	// as follows:
	//
	// "en" (English)
	//
	// "jp" (Japanese)
	//
	// "zh" (Chinese)
	//
	// If no code is specified, "en" is used as the default.
	AcceptLanguage *string `type:"string"`

	// The maximum number of items to return in the results. If more results exist
	// than fit in the specified PageSize, the value of NextPageToken in the response
	// is non-null.
	PageSize *int64 `type:"integer"`

	// The page token of the first page retrieved. If null, this retrieves the first
	// page of size PageSize.
	PageToken *string `type:"string"`

	// The product identifier.. Identifies the product for which to retrieve LaunchPathSummaries
	// information.
	//
	// ProductId is a required field
	ProductId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ListLaunchPathsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListLaunchPathsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListLaunchPathsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListLaunchPathsInput"}
	if s.ProductId == nil {
		invalidParams.Add(request.NewErrParamRequired("ProductId"))
	}
	if s.ProductId != nil && len(*s.ProductId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ProductId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAcceptLanguage sets the AcceptLanguage field's value.
func (s *ListLaunchPathsInput) SetAcceptLanguage(v string) *ListLaunchPathsInput {
	s.AcceptLanguage = &v
	return s
}

// SetPageSize sets the PageSize field's value.
func (s *ListLaunchPathsInput) SetPageSize(v int64) *ListLaunchPathsInput {
	s.PageSize = &v
	return s
}

// SetPageToken sets the PageToken field's value.
func (s *ListLaunchPathsInput) SetPageToken(v string) *ListLaunchPathsInput {
	s.PageToken = &v
	return s
}

// SetProductId sets the ProductId field's value.
func (s *ListLaunchPathsInput) SetProductId(v string) *ListLaunchPathsInput {
	s.ProductId = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListLaunchPathsOutput
type ListLaunchPathsOutput struct {
	_ struct{} `type:"structure"`

	// List of launch path information summaries for the specified PageToken.
	LaunchPathSummaries []*LaunchPathSummary `type:"list"`

	// The page token to use to retrieve the next page of results for this operation.
	// If there are no more pages, this value is null.
	NextPageToken *string `type:"string"`
}

// String returns the string representation
func (s ListLaunchPathsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListLaunchPathsOutput) GoString() string {
	return s.String()
}

// SetLaunchPathSummaries sets the LaunchPathSummaries field's value.
func (s *ListLaunchPathsOutput) SetLaunchPathSummaries(v []*LaunchPathSummary) *ListLaunchPathsOutput {
	s.LaunchPathSummaries = v
	return s
}

// SetNextPageToken sets the NextPageToken field's value.
func (s *ListLaunchPathsOutput) SetNextPageToken(v string) *ListLaunchPathsOutput {
	s.NextPageToken = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListPortfolioAccessInput
type ListPortfolioAccessInput struct {
	_ struct{} `type:"structure"`

	// The language code to use for this operation. Supported language codes are
	// as follows:
	//
	// "en" (English)
	//
	// "jp" (Japanese)
	//
	// "zh" (Chinese)
	//
	// If no code is specified, "en" is used as the default.
	AcceptLanguage *string `type:"string"`

	// The portfolio identifier.
	//
	// PortfolioId is a required field
	PortfolioId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ListPortfolioAccessInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListPortfolioAccessInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListPortfolioAccessInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListPortfolioAccessInput"}
	if s.PortfolioId == nil {
		invalidParams.Add(request.NewErrParamRequired("PortfolioId"))
	}
	if s.PortfolioId != nil && len(*s.PortfolioId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PortfolioId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAcceptLanguage sets the AcceptLanguage field's value.
func (s *ListPortfolioAccessInput) SetAcceptLanguage(v string) *ListPortfolioAccessInput {
	s.AcceptLanguage = &v
	return s
}

// SetPortfolioId sets the PortfolioId field's value.
func (s *ListPortfolioAccessInput) SetPortfolioId(v string) *ListPortfolioAccessInput {
	s.PortfolioId = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListPortfolioAccessOutput
type ListPortfolioAccessOutput struct {
	_ struct{} `type:"structure"`

	// List of account IDs associated with access to the portfolio.
	AccountIds []*string `type:"list"`

	// The page token to use to retrieve the next page of results for this operation.
	// If there are no more pages, this value is null.
	NextPageToken *string `type:"string"`
}

// String returns the string representation
func (s ListPortfolioAccessOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListPortfolioAccessOutput) GoString() string {
	return s.String()
}

// SetAccountIds sets the AccountIds field's value.
func (s *ListPortfolioAccessOutput) SetAccountIds(v []*string) *ListPortfolioAccessOutput {
	s.AccountIds = v
	return s
}

// SetNextPageToken sets the NextPageToken field's value.
func (s *ListPortfolioAccessOutput) SetNextPageToken(v string) *ListPortfolioAccessOutput {
	s.NextPageToken = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListPortfoliosForProductInput
type ListPortfoliosForProductInput struct {
	_ struct{} `type:"structure"`

	// The language code to use for this operation. Supported language codes are
	// as follows:
	//
	// "en" (English)
	//
	// "jp" (Japanese)
	//
	// "zh" (Chinese)
	//
	// If no code is specified, "en" is used as the default.
	AcceptLanguage *string `type:"string"`

	// The maximum number of items to return in the results. If more results exist
	// than fit in the specified PageSize, the value of NextPageToken in the response
	// is non-null.
	PageSize *int64 `type:"integer"`

	// The page token of the first page retrieved. If null, this retrieves the first
	// page of size PageSize.
	PageToken *string `type:"string"`

	// The product identifier.
	//
	// ProductId is a required field
	ProductId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ListPortfoliosForProductInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListPortfoliosForProductInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListPortfoliosForProductInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListPortfoliosForProductInput"}
	if s.ProductId == nil {
		invalidParams.Add(request.NewErrParamRequired("ProductId"))
	}
	if s.ProductId != nil && len(*s.ProductId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ProductId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAcceptLanguage sets the AcceptLanguage field's value.
func (s *ListPortfoliosForProductInput) SetAcceptLanguage(v string) *ListPortfoliosForProductInput {
	s.AcceptLanguage = &v
	return s
}

// SetPageSize sets the PageSize field's value.
func (s *ListPortfoliosForProductInput) SetPageSize(v int64) *ListPortfoliosForProductInput {
	s.PageSize = &v
	return s
}

// SetPageToken sets the PageToken field's value.
func (s *ListPortfoliosForProductInput) SetPageToken(v string) *ListPortfoliosForProductInput {
	s.PageToken = &v
	return s
}

// SetProductId sets the ProductId field's value.
func (s *ListPortfoliosForProductInput) SetProductId(v string) *ListPortfoliosForProductInput {
	s.ProductId = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListPortfoliosForProductOutput
type ListPortfoliosForProductOutput struct {
	_ struct{} `type:"structure"`

	// The page token to use to retrieve the next page of results for this operation.
	// If there are no more pages, this value is null.
	NextPageToken *string `type:"string"`

	// List of detailed portfolio information objects.
	PortfolioDetails []*PortfolioDetail `type:"list"`
}

// String returns the string representation
func (s ListPortfoliosForProductOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListPortfoliosForProductOutput) GoString() string {
	return s.String()
}

// SetNextPageToken sets the NextPageToken field's value.
func (s *ListPortfoliosForProductOutput) SetNextPageToken(v string) *ListPortfoliosForProductOutput {
	s.NextPageToken = &v
	return s
}

// SetPortfolioDetails sets the PortfolioDetails field's value.
func (s *ListPortfoliosForProductOutput) SetPortfolioDetails(v []*PortfolioDetail) *ListPortfoliosForProductOutput {
	s.PortfolioDetails = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListPortfoliosInput
type ListPortfoliosInput struct {
	_ struct{} `type:"structure"`

	// The language code to use for this operation. Supported language codes are
	// as follows:
	//
	// "en" (English)
	//
	// "jp" (Japanese)
	//
	// "zh" (Chinese)
	//
	// If no code is specified, "en" is used as the default.
	AcceptLanguage *string `type:"string"`

	// The maximum number of items to return in the results. If more results exist
	// than fit in the specified PageSize, the value of NextPageToken in the response
	// is non-null.
	PageSize *int64 `type:"integer"`

	// The page token of the first page retrieved. If null, this retrieves the first
	// page of size PageSize.
	PageToken *string `type:"string"`
}

// String returns the string representation
func (s ListPortfoliosInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListPortfoliosInput) GoString() string {
	return s.String()
}

// SetAcceptLanguage sets the AcceptLanguage field's value.
func (s *ListPortfoliosInput) SetAcceptLanguage(v string) *ListPortfoliosInput {
	s.AcceptLanguage = &v
	return s
}

// SetPageSize sets the PageSize field's value.
func (s *ListPortfoliosInput) SetPageSize(v int64) *ListPortfoliosInput {
	s.PageSize = &v
	return s
}

// SetPageToken sets the PageToken field's value.
func (s *ListPortfoliosInput) SetPageToken(v string) *ListPortfoliosInput {
	s.PageToken = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListPortfoliosOutput
type ListPortfoliosOutput struct {
	_ struct{} `type:"structure"`

	// The page token to use to retrieve the next page of results for this operation.
	// If there are no more pages, this value is null.
	NextPageToken *string `type:"string"`

	// List of detailed portfolio information objects.
	PortfolioDetails []*PortfolioDetail `type:"list"`
}

// String returns the string representation
func (s ListPortfoliosOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListPortfoliosOutput) GoString() string {
	return s.String()
}

// SetNextPageToken sets the NextPageToken field's value.
func (s *ListPortfoliosOutput) SetNextPageToken(v string) *ListPortfoliosOutput {
	s.NextPageToken = &v
	return s
}

// SetPortfolioDetails sets the PortfolioDetails field's value.
func (s *ListPortfoliosOutput) SetPortfolioDetails(v []*PortfolioDetail) *ListPortfoliosOutput {
	s.PortfolioDetails = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListPrincipalsForPortfolioInput
type ListPrincipalsForPortfolioInput struct {
	_ struct{} `type:"structure"`

	// The language code to use for this operation. Supported language codes are
	// as follows:
	//
	// "en" (English)
	//
	// "jp" (Japanese)
	//
	// "zh" (Chinese)
	//
	// If no code is specified, "en" is used as the default.
	AcceptLanguage *string `type:"string"`

	// The maximum number of items to return in the results. If more results exist
	// than fit in the specified PageSize, the value of NextPageToken in the response
	// is non-null.
	PageSize *int64 `type:"integer"`

	// The page token of the first page retrieved. If null, this retrieves the first
	// page of size PageSize.
	PageToken *string `type:"string"`

	// The portfolio identifier.
	//
	// PortfolioId is a required field
	PortfolioId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ListPrincipalsForPortfolioInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListPrincipalsForPortfolioInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListPrincipalsForPortfolioInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListPrincipalsForPortfolioInput"}
	if s.PortfolioId == nil {
		invalidParams.Add(request.NewErrParamRequired("PortfolioId"))
	}
	if s.PortfolioId != nil && len(*s.PortfolioId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PortfolioId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAcceptLanguage sets the AcceptLanguage field's value.
func (s *ListPrincipalsForPortfolioInput) SetAcceptLanguage(v string) *ListPrincipalsForPortfolioInput {
	s.AcceptLanguage = &v
	return s
}

// SetPageSize sets the PageSize field's value.
func (s *ListPrincipalsForPortfolioInput) SetPageSize(v int64) *ListPrincipalsForPortfolioInput {
	s.PageSize = &v
	return s
}

// SetPageToken sets the PageToken field's value.
func (s *ListPrincipalsForPortfolioInput) SetPageToken(v string) *ListPrincipalsForPortfolioInput {
	s.PageToken = &v
	return s
}

// SetPortfolioId sets the PortfolioId field's value.
func (s *ListPrincipalsForPortfolioInput) SetPortfolioId(v string) *ListPrincipalsForPortfolioInput {
	s.PortfolioId = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListPrincipalsForPortfolioOutput
type ListPrincipalsForPortfolioOutput struct {
	_ struct{} `type:"structure"`

	// The page token to use to retrieve the next page of results for this operation.
	// If there are no more pages, this value is null.
	NextPageToken *string `type:"string"`

	// The IAM principals (users or roles) associated with the portfolio.
	Principals []*Principal `type:"list"`
}

// String returns the string representation
func (s ListPrincipalsForPortfolioOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListPrincipalsForPortfolioOutput) GoString() string {
	return s.String()
}

// SetNextPageToken sets the NextPageToken field's value.
func (s *ListPrincipalsForPortfolioOutput) SetNextPageToken(v string) *ListPrincipalsForPortfolioOutput {
	s.NextPageToken = &v
	return s
}

// SetPrincipals sets the Principals field's value.
func (s *ListPrincipalsForPortfolioOutput) SetPrincipals(v []*Principal) *ListPrincipalsForPortfolioOutput {
	s.Principals = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListProvisioningArtifactsInput
type ListProvisioningArtifactsInput struct {
	_ struct{} `type:"structure"`

	// The language code to use for this operation. Supported language codes are
	// as follows:
	//
	// "en" (English)
	//
	// "jp" (Japanese)
	//
	// "zh" (Chinese)
	//
	// If no code is specified, "en" is used as the default.
	AcceptLanguage *string `type:"string"`

	// The product identifier.
	//
	// ProductId is a required field
	ProductId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ListProvisioningArtifactsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListProvisioningArtifactsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListProvisioningArtifactsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListProvisioningArtifactsInput"}
	if s.ProductId == nil {
		invalidParams.Add(request.NewErrParamRequired("ProductId"))
	}
	if s.ProductId != nil && len(*s.ProductId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ProductId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAcceptLanguage sets the AcceptLanguage field's value.
func (s *ListProvisioningArtifactsInput) SetAcceptLanguage(v string) *ListProvisioningArtifactsInput {
	s.AcceptLanguage = &v
	return s
}

// SetProductId sets the ProductId field's value.
func (s *ListProvisioningArtifactsInput) SetProductId(v string) *ListProvisioningArtifactsInput {
	s.ProductId = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListProvisioningArtifactsOutput
type ListProvisioningArtifactsOutput struct {
	_ struct{} `type:"structure"`

	// The page token to use to retrieve the next page of results for this operation.
	// If there are no more pages, this value is null.
	NextPageToken *string `type:"string"`

	// List of detailed provisioning artifact information objects.
	ProvisioningArtifactDetails []*ProvisioningArtifactDetail `type:"list"`
}

// String returns the string representation
func (s ListProvisioningArtifactsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListProvisioningArtifactsOutput) GoString() string {
	return s.String()
}

// SetNextPageToken sets the NextPageToken field's value.
func (s *ListProvisioningArtifactsOutput) SetNextPageToken(v string) *ListProvisioningArtifactsOutput {
	s.NextPageToken = &v
	return s
}

// SetProvisioningArtifactDetails sets the ProvisioningArtifactDetails field's value.
func (s *ListProvisioningArtifactsOutput) SetProvisioningArtifactDetails(v []*ProvisioningArtifactDetail) *ListProvisioningArtifactsOutput {
	s.ProvisioningArtifactDetails = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListRecordHistoryInput
type ListRecordHistoryInput struct {
	_ struct{} `type:"structure"`

	// The language code to use for this operation. Supported language codes are
	// as follows:
	//
	// "en" (English)
	//
	// "jp" (Japanese)
	//
	// "zh" (Chinese)
	//
	// If no code is specified, "en" is used as the default.
	AcceptLanguage *string `type:"string"`

	// The access level for obtaining results. If left unspecified, User level access
	// is used.
	AccessLevelFilter *AccessLevelFilter `type:"structure"`

	// The maximum number of items to return in the results. If more results exist
	// than fit in the specified PageSize, the value of NextPageToken in the response
	// is non-null.
	PageSize *int64 `type:"integer"`

	// The page token of the first page retrieved. If null, this retrieves the first
	// page of size PageSize.
	PageToken *string `type:"string"`

	// The filter to limit search results.
	SearchFilter *ListRecordHistorySearchFilter `type:"structure"`
}

// String returns the string representation
func (s ListRecordHistoryInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListRecordHistoryInput) GoString() string {
	return s.String()
}

// SetAcceptLanguage sets the AcceptLanguage field's value.
func (s *ListRecordHistoryInput) SetAcceptLanguage(v string) *ListRecordHistoryInput {
	s.AcceptLanguage = &v
	return s
}

// SetAccessLevelFilter sets the AccessLevelFilter field's value.
func (s *ListRecordHistoryInput) SetAccessLevelFilter(v *AccessLevelFilter) *ListRecordHistoryInput {
	s.AccessLevelFilter = v
	return s
}

// SetPageSize sets the PageSize field's value.
func (s *ListRecordHistoryInput) SetPageSize(v int64) *ListRecordHistoryInput {
	s.PageSize = &v
	return s
}

// SetPageToken sets the PageToken field's value.
func (s *ListRecordHistoryInput) SetPageToken(v string) *ListRecordHistoryInput {
	s.PageToken = &v
	return s
}

// SetSearchFilter sets the SearchFilter field's value.
func (s *ListRecordHistoryInput) SetSearchFilter(v *ListRecordHistorySearchFilter) *ListRecordHistoryInput {
	s.SearchFilter = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListRecordHistoryOutput
type ListRecordHistoryOutput struct {
	_ struct{} `type:"structure"`

	// The page token to use to retrieve the next page of results for this operation.
	// If there are no more pages, this value is null.
	NextPageToken *string `type:"string"`

	// A list of record detail objects, listed in reverse chronological order.
	RecordDetails []*RecordDetail `type:"list"`
}

// String returns the string representation
func (s ListRecordHistoryOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListRecordHistoryOutput) GoString() string {
	return s.String()
}

// SetNextPageToken sets the NextPageToken field's value.
func (s *ListRecordHistoryOutput) SetNextPageToken(v string) *ListRecordHistoryOutput {
	s.NextPageToken = &v
	return s
}

// SetRecordDetails sets the RecordDetails field's value.
func (s *ListRecordHistoryOutput) SetRecordDetails(v []*RecordDetail) *ListRecordHistoryOutput {
	s.RecordDetails = v
	return s
}

// The search filter to limit results when listing request history records.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListRecordHistorySearchFilter
type ListRecordHistorySearchFilter struct {
	_ struct{} `type:"structure"`

	// The filter key.
	Key *string `type:"string"`

	// The filter value for Key.
	Value *string `type:"string"`
}

// String returns the string representation
func (s ListRecordHistorySearchFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListRecordHistorySearchFilter) GoString() string {
	return s.String()
}

// SetKey sets the Key field's value.
func (s *ListRecordHistorySearchFilter) SetKey(v string) *ListRecordHistorySearchFilter {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *ListRecordHistorySearchFilter) SetValue(v string) *ListRecordHistorySearchFilter {
	s.Value = &v
	return s
}

// The constraints that the administrator has put on the parameter.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ParameterConstraints
type ParameterConstraints struct {
	_ struct{} `type:"structure"`

	// The values that the administrator has allowed for the parameter.
	AllowedValues []*string `type:"list"`
}

// String returns the string representation
func (s ParameterConstraints) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ParameterConstraints) GoString() string {
	return s.String()
}

// SetAllowedValues sets the AllowedValues field's value.
func (s *ParameterConstraints) SetAllowedValues(v []*string) *ParameterConstraints {
	s.AllowedValues = v
	return s
}

// Detailed portfolio information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/PortfolioDetail
type PortfolioDetail struct {
	_ struct{} `type:"structure"`

	// The ARN assigned to the portfolio.
	ARN *string `min:"1" type:"string"`

	// The UTC timestamp of the creation time.
	CreatedTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The text description of the portfolio.
	Description *string `type:"string"`

	// The name to use for display purposes.
	DisplayName *string `min:"1" type:"string"`

	// The identifier for the portfolio.
	Id *string `min:"1" type:"string"`

	// The name of the portfolio provider.
	ProviderName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s PortfolioDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PortfolioDetail) GoString() string {
	return s.String()
}

// SetARN sets the ARN field's value.
func (s *PortfolioDetail) SetARN(v string) *PortfolioDetail {
	s.ARN = &v
	return s
}

// SetCreatedTime sets the CreatedTime field's value.
func (s *PortfolioDetail) SetCreatedTime(v time.Time) *PortfolioDetail {
	s.CreatedTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *PortfolioDetail) SetDescription(v string) *PortfolioDetail {
	s.Description = &v
	return s
}

// SetDisplayName sets the DisplayName field's value.
func (s *PortfolioDetail) SetDisplayName(v string) *PortfolioDetail {
	s.DisplayName = &v
	return s
}

// SetId sets the Id field's value.
func (s *PortfolioDetail) SetId(v string) *PortfolioDetail {
	s.Id = &v
	return s
}

// SetProviderName sets the ProviderName field's value.
func (s *PortfolioDetail) SetProviderName(v string) *PortfolioDetail {
	s.ProviderName = &v
	return s
}

// A principal's ARN and type.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/Principal
type Principal struct {
	_ struct{} `type:"structure"`

	// The ARN representing the principal (IAM user, role, or group).
	PrincipalARN *string `min:"1" type:"string"`

	// The principal type. Must be IAM
	PrincipalType *string `type:"string" enum:"PrincipalType"`
}

// String returns the string representation
func (s Principal) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Principal) GoString() string {
	return s.String()
}

// SetPrincipalARN sets the PrincipalARN field's value.
func (s *Principal) SetPrincipalARN(v string) *Principal {
	s.PrincipalARN = &v
	return s
}

// SetPrincipalType sets the PrincipalType field's value.
func (s *Principal) SetPrincipalType(v string) *Principal {
	s.PrincipalType = &v
	return s
}

// A single product view aggregation value/count pair, containing metadata about
// each product to which the calling user has access.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ProductViewAggregationValue
type ProductViewAggregationValue struct {
	_ struct{} `type:"structure"`

	// An approximate count of the products that match the value.
	ApproximateCount *int64 `type:"integer"`

	// The value of the product view aggregation.
	Value *string `type:"string"`
}

// String returns the string representation
func (s ProductViewAggregationValue) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ProductViewAggregationValue) GoString() string {
	return s.String()
}

// SetApproximateCount sets the ApproximateCount field's value.
func (s *ProductViewAggregationValue) SetApproximateCount(v int64) *ProductViewAggregationValue {
	s.ApproximateCount = &v
	return s
}

// SetValue sets the Value field's value.
func (s *ProductViewAggregationValue) SetValue(v string) *ProductViewAggregationValue {
	s.Value = &v
	return s
}

// Detailed product view information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ProductViewDetail
type ProductViewDetail struct {
	_ struct{} `type:"structure"`

	// The UTC timestamp of the creation time.
	CreatedTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The ARN associated with the product.
	ProductARN *string `min:"1" type:"string"`

	// The summary metadata about the specified product view.
	ProductViewSummary *ProductViewSummary `type:"structure"`

	// Current status of the product.
	Status *string `type:"string" enum:"Status"`
}

// String returns the string representation
func (s ProductViewDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ProductViewDetail) GoString() string {
	return s.String()
}

// SetCreatedTime sets the CreatedTime field's value.
func (s *ProductViewDetail) SetCreatedTime(v time.Time) *ProductViewDetail {
	s.CreatedTime = &v
	return s
}

// SetProductARN sets the ProductARN field's value.
func (s *ProductViewDetail) SetProductARN(v string) *ProductViewDetail {
	s.ProductARN = &v
	return s
}

// SetProductViewSummary sets the ProductViewSummary field's value.
func (s *ProductViewDetail) SetProductViewSummary(v *ProductViewSummary) *ProductViewDetail {
	s.ProductViewSummary = v
	return s
}

// SetStatus sets the Status field's value.
func (s *ProductViewDetail) SetStatus(v string) *ProductViewDetail {
	s.Status = &v
	return s
}

// The summary metadata about the specified product.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ProductViewSummary
type ProductViewSummary struct {
	_ struct{} `type:"structure"`

	// The distributor of the product. Contact the product administrator for the
	// significance of this value.
	Distributor *string `type:"string"`

	// A value of false indicates that the product does not have a default path,
	// while a value of true indicates that it does. If it's false, call ListLaunchPaths
	// to disambiguate between paths. If true, ListLaunchPaths is not required,
	// and the output of the ProductViewSummary operation can be used directly with
	// DescribeProvisioningParameters.
	HasDefaultPath *bool `type:"boolean"`

	// The product view identifier.
	Id *string `min:"1" type:"string"`

	// The name of the product.
	Name *string `type:"string"`

	// The owner of the product. Contact the product administrator for the significance
	// of this value.
	Owner *string `type:"string"`

	// The product identifier.
	ProductId *string `min:"1" type:"string"`

	// Short description of the product.
	ShortDescription *string `type:"string"`

	// The description of the support for this Product.
	SupportDescription *string `type:"string"`

	// The email contact information to obtain support for this Product.
	SupportEmail *string `type:"string"`

	// The URL information to obtain support for this Product.
	SupportUrl *string `type:"string"`

	// The product type. Contact the product administrator for the significance
	// of this value.
	Type *string `type:"string" enum:"ProductType"`
}

// String returns the string representation
func (s ProductViewSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ProductViewSummary) GoString() string {
	return s.String()
}

// SetDistributor sets the Distributor field's value.
func (s *ProductViewSummary) SetDistributor(v string) *ProductViewSummary {
	s.Distributor = &v
	return s
}

// SetHasDefaultPath sets the HasDefaultPath field's value.
func (s *ProductViewSummary) SetHasDefaultPath(v bool) *ProductViewSummary {
	s.HasDefaultPath = &v
	return s
}

// SetId sets the Id field's value.
func (s *ProductViewSummary) SetId(v string) *ProductViewSummary {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *ProductViewSummary) SetName(v string) *ProductViewSummary {
	s.Name = &v
	return s
}

// SetOwner sets the Owner field's value.
func (s *ProductViewSummary) SetOwner(v string) *ProductViewSummary {
	s.Owner = &v
	return s
}

// SetProductId sets the ProductId field's value.
func (s *ProductViewSummary) SetProductId(v string) *ProductViewSummary {
	s.ProductId = &v
	return s
}

// SetShortDescription sets the ShortDescription field's value.
func (s *ProductViewSummary) SetShortDescription(v string) *ProductViewSummary {
	s.ShortDescription = &v
	return s
}

// SetSupportDescription sets the SupportDescription field's value.
func (s *ProductViewSummary) SetSupportDescription(v string) *ProductViewSummary {
	s.SupportDescription = &v
	return s
}

// SetSupportEmail sets the SupportEmail field's value.
func (s *ProductViewSummary) SetSupportEmail(v string) *ProductViewSummary {
	s.SupportEmail = &v
	return s
}

// SetSupportUrl sets the SupportUrl field's value.
func (s *ProductViewSummary) SetSupportUrl(v string) *ProductViewSummary {
	s.SupportUrl = &v
	return s
}

// SetType sets the Type field's value.
func (s *ProductViewSummary) SetType(v string) *ProductViewSummary {
	s.Type = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ProvisionProductInput
type ProvisionProductInput struct {
	_ struct{} `type:"structure"`

	// The language code to use for this operation. Supported language codes are
	// as follows:
	//
	// "en" (English)
	//
	// "jp" (Japanese)
	//
	// "zh" (Chinese)
	//
	// If no code is specified, "en" is used as the default.
	AcceptLanguage *string `type:"string"`

	// Passed to CloudFormation. The SNS topic ARNs to which to publish stack-related
	// events.
	NotificationArns []*string `type:"list"`

	// The identifier of the path for this product's provisioning. This value is
	// optional if the product has a default path, and is required if there is more
	// than one path for the specified product.
	PathId *string `min:"1" type:"string"`

	// The product identifier.
	//
	// ProductId is a required field
	ProductId *string `min:"1" type:"string" required:"true"`

	// An idempotency token that uniquely identifies the provisioning request.
	//
	// ProvisionToken is a required field
	ProvisionToken *string `min:"1" type:"string" required:"true" idempotencyToken:"true"`

	// A user-friendly name to identify the ProvisionedProduct object. This value
	// must be unique for the AWS account and cannot be updated after the product
	// is provisioned.
	//
	// ProvisionedProductName is a required field
	ProvisionedProductName *string `type:"string" required:"true"`

	// The provisioning artifact identifier for this product.
	//
	// ProvisioningArtifactId is a required field
	ProvisioningArtifactId *string `min:"1" type:"string" required:"true"`

	// Parameters specified by the administrator that are required for provisioning
	// the product.
	ProvisioningParameters []*ProvisioningParameter `type:"list"`

	// A list of tags to use as provisioning options.
	Tags []*Tag `type:"list"`
}

// String returns the string representation
func (s ProvisionProductInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ProvisionProductInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ProvisionProductInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ProvisionProductInput"}
	if s.PathId != nil && len(*s.PathId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PathId", 1))
	}
	if s.ProductId == nil {
		invalidParams.Add(request.NewErrParamRequired("ProductId"))
	}
	if s.ProductId != nil && len(*s.ProductId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ProductId", 1))
	}
	if s.ProvisionToken == nil {
		invalidParams.Add(request.NewErrParamRequired("ProvisionToken"))
	}
	if s.ProvisionToken != nil && len(*s.ProvisionToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ProvisionToken", 1))
	}
	if s.ProvisionedProductName == nil {
		invalidParams.Add(request.NewErrParamRequired("ProvisionedProductName"))
	}
	if s.ProvisioningArtifactId == nil {
		invalidParams.Add(request.NewErrParamRequired("ProvisioningArtifactId"))
	}
	if s.ProvisioningArtifactId != nil && len(*s.ProvisioningArtifactId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ProvisioningArtifactId", 1))
	}
	if s.ProvisioningParameters != nil {
		for i, v := range s.ProvisioningParameters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ProvisioningParameters", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAcceptLanguage sets the AcceptLanguage field's value.
func (s *ProvisionProductInput) SetAcceptLanguage(v string) *ProvisionProductInput {
	s.AcceptLanguage = &v
	return s
}

// SetNotificationArns sets the NotificationArns field's value.
func (s *ProvisionProductInput) SetNotificationArns(v []*string) *ProvisionProductInput {
	s.NotificationArns = v
	return s
}

// SetPathId sets the PathId field's value.
func (s *ProvisionProductInput) SetPathId(v string) *ProvisionProductInput {
	s.PathId = &v
	return s
}

// SetProductId sets the ProductId field's value.
func (s *ProvisionProductInput) SetProductId(v string) *ProvisionProductInput {
	s.ProductId = &v
	return s
}

// SetProvisionToken sets the ProvisionToken field's value.
func (s *ProvisionProductInput) SetProvisionToken(v string) *ProvisionProductInput {
	s.ProvisionToken = &v
	return s
}

// SetProvisionedProductName sets the ProvisionedProductName field's value.
func (s *ProvisionProductInput) SetProvisionedProductName(v string) *ProvisionProductInput {
	s.ProvisionedProductName = &v
	return s
}

// SetProvisioningArtifactId sets the ProvisioningArtifactId field's value.
func (s *ProvisionProductInput) SetProvisioningArtifactId(v string) *ProvisionProductInput {
	s.ProvisioningArtifactId = &v
	return s
}

// SetProvisioningParameters sets the ProvisioningParameters field's value.
func (s *ProvisionProductInput) SetProvisioningParameters(v []*ProvisioningParameter) *ProvisionProductInput {
	s.ProvisioningParameters = v
	return s
}

// SetTags sets the Tags field's value.
func (s *ProvisionProductInput) SetTags(v []*Tag) *ProvisionProductInput {
	s.Tags = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ProvisionProductOutput
type ProvisionProductOutput struct {
	_ struct{} `type:"structure"`

	// The detailed result of the ProvisionProduct request, containing the inputs
	// made to that request, the current state of the request, a pointer to the
	// ProvisionedProduct object of the request, and a list of any errors that the
	// request encountered.
	RecordDetail *RecordDetail `type:"structure"`
}

// String returns the string representation
func (s ProvisionProductOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ProvisionProductOutput) GoString() string {
	return s.String()
}

// SetRecordDetail sets the RecordDetail field's value.
func (s *ProvisionProductOutput) SetRecordDetail(v *RecordDetail) *ProvisionProductOutput {
	s.RecordDetail = v
	return s
}

// Detailed information about a ProvisionedProduct object.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ProvisionedProductDetail
type ProvisionedProductDetail struct {
	_ struct{} `type:"structure"`

	// The ARN associated with the ProvisionedProduct object.
	Arn *string `min:"1" type:"string"`

	// The UTC timestamp of the creation time.
	CreatedTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The identifier of the ProvisionedProduct object.
	Id *string `type:"string"`

	// A token to disambiguate duplicate requests. You can create multiple resources
	// using the same input in multiple requests, provided that you also specify
	// a different idempotency token for each request.
	IdempotencyToken *string `min:"1" type:"string"`

	// The record identifier of the last request performed on this ProvisionedProduct
	// object.
	LastRecordId *string `type:"string"`

	// The user-friendly name of the ProvisionedProduct object.
	Name *string `min:"1" type:"string"`

	// The current status of the ProvisionedProduct.
	Status *string `type:"string" enum:"RecordStatus"`

	// The current status message of the ProvisionedProduct.
	StatusMessage *string `type:"string"`

	// The type of the ProvisionedProduct object.
	Type *string `type:"string"`
}

// String returns the string representation
func (s ProvisionedProductDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ProvisionedProductDetail) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *ProvisionedProductDetail) SetArn(v string) *ProvisionedProductDetail {
	s.Arn = &v
	return s
}

// SetCreatedTime sets the CreatedTime field's value.
func (s *ProvisionedProductDetail) SetCreatedTime(v time.Time) *ProvisionedProductDetail {
	s.CreatedTime = &v
	return s
}

// SetId sets the Id field's value.
func (s *ProvisionedProductDetail) SetId(v string) *ProvisionedProductDetail {
	s.Id = &v
	return s
}

// SetIdempotencyToken sets the IdempotencyToken field's value.
func (s *ProvisionedProductDetail) SetIdempotencyToken(v string) *ProvisionedProductDetail {
	s.IdempotencyToken = &v
	return s
}

// SetLastRecordId sets the LastRecordId field's value.
func (s *ProvisionedProductDetail) SetLastRecordId(v string) *ProvisionedProductDetail {
	s.LastRecordId = &v
	return s
}

// SetName sets the Name field's value.
func (s *ProvisionedProductDetail) SetName(v string) *ProvisionedProductDetail {
	s.Name = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ProvisionedProductDetail) SetStatus(v string) *ProvisionedProductDetail {
	s.Status = &v
	return s
}

// SetStatusMessage sets the StatusMessage field's value.
func (s *ProvisionedProductDetail) SetStatusMessage(v string) *ProvisionedProductDetail {
	s.StatusMessage = &v
	return s
}

// SetType sets the Type field's value.
func (s *ProvisionedProductDetail) SetType(v string) *ProvisionedProductDetail {
	s.Type = &v
	return s
}

// Contains information indicating the ways in which a product can be provisioned.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ProvisioningArtifact
type ProvisioningArtifact struct {
	_ struct{} `type:"structure"`

	// The UTC timestamp of the creation time.
	CreatedTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The text description of the artifact.
	Description *string `type:"string"`

	// The identifier for the artifact.
	Id *string `min:"1" type:"string"`

	// The name of the artifact.
	Name *string `type:"string"`
}

// String returns the string representation
func (s ProvisioningArtifact) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ProvisioningArtifact) GoString() string {
	return s.String()
}

// SetCreatedTime sets the CreatedTime field's value.
func (s *ProvisioningArtifact) SetCreatedTime(v time.Time) *ProvisioningArtifact {
	s.CreatedTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *ProvisioningArtifact) SetDescription(v string) *ProvisioningArtifact {
	s.Description = &v
	return s
}

// SetId sets the Id field's value.
func (s *ProvisioningArtifact) SetId(v string) *ProvisioningArtifact {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *ProvisioningArtifact) SetName(v string) *ProvisioningArtifact {
	s.Name = &v
	return s
}

// Detailed provisioning artifact information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ProvisioningArtifactDetail
type ProvisioningArtifactDetail struct {
	_ struct{} `type:"structure"`

	// The UTC timestamp of the creation time.
	CreatedTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The text description of the provisioning artifact.
	Description *string `type:"string"`

	// The identifier of the provisioning artifact.
	Id *string `min:"1" type:"string"`

	// The name assigned to the provisioning artifact.
	Name *string `type:"string"`

	// The type of the provisioning artifact.
	Type *string `type:"string" enum:"ProvisioningArtifactType"`
}

// String returns the string representation
func (s ProvisioningArtifactDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ProvisioningArtifactDetail) GoString() string {
	return s.String()
}

// SetCreatedTime sets the CreatedTime field's value.
func (s *ProvisioningArtifactDetail) SetCreatedTime(v time.Time) *ProvisioningArtifactDetail {
	s.CreatedTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *ProvisioningArtifactDetail) SetDescription(v string) *ProvisioningArtifactDetail {
	s.Description = &v
	return s
}

// SetId sets the Id field's value.
func (s *ProvisioningArtifactDetail) SetId(v string) *ProvisioningArtifactDetail {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *ProvisioningArtifactDetail) SetName(v string) *ProvisioningArtifactDetail {
	s.Name = &v
	return s
}

// SetType sets the Type field's value.
func (s *ProvisioningArtifactDetail) SetType(v string) *ProvisioningArtifactDetail {
	s.Type = &v
	return s
}

// A parameter used to successfully provision the product. This value includes
// a list of allowable values and additional metadata.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ProvisioningArtifactParameter
type ProvisioningArtifactParameter struct {
	_ struct{} `type:"structure"`

	// The default value for this parameter.
	DefaultValue *string `type:"string"`

	// The text description of the parameter.
	Description *string `type:"string"`

	// If this value is true, the value for this parameter is obfuscated from view
	// when the parameter is retrieved. This parameter is used to hide sensitive
	// information.
	IsNoEcho *bool `type:"boolean"`

	// The list of constraints that the administrator has put on the parameter.
	ParameterConstraints *ParameterConstraints `type:"structure"`

	// The parameter key.
	ParameterKey *string `min:"1" type:"string"`

	// The parameter type.
	ParameterType *string `type:"string"`
}

// String returns the string representation
func (s ProvisioningArtifactParameter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ProvisioningArtifactParameter) GoString() string {
	return s.String()
}

// SetDefaultValue sets the DefaultValue field's value.
func (s *ProvisioningArtifactParameter) SetDefaultValue(v string) *ProvisioningArtifactParameter {
	s.DefaultValue = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *ProvisioningArtifactParameter) SetDescription(v string) *ProvisioningArtifactParameter {
	s.Description = &v
	return s
}

// SetIsNoEcho sets the IsNoEcho field's value.
func (s *ProvisioningArtifactParameter) SetIsNoEcho(v bool) *ProvisioningArtifactParameter {
	s.IsNoEcho = &v
	return s
}

// SetParameterConstraints sets the ParameterConstraints field's value.
func (s *ProvisioningArtifactParameter) SetParameterConstraints(v *ParameterConstraints) *ProvisioningArtifactParameter {
	s.ParameterConstraints = v
	return s
}

// SetParameterKey sets the ParameterKey field's value.
func (s *ProvisioningArtifactParameter) SetParameterKey(v string) *ProvisioningArtifactParameter {
	s.ParameterKey = &v
	return s
}

// SetParameterType sets the ParameterType field's value.
func (s *ProvisioningArtifactParameter) SetParameterType(v string) *ProvisioningArtifactParameter {
	s.ParameterType = &v
	return s
}

// Provisioning artifact properties.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ProvisioningArtifactProperties
type ProvisioningArtifactProperties struct {
	_ struct{} `type:"structure"`

	// The text description of the provisioning artifact properties.
	Description *string `type:"string"`

	// Additional information about the provisioning artifact properties.
	//
	// Info is a required field
	Info map[string]*string `min:"1" type:"map" required:"true"`

	// The name assigned to the provisioning artifact properties.
	Name *string `type:"string"`

	// The type of the provisioning artifact properties.
	Type *string `type:"string" enum:"ProvisioningArtifactType"`
}

// String returns the string representation
func (s ProvisioningArtifactProperties) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ProvisioningArtifactProperties) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ProvisioningArtifactProperties) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ProvisioningArtifactProperties"}
	if s.Info == nil {
		invalidParams.Add(request.NewErrParamRequired("Info"))
	}
	if s.Info != nil && len(s.Info) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Info", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *ProvisioningArtifactProperties) SetDescription(v string) *ProvisioningArtifactProperties {
	s.Description = &v
	return s
}

// SetInfo sets the Info field's value.
func (s *ProvisioningArtifactProperties) SetInfo(v map[string]*string) *ProvisioningArtifactProperties {
	s.Info = v
	return s
}

// SetName sets the Name field's value.
func (s *ProvisioningArtifactProperties) SetName(v string) *ProvisioningArtifactProperties {
	s.Name = &v
	return s
}

// SetType sets the Type field's value.
func (s *ProvisioningArtifactProperties) SetType(v string) *ProvisioningArtifactProperties {
	s.Type = &v
	return s
}

// The arameter key/value pairs used to provision a product.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ProvisioningParameter
type ProvisioningParameter struct {
	_ struct{} `type:"structure"`

	// The ProvisioningArtifactParameter.ParameterKey parameter from DescribeProvisioningParameters.
	Key *string `min:"1" type:"string"`

	// The value to use for provisioning. Any constraints on this value can be found
	// in ProvisioningArtifactParameter for Key.
	Value *string `type:"string"`
}

// String returns the string representation
func (s ProvisioningParameter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ProvisioningParameter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ProvisioningParameter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ProvisioningParameter"}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKey sets the Key field's value.
func (s *ProvisioningParameter) SetKey(v string) *ProvisioningParameter {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *ProvisioningParameter) SetValue(v string) *ProvisioningParameter {
	s.Value = &v
	return s
}

// The full details of a specific ProvisionedProduct object.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/RecordDetail
type RecordDetail struct {
	_ struct{} `type:"structure"`

	// The UTC timestamp of the creation time.
	CreatedTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The identifier of the path for this product's provisioning.
	PathId *string `min:"1" type:"string"`

	// The product identifier.
	ProductId *string `min:"1" type:"string"`

	// The identifier of the ProvisionedProduct object.
	ProvisionedProductId *string `min:"1" type:"string"`

	// The user-friendly name of the ProvisionedProduct object.
	ProvisionedProductName *string `type:"string"`

	// The type of the ProvisionedProduct object.
	ProvisionedProductType *string `type:"string"`

	// The provisioning artifact identifier for this product.
	ProvisioningArtifactId *string `min:"1" type:"string"`

	// A list of errors that occurred while processing the request.
	RecordErrors []*RecordError `type:"list"`

	// The identifier of the ProvisionedProduct object record.
	RecordId *string `min:"1" type:"string"`

	// List of tags associated with this record.
	RecordTags []*RecordTag `type:"list"`

	// The record type for this record.
	RecordType *string `type:"string"`

	// The status of the ProvisionedProduct object.
	Status *string `type:"string" enum:"RecordStatus"`

	// The time when the record for the ProvisionedProduct object was last updated.
	UpdatedTime *time.Time `type:"timestamp" timestampFormat:"unix"`
}

// String returns the string representation
func (s RecordDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RecordDetail) GoString() string {
	return s.String()
}

// SetCreatedTime sets the CreatedTime field's value.
func (s *RecordDetail) SetCreatedTime(v time.Time) *RecordDetail {
	s.CreatedTime = &v
	return s
}

// SetPathId sets the PathId field's value.
func (s *RecordDetail) SetPathId(v string) *RecordDetail {
	s.PathId = &v
	return s
}

// SetProductId sets the ProductId field's value.
func (s *RecordDetail) SetProductId(v string) *RecordDetail {
	s.ProductId = &v
	return s
}

// SetProvisionedProductId sets the ProvisionedProductId field's value.
func (s *RecordDetail) SetProvisionedProductId(v string) *RecordDetail {
	s.ProvisionedProductId = &v
	return s
}

// SetProvisionedProductName sets the ProvisionedProductName field's value.
func (s *RecordDetail) SetProvisionedProductName(v string) *RecordDetail {
	s.ProvisionedProductName = &v
	return s
}

// SetProvisionedProductType sets the ProvisionedProductType field's value.
func (s *RecordDetail) SetProvisionedProductType(v string) *RecordDetail {
	s.ProvisionedProductType = &v
	return s
}

// SetProvisioningArtifactId sets the ProvisioningArtifactId field's value.
func (s *RecordDetail) SetProvisioningArtifactId(v string) *RecordDetail {
	s.ProvisioningArtifactId = &v
	return s
}

// SetRecordErrors sets the RecordErrors field's value.
func (s *RecordDetail) SetRecordErrors(v []*RecordError) *RecordDetail {
	s.RecordErrors = v
	return s
}

// SetRecordId sets the RecordId field's value.
func (s *RecordDetail) SetRecordId(v string) *RecordDetail {
	s.RecordId = &v
	return s
}

// SetRecordTags sets the RecordTags field's value.
func (s *RecordDetail) SetRecordTags(v []*RecordTag) *RecordDetail {
	s.RecordTags = v
	return s
}

// SetRecordType sets the RecordType field's value.
func (s *RecordDetail) SetRecordType(v string) *RecordDetail {
	s.RecordType = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *RecordDetail) SetStatus(v string) *RecordDetail {
	s.Status = &v
	return s
}

// SetUpdatedTime sets the UpdatedTime field's value.
func (s *RecordDetail) SetUpdatedTime(v time.Time) *RecordDetail {
	s.UpdatedTime = &v
	return s
}

// The error code and description resulting from an operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/RecordError
type RecordError struct {
	_ struct{} `type:"structure"`

	// The numeric value of the error.
	Code *string `type:"string"`

	// The text description of the error.
	Description *string `type:"string"`
}

// String returns the string representation
func (s RecordError) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RecordError) GoString() string {
	return s.String()
}

// SetCode sets the Code field's value.
func (s *RecordError) SetCode(v string) *RecordError {
	s.Code = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *RecordError) SetDescription(v string) *RecordError {
	s.Description = &v
	return s
}

// An output for the specified Product object created as the result of a request.
// For example, a CloudFormation-backed product that creates an S3 bucket would
// have an output for the S3 bucket URL.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/RecordOutput
type RecordOutput struct {
	_ struct{} `type:"structure"`

	// The text description of the output.
	Description *string `type:"string"`

	// The output key.
	OutputKey *string `type:"string"`

	// The output value.
	OutputValue *string `type:"string"`
}

// String returns the string representation
func (s RecordOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RecordOutput) GoString() string {
	return s.String()
}

// SetDescription sets the Description field's value.
func (s *RecordOutput) SetDescription(v string) *RecordOutput {
	s.Description = &v
	return s
}

// SetOutputKey sets the OutputKey field's value.
func (s *RecordOutput) SetOutputKey(v string) *RecordOutput {
	s.OutputKey = &v
	return s
}

// SetOutputValue sets the OutputValue field's value.
func (s *RecordOutput) SetOutputValue(v string) *RecordOutput {
	s.OutputValue = &v
	return s
}

// A tag associated with the record, stored as a key-value pair.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/RecordTag
type RecordTag struct {
	_ struct{} `type:"structure"`

	// The key for this tag.
	Key *string `min:"1" type:"string"`

	// The value for this tag.
	Value *string `min:"1" type:"string"`
}

// String returns the string representation
func (s RecordTag) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RecordTag) GoString() string {
	return s.String()
}

// SetKey sets the Key field's value.
func (s *RecordTag) SetKey(v string) *RecordTag {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *RecordTag) SetValue(v string) *RecordTag {
	s.Value = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/RejectPortfolioShareInput
type RejectPortfolioShareInput struct {
	_ struct{} `type:"structure"`

	// The language code to use for this operation. Supported language codes are
	// as follows:
	//
	// "en" (English)
	//
	// "jp" (Japanese)
	//
	// "zh" (Chinese)
	//
	// If no code is specified, "en" is used as the default.
	AcceptLanguage *string `type:"string"`

	// The portfolio identifier.
	//
	// PortfolioId is a required field
	PortfolioId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s RejectPortfolioShareInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RejectPortfolioShareInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RejectPortfolioShareInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RejectPortfolioShareInput"}
	if s.PortfolioId == nil {
		invalidParams.Add(request.NewErrParamRequired("PortfolioId"))
	}
	if s.PortfolioId != nil && len(*s.PortfolioId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PortfolioId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAcceptLanguage sets the AcceptLanguage field's value.
func (s *RejectPortfolioShareInput) SetAcceptLanguage(v string) *RejectPortfolioShareInput {
	s.AcceptLanguage = &v
	return s
}

// SetPortfolioId sets the PortfolioId field's value.
func (s *RejectPortfolioShareInput) SetPortfolioId(v string) *RejectPortfolioShareInput {
	s.PortfolioId = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/RejectPortfolioShareOutput
type RejectPortfolioShareOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s RejectPortfolioShareOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RejectPortfolioShareOutput) GoString() string {
	return s.String()
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ScanProvisionedProductsInput
type ScanProvisionedProductsInput struct {
	_ struct{} `type:"structure"`

	// The language code to use for this operation. Supported language codes are
	// as follows:
	//
	// "en" (English)
	//
	// "jp" (Japanese)
	//
	// "zh" (Chinese)
	//
	// If no code is specified, "en" is used as the default.
	AcceptLanguage *string `type:"string"`

	// The access level for obtaining results. If left unspecified, User level access
	// is used.
	AccessLevelFilter *AccessLevelFilter `type:"structure"`

	// The maximum number of items to return in the results. If more results exist
	// than fit in the specified PageSize, the value of NextPageToken in the response
	// is non-null.
	PageSize *int64 `type:"integer"`

	// The page token of the first page retrieved. If null, this retrieves the first
	// page of size PageSize.
	PageToken *string `type:"string"`
}

// String returns the string representation
func (s ScanProvisionedProductsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ScanProvisionedProductsInput) GoString() string {
	return s.String()
}

// SetAcceptLanguage sets the AcceptLanguage field's value.
func (s *ScanProvisionedProductsInput) SetAcceptLanguage(v string) *ScanProvisionedProductsInput {
	s.AcceptLanguage = &v
	return s
}

// SetAccessLevelFilter sets the AccessLevelFilter field's value.
func (s *ScanProvisionedProductsInput) SetAccessLevelFilter(v *AccessLevelFilter) *ScanProvisionedProductsInput {
	s.AccessLevelFilter = v
	return s
}

// SetPageSize sets the PageSize field's value.
func (s *ScanProvisionedProductsInput) SetPageSize(v int64) *ScanProvisionedProductsInput {
	s.PageSize = &v
	return s
}

// SetPageToken sets the PageToken field's value.
func (s *ScanProvisionedProductsInput) SetPageToken(v string) *ScanProvisionedProductsInput {
	s.PageToken = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ScanProvisionedProductsOutput
type ScanProvisionedProductsOutput struct {
	_ struct{} `type:"structure"`

	// The page token to use to retrieve the next page of results for this operation.
	// If there are no more pages, this value is null.
	NextPageToken *string `type:"string"`

	// A list of ProvisionedProduct detail objects.
	ProvisionedProducts []*ProvisionedProductDetail `type:"list"`
}

// String returns the string representation
func (s ScanProvisionedProductsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ScanProvisionedProductsOutput) GoString() string {
	return s.String()
}

// SetNextPageToken sets the NextPageToken field's value.
func (s *ScanProvisionedProductsOutput) SetNextPageToken(v string) *ScanProvisionedProductsOutput {
	s.NextPageToken = &v
	return s
}

// SetProvisionedProducts sets the ProvisionedProducts field's value.
func (s *ScanProvisionedProductsOutput) SetProvisionedProducts(v []*ProvisionedProductDetail) *ScanProvisionedProductsOutput {
	s.ProvisionedProducts = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/SearchProductsAsAdminInput
type SearchProductsAsAdminInput struct {
	_ struct{} `type:"structure"`

	// The language code to use for this operation. Supported language codes are
	// as follows:
	//
	// "en" (English)
	//
	// "jp" (Japanese)
	//
	// "zh" (Chinese)
	//
	// If no code is specified, "en" is used as the default.
	AcceptLanguage *string `type:"string"`

	// The list of filters with which to limit search results. If no search filters
	// are specified, the output is all the products to which the administrator
	// has access.
	Filters map[string][]*string `type:"map"`

	// The maximum number of items to return in the results. If more results exist
	// than fit in the specified PageSize, the value of NextPageToken in the response
	// is non-null.
	PageSize *int64 `type:"integer"`

	// The page token of the first page retrieved. If null, this retrieves the first
	// page of size PageSize.
	PageToken *string `type:"string"`

	// The portfolio identifier.
	PortfolioId *string `min:"1" type:"string"`

	// Access level of the source of the product.
	ProductSource *string `type:"string" enum:"ProductSource"`

	// The sort field specifier. If no value is specified, results are not sorted.
	SortBy *string `type:"string" enum:"ProductViewSortBy"`

	// The sort order specifier. If no value is specified, results are not sorted.
	SortOrder *string `type:"string" enum:"SortOrder"`
}

// String returns the string representation
func (s SearchProductsAsAdminInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SearchProductsAsAdminInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SearchProductsAsAdminInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SearchProductsAsAdminInput"}
	if s.PortfolioId != nil && len(*s.PortfolioId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PortfolioId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAcceptLanguage sets the AcceptLanguage field's value.
func (s *SearchProductsAsAdminInput) SetAcceptLanguage(v string) *SearchProductsAsAdminInput {
	s.AcceptLanguage = &v
	return s
}

// SetFilters sets the Filters field's value.
func (s *SearchProductsAsAdminInput) SetFilters(v map[string][]*string) *SearchProductsAsAdminInput {
	s.Filters = v
	return s
}

// SetPageSize sets the PageSize field's value.
func (s *SearchProductsAsAdminInput) SetPageSize(v int64) *SearchProductsAsAdminInput {
	s.PageSize = &v
	return s
}

// SetPageToken sets the PageToken field's value.
func (s *SearchProductsAsAdminInput) SetPageToken(v string) *SearchProductsAsAdminInput {
	s.PageToken = &v
	return s
}

// SetPortfolioId sets the PortfolioId field's value.
func (s *SearchProductsAsAdminInput) SetPortfolioId(v string) *SearchProductsAsAdminInput {
	s.PortfolioId = &v
	return s
}

// SetProductSource sets the ProductSource field's value.
func (s *SearchProductsAsAdminInput) SetProductSource(v string) *SearchProductsAsAdminInput {
	s.ProductSource = &v
	return s
}

// SetSortBy sets the SortBy field's value.
func (s *SearchProductsAsAdminInput) SetSortBy(v string) *SearchProductsAsAdminInput {
	s.SortBy = &v
	return s
}

// SetSortOrder sets the SortOrder field's value.
func (s *SearchProductsAsAdminInput) SetSortOrder(v string) *SearchProductsAsAdminInput {
	s.SortOrder = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/SearchProductsAsAdminOutput
type SearchProductsAsAdminOutput struct {
	_ struct{} `type:"structure"`

	// The page token to use to retrieve the next page of results for this operation.
	// If there are no more pages, this value is null.
	NextPageToken *string `type:"string"`

	// List of detailed product view information objects.
	ProductViewDetails []*ProductViewDetail `type:"list"`
}

// String returns the string representation
func (s SearchProductsAsAdminOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SearchProductsAsAdminOutput) GoString() string {
	return s.String()
}

// SetNextPageToken sets the NextPageToken field's value.
func (s *SearchProductsAsAdminOutput) SetNextPageToken(v string) *SearchProductsAsAdminOutput {
	s.NextPageToken = &v
	return s
}

// SetProductViewDetails sets the ProductViewDetails field's value.
func (s *SearchProductsAsAdminOutput) SetProductViewDetails(v []*ProductViewDetail) *SearchProductsAsAdminOutput {
	s.ProductViewDetails = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/SearchProductsInput
type SearchProductsInput struct {
	_ struct{} `type:"structure"`

	// The language code to use for this operation. Supported language codes are
	// as follows:
	//
	// "en" (English)
	//
	// "jp" (Japanese)
	//
	// "zh" (Chinese)
	//
	// If no code is specified, "en" is used as the default.
	AcceptLanguage *string `type:"string"`

	// The list of filters with which to limit search results. If no search filters
	// are specified, the output is all the products to which the calling user has
	// access.
	Filters map[string][]*string `type:"map"`

	// The maximum number of items to return in the results. If more results exist
	// than fit in the specified PageSize, the value of NextPageToken in the response
	// is non-null.
	PageSize *int64 `type:"integer"`

	// The page token of the first page retrieved. If null, this retrieves the first
	// page of size PageSize.
	PageToken *string `type:"string"`

	// The sort field specifier. If no value is specified, results are not sorted.
	SortBy *string `type:"string" enum:"ProductViewSortBy"`

	// The sort order specifier. If no value is specified, results are not sorted.
	SortOrder *string `type:"string" enum:"SortOrder"`
}

// String returns the string representation
func (s SearchProductsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SearchProductsInput) GoString() string {
	return s.String()
}

// SetAcceptLanguage sets the AcceptLanguage field's value.
func (s *SearchProductsInput) SetAcceptLanguage(v string) *SearchProductsInput {
	s.AcceptLanguage = &v
	return s
}

// SetFilters sets the Filters field's value.
func (s *SearchProductsInput) SetFilters(v map[string][]*string) *SearchProductsInput {
	s.Filters = v
	return s
}

// SetPageSize sets the PageSize field's value.
func (s *SearchProductsInput) SetPageSize(v int64) *SearchProductsInput {
	s.PageSize = &v
	return s
}

// SetPageToken sets the PageToken field's value.
func (s *SearchProductsInput) SetPageToken(v string) *SearchProductsInput {
	s.PageToken = &v
	return s
}

// SetSortBy sets the SortBy field's value.
func (s *SearchProductsInput) SetSortBy(v string) *SearchProductsInput {
	s.SortBy = &v
	return s
}

// SetSortOrder sets the SortOrder field's value.
func (s *SearchProductsInput) SetSortOrder(v string) *SearchProductsInput {
	s.SortOrder = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/SearchProductsOutput
type SearchProductsOutput struct {
	_ struct{} `type:"structure"`

	// The page token to use to retrieve the next page of results for this operation.
	// If there are no more pages, this value is null.
	NextPageToken *string `type:"string"`

	// A list of the product view aggregation value objects.
	ProductViewAggregations map[string][]*ProductViewAggregationValue `type:"map"`

	// A list of the product view summary objects.
	ProductViewSummaries []*ProductViewSummary `type:"list"`
}

// String returns the string representation
func (s SearchProductsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SearchProductsOutput) GoString() string {
	return s.String()
}

// SetNextPageToken sets the NextPageToken field's value.
func (s *SearchProductsOutput) SetNextPageToken(v string) *SearchProductsOutput {
	s.NextPageToken = &v
	return s
}

// SetProductViewAggregations sets the ProductViewAggregations field's value.
func (s *SearchProductsOutput) SetProductViewAggregations(v map[string][]*ProductViewAggregationValue) *SearchProductsOutput {
	s.ProductViewAggregations = v
	return s
}

// SetProductViewSummaries sets the ProductViewSummaries field's value.
func (s *SearchProductsOutput) SetProductViewSummaries(v []*ProductViewSummary) *SearchProductsOutput {
	s.ProductViewSummaries = v
	return s
}

// Key/value pairs to associate with this provisioning. These tags are entirely
// discretionary and are propagated to the resources created in the provisioning.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/Tag
type Tag struct {
	_ struct{} `type:"structure"`

	// The ProvisioningArtifactParameter.TagKey parameter from DescribeProvisioningParameters.
	//
	// Key is a required field
	Key *string `min:"1" type:"string" required:"true"`

	// The esired value for this key.
	//
	// Value is a required field
	Value *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Tag) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Tag) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Tag"}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}
	if s.Value != nil && len(*s.Value) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Value", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKey sets the Key field's value.
func (s *Tag) SetKey(v string) *Tag {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *Tag) SetValue(v string) *Tag {
	s.Value = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/TerminateProvisionedProductInput
type TerminateProvisionedProductInput struct {
	_ struct{} `type:"structure"`

	// The language code to use for this operation. Supported language codes are
	// as follows:
	//
	// "en" (English)
	//
	// "jp" (Japanese)
	//
	// "zh" (Chinese)
	//
	// If no code is specified, "en" is used as the default.
	AcceptLanguage *string `type:"string"`

	// If set to true, AWS Service Catalog stops managing the specified ProvisionedProduct
	// object even if it cannot delete the underlying resources.
	IgnoreErrors *bool `type:"boolean"`

	// The identifier of the ProvisionedProduct object to terminate. You must specify
	// either ProvisionedProductName or ProvisionedProductId, but not both.
	ProvisionedProductId *string `min:"1" type:"string"`

	// The name of the ProvisionedProduct object to terminate. You must specify
	// either ProvisionedProductName or ProvisionedProductId, but not both.
	ProvisionedProductName *string `min:"1" type:"string"`

	// An idempotency token that uniquely identifies the termination request. This
	// token is only valid during the termination process. After the ProvisionedProduct
	// object is terminated, further requests to terminate the same ProvisionedProduct
	// object always return ResourceNotFound regardless of the value of TerminateToken.
	//
	// TerminateToken is a required field
	TerminateToken *string `min:"1" type:"string" required:"true" idempotencyToken:"true"`
}

// String returns the string representation
func (s TerminateProvisionedProductInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TerminateProvisionedProductInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TerminateProvisionedProductInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TerminateProvisionedProductInput"}
	if s.ProvisionedProductId != nil && len(*s.ProvisionedProductId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ProvisionedProductId", 1))
	}
	if s.ProvisionedProductName != nil && len(*s.ProvisionedProductName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ProvisionedProductName", 1))
	}
	if s.TerminateToken == nil {
		invalidParams.Add(request.NewErrParamRequired("TerminateToken"))
	}
	if s.TerminateToken != nil && len(*s.TerminateToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TerminateToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAcceptLanguage sets the AcceptLanguage field's value.
func (s *TerminateProvisionedProductInput) SetAcceptLanguage(v string) *TerminateProvisionedProductInput {
	s.AcceptLanguage = &v
	return s
}

// SetIgnoreErrors sets the IgnoreErrors field's value.
func (s *TerminateProvisionedProductInput) SetIgnoreErrors(v bool) *TerminateProvisionedProductInput {
	s.IgnoreErrors = &v
	return s
}

// SetProvisionedProductId sets the ProvisionedProductId field's value.
func (s *TerminateProvisionedProductInput) SetProvisionedProductId(v string) *TerminateProvisionedProductInput {
	s.ProvisionedProductId = &v
	return s
}

// SetProvisionedProductName sets the ProvisionedProductName field's value.
func (s *TerminateProvisionedProductInput) SetProvisionedProductName(v string) *TerminateProvisionedProductInput {
	s.ProvisionedProductName = &v
	return s
}

// SetTerminateToken sets the TerminateToken field's value.
func (s *TerminateProvisionedProductInput) SetTerminateToken(v string) *TerminateProvisionedProductInput {
	s.TerminateToken = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/TerminateProvisionedProductOutput
type TerminateProvisionedProductOutput struct {
	_ struct{} `type:"structure"`

	// The detailed result of the TerminateProvisionedProduct request, containing
	// the inputs made to that request, the current state of the request, a pointer
	// to the ProvisionedProduct object that the request is modifying, and a list
	// of any errors that the request encountered.
	RecordDetail *RecordDetail `type:"structure"`
}

// String returns the string representation
func (s TerminateProvisionedProductOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TerminateProvisionedProductOutput) GoString() string {
	return s.String()
}

// SetRecordDetail sets the RecordDetail field's value.
func (s *TerminateProvisionedProductOutput) SetRecordDetail(v *RecordDetail) *TerminateProvisionedProductOutput {
	s.RecordDetail = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/UpdateConstraintInput
type UpdateConstraintInput struct {
	_ struct{} `type:"structure"`

	// The language code to use for this operation. Supported language codes are
	// as follows:
	//
	// "en" (English)
	//
	// "jp" (Japanese)
	//
	// "zh" (Chinese)
	//
	// If no code is specified, "en" is used as the default.
	AcceptLanguage *string `type:"string"`

	// The updated text description of the constraint.
	Description *string `type:"string"`

	// The identifier of the constraint to update.
	//
	// Id is a required field
	Id *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateConstraintInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateConstraintInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateConstraintInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateConstraintInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAcceptLanguage sets the AcceptLanguage field's value.
func (s *UpdateConstraintInput) SetAcceptLanguage(v string) *UpdateConstraintInput {
	s.AcceptLanguage = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *UpdateConstraintInput) SetDescription(v string) *UpdateConstraintInput {
	s.Description = &v
	return s
}

// SetId sets the Id field's value.
func (s *UpdateConstraintInput) SetId(v string) *UpdateConstraintInput {
	s.Id = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/UpdateConstraintOutput
type UpdateConstraintOutput struct {
	_ struct{} `type:"structure"`

	// The resulting detailed constraint information.
	ConstraintDetail *ConstraintDetail `type:"structure"`

	// The resulting updated constraint parameters.
	ConstraintParameters *string `type:"string"`

	// The status of the current request.
	Status *string `type:"string" enum:"Status"`
}

// String returns the string representation
func (s UpdateConstraintOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateConstraintOutput) GoString() string {
	return s.String()
}

// SetConstraintDetail sets the ConstraintDetail field's value.
func (s *UpdateConstraintOutput) SetConstraintDetail(v *ConstraintDetail) *UpdateConstraintOutput {
	s.ConstraintDetail = v
	return s
}

// SetConstraintParameters sets the ConstraintParameters field's value.
func (s *UpdateConstraintOutput) SetConstraintParameters(v string) *UpdateConstraintOutput {
	s.ConstraintParameters = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *UpdateConstraintOutput) SetStatus(v string) *UpdateConstraintOutput {
	s.Status = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/UpdatePortfolioInput
type UpdatePortfolioInput struct {
	_ struct{} `type:"structure"`

	// The language code to use for this operation. Supported language codes are
	// as follows:
	//
	// "en" (English)
	//
	// "jp" (Japanese)
	//
	// "zh" (Chinese)
	//
	// If no code is specified, "en" is used as the default.
	AcceptLanguage *string `type:"string"`

	// Tags to add to the existing list of tags associated with the portfolio.
	AddTags []*Tag `type:"list"`

	// The updated text description of the portfolio.
	Description *string `type:"string"`

	// The name to use for display purposes.
	DisplayName *string `min:"1" type:"string"`

	// The identifier of the portfolio for the update request.
	//
	// Id is a required field
	Id *string `min:"1" type:"string" required:"true"`

	// The updated name of the portfolio provider.
	ProviderName *string `min:"1" type:"string"`

	// Tags to remove from the existing list of tags associated with the portfolio.
	RemoveTags []*string `type:"list"`
}

// String returns the string representation
func (s UpdatePortfolioInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdatePortfolioInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdatePortfolioInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdatePortfolioInput"}
	if s.DisplayName != nil && len(*s.DisplayName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DisplayName", 1))
	}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}
	if s.ProviderName != nil && len(*s.ProviderName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ProviderName", 1))
	}
	if s.AddTags != nil {
		for i, v := range s.AddTags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "AddTags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAcceptLanguage sets the AcceptLanguage field's value.
func (s *UpdatePortfolioInput) SetAcceptLanguage(v string) *UpdatePortfolioInput {
	s.AcceptLanguage = &v
	return s
}

// SetAddTags sets the AddTags field's value.
func (s *UpdatePortfolioInput) SetAddTags(v []*Tag) *UpdatePortfolioInput {
	s.AddTags = v
	return s
}

// SetDescription sets the Description field's value.
func (s *UpdatePortfolioInput) SetDescription(v string) *UpdatePortfolioInput {
	s.Description = &v
	return s
}

// SetDisplayName sets the DisplayName field's value.
func (s *UpdatePortfolioInput) SetDisplayName(v string) *UpdatePortfolioInput {
	s.DisplayName = &v
	return s
}

// SetId sets the Id field's value.
func (s *UpdatePortfolioInput) SetId(v string) *UpdatePortfolioInput {
	s.Id = &v
	return s
}

// SetProviderName sets the ProviderName field's value.
func (s *UpdatePortfolioInput) SetProviderName(v string) *UpdatePortfolioInput {
	s.ProviderName = &v
	return s
}

// SetRemoveTags sets the RemoveTags field's value.
func (s *UpdatePortfolioInput) SetRemoveTags(v []*string) *UpdatePortfolioInput {
	s.RemoveTags = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/UpdatePortfolioOutput
type UpdatePortfolioOutput struct {
	_ struct{} `type:"structure"`

	// The resulting detailed portfolio information.
	PortfolioDetail *PortfolioDetail `type:"structure"`

	// Tags associated with the portfolio.
	Tags []*Tag `type:"list"`
}

// String returns the string representation
func (s UpdatePortfolioOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdatePortfolioOutput) GoString() string {
	return s.String()
}

// SetPortfolioDetail sets the PortfolioDetail field's value.
func (s *UpdatePortfolioOutput) SetPortfolioDetail(v *PortfolioDetail) *UpdatePortfolioOutput {
	s.PortfolioDetail = v
	return s
}

// SetTags sets the Tags field's value.
func (s *UpdatePortfolioOutput) SetTags(v []*Tag) *UpdatePortfolioOutput {
	s.Tags = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/UpdateProductInput
type UpdateProductInput struct {
	_ struct{} `type:"structure"`

	// The language code to use for this operation. Supported language codes are
	// as follows:
	//
	// "en" (English)
	//
	// "jp" (Japanese)
	//
	// "zh" (Chinese)
	//
	// If no code is specified, "en" is used as the default.
	AcceptLanguage *string `type:"string"`

	// Tags to add to the existing list of tags associated with the product.
	AddTags []*Tag `type:"list"`

	// The updated text description of the product.
	Description *string `type:"string"`

	// The updated distributor of the product.
	Distributor *string `type:"string"`

	// The identifier of the product for the update request.
	//
	// Id is a required field
	Id *string `min:"1" type:"string" required:"true"`

	// The updated product name.
	Name *string `type:"string"`

	// The updated owner of the product.
	Owner *string `type:"string"`

	// Tags to remove from the existing list of tags associated with the product.
	RemoveTags []*string `type:"list"`

	// The updated support description for the product.
	SupportDescription *string `type:"string"`

	// The updated support email for the product.
	SupportEmail *string `type:"string"`

	// The updated support URL for the product.
	SupportUrl *string `type:"string"`
}

// String returns the string representation
func (s UpdateProductInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateProductInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateProductInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateProductInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}
	if s.AddTags != nil {
		for i, v := range s.AddTags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "AddTags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAcceptLanguage sets the AcceptLanguage field's value.
func (s *UpdateProductInput) SetAcceptLanguage(v string) *UpdateProductInput {
	s.AcceptLanguage = &v
	return s
}

// SetAddTags sets the AddTags field's value.
func (s *UpdateProductInput) SetAddTags(v []*Tag) *UpdateProductInput {
	s.AddTags = v
	return s
}

// SetDescription sets the Description field's value.
func (s *UpdateProductInput) SetDescription(v string) *UpdateProductInput {
	s.Description = &v
	return s
}

// SetDistributor sets the Distributor field's value.
func (s *UpdateProductInput) SetDistributor(v string) *UpdateProductInput {
	s.Distributor = &v
	return s
}

// SetId sets the Id field's value.
func (s *UpdateProductInput) SetId(v string) *UpdateProductInput {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateProductInput) SetName(v string) *UpdateProductInput {
	s.Name = &v
	return s
}

// SetOwner sets the Owner field's value.
func (s *UpdateProductInput) SetOwner(v string) *UpdateProductInput {
	s.Owner = &v
	return s
}

// SetRemoveTags sets the RemoveTags field's value.
func (s *UpdateProductInput) SetRemoveTags(v []*string) *UpdateProductInput {
	s.RemoveTags = v
	return s
}

// SetSupportDescription sets the SupportDescription field's value.
func (s *UpdateProductInput) SetSupportDescription(v string) *UpdateProductInput {
	s.SupportDescription = &v
	return s
}

// SetSupportEmail sets the SupportEmail field's value.
func (s *UpdateProductInput) SetSupportEmail(v string) *UpdateProductInput {
	s.SupportEmail = &v
	return s
}

// SetSupportUrl sets the SupportUrl field's value.
func (s *UpdateProductInput) SetSupportUrl(v string) *UpdateProductInput {
	s.SupportUrl = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/UpdateProductOutput
type UpdateProductOutput struct {
	_ struct{} `type:"structure"`

	// The resulting detailed product view information.
	ProductViewDetail *ProductViewDetail `type:"structure"`

	// Tags associated with the product.
	Tags []*Tag `type:"list"`
}

// String returns the string representation
func (s UpdateProductOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateProductOutput) GoString() string {
	return s.String()
}

// SetProductViewDetail sets the ProductViewDetail field's value.
func (s *UpdateProductOutput) SetProductViewDetail(v *ProductViewDetail) *UpdateProductOutput {
	s.ProductViewDetail = v
	return s
}

// SetTags sets the Tags field's value.
func (s *UpdateProductOutput) SetTags(v []*Tag) *UpdateProductOutput {
	s.Tags = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/UpdateProvisionedProductInput
type UpdateProvisionedProductInput struct {
	_ struct{} `type:"structure"`

	// The language code to use for this operation. Supported language codes are
	// as follows:
	//
	// "en" (English)
	//
	// "jp" (Japanese)
	//
	// "zh" (Chinese)
	//
	// If no code is specified, "en" is used as the default.
	AcceptLanguage *string `type:"string"`

	// The identifier of the path to use in the updated ProvisionedProduct object.
	// This value is optional if the product has a default path, and is required
	// if there is more than one path for the specified product.
	PathId *string `min:"1" type:"string"`

	// The identifier of the ProvisionedProduct object.
	ProductId *string `min:"1" type:"string"`

	// The identifier of the ProvisionedProduct object to update. You must specify
	// either ProvisionedProductName or ProvisionedProductId, but not both.
	ProvisionedProductId *string `min:"1" type:"string"`

	// The updated name of the ProvisionedProduct object . You must specify either
	// ProvisionedProductName or ProvisionedProductId, but not both.
	ProvisionedProductName *string `min:"1" type:"string"`

	// The provisioning artifact identifier for this product.
	ProvisioningArtifactId *string `min:"1" type:"string"`

	// A list of ProvisioningParameter objects used to update the ProvisionedProduct
	// object.
	ProvisioningParameters []*UpdateProvisioningParameter `type:"list"`

	// The idempotency token that uniquely identifies the provisioning update request.
	//
	// UpdateToken is a required field
	UpdateToken *string `min:"1" type:"string" required:"true" idempotencyToken:"true"`
}

// String returns the string representation
func (s UpdateProvisionedProductInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateProvisionedProductInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateProvisionedProductInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateProvisionedProductInput"}
	if s.PathId != nil && len(*s.PathId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PathId", 1))
	}
	if s.ProductId != nil && len(*s.ProductId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ProductId", 1))
	}
	if s.ProvisionedProductId != nil && len(*s.ProvisionedProductId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ProvisionedProductId", 1))
	}
	if s.ProvisionedProductName != nil && len(*s.ProvisionedProductName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ProvisionedProductName", 1))
	}
	if s.ProvisioningArtifactId != nil && len(*s.ProvisioningArtifactId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ProvisioningArtifactId", 1))
	}
	if s.UpdateToken == nil {
		invalidParams.Add(request.NewErrParamRequired("UpdateToken"))
	}
	if s.UpdateToken != nil && len(*s.UpdateToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UpdateToken", 1))
	}
	if s.ProvisioningParameters != nil {
		for i, v := range s.ProvisioningParameters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ProvisioningParameters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAcceptLanguage sets the AcceptLanguage field's value.
func (s *UpdateProvisionedProductInput) SetAcceptLanguage(v string) *UpdateProvisionedProductInput {
	s.AcceptLanguage = &v
	return s
}

// SetPathId sets the PathId field's value.
func (s *UpdateProvisionedProductInput) SetPathId(v string) *UpdateProvisionedProductInput {
	s.PathId = &v
	return s
}

// SetProductId sets the ProductId field's value.
func (s *UpdateProvisionedProductInput) SetProductId(v string) *UpdateProvisionedProductInput {
	s.ProductId = &v
	return s
}

// SetProvisionedProductId sets the ProvisionedProductId field's value.
func (s *UpdateProvisionedProductInput) SetProvisionedProductId(v string) *UpdateProvisionedProductInput {
	s.ProvisionedProductId = &v
	return s
}

// SetProvisionedProductName sets the ProvisionedProductName field's value.
func (s *UpdateProvisionedProductInput) SetProvisionedProductName(v string) *UpdateProvisionedProductInput {
	s.ProvisionedProductName = &v
	return s
}

// SetProvisioningArtifactId sets the ProvisioningArtifactId field's value.
func (s *UpdateProvisionedProductInput) SetProvisioningArtifactId(v string) *UpdateProvisionedProductInput {
	s.ProvisioningArtifactId = &v
	return s
}

// SetProvisioningParameters sets the ProvisioningParameters field's value.
func (s *UpdateProvisionedProductInput) SetProvisioningParameters(v []*UpdateProvisioningParameter) *UpdateProvisionedProductInput {
	s.ProvisioningParameters = v
	return s
}

// SetUpdateToken sets the UpdateToken field's value.
func (s *UpdateProvisionedProductInput) SetUpdateToken(v string) *UpdateProvisionedProductInput {
	s.UpdateToken = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/UpdateProvisionedProductOutput
type UpdateProvisionedProductOutput struct {
	_ struct{} `type:"structure"`

	// The detailed result of the UpdateProvisionedProduct request, containing the
	// inputs made to that request, the current state of the request, a pointer
	// to the ProvisionedProduct object that the request is modifying, and a list
	// of any errors that the request encountered.
	RecordDetail *RecordDetail `type:"structure"`
}

// String returns the string representation
func (s UpdateProvisionedProductOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateProvisionedProductOutput) GoString() string {
	return s.String()
}

// SetRecordDetail sets the RecordDetail field's value.
func (s *UpdateProvisionedProductOutput) SetRecordDetail(v *RecordDetail) *UpdateProvisionedProductOutput {
	s.RecordDetail = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/UpdateProvisioningArtifactInput
type UpdateProvisioningArtifactInput struct {
	_ struct{} `type:"structure"`

	// The language code to use for this operation. Supported language codes are
	// as follows:
	//
	// "en" (English)
	//
	// "jp" (Japanese)
	//
	// "zh" (Chinese)
	//
	// If no code is specified, "en" is used as the default.
	AcceptLanguage *string `type:"string"`

	// The updated text description of the provisioning artifact.
	Description *string `type:"string"`

	// The updated name of the provisioning artifact.
	Name *string `type:"string"`

	// The product identifier.
	//
	// ProductId is a required field
	ProductId *string `min:"1" type:"string" required:"true"`

	// The identifier of the provisioning artifact for the update request.
	//
	// ProvisioningArtifactId is a required field
	ProvisioningArtifactId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateProvisioningArtifactInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateProvisioningArtifactInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateProvisioningArtifactInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateProvisioningArtifactInput"}
	if s.ProductId == nil {
		invalidParams.Add(request.NewErrParamRequired("ProductId"))
	}
	if s.ProductId != nil && len(*s.ProductId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ProductId", 1))
	}
	if s.ProvisioningArtifactId == nil {
		invalidParams.Add(request.NewErrParamRequired("ProvisioningArtifactId"))
	}
	if s.ProvisioningArtifactId != nil && len(*s.ProvisioningArtifactId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ProvisioningArtifactId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAcceptLanguage sets the AcceptLanguage field's value.
func (s *UpdateProvisioningArtifactInput) SetAcceptLanguage(v string) *UpdateProvisioningArtifactInput {
	s.AcceptLanguage = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *UpdateProvisioningArtifactInput) SetDescription(v string) *UpdateProvisioningArtifactInput {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateProvisioningArtifactInput) SetName(v string) *UpdateProvisioningArtifactInput {
	s.Name = &v
	return s
}

// SetProductId sets the ProductId field's value.
func (s *UpdateProvisioningArtifactInput) SetProductId(v string) *UpdateProvisioningArtifactInput {
	s.ProductId = &v
	return s
}

// SetProvisioningArtifactId sets the ProvisioningArtifactId field's value.
func (s *UpdateProvisioningArtifactInput) SetProvisioningArtifactId(v string) *UpdateProvisioningArtifactInput {
	s.ProvisioningArtifactId = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/UpdateProvisioningArtifactOutput
type UpdateProvisioningArtifactOutput struct {
	_ struct{} `type:"structure"`

	// Additional information about the provisioning artifact update request.
	Info map[string]*string `min:"1" type:"map"`

	// The resulting detailed provisioning artifact information.
	ProvisioningArtifactDetail *ProvisioningArtifactDetail `type:"structure"`

	// The status of the current request.
	Status *string `type:"string" enum:"Status"`
}

// String returns the string representation
func (s UpdateProvisioningArtifactOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateProvisioningArtifactOutput) GoString() string {
	return s.String()
}

// SetInfo sets the Info field's value.
func (s *UpdateProvisioningArtifactOutput) SetInfo(v map[string]*string) *UpdateProvisioningArtifactOutput {
	s.Info = v
	return s
}

// SetProvisioningArtifactDetail sets the ProvisioningArtifactDetail field's value.
func (s *UpdateProvisioningArtifactOutput) SetProvisioningArtifactDetail(v *ProvisioningArtifactDetail) *UpdateProvisioningArtifactOutput {
	s.ProvisioningArtifactDetail = v
	return s
}

// SetStatus sets the Status field's value.
func (s *UpdateProvisioningArtifactOutput) SetStatus(v string) *UpdateProvisioningArtifactOutput {
	s.Status = &v
	return s
}

// The parameter key/value pair used to update a ProvisionedProduct object.
// If UsePreviousValue is set to true, Value is ignored and the value for Key
// is kept as previously set (current value).
// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/UpdateProvisioningParameter
type UpdateProvisioningParameter struct {
	_ struct{} `type:"structure"`

	// The ProvisioningArtifactParameter.ParameterKey parameter from DescribeProvisioningParameters.
	Key *string `min:"1" type:"string"`

	// If true, uses the currently set value for Key, ignoring UpdateProvisioningParameter.Value.
	UsePreviousValue *bool `type:"boolean"`

	// The value to use for updating the product provisioning. Any constraints on
	// this value can be found in the ProvisioningArtifactParameter parameter for
	// Key.
	Value *string `type:"string"`
}

// String returns the string representation
func (s UpdateProvisioningParameter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateProvisioningParameter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateProvisioningParameter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateProvisioningParameter"}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKey sets the Key field's value.
func (s *UpdateProvisioningParameter) SetKey(v string) *UpdateProvisioningParameter {
	s.Key = &v
	return s
}

// SetUsePreviousValue sets the UsePreviousValue field's value.
func (s *UpdateProvisioningParameter) SetUsePreviousValue(v bool) *UpdateProvisioningParameter {
	s.UsePreviousValue = &v
	return s
}

// SetValue sets the Value field's value.
func (s *UpdateProvisioningParameter) SetValue(v string) *UpdateProvisioningParameter {
	s.Value = &v
	return s
}

// Additional information provided by the administrator.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/UsageInstruction
type UsageInstruction struct {
	_ struct{} `type:"structure"`

	// The usage instruction type for the value.
	Type *string `type:"string"`

	// The usage instruction value for this type.
	Value *string `type:"string"`
}

// String returns the string representation
func (s UsageInstruction) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UsageInstruction) GoString() string {
	return s.String()
}

// SetType sets the Type field's value.
func (s *UsageInstruction) SetType(v string) *UsageInstruction {
	s.Type = &v
	return s
}

// SetValue sets the Value field's value.
func (s *UsageInstruction) SetValue(v string) *UsageInstruction {
	s.Value = &v
	return s
}

const (
	// AccessLevelFilterKeyAccount is a AccessLevelFilterKey enum value
	AccessLevelFilterKeyAccount = "Account"

	// AccessLevelFilterKeyRole is a AccessLevelFilterKey enum value
	AccessLevelFilterKeyRole = "Role"

	// AccessLevelFilterKeyUser is a AccessLevelFilterKey enum value
	AccessLevelFilterKeyUser = "User"
)

const (
	// PrincipalTypeIam is a PrincipalType enum value
	PrincipalTypeIam = "IAM"
)

const (
	// ProductSourceAccount is a ProductSource enum value
	ProductSourceAccount = "ACCOUNT"
)

const (
	// ProductTypeCloudFormationTemplate is a ProductType enum value
	ProductTypeCloudFormationTemplate = "CLOUD_FORMATION_TEMPLATE"
)

const (
	// ProductViewFilterByFullTextSearch is a ProductViewFilterBy enum value
	ProductViewFilterByFullTextSearch = "FullTextSearch"

	// ProductViewFilterByOwner is a ProductViewFilterBy enum value
	ProductViewFilterByOwner = "Owner"

	// ProductViewFilterByProductType is a ProductViewFilterBy enum value
	ProductViewFilterByProductType = "ProductType"
)

const (
	// ProductViewSortByTitle is a ProductViewSortBy enum value
	ProductViewSortByTitle = "Title"

	// ProductViewSortByVersionCount is a ProductViewSortBy enum value
	ProductViewSortByVersionCount = "VersionCount"

	// ProductViewSortByCreationDate is a ProductViewSortBy enum value
	ProductViewSortByCreationDate = "CreationDate"
)

const (
	// ProvisioningArtifactTypeCloudFormationTemplate is a ProvisioningArtifactType enum value
	ProvisioningArtifactTypeCloudFormationTemplate = "CLOUD_FORMATION_TEMPLATE"
)

const (
	// RecordStatusInProgress is a RecordStatus enum value
	RecordStatusInProgress = "IN_PROGRESS"

	// RecordStatusSucceeded is a RecordStatus enum value
	RecordStatusSucceeded = "SUCCEEDED"

	// RecordStatusError is a RecordStatus enum value
	RecordStatusError = "ERROR"
)

const (
	// SortOrderAscending is a SortOrder enum value
	SortOrderAscending = "ASCENDING"

	// SortOrderDescending is a SortOrder enum value
	SortOrderDescending = "DESCENDING"
)

const (
	// StatusAvailable is a Status enum value
	StatusAvailable = "AVAILABLE"

	// StatusCreating is a Status enum value
	StatusCreating = "CREATING"

	// StatusFailed is a Status enum value
	StatusFailed = "FAILED"
)
