#!/usr/bin/python
# -*- coding: iso-8859-15 -*-
######################################################
##
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published
#  by the Free Software Foundation; version 2 only.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
##
######################################################
## 
#  Project: AptOnCd
#  File: PackagesParser.py
#  Author: Laudeci Oliveira <laudeci@gmail.com>
#  Creation: 26/12/2006
#  Changed: 
#  Purpose: 
##
######################################################
import rfc822
import StringIO
import gzip
import string
import os
import sys

PACKAGE = 'Package'
PRIORITY = 'Priority'
SECTION = 'Section'
INSTALLED_SIZE = 'Installed-Size'
MAINTAINER = 'Maintainer'
ORIGINAL_MAINTAINER = 'Original-Maintainer'
ARCHITECTURE = 'Architecture'
VERSION = 'Version'
DEPENDS = 'Depends'
FILENAME = 'Filename'
SIZE = 'Size'
MD5SUM = 'MD5sum'
SHA1 = 'SHA1'
SHA256 = 'SHA256'
DESCRIPTON = 'Description'
BUGS = 'Bugs'
ORIGIN = 'Origin'


class ParseGZ:
    
    def __init__(self, filename = ''):
        self.filename = filename
        self.collection = []
    
    def __get_value(self,source, string, default = ''):
        try:
            return source[string]
        except:
            return default
        
    def Parse(self, filename = ''):
        if self.filename  == '' and filename == '':
            raise AttributeError, "missing filename parameter"
        if filename !='':
            self.filename = filename
            
        if not os.path.isfile(self.filename):
            raise AttributeError , self.filename
        
        try:
            pkgfile=gzip.open(self.filename)
            pkgdata=pkgfile.read()
        except IOError, msg:
            raise AttributeError ,"File doesn't seems to be valid"
        
        packages = string.split(pkgdata,"\n\n")
        for package in packages:
            if package:
                tmp=StringIO.StringIO(package)
                p=rfc822.Message(tmp)
                pk = PackageInfo()
                pk.Priority = self.__get_value(p,PRIORITY)
                pk.Section = self.__get_value(p,SECTION)
                pk.InstaledSize =  self.__get_value(p,INSTALLED_SIZE)
                pk.Maintainer = self.__get_value(p,MAINTAINER)
                pk.OrinalMantainer = self.__get_value(p,ORIGINAL_MAINTAINER)
                pk.Architecture = self.__get_value(p,ARCHITECTURE)
                pk.Version = self.__get_value(p,VERSION)
                pk.Depends = self.__get_value(p,DEPENDS)
                pk.Filename = self.__get_value(p,FILENAME)
                pk.Size = self.__get_value(p,SIZE)
                pk.MD5sum = self.__get_value(p,MD5SUM)
                pk.SHA1 = self.__get_value(p,SHA1)
                pk.SHA256 = self.__get_value(p,SHA256)
                pk.Description = self.__get_value(p,DESCRIPTON)
                pk.Bugs = self.__get_value(p,BUGS)
                pk.Origin = self.__get_value(p,ORIGIN)
                self.collection.append(pk)
                
        return self.collection
    
    def get_collection(self):
        return self.collection
    
class PackageInfo(object):
        """
          This class holds packages info stored in Packages.gz file. 
        """
        def __init__(self):
            self.__Package =''
            self.__Priority = ''
            self.__Section = ''
            self.__Installed_Size = ''
            self.__Maintainer = ''
            self.__Original_Maintainer = ''
            self.__Architecture = ''
            self.__Version = ''
            self.__Depends = ''
            self.__Filename = ''
            self.__Size = ''
            self.__MD5sum = ''
            self.__SHA1 = ''
            self.__SHA256 = ''
            self.__Description = ''
            self.__Bugs = ''
            self.__Origin = ''
            self.__root_folder = ''
            self.__destinationfile=''
            self.__targz_path = ''
            self.__PackageSection = ''
        
        def __get_Package(self):    return self.__Package
        def __set_Pakcage(self,value):    self.__Package = value
        Package = property(fget=__get_Package, fset=__set_Pakcage, doc='Get/Set Package name.')
        
        def __get_Priority(self):    return self.__Priority
        def __set_Priority(self,value):    self.__Priority = value
        Priority = property(fget=__get_Priority, fset=__set_Priority, doc='Get/Set Package Priority.')
        
        def __get_Section(self):    return self.__Section
        def __set_Section(self,value):    self.__Section = value
        Section = property(fget=__get_Section, fset=__set_Section, doc='Get/Set Package Section.')
        
        def __get_Installed_Size(self):    return self.__Installed_Size
        def __set_Installed_Size(self,value):    self.__Installed_Size = value
        InstalledSize = property(fget=__get_Installed_Size, fset=__set_Installed_Size, doc='Get/Set Package Installed Size.')
        
        def __get_Maintainer(self):    return self.__Maintainer
        def __set_Maintainer(self,value):    self.__Maintainer = value
        Maintainer = property(fget=__get_Maintainer, fset=__set_Maintainer, doc="Get/Set Package Maintainer's name.")
        
        def __get_Original_Maintainer(self):    return self.__Original_Maintainer
        def __set_Original_Maintainer(self,value):    self.__Original_Maintainer = value
        OriginalMaintainer = property(fget=__get_Original_Maintainer, fset=__set_Original_Maintainer, doc='Get/Set Package Original Maintainer.')
        
        def __get_Architecture(self):    return self.__Architecture
        def __set_Architecture(self,value):    self.__Architecture = value
        Architecture = property(fget=__get_Architecture, fset=__set_Architecture, doc='Get/Set Package Architecture.')
        
        def __get_Version(self):    return self.__Version
        def __set_Version(self,value):    self.__Version = value
        Version = property(fget=__get_Version, fset=__set_Version, doc='Get/Set Package Version.')
        
        def __get_Depends(self):    return self.__Depends
        def __set_Depends(self,value):    self.__Depends = value
        Depends = property(fget=__get_Depends, fset=__set_Depends, doc='Get/Set Package Depends.')
        
        def __get_Filename(self):    return self.__Filename
        def __set_Filename(self,value):    self.__Filename = value
        Filename = property(fget=__get_Filename, fset=__set_Filename, doc='Get/Set Package Filename.')
        
        def __get_Size(self):    return self.__Size
        def __set_Size(self,value):    self.__Size = value
        Size = property(fget=__get_Size, fset=__set_Size, doc='Get/Set Package Size.')
        
        def __get_MD5sum(self):    return self.__MD5sum
        def __set_MD5sum(self,value):    self.__MD5sum = value
        MD5sum = property(fget=__get_MD5sum, fset=__set_MD5sum, doc='Get/Set Package MD5sum.')
        
        def __get_SHA1(self):    return self.__SHA1
        def __set_SHA1(self,value):    self.__SHA1 = value
        SHA1 = property(fget=__get_SHA1, fset=__set_SHA1, doc='Get/Set Package SHA1.')

        def __get_SHA256(self):    return self.__SHA256
        def __set_SHA256(self,value):    self.__SHA256 = value
        SHA256 = property(fget=__get_SHA256, fset=__set_SHA256, doc='Get/Set Package SHA256.')
        
        def __get_Description(self):    return self.__Description
        def __set_Description(self,value):    self.__Description = value
        Description = property(fget=__get_Description, fset=__set_Description, doc='Get/Set Package Description.')
        
        def __get_Bugs(self):    return self.__Bugs
        def __set_Bugs(self,value):    self.__Bugs = value
        Bugs = property(fget=__get_Bugs, fset=__set_Bugs, doc='Get/Set Package Bugs.')
        
        def __get_Origin(self):    return self.__Origin
        def __set_Origin(self,value):    self.__Origin = value
        Origin = property(fget=__get_Origin, fset=__set_Origin, doc='Get/Set Package Origin.')
        
        def __get_Destination(self):    return self.__destinationfile
        def __set_Destination(self,value):    self.__destinationfile = value
        Destination = property(fget=__get_Destination, fset=__set_Destination, doc='Get/Set Package Destination file and path.')
        
        def __get_root_folder(self):    return self.__root_folder
        def __set_root_folder(self,value):    self.__root_folder = value
        SourceLocation = property(fget=__get_root_folder, fset=__set_root_folder, doc='Get/Set Package Destination file and path.')
        
        def __get_TarGZ_Path(self):    return self.__targz_path
        def __set_TarGZ_Path(self,value):    self.__targz_path = value
        TarGZ_Path = property(fget=__get_TarGZ_Path, fset=__set_TarGZ_Path, doc='Get/Set Package Tar file  name.')
        
        def __get_PackageSection(self):    return self.__PackageSection
        def __set_PackageSection(self,value):    self.__PackageSection = value
        PackageSection = property(fget=__get_PackageSection, fset=__set_PackageSection, doc='Get/Set Package Main section name.')
        
        
        def get_as_list(self):
            return [self.__Package,  self.__Priority, self.__Section, self.__Installed_Size, self.__Maintainer, self.__Original_Maintainer,  \
                     self.__Architecture, self.__Version, self.__Depends, self.__Filename, self.__Size, self.__MD5sum, self.__SHA1, \
                     self.__SHA256, self.__Description, self.__Bugs, self.__Origin]
