/***************************************************************************
 $RCSfile: acclist.cpp,v $
                             -------------------
    cvs         : $Id: acclist.cpp,v 1.7 2003/05/18 03:02:11 aquamaniac Exp $
    begin       : Sun Jan 27 2002
    copyright   : (C) 2002 by Martin Preuss
    email       : martin@aquamaniac.de
*/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or         *
 *   modify it under the terms of the GNU Lesser General Public            *
 *   License as published by the Free Software Foundation; either          *
 *   version 2.1 of the License, or (at your option) any later version.    *
 *                                                                         *
 *   This library is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   Lesser General Public License for more details.                       *
 *                                                                         *
 *   You should have received a copy of the GNU Lesser General Public      *
 *   License along with this library; if not, write to the Free Software   *
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston,                 *
 *   MA  02111-1307  USA                                                   *
 *                                                                         *
 ***************************************************************************/


#ifdef HAVE_CONFIG_H
# include <config.h>
#endif


#include "acclist.h"


HBCI::Error acclist(HBCI::Pointer<AQMAPI> hbciif,
		    HBCI::SimpleConfig &opt){
    int country;
    string instid;
    string custid;
    HBCI::Error err;
    list<HBCI::Pointer<HBCI::Customer> > custs;
    list<HBCI::Pointer<HBCI::Customer> >::iterator it;
    HBCI::Pointer<HBCI::OutboxJob> job;


    country=opt.getIntVariable("country",280,opt.root());
    instid=opt.getVariable("instid","*",opt.root());
    custid=opt.getVariable("customer","*",opt.root());
    try {
        custs=hbciif.ref().getCustomers(country,
                                        instid,
                                        custid);
        if (custs.empty())
            return HBCI::Error("acclist()",
                             ERROR_LEVEL_NORMAL,
                             0,
                             ERROR_ADVISE_DONTKNOW,
                             "customer(s) not found");

        // create job for all matching customers
        for (it=custs.begin();
             it!=custs.end();
             it++) {
            job=new HBCI::OutboxJobGetAccounts(*it);
            // enqueue job
            hbciif.ref().addJob(job);
        } // for

        // execute queue
        err=hbciif.ref().executeQueue(true);
    }
    catch (HBCI::Error lerr) {
        err=lerr;
    }
    return err;
}





