/***************************************************************************
 $RCSfile: transfer.cpp,v $
                             -------------------
    cvs         : $Id: transfer.cpp,v 1.14 2003/07/28 23:51:49 aquamaniac Exp $
    begin       : Sun Feb 10 2002
    copyright   : (C) 2002 by Martin Preuss
    email       : martin@aquamaniac.de
*/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or         *
 *   modify it under the terms of the GNU Lesser General Public            *
 *   License as published by the Free Software Foundation; either          *
 *   version 2.1 of the License, or (at your option) any later version.    *
 *                                                                         *
 *   This library is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   Lesser General Public License for more details.                       *
 *                                                                         *
 *   You should have received a copy of the GNU Lesser General Public      *
 *   License along with this library; if not, write to the Free Software   *
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston,                 *
 *   MA  02111-1307  USA                                                   *
 *                                                                         *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
# include <config.h>
#endif

#include "transfer.h"
#include "aqmloader.h"



HBCI::Error transfer(HBCI::Pointer<AQMAPI> hbciif,
		     HBCI::SimpleConfig &opt){

  HBCI::Pointer<HBCI::OutboxJob> job;
  HBCI::cfgPtr var;
  int country;
  string instid;
  string custid;
  string accnr;
  HBCI::Error err1, err2, err3;
  string tfile;
  list<AQMTransaction> tdas;
  list<AQMTransaction> notTaken;
  list<AQMTransaction> taken;
  list<AQMTransaction>::iterator titer;
  HBCI::Pointer<HBCI::Customer> cust;
  HBCI::Pointer<AQMLoader> loader;
  HBCI::Pointer<HBCI::Account> acc;
  list<HBCI::Pointer<HBCI::OutboxJob> > jobs;
  list<HBCI::Pointer<HBCI::OutboxJob> >::iterator jit;
  string takenfile;
  string nottakenfile;

  job.setDescription("transfer:job (OutboxJob)");
  // FIXME: there should be a better const-correct way around this
  // hack
  loader=new AQMLoader(const_cast<AQMAPI*>(hbciif.ptr()));
  country=opt.getIntVariable("country",280,opt.root());
  custid=opt.getVariable("customer","",opt.root());
  tfile=opt.getVariable("tfile","-",opt.root());
  if (tfile=="-")
    tfile="";
  takenfile=opt.getVariable("taken","",opt.root());
  nottakenfile=opt.getVariable("nottaken","",opt.root());
  err1=loader.ref().readTransferFile(tfile, tdas);
  if (!err1.isOk())
    return err1;

  if (tdas.empty()) {
    fprintf(stderr, "Empty transaction list, nothing to do.\n");
    return HBCI::Error();
  }

  for (titer=tdas.begin();
       titer!=tdas.end();
       titer++) {
    acc=hbciif.ref().findAccount((*titer).ourCountryCode(),
				 (*titer).ourBankCode(),
				 (*titer).ourAccountId());
    if (!acc.isValid()) {
      fprintf(stderr,"Account not found, transaction skipped.\n");
      notTaken.push_back(*titer);
    }
    else {
      // get authorized customer for this account
      if (!custid.empty()) {
	// customer given
	cust=acc.ref().bank().ref().findCustomer(custid);
	if (!cust.isValid())
	  return HBCI::Error("getbalance()",
			     ERROR_LEVEL_NORMAL,
			     0,
			     ERROR_ADVISE_DONTKNOW,
			     "customer not found");
	if (!(acc.ref().isAuthorized(cust)))
	  return HBCI::Error("transfer()",
			     ERROR_LEVEL_NORMAL,
			     0,
			     ERROR_ADVISE_DONTKNOW,
			     "customer is not authorized");
      }
      else {
	// not given, try the first in the list
	list<HBCI::Pointer<HBCI::Customer> > custlist;

	custlist=acc.ref().authorizedCustomers();
	if (custlist.empty())
	  return HBCI::Error("transfer()",
			     ERROR_LEVEL_NORMAL,
			     0,
			     ERROR_ADVISE_DONTKNOW,
			     "no authorized customer for this account");
	cust=custlist.front();
      }

      if ((*titer).transactionCode()==05)
	job=new HBCI::OutboxJobDebitNote(cust,acc,*titer);
      else
	job=new HBCI::OutboxJobTransfer(cust,acc,*titer);
      // enqueue job
      hbciif.ref().addJob(job);
    }
  } // for

  // execute outbox
  try {
    err1=hbciif.ref().executeQueue(true);
  }
  catch (HBCI::Error lerr) {
    err1=lerr;
  }

  // check which transactions has been performed
  jobs=hbciif.ref().queuedJobs();
  for (jit=jobs.begin();
       jit!=jobs.end();
       jit++) {
    HBCI::Pointer<HBCI::OutboxJobTransfer> jtx;
    HBCI::Pointer<HBCI::OutboxJobDebitNote> jdb;
    AQMTransaction tx;
    HBCI::StatusReport status;
    list<int> results;
    list<int>::iterator iit;
    int highestResult;
    HBCI::DateTime currTime=HBCI::DateTime::currentTime();

    try {
      jtx=(*jit).cast<HBCI::OutboxJobTransfer>();
      jdb=(*jit).cast<HBCI::OutboxJobDebitNote>();
    }
    catch(HBCI::Error xerr) {
      ;
    }
    try {
      jdb=(*jit).cast<HBCI::OutboxJobDebitNote>();
    }
    catch(HBCI::Error xerr) {
      ;
    }

    if (jtx.isValid())
      tx=jtx.ref().transaction();
    else if (jdb.isValid())
      tx=jdb.ref().transaction();
    else {
      fprintf(stderr, "Internal error: jtx and jdb invalid.\n");
    }

    /* create temporary status report fir this job */
    results=(*jit).ref().resultCodes();
    highestResult=0;
    for (iit=results.begin();
	 iit!=results.end();
	 iit++) {
      if ((*iit)>highestResult)
	highestResult=(*iit);
    } // for result codes
    status.setResult(highestResult);
    status.setMessageReference((*jit).ref().messageReference());
    status.setSegment((*jit).ref().segmentForStatusReport());
    status.setDate(HBCI::Date(currTime.day(), currTime.month(),
			      currTime.year()));
    status.setTime(HBCI::Time(currTime.hours(),
			      currTime.minutes(),
                              currTime.seconds()));
    tx.setStatus(status);
    tx.setDate(HBCI::Date(currTime.day(), currTime.month(),
			  currTime.year()));
    hbciif.ref().addTransfer(tx);

    if ((*jit).ref().result()==HBCI_JOB_RESULT_SUCCESS)
      taken.push_back(tx);
    else
      notTaken.push_back(tx);
  }
  err2=HBCI::Error();
  err3=HBCI::Error();
  // save list of transactions taken
  if (!taken.empty() && !takenfile.empty())
    err2=loader.ref().writeTransferFile(takenfile,
					taken);

  // save list of transactions not taken
  if (!notTaken.empty() && !nottakenfile.empty())
    err3=loader.ref().writeTransferFile(nottakenfile,
					notTaken);

  if (!err1.isOk())
    return err1;
  if (!err3.isOk())
    return err3;
  return err2;
}





