# 
# top.sh: format outline-style output (top-level commands)
################################################################
# Copyright (C) 2001, 2002 Tom Lord
# 
# See the file "COPYING" for further information about
# the copyright and warranty status of this work.
# 

set -e 

################################################################
# special options
# 
# Some options are special:
# 
#	--version | -V
#	--help | -h
# 
if test $# -ne 0 ; then

  for opt in "$@" ; do
    case $opt in

      --version|-V) exec larch --version
                    ;;


      --help|-h)
		printf "format outline-style output (top-level commands)\\n"
		printf "usage: top [options] program [argument...]\\n"
		printf "\\n"
		printf " -V --version                  print version info\\n"
		printf " -h --help                     display help\\n"
		printf "\\n"
		printf " --sub                         indent for a sub-level\\n"
		printf "\\n"
		printf "Invoke PROGRAM with the heading level for formatted output\\n"
		printf "set to 0.\\n"
		printf "\\n"
		exit 0
      		;;

      *)
		;;
    esac
  done
fi

################################################################
# Ordinary Options
# 
# 

sublvl=

while test $# -ne 0 ; do

  case "$1" in 

    --sub)		shift
    			sublvl="$sublvl*"
			;;

    --)			shift
    			break
			;;

    -*)			printf "top: unrecognized option (%s)\\n" "$1" 1>&2
			printf "try --help\\n" 1>&2
			exit 1
			;;

    *)			break
    			;;

  esac

done



################################################################
# Set Level and Invoke Command
# 

ARCH__OUTLINE_DEPTH="$sublvl"

export ARCH__OUTLINE_DEPTH

"$@"

# tag: Tom Lord Wed Dec 12 05:51:49 2001 (output/top.sh)
#
