# need-args.sh
################################################################
# Copyright (C) 2001, 2002 Tom Lord
# 
# See the file "COPYING" for further information about
# the copyright and warranty status of this work.
# 

set -e 

################################################################
# special options
# 
# Some options are special:
# 
#	--version | -V
#	--help | -h
# 
if test $# -ne 0 ; then

  for opt in "$@" ; do
    case $opt in

      --version|-V) exec as-daemon --version
                    ;;


      --help|-h)
		printf "execute a command if arguments have been provided\\n"
		printf "usage: need-args [options] COMMAND arg1 ...\\n"
		printf "\\n"
		printf " -V --version                  print version info\\n"
		printf " -h --help                     display help\\n"
		printf "\\n"
		printf "Invoke:\\n"
		printf "\\n"
		printf "	COMMAND \"ARG1\" \"ARG2\" ...\\n"
		printf "\\n"
		printf "in the manner of \"/bin/sh\" (note the use of quoting)\\n"
		printf "but only if the number of extra arguments provided is\\n"
		printf "greater than 0.\\n"
		printf "\\n"
		printf "This is useful with \"xargs\" as in:\\n"
		printf "\\n"
		printf "  grep FOO input-file | xargs -n 1 need-args \'printf MATCH\\\\t%%s\\\\n\'\\n"
		printf "\\n"
		exit 0
      		;;

      *)
		;;
    esac
  done
fi

################################################################
# Ordinary Options
# 
# 
while test $# -ne 0 ; do

  case "$1" in 

    --)			shift
			break
			;;

    -*)			printf "need-args: unrecognized option (%s)\\n" "$1" 1>&2
			printf "try --help\\n" 1>&2
			exit 1
			;;

    *)			break
    			;;

  esac

done



################################################################
# Ordinary Arguments
# 

if test $# -lt 1 ; then
  printf "usage: need-args [options] command arg1 ...\\n" 1>&2
  printf "try --help\\n" 1>&2
  exit 1
fi

cmd="$1"
shift

################################################################
# Do It
# 

if test $# -gt 0 ; then
  exec $cmd "$@"
fi

# tag: Tom Lord Tue Jan 22 17:40:06 2002 (shell-utils/need-args.c)
#
