/*
 * Copyright (c) 2000-2001 QoSient, LLC
 * All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

/*
 * Copyright (c) 1993, 1994 Carnegie Mellon University.
 * All rights reserved.
 *
 * Permission to use, copy, modify, and distribute this software and
 * its documentation for any purpose and without fee is hereby granted, 
 * provided that the above copyright notice appear in all copies and
 * that both that copyright notice and this permission notice appear
 * in supporting documentation, and that the name of CMU not be
 * used in advertising or publicity pertaining to distribution of the
 * software without specific, written prior permission.  
 * 
 * CMU DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
 * ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
 * CMU BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
 * ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 *
 */


#define argtimeval timeval

#if defined(HAVE_SOLARIS)
#include <strings.h>
#include <sys/byteorder.h>
#endif

#if defined(linux)
#include <endian.h>
#define __FAVOR_BSD
#endif

#if defined(CYGWIN)
#define _LITTLE_ENDIAN
#else

#if (__FreeBSD__)
#if defined(BYTE_ORDER)
#define __BYTE_ORDER    BYTE_ORDER
#endif
#if defined(LITTLE_ENDIAN)
#define __LITTLE_ENDIAN LITTLE_ENDIAN
#endif
#if defined(BIG_ENDIAN)
#define __BIG_ENDIAN    BIG_ENDIAN
#endif
#endif

#if !defined(_LITTLE_ENDIAN) && !defined(_BIG_ENDIAN)
#if __BYTE_ORDER == __LITTLE_ENDIAN
#define _LITTLE_ENDIAN
#else
#define _BIG_ENDIAN
#endif
#endif
#endif


#if defined(__sgi) || defined(HAVE_SOLARIS) || defined(ultrix) || defined(__osf__) || defined(linux) || defined(bsdi) || defined(AIX) || defined(CYGWIN) || defined(__FreeBSD__) || defined(__NetBSD__) || defined(__OpenBSD__)

#define timelocal mktime

#include <os.h>

#if defined(__sgi)
#include <bstring.h>
#include <ulimit.h>

#if _MIPS_SZLONG == 64
#undef argtimeval
#define argtimeval irix5_timeval
#endif

#undef TCPSTATES
#endif

#if defined(linux)
#include <time.h>
#endif

#if defined(__sgi) || defined(bsdi)
struct ether_addr {
        u_char  ether_addr_octet[6];
};
#endif

#if defined(AIX)
#define _SUN
#include <sys/select.h>
#include <net/nh.h>
#endif
#endif

#define arg_uint8   u_char
#define arg_int8    char
#define arg_uint16  u_short
#define arg_int16   short

#if HOST_BITS_PER_INT == 32
#define arg_uint32  u_int
#define arg_int32   int
#else
#define arg_uint32  u_long
#define arg_int32   long
#endif

#ifndef ICMP_ROUTERADVERT
#define	ICMP_ROUTERADVERT	9	/* router advertisement */
#endif

#ifndef	ICMP_ROUTERSOLICIT
#define	ICMP_ROUTERSOLICIT	10	/* router solicitation */
#endif

#ifndef TCPOPT_WSCALE
#define	TCPOPT_WSCALE		3	/* window scale factor (rfc1072) */
#endif
#ifndef TCPOPT_SACKOK
#define	TCPOPT_SACKOK		4	/* selective ack ok (rfc1072) */
#endif
#ifndef TCPOPT_SACK
#define	TCPOPT_SACK		5	/* selective ack (rfc1072) */
#endif
#ifndef TCPOPT_ECHO
#define	TCPOPT_ECHO		6	/* echo (rfc1072) */
#endif
#ifndef TCPOPT_ECHOREPLY
#define	TCPOPT_ECHOREPLY	7	/* echo (rfc1072) */
#endif
#ifndef TCPOPT_TIMESTAMP
#define TCPOPT_TIMESTAMP	8	/* timestamps (rfc1323) */
#endif
#ifndef TCPOPT_CC
#define TCPOPT_CC		11	/* T/TCP CC options (rfc1644) */
#endif
#ifndef TCPOPT_CCNEW
#define TCPOPT_CCNEW		12	/* T/TCP CC options (rfc1644) */
#endif
#ifndef TCPOPT_CCECHO
#define TCPOPT_CCECHO		13	/* T/TCP CC options (rfc1644) */
#endif


/* Types missing from some systems */

#ifndef	ETHERTYPE_SPRITE
#define	ETHERTYPE_SPRITE	0x0500
#endif
#ifndef ETHERTYPE_NS
#define ETHERTYPE_NS		0x0600
#endif
#ifndef ETHERTYPE_IP
#define ETHERTYPE_IP		0x0800
#endif
#ifndef ETHERTYPE_X25L3
#define ETHERTYPE_X25L3		0x0805
#endif
#ifndef ETHERTYPE_ARP
#define ETHERTYPE_ARP		0x0806
#endif
#ifndef ETHERTYPE_VINES
#define ETHERTYPE_VINES		0x0bad
#endif
#ifndef ETHERTYPE_TRAIL
#define ETHERTYPE_TRAIL		0x1000
#endif
#ifndef ETHERTYPE_TRAIN
#define ETHERTYPE_TRAIN		0x1984
#endif
#ifndef ETHERTYPE_3C_NBP_DGRAM
#define ETHERTYPE_3C_NBP_DGRAM	0x3c07
#endif
#ifndef ETHERTYPE_DEC
#define ETHERTYPE_DEC		0x6000
#endif
#ifndef	ETHERTYPE_MOPDL
#define	ETHERTYPE_MOPDL		0x6001
#endif
#ifndef	ETHERTYPE_MOPRC
#define	ETHERTYPE_MOPRC		0x6002
#endif
#ifndef	ETHERTYPE_DN
#define	ETHERTYPE_DN		0x6003
#endif
#ifndef ETHERTYPE_LAT
#define ETHERTYPE_LAT		0x6004
#endif
#ifndef ETHERTYPE_DEC_DIAG
#define ETHERTYPE_DEC_DIAG	0x6005
#endif
#ifndef ETHERTYPE_DEC_CUST
#define ETHERTYPE_DEC_CUST	0x6006
#endif
#ifndef ETHERTYPE_SCA
#define ETHERTYPE_SCA		0x6007
#endif
#ifndef ETHERTYPE_REVARP
#define ETHERTYPE_REVARP	0x8035
#endif
#ifndef	ETHERTYPE_LANBRIDGE
#define	ETHERTYPE_LANBRIDGE	0x8038
#endif
#ifndef	ETHERTYPE_DECDNS
#define	ETHERTYPE_DECDNS	0x803c
#endif
#ifndef	ETHERTYPE_DECDTS
#define	ETHERTYPE_DECDTS	0x803e
#endif
#ifndef	ETHERTYPE_VEXP
#define	ETHERTYPE_VEXP		0x805b
#endif
#ifndef	ETHERTYPE_VPROD
#define	ETHERTYPE_VPROD		0x805c
#endif
#ifndef ETHERTYPE_ATALK
#define ETHERTYPE_ATALK		0x809b
#endif
#ifndef ETHERTYPE_AARP
#define ETHERTYPE_AARP		0x80f3
#endif
#ifndef	ETHERTYPE_8021Q
#define	ETHERTYPE_8021Q		0x8100
#endif
#ifndef ETHERTYPE_IPX
#define ETHERTYPE_IPX		0x8137
#endif
#ifndef ETHERTYPE_SNMP
#define ETHERTYPE_SNMP		0x814c
#endif
#ifndef ETHERTYPE_IPV6
#define ETHERTYPE_IPV6		0x86dd
#endif
#ifndef ETHERTYPE_MPLS
#define ETHERTYPE_MPLS		0x8847
#endif
#ifndef ETHERTYPE_MPLS_MULTI
#define ETHERTYPE_MPLS_MULTI	0x8848
#endif
#ifndef ETHERTYPE_PPPOED
#define ETHERTYPE_PPPOED	0x8863
#endif
#ifndef ETHERTYPE_PPPOES
#define ETHERTYPE_PPPOES	0x8864
#endif
#ifndef	ETHERTYPE_LOOPBACK
#define	ETHERTYPE_LOOPBACK	0x9000
#endif
