/*
 * Copyright (c) 2000-2001 QoSient, LLC
 * All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

/*
 * Copyright (c) 1993, 1994 Carnegie Mellon University.
 * All rights reserved.
 *
 * Permission to use, copy, modify, and distribute this software and
 * its documentation for any purpose and without fee is hereby granted,
 * provided that the above copyright notice appear in all copies and
 * that both that copyright notice and this permission notice appear
 * in supporting documentation, and that the name of CMU not be
 * used in advertising or publicity pertaining to distribution of the
 * software without specific, written prior permission.
 *
 * CMU DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
 * ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
 * CMU BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
 * ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 *
 */


/* ArgusUtil.h */

#ifndef ArgusUtil_h
#define ArgusUtil_h


#include <stdlib.h>
#include <strings.h>

#include <sys/time.h>
#include <sys/socket.h>

#include <compat.h>

#include <argus.h>
#include <argus_def.h>
#include <argus_out.h>


struct ArgusRecordStruct {
  int length, written;
  char *buf;
};

struct ArgusListObjectStruct {
   struct ArgusListObjectStruct *nxt, *prv;
   void *obj;
};

struct ArgusListStruct {
   struct ArgusListObjectStruct *start;
   struct timeval outputTime, reportTime;
   unsigned int count;
};


#define ARGUS_PROCESS_NEXT_PASS		0x10

struct ArgusQueueHeader {
   struct ArgusQueueHeader *prv, *nxt;
   struct ArgusQueueStruct *queue;
   int status;
   struct timeval lasttime, logtime;
};

struct ArgusQueueStruct {
   int count;
   struct ArgusQueueHeader *start;
   struct ArgusFlowStruct **array;
};


#define ARGUS_READINGHDR        1
#define ARGUS_READINGBLOCK      2
#define ARGUS_MAXRECORDS        1024


#define ARGUS_WAS_FUNCTIONAL		0x10
#define ARGUS_SOCKET_COMPLETE		0x20
#define ARGUS_MAXRECORD			0x10000

struct ArgusSocketStruct {
   struct ArgusListStruct *ArgusOutputList;
   int fd, status, cnt, expectedSize, errornum;
   int ArgusLastRecord, ArgusReadState;
   unsigned char buf[ARGUS_MAXRECORD], *ptr;
   struct ArgusRecordHeader *ahdr;
   struct sockaddr sock;
   char *filename;
};

typedef int (*ArgusHandler)(struct ArgusSocketStruct *, unsigned char *, int, void *);


#if defined(ArgusUtil)

#if defined(_LITTLE_ENDIAN)
void ArgusNtoH (struct ArgusRecord *);
void ArgusHtoN (struct ArgusRecord *);
#endif

void *ArgusCalloc (int, int);
void ArgusFree (void *);

unsigned long long ArgusAbsTimeDiff (struct timeval *, struct timeval *);

struct ArgusListStruct *ArgusNewList(void);
void ArgusDeleteList(struct ArgusListStruct *);
 
int ArgusListEmpty (struct ArgusListStruct *);
int ArgusGetListCount (struct ArgusListStruct *);
 
void *ArgusFrontList (struct ArgusListStruct *);
void *ArgusBackList (struct ArgusListStruct *);
 
void ArgusPushFrontList(struct ArgusListStruct *, void *);
void ArgusPopFrontList (struct ArgusListStruct *);
 
void ArgusPushBackList (struct ArgusListStruct *, void *);
void ArgusPopBackList  (struct ArgusListStruct *);


struct ArgusQueueStruct *ArgusNewQueue (void);
void ArgusDeleteQueue (struct ArgusQueueStruct *);
 
int ArgusGetQueueCount(struct ArgusQueueStruct *);
 
void ArgusPushQueue(struct ArgusQueueStruct *, struct ArgusFlowStruct *);
int ArgusAddToQueue(struct ArgusQueueStruct *, struct ArgusFlowStruct *);
 
struct ArgusFlowStruct *ArgusPopQueue(struct ArgusQueueStruct *);
struct ArgusFlowStruct *ArgusRemoveFromQueue(struct ArgusQueueStruct *, struct ArgusFlowStruct *);
 
int ArgusCheckTimeout(struct ArgusFlowStruct *obj);

void ArgusProcessQueue(struct ArgusQueueStruct *, unsigned char state);
void ArgusEmptyQueue(struct ArgusQueueStruct *);

void ArgusDeleteObject(struct ArgusFlowStruct *);

struct ArgusHashTableHeader *ArgusFindHashObject (void);
extern struct ArgusHashTableHeader *ArgusAddHashEntry (struct ArgusFlowStruct *);
void ArgusRemoveHashEntry (struct ArgusHashTableHeader *);

struct ArgusSocketStruct * ArgusNewSocket (int fd);
void ArgusDeleteSocket (struct ArgusSocketStruct *);
int ArgusReadSocket (struct ArgusSocketStruct *, ArgusHandler, void *);
int ArgusWriteSocket (struct ArgusSocketStruct *, unsigned char *, int);
int ArgusWriteOutSocket (struct ArgusSocketStruct *);

char *ArgusGetFlowString (struct ArgusFlowStruct *);

int Argusdflag = 0;

#ifdef ARGUSDEBUG
extern void ArgusDebug (int, char *, ...);
#endif


#else

 
#if defined(_LITTLE_ENDIAN)
extern void ArgusNtoH (struct ArgusRecord *);
extern void ArgusHtoN (struct ArgusRecord *);
#endif

extern void *ArgusCalloc (int, int);
extern void ArgusFree (void *);

extern long long ArgusAbsTimeDiff (struct timeval *, struct timeval *);
extern struct ArgusListStruct *ArgusNewList(void);
extern void ArgusDeleteList(struct ArgusListStruct *);

extern int ArgusListEmpty (struct ArgusListStruct *);
extern int ArgusGetListCount (struct ArgusListStruct *);

extern void *ArgusFrontList (struct ArgusListStruct *);

extern void ArgusPushFrontList(struct ArgusListStruct *, void *);
extern void ArgusPopFrontList (struct ArgusListStruct *);

extern void ArgusPushBackList (struct ArgusListStruct *, void *);
extern void ArgusPopBackList  (struct ArgusListStruct *);

extern struct ArgusQueueStruct *ArgusNewQueue (void);
extern int ArgusDeleteQueue (struct ArgusQueueStruct *);

extern int ArgusGetQueueCount(struct ArgusQueueStruct *);

extern void ArgusPushQueue(struct ArgusQueueStruct *, struct ArgusFlowStruct *);
extern int ArgusAddToQueue(struct ArgusQueueStruct *, struct ArgusFlowStruct *);

extern struct ArgusFlowStruct *ArgusPopQueue(struct ArgusQueueStruct *);
extern struct ArgusFlowStruct *ArgusRemoveFromQueue(struct ArgusQueueStruct *, struct ArgusFlowStruct *);

extern int ArgusCheckTimeout(struct ArgusFlowStruct *obj);

extern void ArgusProcessQueue(struct ArgusQueueStruct *, unsigned char state);
extern void ArgusEmptyQueue(struct ArgusQueueStruct *);

extern void ArgusDeleteObject(struct ArgusFlowStruct *obj);

extern struct ArgusHashTableHeader *ArgusFindHashObject (void);
extern struct ArgusHashTableHeader *ArgusAddHashEntry (struct ArgusFlowStruct *);
extern void ArgusRemoveHashEntry (struct ArgusHashTableHeader *);

extern struct ArgusSocketStruct * ArgusNewSocket (int fd);
extern void ArgusDeleteSocket (struct ArgusSocketStruct *);
extern int ArgusReadSocket (struct ArgusSocketStruct *, ArgusHandler, void *);
extern int ArgusWriteSocket (struct ArgusSocketStruct *, unsigned char *, int);
extern int ArgusWriteOutSocket (struct ArgusSocketStruct *);

extern char *ArgusGetFlowString (struct ArgusFlowStruct *);


extern int Argusdflag;

#ifdef ARGUSDEBUG
extern void ArgusDebug (int, char *, ...);
#endif

#endif
#endif
