/*
 * Copyright (c) 2000-2001 QoSient, LLC
 * All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#ifndef ArgusUdp
#define ArgusUdp
#endif

#include <stdio.h>
#include <string.h>
#include <errno.h>

#include <ArgusModeler.h>
#include <bootp.h>
struct bootp *bp;

void
ArgusUpdateUDPState (struct ArgusFlowStruct *flowstr, unsigned char *state)
{
   struct ArgusIPFlow *flow = NULL;
   struct udphdr *up = (struct udphdr *) ArgusThisUpHdr;
   char *nxtHdr = (u_char *)(up + 1);

   ArgusTallyTime (flowstr, *state);

   if (STRUCTCAPTURED(*up)) {
      ArgusThisLength -= sizeof(*up);
      ArgusSnapLength -= sizeof(*up);
      ArgusThisUpHdr = nxtHdr;

      ArgusUpdateAppState (flowstr, state);

      flow = &flowstr->flow.ip_flow;

      if (*state == ARGUS_START) {
         if ((flow->dport == IPPORT_BOOTPS))  { /* bootp request */
            if (ArgusThisDir == 0) {
               flow->ip_src = ArgusThisIpHdr->ip_src.s_addr;
               flow->ip_dst = ArgusThisIpHdr->ip_dst.s_addr;
            } else {
               flow->ip_src = ArgusThisIpHdr->ip_dst.s_addr;
               flow->ip_dst = ArgusThisIpHdr->ip_src.s_addr;
            }
         }

      } else {
         flowstr->ArgusTimeout = ARGUS_IPTIMEOUT;
         if ((flow->dport == IPPORT_BOOTPS))  { /* bootp request */
            bp = (struct bootp *) nxtHdr;

            if (bp->bp_op == BOOTREPLY) {
               flow->ip_src = ntohl(bp->bp_yiaddr.s_addr);
               flow->ip_dst = ArgusThisIpHdr->ip_src.s_addr;
            }
         }

         if (!(flow->tp_p))
            if (ArgusResponseStatus && 
                      ((flowstr->state.src.count == 1) && (flowstr->state.dst.count == 1))) {
               ArgusSendFlowRecord (flowstr, ARGUS_STATUS);
         }
      }
   }

#ifdef ARGUSDEBUG
   ArgusDebug (8, "ArgusUpdateUDPState(0x%x, %d) returning\n", flowstr, state);
#endif

}


#include <argus_out.h>

void ArgusUDPFlowRecord (struct ArgusFlowStruct *, struct ArgusRecord *, unsigned char);

void
ArgusUDPFlowRecord (struct ArgusFlowStruct *flow, struct ArgusRecord *argus, unsigned char state)
{
   struct ArgusIPFlow *ipFlow = (struct ArgusIPFlow *)&argus->argus_far.flow.ip_flow;

   switch (ipFlow->tp_p) {
      case ARGUS_RTP_FLOWTAG: {
         struct ArgusRTPObject *rtpObject;

         if ((rtpObject = (struct ArgusRTPObject *) flow->TransportDSRBuffer) != NULL) {
            if (!(rtpObject->status & ARGUS_START)) {
               if (argus->ahdr.length > 0) {
                  bcopy ((char *)rtpObject, &((char *)argus)[argus->ahdr.length], sizeof(*rtpObject));
                  argus->ahdr.length += sizeof(*rtpObject);
               }
            } else
               ipFlow->tp_p = 0;
         }
      }
   }
}


