#include <stdio.h>
#include "curl/curl.h"

class HttpUpload {

public:
  enum state_code {NONE, LOGIN, READING, UPLOADING, DONE, CANCEL, CANCELLED};
  enum err_code  {SUCCESS, ERR_AUTH, ERR_UPLOAD, ERR_SSL, ERR_FILE, 
		  ERR_TIMEOUT, ERR_WRITE, ERR_SERVER, ERR_SIZE, ERR_SERVAUTH};

  HttpUpload(const char *infile, const char *username, const char *password, const char *tmp);
  ~HttpUpload();

  void setProxyInfo(const char *server, const char *user, const char *password);
  bool doTransfer();
  err_code errorInfo(char *buffer, int size);
  void setAlternateHost(const char *host);
  void SetProgressVars (int* pNow, int* pTotal, int *pState);
  long m_nRefs;

private:
  err_code m_Status;

  static const char pServerLoginFormat[];
  static const char pServerUploadURL[];
  static const char pServerName[];

  bool doLogin();
  err_code doUpload();

  bool fileContains(FILE *file, char *str);
  void useProxy(CURL *curl);
  static int progressCallback(void *p, size_t dltotal, size_t dlnow, size_t ultotal, size_t ulnow);

  char *m_pAlternateHost;
  char *m_pCookieFilename;
  char *m_pHttpUser;
  char *m_pHttpPass;
  char *m_pTmpTemplate;
  char *m_pInfile;
  char *m_pProxyServer;
  char *m_pProxyUser;
  char *m_pProxyPassword;
  int  m_nProxyPort;

  static int *m_pNow;
  static int *m_pTotal;
  static int *m_pState;
};

