#!/bin/sh

# Ark - Libraries, Tools & Programs for MMORPG developpements.
# Copyright (C) 1999-2000 The Contributors of the ArkRPG Project
# Please see the file "AUTHORS" for a list of contributors
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.


# Get a boolean answer
get_boolean_answer()
{
	PROMPT_LINE="$1 [Y/N] : ";

	while true;
	do
		read -r -p "${PROMPT_LINE}" ANSWER
		echo ""

		if [ "${ANSWER}x" = "Y x" -o "${ANSWER}x" = "yx" ]; then
			return 1
		elif [ "${ANSWER}x" = "Nx" -o "${ANSWER}x" = "nx" ]; then
			return 0
		fi
	done
}

check_directory()
{
	if [ -e "$1" -a ! -d "$1" ]; then
		echo "$1 exists but it is not a directory"

		if [ ! get_boolean_answer "Rename it to $1.bak ?" ]; then
			mv $1 $1.bak
			mkdir $1
		else
			exit 1
		fi
	elif [ -e "$1" ]; then
		echo "Arkhart has already been configured on this computer";

		if get_boolean_answer "Overwrite old configuration ?"; then
			exit 1;
		fi
	else
		mkdir $1
	fi
}


check_directory "${HOME}/.arkhart";

cfg_file=${HOME}/.arkhart/arkglobal.cfg
game_dir=$PWD

cat >${cfg_file} << EOF
// ===========================================================================
// Configuration file for Arkhart
// ===========================================================================

// The {game} mountpoint maps to the root directory of game data.
system::Mount ("game", "${game_dir}");

// The {gamevar} mountpoint maps to the directory where variable game data are
// stored. This can be saves or log files.
system::Mount ("gamevar", "{game}/var");

EOF

cp -f ${game_dir}/config/renderer.cfg ${HOME}/.arkhart/arkrenderer.cfg

# Print some informations
echo "Written ${cfg_file} .. :";
echo "  Game directory is \"${game_dir}\"";
echo "  Variable directory is \"${game_dir}/var\"";
