/*

*************************************************************************

ArmageTron -- Just another Tron Lightcycle Game in 3D.
Copyright (C) 2000  Manuel Moos (manuel@moosnet.de)

**************************************************************************

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
  
***************************************************************************

*/

#ifndef ArmageTron_CAMERA_H
#define ArmageTron_CAMERA_H

typedef enum {CAMERA_IN=0,CAMERA_FREE,CAMERA_FOLLOW,CAMERA_SMART,
	      CAMERA_SMART_IN} eCamMode;

#include "eCoord.h"
//#include "uInput.h"
#include "rViewport.h"
#include "tList.h"

class ePlayer;
class ePlayerNetID;
class eGameObject;
class eCamera;
class eGrid;
class uActionCamera;

//extern REAL se_cameraRise; // how far down does the current camera look?
//extern REAL se_cameraZ;

// extern List<eCamera> se_cameras;

class eCamera{
 protected:
  static uActionCamera se_lookUp,se_lookDown,se_lookLeft,se_lookRight,
    se_moveLeft,se_moveRight,se_moveUp,se_moveDown,se_moveForward,se_moveBack,
    se_zoomIn,se_zoomOut,se_glanceLeft,se_glanceRight,se_glanceBack,
    se_switchView;

  
  int id;
  //  tCHECKED_PTR(eGameObject) foot;
  tCHECKED_PTR(eGrid)           grid;
  //eGameObject *center;
  tCHECKED_PTR(ePlayerNetID)    netPlayer;
  tCHECKED_PTR(ePlayer)         localPlayer;

  int        centerID; // the game id of the object we are watching
  //int        lastCenterID; // the game id of the object we are watching
  REAL       lastSwitch; // the last center switch
  eCamMode    mode;
  
  eCoord pos;       // Position
  eCoord lastPos;  // last rendered position
  eCoord dir;       // direction
  eCoord top;       // vector (top,1) is top of camera (limits views)
  REAL  z,rise;    // height above the floor and whether we look up or down
  REAL  fov;       // field of vision;

  REAL turning;   // number of turns in the last seconds
  REAL smoothTurning; //that value smoothed


  REAL distance;    // distance travelled so far
  REAL lastrendertime; // the time this was last rendered

  REAL smartcamSkewSmooth,smartcamIncamSmooth;
  eCoord centerDirSmooth;
  eCoord centerPosSmooth;

  tCHECKED_PTR(rViewport) vp;

  eCoord centerPosLast;
  REAL  userCameraControl;
  REAL  centerIncam;

  bool glancingLeft,glancingRight,glancingBack;
  REAL glanceSmooth;

  static bool InterestingToWatch(eGameObject *g);

  void Bound(); // make sure the camera is inside the arena
  
  void MyInit();
public:
  bool CenterIncamOnTurn();
  bool WhobbleIncam();
  bool AutoSwitchIncam();

  eCamera(eGrid *grid, rViewport *vp,ePlayerNetID *owner,ePlayer *lp,eCamMode m=CAMERA_IN);
  virtual ~eCamera();

  eGameObject *Center();

  eCoord CenterPos();
  eCoord CenterDir();
  virtual eCoord CenterCycleDir();

  eCoord CenterCamDir();
  eCoord CenterCamTop();
  eCoord CenterCamPos();
  REAL  CenterCamZ();

  REAL  CenterZ();
  REAL  CenterSpeed();

  const eCoord& CameraDir() const {return dir;}
  const eCoord& CameraPos() const {return pos;}
  REAL          CameraZ  () const {return z;}

  bool CenterAlive();

  bool CenterCockpitFixedBefore();
  void CenterCockpitFixedAfter();

  void SwitchView();
  void SwitchCenter(int d);
  bool Act(uActionCamera *act,REAL x);

#ifndef DEDICATED
  void Render();
  void SoundMix(unsigned char *dest,unsigned int len);
private:
  void SoundMixGameObject(unsigned char *dest,unsigned int len,eGameObject *go);
public:
#endif

  virtual void Timestep(REAL ts);

  REAL Dist(){return distance;}

  /*
  static int    Number(){return se_cameras.Len();}
  static const eCoord& PosNum(int i){
    if (i<se_cameras.Len())
      return se_cameras(i)->lastPos;
    else
      return se_zeroCoord;
  }
  static const eCoord& DirNum(int i){
    if (i<se_cameras.Len())
      return se_cameras(i)->dir;
    else
      return se_zeroCoord;
  }

  static REAL HeightNum(int i){
    if (i<se_cameras.Len())
      return se_cameras(i)->z;
    else
      return 0;
  }
  */

  static void s_Timestep(eGrid *grid, REAL time);
};

/*
inline int    NumberOfCameras(){return eCamera::Number();}
inline const eCoord& CameraPos(int i){return eCamera::PosNum(i);}
inline const eCoord& CameraDir(int i){return eCamera::DirNum(i);}
inline REAL CameraHeight(int i){return eCamera::HeightNum(i);}
*/


#endif
