//proto.h:

/*
 *      Copyright (C) Philipp 'ph3-der-loewe' Schafft - 2010
 *
 *  This file is part of aroarfw, a RoarAudio framework for
 *  embedded systems (Controlers).
 *
 *  This file is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License version 3
 *  or (at your option) any later version as published by
 *  the Free Software Foundation.
 *
 *  aroarfw is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this software; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 51 Franklin Street, Fifth Floor,
 *  Boston, MA 02110-1301, USA.
 */

#ifndef _AROARFW_PROTO_H_
#define _AROARFW_PROTO_H_

//! Command values used for rmsg*_t
typedef enum {
// grep ^'#define MUROAR_CMD_' muroar.h  | sed 's/  */ /g; s/^#define MUROAR_/R/;' | while read c i d; do printf " //! XXX\n %-24s = %3i,\n" $c $i; done
 //! No Operation Commands
 RCMD_NOOP                =   0,
 //! Identify our client to the server
 RCMD_IDENTIFY            =   1,
 //! Auth our client on the server
 RCMD_AUTH                =   2,
 //! Create a new stream
 RCMD_NEW_STREAM          =   3,
 //! Set meta data on a stream
 RCMD_SET_META            =   4,
 //! Exec a stream
 RCMD_EXEC_STREAM         =   5,
 //! Terminate the client connection
 RCMD_QUIT                =   6,
 //! Get standby state from from server
 RCMD_GET_STANDBY         =   7,
 //! Ask the server to change it's standby state
 RCMD_SET_STANDBY         =   8,
 //! Asks server for general information
 RCMD_SERVER_INFO         =   9,
 //! Asks the server for some stats
 RCMD_SERVER_STATS        =  10,
 //! Asks the server for information on outputs
 RCMD_SERVER_OINFO        =  11,
 //! Add data to the stream's input buffer
 RCMD_ADD_DATA            =  12,
 //! Terminate the server
 RCMD_EXIT                =  13,
 //! List streams
 RCMD_LIST_STREAMS        =  14,
 //! List clients
 RCMD_LIST_CLIENTS        =  15,
 //! Get a client object
 RCMD_GET_CLIENT          =  16,
 //! Get a stream object
 RCMD_GET_STREAM          =  17,
 //! Kick (terminate) a object from the server
 RCMD_KICK                =  18,
 //! Change the volume of a stream
 RCMD_SET_VOL             =  19,
 //! Get volume information of a stream
 RCMD_GET_VOL             =  20,
 //! Connect a stream to IO resource (to a socket)
 RCMD_CON_STREAM          =  21,
 //! Get meta data of a stream
 RCMD_GET_META            =  22,
 //! List meta data of a stream
 RCMD_LIST_META           =  23,
 //! Asks the server to generate a notify sound (beep)
 RCMD_BEEP                =  24,
 //! Get Access Control List informations
 RCMD_GET_ACL             =  25,
 //! Set Access Control List informations
 RCMD_SET_ACL             =  26,
 //! Get stream parameters
 RCMD_GET_STREAM_PARA     =  27,
 //! Set stream parameters
 RCMD_SET_STREAM_PARA     =  28,
 //! Attach a stream to some resource (client, driver, ...)
 RCMD_ATTACH              =  29,
 //! Pass an open file handle to the server
 RCMD_PASSFH              =  30,
 //! Get current system clock time of server
 RCMD_GETTIMEOFDAY        =  31,
 //! Asks the server for our client ID
 RCMD_WHOAMI              =  32,
 //! Positive return value for request
 RCMD_OK                  = 254,
 //! Negative (error) return value for request
 RCMD_ERROR               = 255
} rcmd_t;

//! Parameter for server termination (RCMD_EXIT)
typedef enum {
 //! Request the server to exit without waiting for clients to exit
 RTERM_EXIT = 0,
 //! Request the server to exit but wait for clients to exit
 RTERM_TERM = 1
} rterm_t;

//! Parameter for type of volume change
typedef enum {
 //! Set all channels at once
 RVOL_SET_ALL = 1,
 //! Set only one channel
 RVOL_SET_ONE = 2
} rvolch_t;

//! Parameter for stream flag operation
typedef enum {
 //! Set flag
 RFLAGCH_SET   = 0,
 //! Reset flag
 RFLAGCH_RESET = 1
} rflagch_t;

//! States a stream can have
typedef enum {
 //! The state of stream is unknown
 RSTREAMSTATE_UNKNOWN = -1,
 //! The stream does not exist
 RSTREAMSTATE_NULL    =  0,
 //! The stream object is unused
 RSTREAMSTATE_UNUSED  = RSTREAMSTATE_NULL,
 //! The stream is initing (is creating)
 RSTREAMSTATE_INITING =  1,
 //! The stream is new. This means the stream have not been used yet
 RSTREAMSTATE_NEW     =  2,
 //! The stream is old, This means it was arrady used for data
 RSTREAMSTATE_OLD     =  3,
 //! The stream is currently closing. This state should only be rarly seen from outsite
 //! the server.
 RSTREAMSTATE_CLOSING =  4
} rstreamstat_t;


//! Type for stream directions
typedef enum {
 //! Waveform Playback stream
 RDIR_PLAY        =  1,
 //! Waveform recoard stream
 RDIR_RECORD      =  2,
 //! Waveform monitoring stream
 RDIR_MONITOR     =  3,
 //! Waveform filter stream
 RDIR_FILTER      =  4,
 //! Waveform (and maybe other) stream attached to a driver
 RDIR_OUTPUT      =  5,
 //! Mixer core
 RDIR_MIXING      =  6,
// RDIR_INTERNAL    =  7, // unused, undefined.
 //! Meta data stream, obsolete
 RDIR_META        =  8,
 //! Waveform bidirectional stream (this is PLAY and MONITOR in one stream)
 RDIR_BIDIR       =  9,
 //! Thru stream, this stream type sends raw copys of data passing thru a stream
 RDIR_THRU        = 10,
 //! Bridge between subsystems or two objects in the same subsystem
 RDIR_BRIDGE      = 11,
 //! MIDI input stream
 RDIR_MIDI_IN     = 12,
 //! MIDI output stream
 RDIR_MIDI_OUT    = 13,
 //! Light Control input stream
 RDIR_LIGHT_IN    = 14,
 //! Light Control output stream
 RDIR_LIGHT_OUT   = 15,
 //! Raw data input stream
 RDIR_RAW_IN      = 16,
 //! Raw data output stream
 RDIR_RAW_OUT     = 17,
 //! Complex data input stream
 RDIR_COMPLEX_IN  = 18,
 //! Complex data output stream
 RDIR_COMPLEX_OUT = 19,
 //! Radio Data and Transmitter Control System input stream
 RDIR_RDTCS_IN    = 20,
 //! Radio Data and Transmitter Control System output stream
 RDIR_RDTCS_OUT   = 21,
 //! One more than the maximum direction ID
 RDIR_DIRIDS      = 22,
} rdir_t;

//! Roles a stream can have
typedef enum {
 //! Unknown role
 RROLE_UNKNOWN          = -1,
 //! No role assigned
 RROLE_NONE             =  0,
 //! Normal music
 RROLE_MUSIC            =  1,
 //! Sound from a video
 RROLE_VIDEO            =  2,
 //! Sound generted by a game (see also RROLE_BACKGROUND_MUSIC)
 RROLE_GAME             =  3,
 //! Event sounds?
 RROLE_EVENT            =  4,
 //! Notify beep sounds
 RROLE_BEEP             =  5,
 //! Voice connections (RoN, VoIP, ISDN,...)
 RROLE_PHONE            =  6,
 //! Background music
 RROLE_BACKGROUND_MUSIC =  7,
 //! Voice stream (singer, speaker, ....)
 RROLE_VOICE            =  8,
 //! General instrument
 RROLE_INSTRUMENT       =  9,
 //! Rhythem instrument
 RROLE_RHYTHM           = 10,
 //! Click track
 RROLE_CLICK            = 11,
 //! Already mixed data (for example outout of another sound daemon)
 RROLE_MIXED            = 12,
} rrole_t;

//! Possible standby modes
typedef enum {
 //! Standby is inactive
 RSTANDBY_INACTIVE  = 0,
 //! Standby is active
 RSTANDBY_ACTIVE    = 1
} rstandby_t;


//! RoarAudio object types
typedef enum {
 //! Clients
 ROT_CLIENT   = 1,
 //! Streams
 ROT_STREAM   = 2,
 //! Sources
 ROT_SOURCE   = 3,
 //! Samples
 ROT_SAMPLE   = 4
} rot_t;

//! Types of attaches for the RCMD_ATTACH command
typedef enum {
 //! Simple Attach: Attach stream to a diffrent client
 RATTACH_SIMPLE = 1,
 //! Source Attach: Attach stream to a source driver
 RATTACH_SOURCE = 2,
 //! Output Attach: Attach stream to a output driver
 RATTACH_OUTPUT = 3
} rattach_t;

//! Sub-Commands for the RCMD_?ET_STREAM_PARA commands
typedef enum {
 //! Ask for info structure
 RSTREAMPARA_INFO    = 1,
 //! Operate on stream flags
 RSTREAMPARA_FLAGS   = 2,
 //! Get or set stream name
 RSTREAMPARA_NAME    = 3,
 //! Get or set channel mapping
 RSTREAMPARA_CHANMAP = 4,
 //! Get or set stream role
 RSTREAMPARA_ROLE    = 5
} rstreampata_t;

//! Auth methodes for the RCMD_AUTH command
typedef enum {
 //! Ask the library to automaticly search for a working auth method.
 //! This MUST NOT be send to the wire.
 RAUTH_AUTO            = -1,
 //! Send a dummy auth request. The server may grand access.
 //! This is a bit like anonymous FTP.
 //! (The server is free to do some magicly checking like TRUST does)
 RAUTH_NONE            =  0,
 //! Send a binary-save cookie. This is normaly stored in a cookie file.
 RAUTH_COOKIE          =  1,
 //! Ask the server to grand access based on information provided by the operating system.
 //! This is usefull for UNIX sockets. With UNIX sockets the server may for example
 //! Match the uid of the client with an internal list.
 RAUTH_TRUST           =  2,
 //! Send a user supplyed password. The user should get asked for the password.
 RAUTH_PASSWORD        =  3,
 //! Send Username/Password for the current system user.
 //! The user should be matched using local, NIS, PAM, LDAP,... databases.
 RAUTH_SYSUSER         =  4,
 //! Use a OpenPGP based method using a signing key. (not recommented!)
 RAUTH_OPENPGP_SIGN    =  5,
 //! Use a OpenPGP based method using a encryption key.
 RAUTH_OPENPGP_ENCRYPT =  6,
 //! Use a OpenPGP based method using a auth key. (recommented)
 RAUTH_OPENPGP_AUTH    =  7,
 //! Use Kerveros
 RAUTH_KERBEROS        =  8,
 //! Auth based on client's host or node name or address.
 RAUTH_RHOST           =  9,
 //! Use xauth cookie.
 RAUTH_XAUTH           = 10,
 //! Use Ident service.
 RAUTH_IDENT           = 11
} rauth_t;

//! Protocol IDs
typedef enum {
 //! No protocol given, unused entry, use default
 RPROTO_NONE          = 0,
 //! The RoarAudio protocol
 RPROTO_ROARAUDIO     = 1,
 //! Old EsounD protocol
 RPROTO_ESOUND        = 2,
 //! Auto select protocol
 RPROTO_AUTO          = 3,
 //! HTTP
 RPROTO_HTTP          = 4,
 //! Gopher
 RPROTO_GOPHER        = 5,
 //! Nullsoft ICY protocol
 RPROTO_ICY           = 7,
 //! PulseAudio Simple protocol
 RPROTO_SIMPLE        = 8,
 //! RSound protocol
 RPROTO_RSOUND        = 9
} rproto_t;

#endif

//ll
