//vendor.h:

/*
 *      Copyright (C) Philipp 'ph3-der-loewe' Schafft - 2011-2012
 *
 *  This file is part of aroarfw, a RoarAudio framework for
 *  embedded systems (Controlers).
 *
 *  This file is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License version 3
 *  or (at your option) any later version as published by
 *  the Free Software Foundation.
 *
 *  aroarfw is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this software; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 51 Franklin Street, Fifth Floor,
 *  Boston, MA 02110-1301, USA.
 */

#ifndef _AROARFW_VENDOR_H_
#define _AROARFW_VENDOR_H_

//! Device Vendor IDs
typedef enum {
 //! Vendor ID for RoarAudio foundation
 RDEVVENDOR_ROARAUDIO = 0,
 //! Vendor ID for common basic standards
 RDEVVENDOR_BASICDEV  = 1
} rdevvendor_t;

//! Standard Vendor IDs
typedef enum {
 //! Vendor ID for RoarAudio foundation
 RSTDVENDOR_ROARAUDIO = 0,
 //! Vendor ID for protocol standards written by non-vendors
 RSTDVENDOR_PROTO     = 1,
 //! Vendor ID for RFCs.
 //! RFC number is standard number.
 //! Standard version is always set to zero.
 RSTDVENDOR_RFC       = 2
} rstdvendor_t;

#endif

//ll
