

/*
   ArrayUtil, program to check and configure a SmartArray controller
   Copyright (C) 1999  Hugo Trippaers

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*
   $Header: /home/cvs/cvsroot/array-util/images.c,v 1.2 2001/08/30 12:27:53 spark Exp $
 */

#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <gdk_imlib.h>
#include "xpms/ctrl.xpm"
#include "xpms/logdrv.xpm"
#include "xpms/physdrv.xpm"
#include "xpms/error.xpm"
#include "xpms/icon_info.xpm"
#include "xpms/icon_warning.xpm"
#include "xpms/icon_error.xpm"
#include "icons.h"
#include "array_util.h"


int
load_images (GtkWidget * window)
{
  GtkStyle *style;

  style = gtk_widget_get_style (window);

  icon_ctrl_image = gdk_pixmap_create_from_xpm_d (window->window,
						  &icon_ctrl_bitmap,
					       &style->bg[GTK_STATE_NORMAL],
						  (gchar **) ctrl_xpm);
  icon_logdrv_image = gdk_pixmap_create_from_xpm_d (window->window,
						    &icon_logdrv_bitmap,
					       &style->bg[GTK_STATE_NORMAL],
						    (gchar **) logdrv_xpm);
  icon_physdrv_image = gdk_pixmap_create_from_xpm_d (window->window,
						     &icon_physdrv_bitmap,
					       &style->bg[GTK_STATE_NORMAL],
						     (gchar **) physdrv_xpm);
  icon_error_image = gdk_pixmap_create_from_xpm_d (window->window,
						   &icon_error_bitmap,
					       &style->bg[GTK_STATE_NORMAL],
						   (gchar **) error_xpm);
  icon_miniinfo = gdk_pixmap_create_from_xpm_d (window->window,
						&icon_miniinfo_bm,
						&style->bg[GTK_STATE_NORMAL],
						(gchar **) icon_info_xpm);
  icon_miniwarn = gdk_pixmap_create_from_xpm_d (window->window,
						&icon_miniwarn_bm,
						&style->bg[GTK_STATE_NORMAL],
						(gchar **) icon_warning_xpm);
  icon_minierr = gdk_pixmap_create_from_xpm_d (window->window,
						&icon_minierr_bm,
						&style->bg[GTK_STATE_NORMAL],
						(gchar **) icon_error_xpm);
  return 1;
}
