/*
 * Copyright (c) 2001,2002 Tony Sideris
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
#ifndef __DATADOC_H__
#define __DATADOC_H__

#include <qvaluestack.h>

#include "docwidget.h"

/*========================================================*/

class ArsonDataContentsVisiter : public ArsonFileTreeVisiter
{
	typedef QValueStack<QString> STRSTACK;

protected:
	ArsonDataContentsVisiter (void);
	
	virtual bool visitFile (QListViewItem *pi, ArsonFileListFileItem *pl);

	virtual bool beginBranch (QListViewItem *pi, ArsonListItem *pl);
	virtual void endBranch (void);

	virtual bool onDataItem (const QString &src, const QString &dst) = 0;
	
	QString path (void) const;

	QString m_path;
};

/*========================================================*/

class ArsonDataDoc : public ArsonFileListDoc
{
	Q_OBJECT
	
public:
	ArsonDataDoc (QWidget *parent, const char *name = NULL);

	virtual QString propDocType (void) const;
	virtual QString propFolder (void) const { return "folder"; }
	virtual QString propItem (void) const { return "file"; }

private:
	virtual ArsonFileListItem *createFileItem (const KURL &url) const;
	virtual ArsonFileListItem *createDirItem (const QString &dn) const;

	virtual ArsonProcessMgr *createCdWriter (ArsonProcessUI *pUI) { return NULL; }
	virtual ArsonProgress *createProgress (QWidget *parent);
	virtual ArsonListWnd *createListWnd (void);
	virtual void addDirectory (const KURL &url, ArsonListInserter &pos);
	virtual void connectTo (ArsonActionConnector &ac);
	virtual Status *initStatus (QStatusBar *psb);

public slots:
	void slotNewFolder (void);
	void slotCalcIsoSize (void);
};

/*========================================================*/
#endif	/*	__DATADOC_H__	*/
