/*
 * Copyright (c) 2001,2002 Tony Sideris
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
#ifndef __READCD_H__
#define __READCD_H__

#include "processmgr.h"

/*==================================*/
/*	DEFINES
 *==================================*/

#define ARSON_WIZARD_IMAGEFILE		"imgfile"
#define ARSON_WIZARD_DIRECTORY		"onedir"
#define ARSON_WIZARD_READCD			"readcd"

/*========================================================*/

class ArsonReadCdMgr : public ArsonProcessMgr
{
public:
	ArsonReadCdMgr (ArsonProcessUI *pUI, const char *outfile);

	virtual void begin (const ArsonProcessOpts &opts);

//	static bool readCd (const char *outfile);

private:
	QString m_strOutFile;
};

/*========================================================*/

class ArsonCdImageFile
{
public:
	enum ImageTypes {
		Unknown = -1,
		Iso = 0,
		Cif,
		Cue,
		Toc,
		Max,	//	All actual file types go before this
		Dir,
	};

	ArsonCdImageFile (const QString &filename);

	const QString &filename (void) const { return m_file; }
	void setFilename (const char *name) { m_file = name; }
	
	int imgFormat (void);
	bool write (void);

	const static QString exts[Max];
	
private:
	QString m_file;
	int m_type;
};

/*==================================*/
/*	FUNCTIONS
 *==================================*/

void arsonWriteDir (const QString &indir = QString::null);
void arsonWriteCueFile (const char *cuefile);
void arsonWriteIsoFile (const char *isofile);
void arsonWriteImg (const char *fn = NULL);

void arsonUnlockDrive (void);
void arsonBlankCdrw (void);
void arsonCdCopy (void);
void arsonReadCd (void);
void arsonFixate (void);

/*========================================================*/
#endif	/*	__READCD_H__	*/
