/*
 * This file was automatically generated by EvoSuite
 * Fri Jan 12 10:48:05 GMT 2018
 */

package uk.ac.sanger.artemis.circular;

import org.junit.Test;
import static org.junit.Assert.*;
import static org.evosuite.runtime.EvoAssertions.*;
import java.io.File;
import java.util.Vector;
import org.evosuite.runtime.EvoRunner;
import org.evosuite.runtime.EvoRunnerParameters;
import org.evosuite.runtime.mock.java.io.MockFile;
import org.evosuite.runtime.testdata.EvoSuiteFile;
import org.evosuite.runtime.testdata.FileSystemHandling;
import org.junit.runner.RunWith;
import uk.ac.sanger.artemis.circular.EmbossCirdnaReader;

@RunWith(EvoRunner.class) @EvoRunnerParameters(mockJVMNonDeterminism = true, useVFS = true, useVNET = true, resetStaticState = true, separateClassLoader = true, useJEE = true) 
public class EmbossCirdnaReader_ESTest extends EmbossCirdnaReader_ESTest_scaffolding {

  @Test(timeout = 4000)
  public void test00()  throws Throwable  {
      EmbossCirdnaReader embossCirdnaReader0 = null;
      try {
        embossCirdnaReader0 = new EmbossCirdnaReader();
        fail("Expecting exception: SecurityException");
      
      } catch(SecurityException e) {
         //
         // Permission Denied
         //
         verifyException("org.evosuite.runtime.System", e);
      }
  }

  @Test(timeout = 4000)
  public void test01()  throws Throwable  {
      MockFile mockFile0 = new MockFile("");
      EmbossCirdnaReader embossCirdnaReader0 = new EmbossCirdnaReader(mockFile0);
      embossCirdnaReader0.start = 3096;
      int int0 = embossCirdnaReader0.getStart();
      assertEquals(3096, int0);
  }

  @Test(timeout = 4000)
  public void test02()  throws Throwable  {
      MockFile mockFile0 = new MockFile("*d<>", "");
      EmbossCirdnaReader embossCirdnaReader0 = new EmbossCirdnaReader(mockFile0);
      embossCirdnaReader0.start = (-1505);
      int int0 = embossCirdnaReader0.getStart();
      assertEquals((-1505), int0);
  }

  @Test(timeout = 4000)
  public void test03()  throws Throwable  {
      MockFile mockFile0 = new MockFile("");
      EmbossCirdnaReader embossCirdnaReader0 = new EmbossCirdnaReader(mockFile0);
      embossCirdnaReader0.end = 1138;
      int int0 = embossCirdnaReader0.getEnd();
      assertEquals(1138, int0);
  }

  @Test(timeout = 4000)
  public void test04()  throws Throwable  {
      MockFile mockFile0 = new MockFile("");
      EmbossCirdnaReader embossCirdnaReader0 = new EmbossCirdnaReader(mockFile0);
      embossCirdnaReader0.end = (-242);
      int int0 = embossCirdnaReader0.getEnd();
      assertEquals((-242), int0);
  }

  @Test(timeout = 4000)
  public void test05()  throws Throwable  {
      EmbossCirdnaReader embossCirdnaReader0 = null;
      try {
        embossCirdnaReader0 = new EmbossCirdnaReader((File) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("org.evosuite.runtime.mock.java.io.MockFileInputStream", e);
      }
  }

  @Test(timeout = 4000)
  public void test06()  throws Throwable  {
      MockFile mockFile0 = new MockFile("W?'{V@c8?eSA", "W?'{V@c8?eSA");
      EmbossCirdnaReader embossCirdnaReader0 = new EmbossCirdnaReader(mockFile0);
      EvoSuiteFile evoSuiteFile0 = new EvoSuiteFile(java.lang.System.getProperty("user.dir") + "/W?'{V@c8?eSA/W?'{V@c8?eSA");
      FileSystemHandling.appendLineToFile(evoSuiteFile0, "end contigcontig");
      // Undeclared exception!
      try { 
        embossCirdnaReader0.readFile();
        fail("Expecting exception: NumberFormatException");
      
      } catch(NumberFormatException e) {
         //
         // For input string: \"contigcontig\"
         //
         verifyException("java.lang.NumberFormatException", e);
      }
  }

  @Test(timeout = 4000)
  public void test07()  throws Throwable  {
      MockFile mockFile0 = new MockFile("p_p 35d");
      EmbossCirdnaReader embossCirdnaReader0 = new EmbossCirdnaReader(mockFile0);
      EvoSuiteFile evoSuiteFile0 = new EvoSuiteFile(java.lang.System.getProperty("user.dir") + "/p_p 35d");
      FileSystemHandling.appendStringToFile(evoSuiteFile0, "p_p 35d");
      Vector vector0 = embossCirdnaReader0.readFile();
      assertNull(vector0);
  }

  @Test(timeout = 4000)
  public void test08()  throws Throwable  {
      MockFile mockFile0 = new MockFile("");
      EmbossCirdnaReader embossCirdnaReader0 = new EmbossCirdnaReader(mockFile0);
      boolean boolean0 = embossCirdnaReader0.isReading();
      assertTrue(boolean0);
  }

  @Test(timeout = 4000)
  public void test09()  throws Throwable  {
      MockFile mockFile0 = new MockFile("");
      EmbossCirdnaReader embossCirdnaReader0 = new EmbossCirdnaReader(mockFile0);
      int int0 = embossCirdnaReader0.getStart();
      assertEquals(0, int0);
  }

  @Test(timeout = 4000)
  public void test10()  throws Throwable  {
      MockFile mockFile0 = new MockFile("");
      EmbossCirdnaReader embossCirdnaReader0 = new EmbossCirdnaReader(mockFile0);
      Vector vector0 = embossCirdnaReader0.getBlock();
      assertEquals("[]", vector0.toString());
  }

  @Test(timeout = 4000)
  public void test11()  throws Throwable  {
      MockFile mockFile0 = new MockFile("");
      EmbossCirdnaReader embossCirdnaReader0 = new EmbossCirdnaReader(mockFile0);
      Vector vector0 = embossCirdnaReader0.getRestrictionEnzyme();
      assertEquals("[]", vector0.toString());
  }

  @Test(timeout = 4000)
  public void test12()  throws Throwable  {
      MockFile mockFile0 = new MockFile("");
      EmbossCirdnaReader embossCirdnaReader0 = new EmbossCirdnaReader(mockFile0);
      int int0 = embossCirdnaReader0.getEnd();
      assertEquals(0, int0);
  }
}
