/*
 * This file was automatically generated by EvoSuite
 * Thu Sep 20 13:47:14 GMT 2018
 */

package uk.ac.sanger.artemis.io;

import org.junit.Test;
import static org.junit.Assert.*;
import static org.evosuite.shaded.org.mockito.Mockito.*;
import static org.evosuite.runtime.EvoAssertions.*;
import java.awt.HeadlessException;
import java.io.StringReader;
import org.evosuite.runtime.EvoRunner;
import org.evosuite.runtime.EvoRunnerParameters;
import org.evosuite.runtime.ViolatedAssumptionAnswer;
import org.junit.runner.RunWith;
import uk.ac.sanger.artemis.io.BlastEntryInformation;
import uk.ac.sanger.artemis.io.Entry;
import uk.ac.sanger.artemis.io.EntryInformation;
import uk.ac.sanger.artemis.io.GenbankDocumentEntry;
import uk.ac.sanger.artemis.io.KeyVector;
import uk.ac.sanger.artemis.io.QualifierInfoHash;
import uk.ac.sanger.artemis.io.ReadListener;
import uk.ac.sanger.artemis.util.Document;
import uk.ac.sanger.artemis.util.LinePushBackReader;
import uk.ac.sanger.artemis.util.TextDocument;

@RunWith(EvoRunner.class) @EvoRunnerParameters(mockJVMNonDeterminism = true, useVFS = true, useVNET = true, resetStaticState = true, useJEE = true) 
public class GenbankDocumentEntry_ESTest extends GenbankDocumentEntry_ESTest_scaffolding {


  @Test(timeout = 4000)
  public void test1()  throws Throwable  {
      GenbankDocumentEntry genbankDocumentEntry0 = null;
      try {
        genbankDocumentEntry0 = new GenbankDocumentEntry((EntryInformation) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.io.SimpleEntryInformation", e);
      }
  }

  @Test(timeout = 4000)
  public void test2()  throws Throwable  {
      EntryInformation entryInformation0 = mock(EntryInformation.class, new ViolatedAssumptionAnswer());
      doReturn((QualifierInfoHash) null).when(entryInformation0).getAllQualifierInfo();
      doReturn((KeyVector) null).when(entryInformation0).getUserKeys();
      doReturn((KeyVector) null).when(entryInformation0).getValidKeys();
      doReturn(false).when(entryInformation0).useEMBLFormat();
      GenbankDocumentEntry genbankDocumentEntry0 = new GenbankDocumentEntry(entryInformation0);
      genbankDocumentEntry0.dispose();
      GenbankDocumentEntry genbankDocumentEntry1 = null;
      try {
        genbankDocumentEntry1 = new GenbankDocumentEntry(genbankDocumentEntry0);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //ß
         verifyException("uk.ac.sanger.artemis.io.SimpleDocumentEntry", e);
      }
  }

  @Test(timeout = 4000)
  public void test3()  throws Throwable  {
      BlastEntryInformation blastEntryInformation0 = new BlastEntryInformation();
      StringReader stringReader0 = new StringReader("amWO:T~Xu`P");
      LinePushBackReader linePushBackReader0 = new LinePushBackReader(stringReader0);
      Document document0 = mock(Document.class, new ViolatedAssumptionAnswer());
      doReturn(linePushBackReader0).when(document0).getLinePushBackReader();
      ReadListener readListener0 = mock(ReadListener.class, new ViolatedAssumptionAnswer());
      GenbankDocumentEntry genbankDocumentEntry0 = new GenbankDocumentEntry(blastEntryInformation0, document0, readListener0);
      assertFalse(genbankDocumentEntry0.isReadOnly());
  }

  @Test(timeout = 4000)
  public void test4()  throws Throwable  {
      BlastEntryInformation blastEntryInformation0 = new BlastEntryInformation();
      GenbankDocumentEntry genbankDocumentEntry0 = new GenbankDocumentEntry(blastEntryInformation0);
      GenbankDocumentEntry genbankDocumentEntry1 = new GenbankDocumentEntry(blastEntryInformation0, genbankDocumentEntry0, false);
      assertFalse(genbankDocumentEntry1.isReadOnly());
  }

  @Test(timeout = 4000)
  public void test5()  throws Throwable  {
      EntryInformation entryInformation0 = mock(EntryInformation.class, new ViolatedAssumptionAnswer());
      doReturn((QualifierInfoHash) null).when(entryInformation0).getAllQualifierInfo();
      doReturn((KeyVector) null).when(entryInformation0).getUserKeys();
      doReturn((KeyVector) null).when(entryInformation0).getValidKeys();
      doReturn(false).when(entryInformation0).useEMBLFormat();
      GenbankDocumentEntry genbankDocumentEntry0 = null;
      try {
        genbankDocumentEntry0 = new GenbankDocumentEntry(entryInformation0, (Entry) null, true);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.io.SimpleDocumentEntry", e);
      }
  }

  @Test(timeout = 4000)
  public void test6()  throws Throwable  {
      EntryInformation entryInformation0 = mock(EntryInformation.class, new ViolatedAssumptionAnswer());
      doReturn((QualifierInfoHash) null).when(entryInformation0).getAllQualifierInfo();
      doReturn((KeyVector) null).when(entryInformation0).getUserKeys();
      doReturn((KeyVector) null).when(entryInformation0).getValidKeys();
      doReturn(false).when(entryInformation0).useEMBLFormat();
      ReadListener readListener0 = mock(ReadListener.class, new ViolatedAssumptionAnswer());
      GenbankDocumentEntry genbankDocumentEntry0 = null;
      try {
        genbankDocumentEntry0 = new GenbankDocumentEntry(entryInformation0, (Document) null, readListener0);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.io.SimpleDocumentEntry", e);
      }
  }

  @Test(timeout = 4000)
  public void test7()  throws Throwable  {
      EntryInformation entryInformation0 = mock(EntryInformation.class, new ViolatedAssumptionAnswer());
      doReturn((QualifierInfoHash) null).when(entryInformation0).getAllQualifierInfo();
      doReturn((KeyVector) null).when(entryInformation0).getUserKeys();
      doReturn((KeyVector) null).when(entryInformation0).getValidKeys();
      doReturn(false).when(entryInformation0).useEMBLFormat();
      GenbankDocumentEntry genbankDocumentEntry0 = new GenbankDocumentEntry(entryInformation0);
      GenbankDocumentEntry genbankDocumentEntry1 = new GenbankDocumentEntry(genbankDocumentEntry0);
      assertFalse(genbankDocumentEntry1.equals((Object)genbankDocumentEntry0));
  }
}
