#include <unistd.h>

#include "protocol-asd.h"
#include "protocol-asd-unix.h"
#include "unix.h"

static int _fd;
static gboolean _enabled = FALSE;
static gchar* _path = NULL;

gboolean protocol_asd_unix_init(gchar *fname)
{
  gchar p[PATH_MAX];

  g_assert(!_enabled);
  
  if (!fname)
    {
      g_snprintf(p, sizeof(p), "%s/.asd-socket", g_get_home_dir());
      fname = p;
    }

  _path = g_strdup(fname);

  return (_enabled = (_fd = unix_server_socket(fname)) >= 0);
}

void protocol_asd_unix_done()
{
  if (_enabled)
    {
      close(_fd);
      unlink(_path);
      g_free(_path);
      _path = NULL;
    }

  _enabled = FALSE;
}

int protocol_asd_unix_get_fd()
{
  return _fd;
}

gboolean protocol_asd_unix_enabled()
{
  return _enabled;
}

void protocol_asd_unix_accept()
{  
  int sock;
  g_assert(_enabled);

  if ((sock = unix_server_accept(_fd)) >= 0)
    protocol_asd_new_socket(sock);
}
